/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AbstractConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import java.lang.reflect.Method;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpoint;

final class JmsJcaEndpointInvokerImpl
implements SibRaEndpointInvoker {
    private static Method ON_MESSAGE_METHOD;
    private JmsSharedUtils _jmsUtils;
    private static final TraceComponent TRACE;
    private static final TraceNLS NLS;
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String CLASS_NAME;

    JmsJcaEndpointInvokerImpl() throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"JmsJcaEndpointInvokerImpl");
        }
        try {
            this._jmsUtils = JmsInternalsFactory.getSharedUtils();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)(CLASS_NAME + ".JmsJcaEndpointInvokerImpl"), (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)jMSException));
            }
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UTILITY_CLASS_CWSJR1481", new Object[]{jMSException}, null), (Throwable)jMSException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"JmsJcaEndpointInvokerImpl");
        }
    }

    public Method getEndpointMethod() throws ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointMethod");
        }
        if (ON_MESSAGE_METHOD == null) {
            try {
                ON_MESSAGE_METHOD = MessageListener.class.getMethod("onMessage", Message.class);
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + "." + "getEndpointMethod"), (String)FFDC_PROBE_2, (Object)this);
                if (TRACE.isEntryEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("ON_MESSAGE_CWSJR1483", new Object[]{exception}, null), (Throwable)exception);
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointMethod", (Object)ON_MESSAGE_METHOD);
        }
        return ON_MESSAGE_METHOD;
    }

    public boolean invokeEndpoint(MessageEndpoint messageEndpoint, SIBusMessage sIBusMessage, AbstractConsumerSession abstractConsumerSession, SITransaction sITransaction) throws ResourceAdapterInternalException {
        boolean bl;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"invokeEndpoint", (Object)new Object[]{messageEndpoint, sIBusMessage, abstractConsumerSession, sITransaction});
        }
        if (!(messageEndpoint instanceof MessageListener)) {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNEXPECTED_ENDPOINT_CWSJR1482", new Object[]{messageEndpoint, MessageListener.class}, null));
        }
        MessageListener messageListener = (MessageListener)messageEndpoint;
        try {
            Message message = this._jmsUtils.inboundMessagePath(sIBusMessage, null);
            messageListener.onMessage(message);
            bl = true;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)(CLASS_NAME + "." + "invokeEndpoint"), (String)FFDC_PROBE_1, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Throwable)throwable);
            }
            bl = false;
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"invokeEndpoint", (Object)bl);
        }
        return bl;
    }

    static {
        TRACE = SibTr.register((Class)JmsJcaEndpointInvokerImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
        NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
        CLASS_NAME = JmsJcaEndpointInvokerImpl.class.getName();
    }
}

