/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jmsra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.SIDestinationAddressFactory;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.websphere.sib.api.jms.JmsQueue;
import com.ibm.websphere.sib.api.jms.JmsTopic;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.api.jms.JmsSharedUtils;
import com.ibm.ws.sib.api.jmsra.JmsJcaActivationSpec;
import com.ibm.ws.sib.api.jmsra.JmsraConstants;
import com.ibm.ws.sib.api.jmsra.impl.JmsJcaEndpointInvokerImpl;
import com.ibm.ws.sib.ra.inbound.SibRaDurableSubscriptionSharing;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfiguration;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointConfigurationProvider;
import com.ibm.ws.sib.ra.inbound.SibRaEndpointInvoker;
import com.ibm.ws.sib.ra.inbound.SibRaMessageDeletionMode;
import com.ibm.ws.sib.ra.inbound.SibRaReadAhead;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.sib.zwlmclassifier.WlmClassifierHandlerFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SelectorDomain;
import com.ibm.wsspi.sib.exitpoint.ra.RAHandlerRegistry;
import com.ibm.wsspi.sib.exitpoint.ra.RAType;
import com.ibm.wsspi.sib.exitpoint.ra.RegistrationException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import javax.jms.Destination;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.InvalidPropertyException;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;

public final class JmsJcaActivationSpecImpl
implements JmsJcaActivationSpec,
SibRaEndpointConfigurationProvider {
    private transient ResourceAdapter _resourceAdapter;
    private String _userName;
    private String _password;
    private Destination _destination;
    private String _durableSubscriptionHome;
    private String _destinationType;
    private String _messageSelector;
    private String _acknowledgeMode = "Auto-acknowledge";
    private String _subscriptionDurability = "NonDurable";
    private String _shareDurableSubscriptions = "InCluster";
    private String _clientId;
    private String _subscriptionName;
    private Integer _maxBatchSize = DEFAULT_MAX_BATCH_SIZE;
    private Integer _maxConcurrency = DEFAULT_MAX_CONCURRENCY;
    private String _busName = JmsraConstants.DEFAULT_BUS_NAME;
    private Boolean _shareDataSourceWithCMP = Boolean.FALSE;
    private String _targetTransportChain;
    private String _readAhead = "Default";
    private String _xaRecoveryAlias;
    static final String QUEUE = "javax.jms.Queue";
    static final String TOPIC = "javax.jms.Topic";
    static final String AUTO_ACKNOWLEDGE = "Auto-acknowledge";
    static final String DUPS_OK_ACKNOWLEDGE = "Dups-ok-acknowledge";
    private static final String DEFAULT_ACKNOWLEDGE_MODE = "Auto-acknowledge";
    static final String DURABLE = "Durable";
    static final String NON_DURABLE = "NonDurable";
    private static final String DEFAULT_DURABILITY = "NonDurable";
    private static final Integer DEFAULT_MAX_BATCH_SIZE = new Integer(1);
    private static final Integer DEFAULT_MAX_CONCURRENCY = new Integer(10);
    private static final long serialVersionUID = -7593258810211123494L;
    private static final TraceComponent TRACE = SibTr.register((Class)JmsJcaActivationSpecImpl.class, (String)"SIBJmsRa", (String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final TraceNLS NLS = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.api.jmsra.CWSJRMessages");
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String CLASS_NAME = JmsJcaActivationSpecImpl.class.getName();

    public String getUserName() {
        return this._userName;
    }

    public void setUserName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setUserName", (Object)string);
        }
        this._userName = string;
    }

    public String getPassword() {
        return this._password;
    }

    public void setPassword(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setPassword", (Object)"***");
        }
        this._password = string;
    }

    public Destination getDestination() {
        return this._destination;
    }

    public void setDestination(Destination destination) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDestination", (Object)destination);
        }
        this._destination = destination;
    }

    public String getDestinationType() {
        return this._destinationType;
    }

    public void setDestinationType(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDestinationType", (Object)string);
        }
        this._destinationType = string;
    }

    public String getMessageSelector() {
        return this._messageSelector;
    }

    public void setMessageSelector(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMessageSelector", (Object)string);
        }
        this._messageSelector = string;
    }

    public String getAcknowledgeMode() {
        return this._acknowledgeMode;
    }

    public void setAcknowledgeMode(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setAcknowledgeMode", (Object)string);
        }
        this._acknowledgeMode = string;
    }

    public String getSubscriptionDurability() {
        return this._subscriptionDurability;
    }

    public void setSubscriptionDurability(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setSubscriptionDurability", (Object)string);
        }
        this._subscriptionDurability = string;
    }

    public String getDurableSubscriptionHome() {
        return this._durableSubscriptionHome;
    }

    public void setDurableSubscriptionHome(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setDurableSubscriptionHome", (Object)string);
        }
        this._durableSubscriptionHome = string;
    }

    public String getShareDurableSubscriptions() {
        return this._shareDurableSubscriptions;
    }

    public void setShareDurableSubscriptions(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"shareDurableSubscriptions", (Object)string);
        }
        this._shareDurableSubscriptions = string;
    }

    public String getClientId() {
        return this._clientId;
    }

    public void setClientId(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setClientId", (Object)string);
        }
        this._clientId = string;
    }

    public String getSubscriptionName() {
        return this._subscriptionName;
    }

    public void setSubscriptionName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setSubscriptionName", (Object)string);
        }
        this._subscriptionName = string;
    }

    public Integer getMaxBatchSize() {
        return this._maxBatchSize;
    }

    public void setMaxBatchSize(Integer n) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMaxBatchSize", (Object)n);
        }
        this._maxBatchSize = n;
    }

    public Integer getMaxConcurrency() {
        return this._maxConcurrency;
    }

    public void setMaxConcurrency(Integer n) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setMaxConcurrency", (Object)n);
        }
        this._maxConcurrency = n;
    }

    public String getBusName() {
        return this._busName;
    }

    public void setBusName(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setBusName", (Object)string);
        }
        this._busName = string;
    }

    public void setShareDataSourceWithCMP(Boolean bl) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setShareDataSourceWithCMP", (Object)bl);
        }
        this._shareDataSourceWithCMP = bl;
    }

    public Boolean getShareDataSourceWithCMP() {
        return this._shareDataSourceWithCMP;
    }

    public void setTargetTransportChain(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setTargetTransportChain", (Object)string);
        }
        this._targetTransportChain = string;
    }

    public String getTargetTransportChain() {
        return this._targetTransportChain;
    }

    public void setReadAhead(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setReadAhead", (Object)string);
        }
        this._readAhead = string;
    }

    public String getReadAhead() {
        return this._readAhead;
    }

    public ResourceAdapter getResourceAdapter() {
        return this._resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setResourceAdapter", (Object)resourceAdapter);
        }
        this._resourceAdapter = resourceAdapter;
    }

    public void setXARecoveryAlias(String string) {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"setXARecoveryAlias", (Object)string);
        }
        this._xaRecoveryAlias = string;
    }

    public void validate() throws InvalidPropertyException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
        try {
            ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
            if (null == this._busName || "".equals(this._busName)) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid BusName - BusName was " + this._busName));
                }
                arrayList.add(new PropertyDescriptor("busName", JmsJcaActivationSpec.class));
            }
            if (null == this._destination) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Invalid Destination - Destination was null");
                }
                arrayList.add(new PropertyDescriptor("destination", JmsJcaActivationSpec.class));
            }
            if (!QUEUE.equals(this._destinationType) && !TOPIC.equals(this._destinationType)) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination Type - We expected a destination type of javax.jms.Queue or javax.jms.Topic but we got " + this._destinationType));
                }
                arrayList.add(new PropertyDescriptor("destinationType", JmsJcaActivationSpec.class));
            }
            if (!"Auto-acknowledge".equals(this._acknowledgeMode) && !DUPS_OK_ACKNOWLEDGE.equals(this._acknowledgeMode)) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Acknowledge Mode - We expected an acknowledge mode of Auto-acknowledge or Dups-ok-acknowledge but we got " + this._acknowledgeMode));
                }
                arrayList.add(new PropertyDescriptor("acknowledgeMode", JmsJcaActivationSpec.class));
            }
            if (!("Default".equals(this._readAhead) || "AlwaysOn".equals(this._readAhead) || "AlwaysOff".equals(this._readAhead))) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid ReadAhead - We expected a read ahead of Default, AlwaysOn or AlwaysOff but we got " + this._readAhead));
                }
                arrayList.add(new PropertyDescriptor("readAhead", JmsJcaActivationSpec.class));
            }
            if (QUEUE.equals(this._destinationType) && !(this._destination instanceof JmsQueue)) {
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination - We expect a destination object to be a " + JmsQueue.class.getName() + " but we got " + this._destination.getClass().getName()));
                }
                arrayList.add(new PropertyDescriptor("destination", JmsJcaActivationSpec.class));
            }
            if (TOPIC.equals(this._destinationType)) {
                if (!(this._destination instanceof JmsTopic)) {
                    if (TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid Destination - We expect a destination object to be a " + JmsTopic.class.getName() + " but we got " + this._destination.getClass().getName()));
                    }
                    arrayList.add(new PropertyDescriptor("destination", JmsJcaActivationSpec.class));
                }
                if (!DURABLE.equals(this._subscriptionDurability) && !"NonDurable".equals(this._subscriptionDurability)) {
                    if (TRACE.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid subscriptionDurability - We expect a value of Durable or NonDurable but we got " + this._subscriptionDurability));
                    }
                    arrayList.add(new PropertyDescriptor("subscriptionDurability", JmsJcaActivationSpec.class));
                }
                if (DURABLE.equals(this._subscriptionDurability)) {
                    if (null == this._clientId || "".equals(this._clientId)) {
                        arrayList.add(new PropertyDescriptor("clientId", JmsJcaActivationSpec.class));
                    }
                    if (null == this._durableSubscriptionHome || "".equals(this._durableSubscriptionHome)) {
                        arrayList.add(new PropertyDescriptor("durableSubscriptionHome", JmsJcaActivationSpec.class));
                    }
                    if (null == this._subscriptionName || "".equals(this._subscriptionName)) {
                        arrayList.add(new PropertyDescriptor("subscriptionName", JmsJcaActivationSpec.class));
                    }
                    if (!("AlwaysShared".equals(this._shareDurableSubscriptions) || "NeverShared".equals(this._shareDurableSubscriptions) || "InCluster".equals(this._shareDurableSubscriptions))) {
                        if (TRACE.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)TRACE, (String)("Invalid shareDurableSubscriptions - We expect a value of AlwaysShared, NeverShared or InCluster but we got " + this._shareDurableSubscriptions));
                        }
                        arrayList.add(new PropertyDescriptor("shareDurableSubscriptions", JmsJcaActivationSpec.class));
                    }
                }
            }
            if (null == this._maxConcurrency || this._maxConcurrency < 1) {
                arrayList.add(new PropertyDescriptor("maxConcurrency", JmsJcaActivationSpec.class));
            }
            if (null == this._maxBatchSize || this._maxBatchSize < 1) {
                arrayList.add(new PropertyDescriptor("maxBatchSize", JmsJcaActivationSpec.class));
            }
            if (null == this._shareDataSourceWithCMP) {
                arrayList.add(new PropertyDescriptor("shareDataSourceWithCMP", JmsJcaActivationSpec.class));
            }
            if (!arrayList.isEmpty()) {
                PropertyDescriptor[] propertyDescriptorArray = arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
                ArrayList<String> arrayList2 = new ArrayList<String>();
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    arrayList2.add(propertyDescriptorArray[i].getDisplayName());
                }
                if (TRACE.isDebugEnabled()) {
                    SibTr.debug((Object)this, (TraceComponent)TRACE, (String)"Invalid properties found:", arrayList2);
                }
                InvalidPropertyException invalidPropertyException = new InvalidPropertyException(NLS.getFormattedMessage("INVALID_PROPERTIES_CWSJR1181", new Object[]{arrayList2}, null));
                invalidPropertyException.setInvalidPropertyDescriptors(propertyDescriptorArray);
                throw invalidPropertyException;
            }
        }
        catch (IntrospectionException introspectionException) {
            FFDCFilter.processException((Throwable)introspectionException, (String)(CLASS_NAME + "." + "validate"), (String)FFDC_PROBE_1, (Object)this);
            SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)introspectionException);
            throw new RuntimeException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1185", new Object[]{introspectionException}, null), introspectionException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"validate");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append("@");
        stringBuffer.append(System.identityHashCode(this));
        stringBuffer.append(" <userName=");
        stringBuffer.append(this._userName);
        stringBuffer.append("> <password=");
        stringBuffer.append(this._password == null ? null : "*****");
        stringBuffer.append("> <xaRecoveryAlias=");
        stringBuffer.append(this._xaRecoveryAlias);
        stringBuffer.append("> <destination=");
        stringBuffer.append(this._destination);
        stringBuffer.append("> <durableSubscriptionHome=");
        stringBuffer.append(this._durableSubscriptionHome);
        stringBuffer.append("> <destinationType=");
        stringBuffer.append(this._destinationType);
        stringBuffer.append("> <messageSelector=");
        stringBuffer.append(this._messageSelector);
        stringBuffer.append("> <acknowledgeMode=");
        stringBuffer.append(this._acknowledgeMode);
        stringBuffer.append("> <subscriptionDurability=");
        stringBuffer.append(this._subscriptionDurability);
        stringBuffer.append("> <shareDurableSubscriptions=");
        stringBuffer.append(this._shareDurableSubscriptions);
        stringBuffer.append("> <clientId=");
        stringBuffer.append(this._clientId);
        stringBuffer.append("> <subscriptionName=");
        stringBuffer.append(this._subscriptionName);
        stringBuffer.append("> <maxBatchSize=");
        stringBuffer.append(this._maxBatchSize);
        stringBuffer.append("> <maxConcurrency=");
        stringBuffer.append(this._maxConcurrency);
        stringBuffer.append("> <busName=");
        stringBuffer.append(this._busName);
        stringBuffer.append("> <shareDataSourceWithCMP=");
        stringBuffer.append(this._shareDataSourceWithCMP);
        stringBuffer.append("> <targetTransportChain=");
        stringBuffer.append(this._targetTransportChain);
        stringBuffer.append("> <readAhead=");
        stringBuffer.append(this._readAhead);
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }

    public SibRaEndpointInvoker getEndpointInvoker() throws ResourceAdapterInternalException {
        return new JmsJcaEndpointInvokerImpl();
    }

    public SibRaEndpointConfiguration getEndpointConfiguration() throws InvalidPropertyException, ResourceAdapterInternalException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration");
        }
        JmsJcaEndpointConfigurationImpl jmsJcaEndpointConfigurationImpl = new JmsJcaEndpointConfigurationImpl();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getEndpointConfiguration", (Object)jmsJcaEndpointConfigurationImpl);
        }
        return jmsJcaEndpointConfigurationImpl;
    }

    static {
        if (PlatformHelperFactory.getPlatformHelper().isZOS()) {
            try {
                RAHandlerRegistry.register(WlmClassifierHandlerFactory.getInstance().getWlmClassifierHandlerClass(), RAType.JMS, 10);
            }
            catch (RegistrationException registrationException) {
                FFDCFilter.processException((Throwable)registrationException, (String)CLASS_NAME, (String)FFDC_PROBE_3);
                SibTr.error((TraceComponent)TRACE, (String)"WLM_CLASSIFIER_REG_CWSJR1186", (Object)new Object[]{registrationException});
            }
        }
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.api.jmsra.inbound.impl/src/com/ibm/ws/sib/api/jmsra/impl/JmsJcaActivationSpecImpl.java, SIB.api.jmsra, WAS602.SIB, o0610.11 1.41");
        }
    }

    private class JmsJcaEndpointConfigurationImpl
    implements SibRaEndpointConfiguration {
        private final SIDestinationAddressFactory _destinationAddressFactory;
        private final JmsSharedUtils _jmsUtils;

        private JmsJcaEndpointConfigurationImpl() throws InvalidPropertyException, ResourceAdapterInternalException {
            JmsJcaActivationSpecImpl.this.validate();
            try {
                this._destinationAddressFactory = SIDestinationAddressFactory.getInstance();
                this._jmsUtils = JmsInternalsFactory.getSharedUtils();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)(CLASS_NAME + ".JmsJcaEndpointConfigurationImpl." + "JmsJcaEndpointConfigurationImpl"), (String)JmsJcaActivationSpecImpl.FFDC_PROBE_2, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)exception);
                }
                throw new ResourceAdapterInternalException(NLS.getFormattedMessage("EXCEPTION_RECEIVED_CWSJR1182", new Object[]{exception}, null), (Throwable)exception);
            }
        }

        public SIDestinationAddress getDestination() {
            JmsDestination jmsDestination = (JmsDestination)JmsJcaActivationSpecImpl.this._destination;
            return this._destinationAddressFactory.createSIDestinationAddress(jmsDestination.getDestName(), jmsDestination.getBusName());
        }

        public DestinationType getDestinationType() {
            DestinationType destinationType = JmsJcaActivationSpecImpl.QUEUE.equals(JmsJcaActivationSpecImpl.this._destinationType) ? DestinationType.QUEUE : DestinationType.TOPICSPACE;
            return destinationType;
        }

        public String getDiscriminator() {
            JmsDestination jmsDestination = (JmsDestination)JmsJcaActivationSpecImpl.this._destination;
            return jmsDestination.getDestDiscrim();
        }

        public int getMaxConcurrency() {
            return JmsJcaActivationSpecImpl.this._maxConcurrency;
        }

        public int getMaxBatchSize() {
            return JmsJcaActivationSpecImpl.this._maxBatchSize;
        }

        public String getBusName() {
            return JmsJcaActivationSpecImpl.this._busName;
        }

        public String getUserName() {
            return JmsJcaActivationSpecImpl.this._userName;
        }

        public String getPassword() {
            return JmsJcaActivationSpecImpl.this._password;
        }

        public String getXaRecoveryAlias() {
            return JmsJcaActivationSpecImpl.this._xaRecoveryAlias;
        }

        public String getMessageSelector() {
            return JmsJcaActivationSpecImpl.this._messageSelector;
        }

        public String getDurableSubscriptionName() {
            return this._jmsUtils.getCoreDurableSubName(JmsJcaActivationSpecImpl.this._clientId, JmsJcaActivationSpecImpl.this._subscriptionName);
        }

        public String getDurableSubscriptionHome() {
            return JmsJcaActivationSpecImpl.this._durableSubscriptionHome;
        }

        public SibRaDurableSubscriptionSharing getShareDurableSubscriptions() {
            SibRaDurableSubscriptionSharing sibRaDurableSubscriptionSharing = "AlwaysShared".equals(JmsJcaActivationSpecImpl.this._shareDurableSubscriptions) ? SibRaDurableSubscriptionSharing.ALWAYS : ("NeverShared".equals(JmsJcaActivationSpecImpl.this._shareDurableSubscriptions) ? SibRaDurableSubscriptionSharing.NEVER : SibRaDurableSubscriptionSharing.CLUSTER_ONLY);
            return sibRaDurableSubscriptionSharing;
        }

        public SibRaMessageDeletionMode getMessageDeletionMode() {
            SibRaMessageDeletionMode sibRaMessageDeletionMode = "Auto-acknowledge".equals(JmsJcaActivationSpecImpl.this._acknowledgeMode) ? SibRaMessageDeletionMode.SINGLE : SibRaMessageDeletionMode.BATCH;
            return sibRaMessageDeletionMode;
        }

        public boolean isDurableSubscription() {
            return JmsJcaActivationSpecImpl.TOPIC.equals(JmsJcaActivationSpecImpl.this._destinationType) && JmsJcaActivationSpecImpl.DURABLE.equals(JmsJcaActivationSpecImpl.this._subscriptionDurability);
        }

        public SelectorDomain getSelectorDomain() {
            return SelectorDomain.JMS;
        }

        public boolean getShareDataSourceWithCMP() {
            return JmsJcaActivationSpecImpl.this._shareDataSourceWithCMP;
        }

        public String getTargetTransportChain() {
            return JmsJcaActivationSpecImpl.this._targetTransportChain;
        }

        public RAType getRaType() {
            return RAType.JMS;
        }

        public SibRaReadAhead getReadAhead() {
            SibRaReadAhead sibRaReadAhead = "AlwaysOn".equals(JmsJcaActivationSpecImpl.this._readAhead) ? SibRaReadAhead.ON : ("AlwaysOff".equals(JmsJcaActivationSpecImpl.this._readAhead) ? SibRaReadAhead.OFF : SibRaReadAhead.DEFAULT);
            return sibRaReadAhead;
        }

        public ActivationSpec getActivationSpec() {
            return JmsJcaActivationSpecImpl.this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("[");
            stringBuffer.append(this.getClass().getName());
            stringBuffer.append("@");
            stringBuffer.append(System.identityHashCode(this));
            stringBuffer.append(" <JmsJcaActivationSpecImpl.this=");
            stringBuffer.append(JmsJcaActivationSpecImpl.this);
            stringBuffer.append(">]");
            return stringBuffer.toString();
        }
    }
}

