/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.admin.SIBRemoteMessageDetail;
import com.ibm.websphere.sib.api.jms.JmsDestination;
import com.ibm.ws.sib.admin.impl.SIBRemoteMessageImpl;
import com.ibm.ws.sib.api.jms.JmsInternalsFactory;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsSdoMessage;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMessageControllable;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SIBusSdoMessage;
import java.io.Serializable;
import javax.jms.Destination;

public class SIBRemoteMessageDetailImpl
extends SIBRemoteMessageImpl
implements SIBRemoteMessageDetail,
Serializable {
    private static final long serialVersionUID = -6198598400847074297L;
    private boolean fullyValid = true;
    private boolean _valid = false;
    private String _type = null;
    private String _bus_discriminator;
    private Integer _bus_priority;
    private String _bus_reliability;
    private Long _bus_timeToLive;
    private String _bus_replyDiscriminator;
    private Integer _bus_replyPriority;
    private String _bus_replyReliability;
    private Long _bus_replyTimeToLive;
    private String _bus_systemMessageId;
    private String _js_messageType;
    private int _js_approximateLength;
    private Long _js_timestamp;
    private Long _js_messageWaitTime;
    private Long _js_currentMEArrivalTimestamp;
    private Integer _js_redeliveredCount;
    private String _js_securityUserid;
    private String _js_producerType;
    private byte[] _js_apiMessageIdAsBytes;
    private byte[] _js_correlationIdAsBytes;
    private String _api_messageId;
    private String _api_correlationId;
    private String _api_userid;
    private String _api_format;
    private String _jms_deliveryMode;
    private Long _jms_expiration;
    private String _jms_destination;
    private String _jms_replyTo;
    private Boolean _jms_redelivered;
    private String _jms_type;
    private int _jms_xDeliveryCount;
    private String _jms_xAppId;

    public SIBRemoteMessageDetailImpl(SIMPRemoteMessageControllable sIMPRemoteMessageControllable) {
        super(sIMPRemoteMessageControllable);
        try {
            this.copyMessageDetail((SIBusMessage)sIMPRemoteMessageControllable.getJsMessage());
            this._valid = true;
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            this.fullyValid = false;
        }
        catch (SIMPException sIMPException) {
            this.fullyValid = false;
        }
    }

    public boolean isFullyValid() {
        return this.fullyValid;
    }

    public boolean isValid() {
        return this._valid;
    }

    public String getType() {
        return this._type;
    }

    public String getBusDiscriminator() {
        return this._bus_discriminator;
    }

    public Integer getBusPriority() {
        return this._bus_priority;
    }

    public String getBusReliability() {
        return this._bus_reliability;
    }

    public Long getBusTimeToLive() {
        return this._bus_timeToLive;
    }

    public String getBusReplyDiscriminator() {
        return this._bus_replyDiscriminator;
    }

    public Integer getBusReplyPriority() {
        return this._bus_replyPriority;
    }

    public String getBusReplyReliability() {
        return this._bus_replyReliability;
    }

    public Long getBusReplyTimeToLive() {
        return this._bus_replyTimeToLive;
    }

    public String getBusSystemMessageId() {
        return this._bus_systemMessageId;
    }

    public String getJsMessageType() {
        return this._js_messageType;
    }

    public int getJsApproximateLength() {
        return this._js_approximateLength;
    }

    public Long getJsTimestamp() {
        return this._js_timestamp;
    }

    public Long getJsMessageWaitTime() {
        return this._js_messageWaitTime;
    }

    public Long getJsCurrentMEArrivalTimestamp() {
        return this._js_currentMEArrivalTimestamp;
    }

    public Integer getJsRedeliveredCount() {
        return this._js_redeliveredCount;
    }

    public String getJsSecurityUserid() {
        return this._js_securityUserid;
    }

    public String getJsProducerType() {
        return this._js_producerType;
    }

    public byte[] getJsApiMessageIdAsBytes() {
        return this._js_apiMessageIdAsBytes;
    }

    public byte[] getJsCorrelationIdAsBytes() {
        return this._js_correlationIdAsBytes;
    }

    public String getApiMessageId() {
        return this._api_messageId;
    }

    public String getApiCorrelationId() {
        return this._api_correlationId;
    }

    public String getApiUserid() {
        return this._api_userid;
    }

    public String getApiFormat() {
        return this._api_format;
    }

    public String getJmsDeliveryMode() {
        return this._jms_deliveryMode;
    }

    public Long getJmsExpiration() {
        return this._jms_expiration;
    }

    public String getJmsDestination() {
        return this._jms_destination;
    }

    public String getJmsReplyTo() {
        return this._jms_replyTo;
    }

    public Boolean getJmsRedelivered() {
        return this._jms_redelivered;
    }

    public String getJmsType() {
        return this._jms_type;
    }

    public int getJmsxDeliveryCount() {
        return this._jms_xDeliveryCount;
    }

    public String getJmsxAppId() {
        return this._jms_xAppId;
    }

    private void copyMessageDetail(SIBusMessage sIBusMessage) {
        JmsDestination jmsDestination;
        JsMessage jsMessage;
        this._bus_discriminator = sIBusMessage.getDiscriminator();
        this._bus_priority = sIBusMessage.getPriority();
        this._bus_reliability = sIBusMessage.getReliability().toString();
        this._bus_timeToLive = sIBusMessage.getTimeToLive();
        this._bus_replyDiscriminator = sIBusMessage.getReplyDiscriminator();
        this._bus_replyPriority = sIBusMessage.getReplyPriority();
        Reliability reliability = sIBusMessage.getReplyReliability();
        if (reliability != null) {
            this._bus_replyReliability = reliability.toString();
        }
        this._bus_replyTimeToLive = sIBusMessage.getReplyTimeToLive();
        this._bus_systemMessageId = sIBusMessage.getSystemMessageId();
        if (sIBusMessage instanceof JsMessage) {
            jsMessage = (JsMessage)sIBusMessage;
            this._type = jsMessage.getJsMessageType().toString();
            this._js_messageType = jsMessage.getJsMessageType().toString();
            this._js_approximateLength = jsMessage.getApproximateLength();
            this._js_timestamp = jsMessage.getTimestamp();
            this._js_messageWaitTime = jsMessage.getMessageWaitTime();
            this._js_currentMEArrivalTimestamp = jsMessage.getCurrentMEArrivalTimestamp();
            this._js_redeliveredCount = jsMessage.getRedeliveredCount();
            this._js_securityUserid = jsMessage.getSecurityUserid();
            this._js_producerType = jsMessage.getProducerType().toString();
            this._js_apiMessageIdAsBytes = jsMessage.getApiMessageIdAsBytes();
            this._js_correlationIdAsBytes = jsMessage.getCorrelationIdAsBytes();
        }
        if (sIBusMessage instanceof JsApiMessage) {
            jsMessage = (JsApiMessage)sIBusMessage;
            this._api_messageId = jsMessage.getApiMessageId();
            this._api_correlationId = jsMessage.getCorrelationId();
            this._api_userid = jsMessage.getUserid();
            this._api_format = jsMessage.getFormat();
        }
        if (sIBusMessage instanceof JsJmsMessage) {
            jsMessage = (JsJmsMessage)sIBusMessage;
            this._jms_deliveryMode = jsMessage.getJmsDeliveryMode().toString();
            this._jms_expiration = jsMessage.getJmsExpiration();
            if (jsMessage.getJmsDestination() != null) {
                try {
                    jmsDestination = JmsInternalsFactory.getMessageDestEncodingUtils().getDestinationFromMsgRepresentation(jsMessage.getJmsDestination());
                    this._jms_destination = jmsDestination.toString();
                }
                catch (Exception exception) {
                    this.fullyValid = false;
                }
            }
            try {
                jmsDestination = JmsInternalsFactory.getSharedUtils().inboundMessagePath((SIBusMessage)jsMessage, null);
                Destination destination = jmsDestination.getJMSReplyTo();
                if (destination != null) {
                    this._jms_replyTo = destination.toString();
                }
            }
            catch (Exception exception) {
                this.fullyValid = false;
            }
            this._jms_redelivered = jsMessage.getJmsRedelivered();
            this._jms_type = jsMessage.getJmsType();
            this._jms_xDeliveryCount = jsMessage.getJmsxDeliveryCount();
            this._jms_xAppId = jsMessage.getJmsxAppId();
        }
        if (sIBusMessage instanceof SIBusSdoMessage) {
            jsMessage = (SIBusSdoMessage)sIBusMessage;
            this._api_messageId = jsMessage.getApiMessageId();
            this._api_correlationId = jsMessage.getCorrelationId();
            this._api_userid = jsMessage.getUserid();
            this._api_format = jsMessage.getFormat();
            if (sIBusMessage instanceof JsSdoMessage) {
                this._type = "SDO";
                jmsDestination = (JsSdoMessage)sIBusMessage;
            } else {
                this._type = "BUSSDO";
            }
        }
    }
}

