/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.MessageEvent;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceEvent6;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JsNotifySpy
implements NotificationListener {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsNotifySpy";
    private static final TraceComponent tc = SibTr.register((Class)JsNotifySpy.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");

    public JsNotifySpy(ObjectName objectName, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"JsNotifySpy().<init>");
        }
        if (tc.isEventEnabled()) {
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                notificationFilterSupport.enableType("SIBRunning");
                adminService.addNotificationListener(objectName, (NotificationListener)this, null, object);
                ObjectName objectName2 = new ObjectName("*:*");
                adminService.addNotificationListenerExtended(objectName2, (NotificationListener)this, null, object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"JsNotifySpy().<init>");
        }
    }

    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleNotification()");
        }
        if (notification == null) {
            String string = "[NULL JMX event]: (handback obj= " + object + "): " + "Notification object is null";
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)string);
            }
        } else {
            Object object2;
            String string = "[Notification] (" + notification.getType() + ")" + notification.toString();
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)string);
            }
            if ((object2 = notification.getUserData()) != null) {
                if (object2 instanceof MessageEvent) {
                    if (tc.isDebugEnabled()) {
                        string = "[MessageEvent] (" + object2.toString() + ")";
                        SibTr.event((TraceComponent)tc, (String)string);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    DateFormat dateFormat = this.getBasicDateFormatter();
                    Date date = new Date();
                    FieldPosition fieldPosition = new FieldPosition(0);
                    string = "[MessageEvent] (" + ((MessageEvent)object2).formatBasic(stringBuffer, dateFormat, date, fieldPosition) + ")";
                } else if (object2 instanceof TraceEvent6) {
                    if (tc.isDebugEnabled()) {
                        string = "[TraceEvent] (" + object2.toString() + ")";
                        SibTr.event((TraceComponent)tc, (String)string);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    DateFormat dateFormat = this.getBasicDateFormatter();
                    Date date = new Date();
                    FieldPosition fieldPosition = new FieldPosition(0);
                    string = "[Trace] (" + ((MessageEvent)object2).formatBasic(stringBuffer, dateFormat, date, fieldPosition) + ")";
                } else {
                    if (tc.isDebugEnabled()) {
                        string = "[UnknownEvent] (" + object2.toString() + ")";
                        SibTr.event((TraceComponent)tc, (String)string);
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    DateFormat dateFormat = this.getBasicDateFormatter();
                    Date date = new Date();
                    FieldPosition fieldPosition = new FieldPosition(0);
                    string = "[UNKNOWNEVENT] (" + ((MessageEvent)object2).formatBasic(stringBuffer, dateFormat, date, fieldPosition) + ")";
                }
            } else {
                string = "[No userdata in notification]";
            }
            if (tc.isEventEnabled()) {
                SibTr.event((TraceComponent)tc, (String)string);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleNotification()");
        }
    }

    private DateFormat getBasicDateFormatter() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 2);
        if (dateFormat instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)dateFormat;
            String string = simpleDateFormat.toPattern();
            int n = string.length();
            int n2 = string.lastIndexOf(115) + 1;
            String string2 = string.substring(0, n2) + ":SSS z";
            if (n2 < n) {
                string2 = string2 + string.substring(n2, n);
            }
            string2 = string2.replace('h', 'H');
            string2 = string2.replace('K', 'H');
            string2 = string2.replace('k', 'H');
            string2 = string2.replace('a', ' ');
            string2 = string2.trim();
            simpleDateFormat.applyPattern(string2);
            dateFormat = simpleDateFormat;
        } else {
            dateFormat = new SimpleDateFormat("yy.MM.dd HH:mm:ss:SSS z");
        }
        return dateFormat;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsNotifySpy.java, SIB.admin, WAS602.SIB, o0610.11 1.14");
        }
    }
}

