/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.Controllable;
import com.ibm.ws.sib.admin.ControllableRegistrationService;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.admin.SIBExceptionInvalidValue;
import com.ibm.ws.sib.admin.exception.AlreadyRegisteredException;
import com.ibm.ws.sib.admin.exception.InvalidMBeanTypeException;
import com.ibm.ws.sib.admin.exception.NotRegisteredException;
import com.ibm.ws.sib.admin.impl.JsMediationPoint;
import com.ibm.ws.sib.admin.impl.JsMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.JsObject;
import com.ibm.ws.sib.admin.impl.JsPublicationPoint;
import com.ibm.ws.sib.admin.impl.JsQueuePoint;
import com.ibm.ws.sib.admin.impl.JsRemoteMediationPoint;
import com.ibm.ws.sib.admin.impl.JsRemotePublicationPoint;
import com.ibm.ws.sib.admin.impl.JsRemoteQueuePoint;
import com.ibm.ws.sib.admin.impl.JsRemoteSubscriptionPoint;
import com.ibm.ws.sib.admin.impl.JsSubscriptionPoint;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public final class JsMBeanFactoryImpl
implements ControllableRegistrationService {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsMBeanFactoryImpl";
    private static final TraceComponent tc = SibTr.register((Class)JsMBeanFactoryImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private JsMessagingEngineImpl _me = null;
    private Vector objects = new Vector();
    private HashMap newObjects = new HashMap();
    private HashMap controllableMap = new HashMap();
    private boolean _setup = false;

    public JsMBeanFactoryImpl(JsMessagingEngineImpl jsMessagingEngineImpl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.JsMBeanFactoryImpl().<init>");
        }
        this._me = jsMessagingEngineImpl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.JsMBeanFactoryImpl().<init>");
        }
    }

    public RuntimeEventListener register(Controllable controllable, ControllableType controllableType) throws AlreadyRegisteredException, SIBExceptionInvalidValue {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{controllable, controllableType});
        }
        RuntimeEventListener runtimeEventListener = null;
        if (controllableType == ControllableType.QUEUE_POINT) {
            runtimeEventListener = this.createQueuePointMBean(controllable);
        } else if (controllableType == ControllableType.PUBLICATION_POINT) {
            runtimeEventListener = this.createPublicationPointMBean(controllable);
        } else if (controllableType == ControllableType.SUBSCRIPTION_POINT) {
            runtimeEventListener = this.createSubscriptionPointMBean(controllable);
        } else if (controllableType == ControllableType.MEDIATION_POINT) {
            runtimeEventListener = this.createMediationPointMBean(controllable);
        } else if (controllableType == ControllableType.REMOTE_QUEUE_POINT) {
            runtimeEventListener = this.createRemoteQueuePointMBean(controllable);
        } else if (controllableType == ControllableType.REMOTE_PUBLICATION_POINT) {
            runtimeEventListener = this.createRemotePublicationPointMBean(controllable);
        } else if (controllableType == ControllableType.REMOTE_SUBSCRIPTION_POINT) {
            runtimeEventListener = this.createRemoteSubscriptionPointMBean(controllable);
        } else if (controllableType == ControllableType.REMOTE_MEDIATION_POINT) {
            runtimeEventListener = this.createRemoteMediationPointMBean(controllable);
        } else {
            String string = "Invalid ControllableType of " + controllableType.toString();
            SIBExceptionInvalidValue sIBExceptionInvalidValue = new SIBExceptionInvalidValue(nls.getFormattedMessage("INTERNAL_ERROR_SIAS0003", new Object[]{string}, string));
            FFDCFilter.processException((Throwable)sIBExceptionInvalidValue, (String)"com.ibm.ws.sib.admin.impl.JsMBeanFactoryImpl.register", (String)"PROBE_ID_10", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)sIBExceptionInvalidValue);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"register", (Object)sIBExceptionInvalidValue);
            }
            throw sIBExceptionInvalidValue;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)new Object[]{runtimeEventListener});
        }
        return runtimeEventListener;
    }

    public RuntimeEventListener register(Controllable controllable, Controllable controllable2, ControllableType controllableType) throws AlreadyRegisteredException, SIBExceptionInvalidValue {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{controllable, controllable2, controllableType});
        }
        Object var4_4 = null;
        String string = "Invalid ControllableType of " + controllableType.toString();
        SIBExceptionInvalidValue sIBExceptionInvalidValue = new SIBExceptionInvalidValue(nls.getFormattedMessage("INTERNAL_ERROR_SIAS0003", new Object[]{string}, string));
        FFDCFilter.processException((Throwable)sIBExceptionInvalidValue, (String)"com.ibm.ws.sib.admin.impl.JsMBeanFactoryImpl.register", (String)"PROBE_ID_20", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)sIBExceptionInvalidValue);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)sIBExceptionInvalidValue);
        }
        throw sIBExceptionInvalidValue;
    }

    public RuntimeEventListener register(Controllable controllable, RuntimeEventListener runtimeEventListener, ControllableType controllableType) throws AlreadyRegisteredException, SIBExceptionInvalidValue {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{controllable, runtimeEventListener, controllableType});
        }
        Object var4_4 = null;
        String string = "Invalid ControllableType of " + controllableType.toString();
        SIBExceptionInvalidValue sIBExceptionInvalidValue = new SIBExceptionInvalidValue(nls.getFormattedMessage("INTERNAL_ERROR_SIAS0003", new Object[]{string}, string));
        FFDCFilter.processException((Throwable)sIBExceptionInvalidValue, (String)"com.ibm.ws.sib.admin.impl.JsMBeanFactoryImpl.register", (String)"PROBE_ID_20", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)sIBExceptionInvalidValue);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)sIBExceptionInvalidValue);
        }
        throw sIBExceptionInvalidValue;
    }

    public void deregister(Controllable controllable, ControllableType controllableType) throws NotRegisteredException, SIBExceptionInvalidValue {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister", (Object)new Object[]{controllable, controllableType});
        }
        this.deregister(controllable);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    public void deregister(Controllable controllable) throws NotRegisteredException {
        Object v;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister", (Object)new Object[]{controllable});
        }
        if ((v = this.controllableMap.remove(controllable)) != null) {
            if (v instanceof JsObject) {
                ((JsObject)v).deactivateMBean();
            }
        } else {
            throw new NotRegisteredException("");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    public synchronized void deregisterAll() {
        Controllable controllable;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterAll");
        }
        Set set = this.controllableMap.entrySet();
        Vector vector = new Vector();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            controllable = iterator.next();
            Object k = controllable.getKey();
            if (k instanceof Controllable) {
                vector.add(k);
                continue;
            }
            SibTr.debug((TraceComponent)tc, (String)("Object " + k.toString() + " which is not of type Controllable was found in controllableMap"));
        }
        iterator = vector.iterator();
        while (iterator.hasNext()) {
            try {
                controllable = (Controllable)iterator.next();
                SibTr.debug((TraceComponent)tc, (String)("Controllable object " + controllable.toString() + " is being deregistered"));
                this.deregister(controllable);
                SibTr.debug((TraceComponent)tc, (String)"Controllable object was deregistered");
            }
            catch (NotRegisteredException notRegisteredException) {
                SibTr.debug((TraceComponent)tc, (String)"Controllable object could not be deregistered");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterAll");
        }
    }

    private RuntimeEventListener createQueuePointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createQueuePointMBean", (Object)new Object[]{controllable});
        }
        JsQueuePoint jsQueuePoint = new JsQueuePoint(this._me, controllable);
        this.controllableMap.put(controllable, jsQueuePoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createQueuePointMBean", (Object)new Object[]{jsQueuePoint});
        }
        return jsQueuePoint;
    }

    private RuntimeEventListener createPublicationPointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createPublicationPointMBean", (Object)new Object[]{controllable});
        }
        JsPublicationPoint jsPublicationPoint = new JsPublicationPoint(this._me, controllable);
        this.controllableMap.put(controllable, jsPublicationPoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createPublicationPointMBean", (Object)new Object[]{jsPublicationPoint});
        }
        return jsPublicationPoint;
    }

    private RuntimeEventListener createMediationPointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createMediationPointMBean", (Object)new Object[]{controllable});
        }
        JsMediationPoint jsMediationPoint = new JsMediationPoint(this._me, controllable);
        this.controllableMap.put(controllable, jsMediationPoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createMediationPointMBean", (Object)new Object[]{jsMediationPoint});
        }
        return jsMediationPoint;
    }

    private RuntimeEventListener createSubscriptionPointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionPointMBean", (Object)new Object[]{controllable});
        }
        JsSubscriptionPoint jsSubscriptionPoint = new JsSubscriptionPoint(this._me, controllable);
        this.controllableMap.put(controllable, jsSubscriptionPoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionPointMBean", (Object)new Object[]{jsSubscriptionPoint});
        }
        return jsSubscriptionPoint;
    }

    private RuntimeEventListener createRemoteQueuePointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteQueuePointMBean", (Object)new Object[]{controllable});
        }
        JsRemoteQueuePoint jsRemoteQueuePoint = new JsRemoteQueuePoint(this._me, controllable);
        this.controllableMap.put(controllable, jsRemoteQueuePoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteQueuePointMBean", (Object)new Object[]{jsRemoteQueuePoint});
        }
        return jsRemoteQueuePoint;
    }

    private RuntimeEventListener createRemotePublicationPointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemotePublicationPointMBean", (Object)new Object[]{controllable});
        }
        JsRemotePublicationPoint jsRemotePublicationPoint = new JsRemotePublicationPoint(this._me, controllable);
        this.controllableMap.put(controllable, jsRemotePublicationPoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemotePublicationPointMBean", (Object)new Object[]{jsRemotePublicationPoint});
        }
        return jsRemotePublicationPoint;
    }

    private RuntimeEventListener createRemoteMediationPointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteMediationPointMBean", (Object)new Object[]{controllable});
        }
        JsRemoteMediationPoint jsRemoteMediationPoint = new JsRemoteMediationPoint(this._me, controllable);
        this.controllableMap.put(controllable, jsRemoteMediationPoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteMediationPointMBean", (Object)new Object[]{jsRemoteMediationPoint});
        }
        return jsRemoteMediationPoint;
    }

    private RuntimeEventListener createRemoteSubscriptionPointMBean(Controllable controllable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createRemoteSubscriptionPointMBean", (Object)new Object[]{controllable});
        }
        JsRemoteSubscriptionPoint jsRemoteSubscriptionPoint = new JsRemoteSubscriptionPoint(this._me, controllable);
        this.controllableMap.put(controllable, jsRemoteSubscriptionPoint);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createRemoteSubscriptionPointMBean", (Object)new Object[]{jsRemoteSubscriptionPoint});
        }
        return jsRemoteSubscriptionPoint;
    }

    public String register(Object object, String string, String string2) throws InvalidMBeanTypeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{object, string, string2});
        }
        String string3 = null;
        if (!string.equals("QueuePoint")) {
            throw new InvalidMBeanTypeException("");
        }
        string3 = this.createQueuePointMBean(object, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)string3);
        }
        return string3;
    }

    public String register(Object object, LocalizationDefinition localizationDefinition, String string) throws InvalidMBeanTypeException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{object, string, localizationDefinition});
        }
        String string2 = null;
        if (!string.equals("QueuePoint")) {
            throw new InvalidMBeanTypeException("");
        }
        string2 = this.createQueuePointMBean(object, localizationDefinition);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register", (Object)string2);
        }
        return string2;
    }

    public void deregister(Object object) throws NotRegisteredException {
        Object v;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)new Object[]{object});
        }
        if ((v = this.newObjects.remove(object)) != null) {
            if (v instanceof JsObject) {
                ((JsObject)v).deactivateMBean();
            }
        } else {
            throw new NotRegisteredException("");
        }
        int n = 0;
        Enumeration enumeration = this.objects.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (e.equals(object)) {
                this.objects.remove(n);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deregister", (Object)"removed object");
                }
                return;
            }
            ++n;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister", (Object)"did not find object");
        }
        throw new NotRegisteredException("");
    }

    private String createQueuePointMBean(Object object, String string) {
        JsQueuePoint jsQueuePoint = new JsQueuePoint(this._me, null, string);
        this.objects.add(object);
        this.newObjects.put(object, jsQueuePoint);
        return jsQueuePoint.getObjectName().getCanonicalName();
    }

    private String createQueuePointMBean(Object object, LocalizationDefinition localizationDefinition) {
        JsQueuePoint jsQueuePoint = new JsQueuePoint(this._me, null, localizationDefinition.getName());
        this.objects.add(object);
        this.newObjects.put(object, jsQueuePoint);
        return jsQueuePoint.getObjectName().getCanonicalName();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsMBeanFactoryImpl.java, SIB.admin, WAS602.SIB, o0610.11 1.19");
        }
    }
}

