/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.sibresources.SIBForeignBus;
import com.ibm.websphere.models.config.sibresources.impl.SIBusImpl;
import com.ibm.ws.security.service.SecurityService;
import com.ibm.ws.sib.admin.BaseDestinationDefinition;
import com.ibm.ws.sib.admin.DestinationDefinition;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsAdminFactory;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.MediationDefinition;
import com.ibm.ws.sib.admin.SIBExceptionBase;
import com.ibm.ws.sib.admin.SIBExceptionDestinationNotFound;
import com.ibm.ws.sib.admin.impl.JsAdminFactoryImpl;
import com.ibm.ws.sib.admin.impl.JsDestinationCache;
import com.ibm.ws.sib.admin.impl.JsEObjectImpl;
import com.ibm.ws.sib.admin.impl.JsMainImpl;
import com.ibm.ws.sib.admin.impl.JsMediationCache;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class JsBusImpl
extends JsEObjectImpl
implements JsBus,
JsEObject {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.impl.JsBusImpl";
    private static final TraceComponent tc = SibTr.register((Class)JsBusImpl.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private JsMainImpl _mainImpl;
    private JsAdminFactory _jsaf = null;
    private JsDestinationCache _destinationCache = null;
    private JsMediationCache _mediationCache = null;
    private String _name = null;
    private SIBUuid8 _uuid = null;
    private Object configurationReload = null;
    private Properties customProperties = new Properties();

    public JsBusImpl(EObject eObject, JsMainImpl jsMainImpl, String string, String string2) {
        super(null, eObject, "SIBus", string);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.JsBusImpl.<init>");
        }
        this._mainImpl = jsMainImpl;
        try {
            this._jsaf = JsAdminFactory.getInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._name = string;
        this._mediationCache = new JsMediationCache(this);
        this._destinationCache = new JsDestinationCache(this);
        this.setCustomProperties();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"com.ibm.ws.sib.admin.impl.JsBusImpl.<init>");
        }
    }

    public String getName() {
        return this._name;
    }

    public boolean isSecure() {
        boolean bl = false;
        if (this.getAttribute("secure").equals("true")) {
            bl = true;
        }
        SecurityService securityService = (SecurityService)this._mainImpl.getService(SecurityService.class);
        boolean bl2 = securityService.isSecurityEnabled() && bl;
        return bl2;
    }

    public SIBUuid8 getUuid() {
        if (this._uuid == null) {
            String string = this.getAttribute("uuid");
            this._uuid = new SIBUuid8(string);
        }
        return this._uuid;
    }

    public JsDestinationCache getDestinationCache() {
        return this._destinationCache;
    }

    public JsMediationCache getMediationCache() {
        return this._mediationCache;
    }

    public BaseDestinationDefinition getSIBDestination(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        return this.getDestinationCache().getSIBDestination(string, string2);
    }

    public void getSIBDestination(String string, String string2, DestinationDefinition destinationDefinition) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        this.getDestinationCache().getSIBDestination(string, string2, destinationDefinition);
    }

    public Set getSIBDestinationLocalitySet(String string, String string2) throws SIBExceptionBase {
        return this.getDestinationCache().getSIBDestinationLocalitySet(string, string2);
    }

    public MediationDefinition getSIBMediation(String string, String string2) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        return this.getMediationCache().getSIBMediation(string, string2);
    }

    public void getSIBMediation(String string, String string2, MediationDefinition mediationDefinition) throws SIBExceptionBase, SIBExceptionDestinationNotFound {
        this.getMediationCache().getSIBMediation(string, string2, mediationDefinition);
    }

    public Set getSIBMediationLocalitySet(String string, String string2) throws SIBExceptionBase {
        return this.getMediationCache().getSIBMediationLocalitySet(string, string2);
    }

    public ForeignBusDefinition getForeignBus(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBus", (Object)string);
        }
        EList eList = ((SIBusImpl)this.getEObject()).getForeignBus();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SIBForeignBus sIBForeignBus = (SIBForeignBus)iterator.next();
            if (!string.equals(sIBForeignBus.getName())) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getForeignBus");
            }
            return ((JsAdminFactoryImpl)this._jsaf).createForeignBusDefinition(sIBForeignBus);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBus", (Object)"null");
        }
        return null;
    }

    public ForeignBusDefinition getForeignBusForLink(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusForLink", (Object)string);
        }
        EList eList = ((SIBusImpl)this.getEObject()).getForeignBus();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            SIBForeignBus sIBForeignBus = (SIBForeignBus)iterator.next();
            if (sIBForeignBus.getVirtualLink() == null || !string.equals(sIBForeignBus.getVirtualLink().getUuid())) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getForeignBusForLink");
            }
            return ((JsAdminFactoryImpl)this._jsaf).createForeignBusDefinition(sIBForeignBus);
        }
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_ERROR_SIAS0003", (Object)("Bus '" + this._name + "' does not contain a definition for a Foreign Bus with virtual link UUID '" + string + "'. You may have a link configured on a messaging engine that specifies a foreign bus that has been deleted."));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusForLink", (Object)"null");
        }
        return null;
    }

    public void refreshMediationCache() {
        this._mediationCache = new JsMediationCache(this);
    }

    public void refreshDestinationCache() {
        this._destinationCache = new JsDestinationCache(this);
    }

    boolean isConfigurationReloadEnabled() {
        if (this.configurationReload == null) {
            this.configurationReload = this.getAttribute("configurationReloadEnabled");
        }
        return this.configurationReload.equals("true");
    }

    public void setCustomProperties() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperties");
        }
        EList eList = ((SIBusImpl)this.getEObject()).getProperties();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string = property.getName();
            String string2 = property.getValue();
            this.setCustomProperty(property.getName(), property.getValue());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperties");
        }
    }

    public void setCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty", (Object)(string + " " + string2));
        }
        this.customProperties.put(string, string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    public String getCustomProperty(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCustomProperty", (Object)string);
        }
        String string2 = this.customProperties.getProperty(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCustomProperty", (Object)string2);
        }
        return string2;
    }

    public Boolean isEventNotificationPropertySet() {
        String string;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEventNotificationPropertySet");
        }
        Boolean bl = null;
        if (this.customProperties.containsKey("sib.event.notification") && (string = this.customProperties.getProperty("sib.event.notification")) != null) {
            if (string.equals("enabled")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Event Notification is enabled at the Bus");
                }
                bl = Boolean.TRUE;
            } else if (string.equals("disabled")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Event Notification is disabled at the Bus");
                }
                bl = Boolean.FALSE;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Event Notification Bus property set to: " + string));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEventNotificationPropertySet", bl);
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/impl/JsBusImpl.java, SIB.admin, WAS602.SIB, o0610.11 1.26");
        }
    }
}

