/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.admin.dynconfig;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.models.config.sibresources.impl.SIBusImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.SIBExceptionBusNotFound;
import com.ibm.ws.sib.admin.dynconfig.DynamicConfigManager;
import com.ibm.ws.sib.admin.impl.BaseMessagingEngineImpl;
import com.ibm.ws.sib.admin.impl.JsBusImpl;
import com.ibm.ws.sib.admin.impl.JsMainImpl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public final class JsBusListener
implements ConfigChangeListener {
    private static final String CLASS_NAME = "com.ibm.ws.sib.admin.dynconfig.JsBusListener";
    private static final TraceComponent tc = SibTr.register((Class)JsBusListener.class, (String)"SIBAdmin", (String)"com.ibm.ws.sib.admin.impl.CWSIDMessages");
    private String busName;
    private JsMainImpl mainImpl;
    private DynamicConfigManager dcManager;

    private JsBusListener() {
    }

    private JsBusListener(String string, JsMainImpl jsMainImpl, DynamicConfigManager dynamicConfigManager) {
        this.busName = string;
        this.mainImpl = jsMainImpl;
        this.dcManager = dynamicConfigManager;
    }

    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        block16: {
            String string;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"configChanged");
            }
            ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("configChanged: change count for bus " + this.busName + " is " + configChangeNotifierArray.length));
            }
            for (int i = 0; i < configChangeNotifierArray.length; ++i) {
                string = configChangeNotifierArray[i].getUri();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("configChanged: uri=" + string));
                }
                if (string.endsWith("sib-bus.xml")) {
                    bl = true;
                    continue;
                }
                if (string.endsWith("sib-mediations.xml")) {
                    bl2 = true;
                    continue;
                }
                if (string.endsWith("sib-destinations.xml")) {
                    bl3 = true;
                    bl2 = true;
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("configChanged: Unknown file in change set :" + string));
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("configChanged: change flags for bus " + this.busName + " are busChanged=" + bl + ", mediationsChanged=" + bl2 + ", destinationsChanged=" + bl3));
            }
            try {
                JsBusImpl jsBusImpl = (JsBusImpl)this.mainImpl.getBus(this.busName);
                string = (SIBusImpl)jsBusImpl.getEObject();
                if (bl) {
                    string = (SIBusImpl)this.mainImpl.getBusEObject(this.busName);
                    jsBusImpl.setEObject((EObject)string);
                }
                Enumeration enumeration = this.mainImpl.listMessagingEngines(this.busName);
                while (enumeration.hasMoreElements()) {
                    BaseMessagingEngineImpl baseMessagingEngineImpl = (BaseMessagingEngineImpl)enumeration.nextElement();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("configChanged: tell engine " + baseMessagingEngineImpl + " on bus " + this.busName));
                    }
                    baseMessagingEngineImpl.busReloaded((SIBus)string, bl, bl3, bl2);
                    this.dcManager.addNotifiedME((JsMessagingEngine)baseMessagingEngineImpl);
                }
                if (bl3) {
                    jsBusImpl.refreshDestinationCache();
                }
                if (bl2) {
                    jsBusImpl.refreshMediationCache();
                }
            }
            catch (SIBExceptionBusNotFound sIBExceptionBusNotFound) {
                FFDCFilter.processException((Throwable)sIBExceptionBusNotFound, (String)"com.ibm.ws.sib.admin.dynconfig.JsBusListener.configChanged", (String)"150", (Object)this);
                if (!tc.isDebugEnabled()) break block16;
                SibTr.debug((TraceComponent)tc, (String)("configChanged: Exception thrown, " + (Object)((Object)sIBExceptionBusNotFound)));
                SibTr.debug((TraceComponent)tc, (String)("configChanged: exception line 1, " + sIBExceptionBusNotFound.getStackTrace()[0]));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configChanged");
        }
    }

    public static void registerListener(DynamicConfigManager dynamicConfigManager, String string, JsMainImpl jsMainImpl) throws Exception {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerListener");
        }
        String string2 = "buses/" + string;
        URI[] uRIArray = new URI[]{URI.createURI((String)(string2 + "/" + "sib-bus.xml")), URI.createURI((String)(string2 + "/" + "sib-mediations.xml")), URI.createURI((String)(string2 + "/" + "sib-destinations.xml"))};
        dynamicConfigManager.registerBus(uRIArray, new JsBusListener(string, jsMainImpl, dynamicConfigManager));
        SibTr.info((TraceComponent)tc, (String)"DYN_CONFIG_BUS_REGISTER_SIAS0021", (Object)new Object[]{string});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerListener");
        }
    }

    public String toString() {
        return "Bus Listener for: " + this.busName;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.admin.impl/src/com/ibm/ws/sib/admin/dynconfig/JsBusListener.java, SIB.admin, WAS602.SIB, o0610.11 1.10");
        }
    }
}

