/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sib.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibresources.SIBDestinationDefault;
import com.ibm.websphere.models.config.sibresources.SIBForeignBus;
import com.ibm.websphere.models.config.sibresources.SIBLinkRef;
import com.ibm.websphere.models.config.sibresources.SIBVirtualLink;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.models.config.sibresources.SIBusMember;
import com.ibm.websphere.models.config.sibresources.SIBusMemberTarget;
import com.ibm.websphere.validation.base.config.WebSphereLevelValidator;
import com.ibm.websphere.validation.base.config.WebSpherePlatformValidator;
import com.ibm.websphere.validation.sib.level60.SIBValidationConstants_60;
import org.eclipse.emf.common.util.EList;

public class SIBusValidator_60
extends WebSphereLevelValidator
implements SIBValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";

    public SIBusValidator_60(WebSpherePlatformValidator webSpherePlatformValidator) {
        super(webSpherePlatformValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sib.level60.sibvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SIBServiceValidator_60";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        boolean bl = true;
        if (object instanceof SIBus) {
            this.validateLocal((SIBus)object);
        } else if (object instanceof SIBusMember) {
            this.validateLocal((SIBusMember)object);
        } else if (object instanceof SIBusMemberTarget) {
            this.validateLocal((SIBusMemberTarget)object);
        } else if (object instanceof SIBForeignBus) {
            this.validateLocal((SIBForeignBus)object);
        } else if (object instanceof SIBVirtualLink) {
            this.validateLocal((SIBVirtualLink)object);
        }
        return bl;
    }

    private void validateLocal(SIBus sIBus) {
        String string;
        String string2 = this.getCurrentCellName();
        String string3 = this.getCurrentBusName();
        String string4 = sIBus.getName();
        if (string4 == null || string4.length() < 1) {
            this.addError(this.getBundleId(), "BUS_ATTRIBUTE_UNDEFINED", new String[]{string3, "name"}, sIBus);
        }
        if ((string = sIBus.getUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "BUS_ATTRIBUTE_UNDEFINED", new String[]{string3, "uuid"}, sIBus);
        }
    }

    private void validateLocal(SIBusMember sIBusMember) {
        EList eList;
        String string = this.getCurrentBusName();
        String string2 = sIBusMember.getNode();
        String string3 = sIBusMember.getServer();
        String string4 = sIBusMember.getCluster();
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (!this.isValidBusMember(string2, string3, string4)) {
            this.addError(this.getBundleId(), "BUS_MEMBER_INVALID_MEMBER_LOCATION", new String[]{string, string2, string3, string4}, sIBusMember);
        }
        if (this.locatesServer(string2, string3, string4) && (eList = sIBusMember.getTarget()).size() > 1) {
            this.addError(this.getBundleId(), "BUS_MEMBER_TOO_MANY_TARGETS", new String[]{string, string2, string3}, sIBusMember);
        }
    }

    private void validateLocal(SIBusMemberTarget sIBusMemberTarget) {
        String string = this.getCurrentBusName();
        String string2 = sIBusMemberTarget.getEngineUuid();
        if (string2 == null || string2.length() < 1) {
            this.addError(this.getBundleId(), "BUS_MEMBER_TARGET_ATTRIBUTE_UNDEFINED", new String[]{string, "engineUuid"}, sIBusMemberTarget);
        }
    }

    private void validateLocal(SIBForeignBus sIBForeignBus) {
        SIBDestinationDefault sIBDestinationDefault;
        String string;
        String string2 = this.getCurrentBusName();
        String string3 = sIBForeignBus.getName();
        if (string3 == null || string3.length() < 1) {
            this.addError(this.getBundleId(), "FOREIGN_BUS_ATTRIBUTE_UNDEFINED", new String[]{string2, "name"}, sIBForeignBus);
        }
        if ((string = sIBForeignBus.getUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "FOREIGN_BUS_ATTRIBUTE_UNDEFINED", new String[]{string2, "uuid"}, sIBForeignBus);
        }
        SIBForeignBus sIBForeignBus2 = sIBForeignBus.getNextHop();
        SIBVirtualLink sIBVirtualLink = sIBForeignBus.getVirtualLink();
        if (sIBForeignBus2 != null && sIBVirtualLink != null) {
            this.addError(this.getBundleId(), "FOREIGN_BUS_INVALID_CONFIG_COMBINATION", new String[]{string2, "uuid"}, sIBForeignBus);
        }
        if ((sIBDestinationDefault = sIBForeignBus.getDestinationDefault()) == null) {
            this.addError(this.getBundleId(), "FOREIGN_BUS_CONFIG_UNDEFINED", new String[]{string2, "uuid"}, sIBForeignBus);
        }
    }

    private void validateLocal(SIBVirtualLink sIBVirtualLink) {
        String string;
        String string2 = this.getCurrentBusName();
        String string3 = sIBVirtualLink.getName();
        if (string3 == null || string3.length() < 1) {
            this.addError(this.getBundleId(), "VIRTUAL_LINK_ATTRIBUTE_UNDEFINED", new String[]{string2, "name"}, sIBVirtualLink);
        }
        if ((string = sIBVirtualLink.getUuid()) == null || string.length() < 1) {
            this.addError(this.getBundleId(), "VIRTUAL_LINK_ATTRIBUTE_UNDEFINED", new String[]{string2, "uuid"}, sIBVirtualLink);
        }
    }

    private void validateLocal(SIBLinkRef sIBLinkRef) {
        String string = this.getCurrentBusName();
        SIBusMemberTarget sIBusMemberTarget = sIBLinkRef.getEngine();
        if (sIBusMemberTarget == null) {
            this.addError(this.getBundleId(), "LINK_REF_CONFIG_UNDEFINED", new String[]{string, "engine"}, sIBLinkRef);
        }
    }

    private String getCurrentCellName() {
        String string = this.getCurrentFileName();
        int n = string.indexOf("cells/") + new String("cells/").length();
        int n2 = string.indexOf("/buses/");
        String string2 = string.substring(n, n2);
        return string2;
    }

    private String getCurrentBusName() {
        String string = this.getCurrentFileName();
        int n = string.indexOf("/buses/") + new String("/buses/").length();
        int n2 = string.indexOf("/sib-bus.xml");
        String string2 = string.substring(n, n2);
        return string2;
    }

    private boolean isValidBusMember(String string, String string2, String string3) {
        boolean bl = false;
        if (this.locatesCluster(string, string2, string3) || this.locatesServer(string, string2, string3)) {
            bl = true;
        }
        return bl;
    }

    private boolean locatesCluster(String string, String string2, String string3) {
        boolean bl = false;
        if (!(string3 == null || string3.length() <= 0 || string != null && string.length() >= 1 || string2 != null && string2.length() >= 1)) {
            bl = true;
        }
        return bl;
    }

    private boolean locatesServer(String string, String string2, String string3) {
        boolean bl = false;
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 && (string3 == null || string3.length() < 1)) {
            bl = true;
        }
        return bl;
    }
}

