/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.validation.sib.level60;

import com.ibm.etools.validation.ValidationException;
import com.ibm.websphere.models.config.sibresources.SIBDestination;
import com.ibm.websphere.models.config.sibresources.SIBGatewayLink;
import com.ibm.websphere.models.config.sibresources.SIBLocalizationPoint;
import com.ibm.websphere.models.config.sibresources.SIBMQLink;
import com.ibm.websphere.models.config.sibresources.SIBMessagingEngine;
import com.ibm.websphere.models.config.sibresources.SIBVirtualGatewayLink;
import com.ibm.websphere.models.config.sibresources.SIBVirtualMQLink;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.validation.base.config.WebSpherePlatformCrossValidator;
import com.ibm.websphere.validation.base.config.level60.ServerContextCrossValidator_60;
import com.ibm.websphere.validation.sib.level60.SIBValidationConstants_60;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;

public class SIBMessagingEnginesCrossValidator_60_Default
extends ServerContextCrossValidator_60
implements SIBValidationConstants_60 {
    public static final String pgmVersion = "%I%";
    public static final String pgmUpdate = "%G%";
    private String currentCell = null;
    private String currentNode = null;
    private String currentServer = null;
    private String currentCluster = null;

    public SIBMessagingEnginesCrossValidator_60_Default(WebSpherePlatformCrossValidator webSpherePlatformCrossValidator) {
        super(webSpherePlatformCrossValidator);
    }

    public String getBundleId() {
        return "com.ibm.websphere.validation.sib.level60.sibvalidation_60_NLS";
    }

    public String getTraceName() {
        return "SIBMessagingEnginesCrossValidator";
    }

    protected boolean basicValidate(Object object) throws ValidationException {
        this.setContext();
        boolean bl = true;
        if (object instanceof SIBMessagingEngine) {
            this.validateAcross((SIBMessagingEngine)object);
        } else {
            bl = super.basicValidate(object);
        }
        return bl;
    }

    private void validateAcross(SIBMessagingEngine sIBMessagingEngine) {
        Object object;
        Object object2;
        String string;
        String string2;
        EList eList;
        String string3;
        String string4 = sIBMessagingEngine.getName();
        String string5 = sIBMessagingEngine.getBusName();
        SIBus sIBus = this.findBus(string5, string3 = sIBMessagingEngine.getBusUuid());
        if (sIBus == null) {
            this.addError(this.getBundleId(), "ENGINE_NO_SUCH_BUS", new String[]{this.currentCell, string4, string5, string3}, sIBMessagingEngine);
        }
        EList eList2 = sIBMessagingEngine.getLocalizationPoints();
        Iterator iterator = eList2.iterator();
        while (iterator.hasNext()) {
            eList = (SIBLocalizationPoint)iterator.next();
            string2 = eList.getIdentifier();
            string = eList.getTargetUuid();
            object2 = this.findDestination(string5, string);
            if (object2 != null) continue;
            this.addError(this.getBundleId(), "LOCALIZATION_POINT_NO_SUCH_DESTINATION", new String[]{this.currentCell, string2, string5, string}, eList);
        }
        eList = sIBMessagingEngine.getMqLink();
        iterator = eList.iterator();
        while (iterator.hasNext()) {
            string2 = (SIBMQLink)iterator.next();
            string = string2.getName();
            object2 = string2.getTargetUuid();
            object = this.findVirtualMQLink(string5, (String)object2);
            if (object != null) continue;
            this.addError(this.getBundleId(), "MQ_LINK_NO_SUCH_VIRTUAL_MQ_LINK", new String[]{this.currentCell, string, string5, object2}, string2);
        }
        string2 = sIBMessagingEngine.getGatewayLink();
        iterator = string2.iterator();
        while (iterator.hasNext()) {
            string = (SIBGatewayLink)iterator.next();
            object2 = string.getName();
            object = string.getTargetUuid();
            SIBVirtualGatewayLink sIBVirtualGatewayLink = this.findVirtualGatewayLink(string5, (String)object);
            if (sIBVirtualGatewayLink != null) continue;
            this.addError(this.getBundleId(), "GATEWAY_LINK_NO_SUCH_VIRTUAL_GATEWAY_LINK", new String[]{this.currentCell, object2, string5, object}, string);
        }
    }

    private SIBus findBus(String string, String string2) {
        String string3 = "cells/" + this.currentCell + "/buses/" + string + "/sib-bus.xml";
        Object object = this.loadModel(string3);
        if (object instanceof EList && !((EList)object).isEmpty()) {
            Iterator iterator = ((EList)object).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof SIBus)) continue;
                SIBus sIBus = (SIBus)e;
                String string4 = sIBus.getUuid();
                String string5 = sIBus.getName();
                if (!string4.equals(string2) || !string5.equals(string)) continue;
                return sIBus;
            }
        }
        return null;
    }

    private SIBDestination findDestination(String string, String string2) {
        String string3 = "cells/" + this.currentCell + "/buses/" + string + "/sib-destinations.xml";
        Object object = this.loadModel(string3);
        if (object instanceof EList && !((EList)object).isEmpty()) {
            Iterator iterator = ((EList)object).iterator();
            while (iterator.hasNext()) {
                SIBDestination sIBDestination;
                String string4;
                Object e = iterator.next();
                if (!(e instanceof SIBDestination) || !(string4 = (sIBDestination = (SIBDestination)e).getUuid()).equals(string2)) continue;
                return sIBDestination;
            }
        }
        return null;
    }

    private SIBVirtualMQLink findVirtualMQLink(String string, String string2) {
        String string3 = "cells/" + this.currentCell + "/buses/" + string + "/sib-bus.xml";
        Object object = this.loadModel(string3);
        if (object instanceof EList && !((EList)object).isEmpty()) {
            Iterator iterator = ((EList)object).iterator();
            while (iterator.hasNext()) {
                SIBVirtualMQLink sIBVirtualMQLink;
                String string4;
                Object e = iterator.next();
                if (!(e instanceof SIBVirtualMQLink) || !(string4 = (sIBVirtualMQLink = (SIBVirtualMQLink)e).getUuid()).equals(string2)) continue;
                return sIBVirtualMQLink;
            }
        }
        return null;
    }

    private SIBVirtualGatewayLink findVirtualGatewayLink(String string, String string2) {
        String string3 = "cells/" + this.currentCell + "/buses/" + string + "/sib-bus.xml";
        Object object = this.loadModel(string3);
        if (object instanceof EList && !((EList)object).isEmpty()) {
            Iterator iterator = ((EList)object).iterator();
            while (iterator.hasNext()) {
                SIBVirtualGatewayLink sIBVirtualGatewayLink;
                String string4;
                Object e = iterator.next();
                if (!(e instanceof SIBVirtualGatewayLink) || !(string4 = (sIBVirtualGatewayLink = (SIBVirtualGatewayLink)e).getUuid()).equals(string2)) continue;
                return sIBVirtualGatewayLink;
            }
        }
        return null;
    }

    private void setContext() {
        this.currentCell = null;
        this.currentNode = null;
        this.currentServer = null;
        this.currentCluster = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.trimLeadingChainOf(this.getCurrentFileName());
        String string2 = null;
        String string3 = null;
        while (string != null) {
            String string4 = this.nabHeadOf(string);
            if (string2 == null) {
                string2 = string4;
                string3 = null;
            } else if (string3 == null) {
                string3 = string4;
                hashMap.put(string2, string3);
                string2 = null;
                string3 = null;
            }
            string = this.nabTailOf(string);
        }
        this.currentCell = (String)hashMap.get("cells");
        this.currentNode = (String)hashMap.get("nodes");
        this.currentServer = (String)hashMap.get("servers");
        this.currentCluster = (String)hashMap.get("clusters");
    }
}

