/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.i18n.context.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.i18n.context.ContextType;
import com.ibm.ws.i18n.context.I18nAttr;
import com.ibm.ws.i18n.context.I18nService;
import com.ibm.ws.i18n.context.LocalThreadContext_20;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Dom {
    private static final TraceComponent tc;
    private static boolean isEntryEnabled;
    public static final String I18NCONTEXTNAMESPACE = "http://www.ibm.com/webservices/InternationalizationContext";
    public static final String I18NCONTEXTPREFIX = "";
    public static final String I18NCONTEXTNAME = "InternationalizationContext";
    private static final String LOCALESNAME = "Locales";
    private static final String LOCALENAME = "Locale";
    private static final String COUNTRYCODENAME = "CountryCode";
    private static final String LANGUAGECODENAME = "LanguageCode";
    private static final String VARIANTCODENAME = "VariantCode";
    private static final String TIMEZONEIDNAME = "TimeZoneId";
    private static Document i18nDocument;

    public static Element fromContext(LocalThreadContext_20 ltc) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"fromContext");
        }
        Element i18nElement = null;
        i18nElement = i18nDocument.createElement(I18NCONTEXTNAME);
        Locale[] locales = (Locale[])ltc.getLocaleList(ContextType.INVOCATION);
        i18nElement.appendChild(Dom.localesToElement(locales));
        i18nElement.appendChild(Dom.timeZoneIdToElement((TimeZone)ltc.getTimeZone(ContextType.INVOCATION)));
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"fromContext", (Object)i18nElement);
        }
        return i18nElement;
    }

    private static Element localesToElement(Locale[] locales) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"localesToElement");
        }
        Element localesElement = i18nDocument.createElement(LOCALESNAME);
        for (int i = 0; i < locales.length; ++i) {
            localesElement.appendChild(Dom.localeToElement(locales[i]));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"localesToElement", (Object)localesElement);
        }
        return localesElement;
    }

    private static Element localeToElement(Locale locale) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"localeToElement");
        }
        Element localeElement = i18nDocument.createElement(LOCALENAME);
        Element countryElement = Dom.countryCodeToElement(locale.getCountry());
        Element languageElement = Dom.languageCodeToElement(locale.getLanguage());
        Element variantElement = Dom.variantCodeToElement(locale.getVariant());
        if (languageElement != null) {
            localeElement.appendChild(languageElement);
        }
        if (countryElement != null) {
            localeElement.appendChild(countryElement);
        }
        if (variantElement != null) {
            localeElement.appendChild(variantElement);
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"localeToElement", (Object)localeElement);
        }
        return localeElement;
    }

    private static Element languageCodeToElement(String languageCode) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"languageCodeToElement");
        }
        Element languageCodeElement = null;
        if (!languageCode.equals(I18NCONTEXTPREFIX)) {
            languageCodeElement = i18nDocument.createElement(LANGUAGECODENAME);
            languageCodeElement.appendChild(i18nDocument.createTextNode(languageCode));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"languageCodeToElement", (Object)languageCodeElement);
        }
        return languageCodeElement;
    }

    private static Element countryCodeToElement(String countryCode) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"countryCodeToElement");
        }
        Element countryCodeElement = null;
        if (!countryCode.equals(I18NCONTEXTPREFIX)) {
            countryCodeElement = i18nDocument.createElement(COUNTRYCODENAME);
            countryCodeElement.appendChild(i18nDocument.createTextNode(countryCode));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"countryCodeToElement", (Object)countryCodeElement);
        }
        return countryCodeElement;
    }

    private static Element variantCodeToElement(String variantCode) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"variantCodeToElement");
        }
        Element variantCodeElement = null;
        if (!variantCode.equals(I18NCONTEXTPREFIX)) {
            variantCodeElement = i18nDocument.createElement(VARIANTCODENAME);
            variantCodeElement.appendChild(i18nDocument.createTextNode(variantCode));
        }
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"variantCodeToElement", (Object)variantCodeElement);
        }
        return variantCodeElement;
    }

    private static Element timeZoneIdToElement(TimeZone tz) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"timeZoneIdToElement");
        }
        Element timeZoneIdElement = i18nDocument.createElement(TIMEZONEIDNAME);
        String tzid = tz.getID();
        if (tzid.equals("Custom")) {
            tzid = tz.getDisplayName();
        }
        timeZoneIdElement.appendChild(i18nDocument.createTextNode(tzid));
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"timeZoneIdToElement", (Object)timeZoneIdElement);
        }
        return timeZoneIdElement;
    }

    public static LocalThreadContext_20 toContext(Element i18nElement) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"toContext");
        }
        NodeList i18nCtxList = i18nElement.getElementsByTagName(I18NCONTEXTNAME);
        NodeList localesList = i18nElement.getElementsByTagName(LOCALENAME);
        String timeZoneId = i18nElement.getElementsByTagName(TIMEZONEIDNAME).item(0).getFirstChild().getNodeValue();
        int numOfLocales = localesList.getLength();
        Object[] locales = new Locale[numOfLocales];
        for (int i = 0; i < numOfLocales; ++i) {
            locales[i] = Dom.elementToLocale((Element)localesList.item(i));
        }
        TimeZone timezone = TimeZone.getTimeZone(timeZoneId);
        LocalThreadContext_20 ltc = LocalThreadContext_20.newInstance(locales, timezone, null, null, I18nAttr.CMI_RUN_AS_CALLER);
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"toContext", (Object)ltc);
        }
        return ltc;
    }

    private static Locale elementToLocale(Element localeElement) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"elementToLocale");
        }
        String languageCode = I18NCONTEXTPREFIX;
        String countryCode = I18NCONTEXTPREFIX;
        String variantCode = I18NCONTEXTPREFIX;
        NodeList children = localeElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (childName.equals(LANGUAGECODENAME)) {
                languageCode = Dom.elementToLanguageCode((Element)child);
                continue;
            }
            if (childName.equals(COUNTRYCODENAME)) {
                countryCode = Dom.elementToCountryCode((Element)child);
                continue;
            }
            if (!childName.equals(VARIANTCODENAME)) continue;
            variantCode = Dom.elementToVariantCode((Element)child);
        }
        Locale locale = variantCode.equals(I18NCONTEXTPREFIX) ? new Locale(languageCode, countryCode) : new Locale(languageCode, countryCode, variantCode);
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"elementToLocale", (Object)locale);
        }
        return locale;
    }

    private static String elementToCountryCode(Element countryCodeElement) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"elementToCountryCode");
        }
        String countryCode = countryCodeElement.getFirstChild().getNodeValue();
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"elementToCountryCode", (Object)countryCode);
        }
        return countryCode;
    }

    private static String elementToLanguageCode(Element languageCodeElement) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"elementToLanguageCode");
        }
        String languageCode = languageCodeElement.getFirstChild().getNodeValue();
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"elementToLanguageCode", (Object)languageCode);
        }
        return languageCode;
    }

    private static String elementToVariantCode(Element variantCodeElement) {
        isEntryEnabled = tc.isEntryEnabled();
        if (isEntryEnabled) {
            Tr.entry((TraceComponent)tc, (String)"elementToVariantCode");
        }
        String variantCode = variantCodeElement.getFirstChild().getNodeValue();
        if (isEntryEnabled) {
            Tr.exit((TraceComponent)tc, (String)"elementToVariantCode", (Object)variantCode);
        }
        return variantCode;
    }

    static {
        block2: {
            tc = Tr.register((String)"com.ibm.ws.i18n.context.util.Dom", (String)"InternationalizationService", (String)"com.ibm.ws.i18n.context.rsrc.i18nctx");
            try {
                i18nDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            }
            catch (ParserConfigurationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.i18n.context.util.Dom.static-init", (String)"101", (Object)I18nService.getInstance());
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"static-init", (Object)("Exception: " + e));
            }
        }
    }
}

