/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ProtectionClassLoader
extends ClassLoader
implements WsClassLoader {
    private static final TraceComponent tc;
    private ClassLoader parent;
    private String classpath;
    private static final Permission accessRuntimePermission;
    private static final boolean debug = true;
    private static String[] protectedPackages;
    private static String[][] packageExceptions;

    public ProtectionClassLoader(ClassLoader classLoader) {
        super(classLoader);
        this.parent = classLoader;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        SecurityManager securityManager;
        final Class<?> clazz = this.parent.loadClass(string);
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
        if (classLoader == this.parent && this.isProtected(string) && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(accessRuntimePermission);
            }
            catch (SecurityException securityException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("attempted to access protected class: " + string), (Object)securityException);
                }
                throw new ClassNotFoundException(string);
            }
        }
        return clazz;
    }

    public String getClassPath() {
        if (this.parent instanceof WsClassLoader) {
            return ((WsClassLoader)this.parent).getClassPath();
        }
        return System.getProperty("java.class.path");
    }

    private void errorMessage(String string) {
        System.out.println("******** com.ibm.ws.classloader.ProtectionClassLoader *******");
        System.out.println("application classloader attempted to access protected class");
        System.out.println("do not fix by adding doPrivileged block - open defect against WAS.classloader");
        System.out.println("class: " + string);
        System.out.println("*************************************************************");
    }

    private boolean isProtected(String string) {
        boolean bl = false;
        for (int i = 0; i < protectedPackages.length; ++i) {
            if (!string.regionMatches(0, protectedPackages[i], 0, protectedPackages[i].length())) continue;
            bl = true;
            for (int j = 0; j < packageExceptions[i].length; ++j) {
                if (!string.regionMatches(0, packageExceptions[i][j], 0, packageExceptions[i][j].length())) continue;
                bl = false;
            }
        }
        return bl;
    }

    static {
        int n;
        Object object;
        Serializable serializable;
        String[] stringArray;
        tc = Tr.register((Class)ProtectionClassLoader.class, (String)"Websphere ClassLoader", null);
        accessRuntimePermission = new WebSphereRuntimePermission("accessRuntimeClasses");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        try {
            stringArray = ProtectionClassLoader.class.getClassLoader().getResources("META-INF/protectedclasses.policy");
            while (stringArray.hasMoreElements()) {
                String string;
                serializable = stringArray.nextElement();
                InputStream inputStream = ((URL)serializable).openStream();
                object = new BufferedReader(new InputStreamReader(inputStream));
                while ((string = ((BufferedReader)object).readLine()) != null) {
                    int n2 = string.length() > 0 ? (int)string.charAt(0) : 35;
                    switch (n2) {
                        case 43: {
                            hashSet2.add(string.trim().substring(1));
                            break;
                        }
                        case 45: {
                            hashSet.add(string.trim().substring(1));
                        }
                    }
                }
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloader.ProtectionClassLoader", (String)"144");
        }
        protectedPackages = hashSet.toArray(new String[hashSet.size()]);
        stringArray = hashSet2.toArray(new String[hashSet2.size()]);
        serializable = new HashMap();
        for (n = 0; n < protectedPackages.length; ++n) {
            object = new ArrayList();
            ((HashMap)serializable).put(protectedPackages[n], object);
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith(protectedPackages[n])) continue;
                ((ArrayList)object).add(stringArray[i]);
            }
        }
        packageExceptions = new String[protectedPackages.length][];
        for (n = 0; n < protectedPackages.length; ++n) {
            object = (ArrayList)((HashMap)serializable).get(protectedPackages[n]);
            ProtectionClassLoader.packageExceptions[n] = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
        }
        if (tc.isDebugEnabled()) {
            for (n = 0; n < protectedPackages.length; ++n) {
                Tr.debug((TraceComponent)tc, (String)("protected: " + protectedPackages[n]));
                for (int i = 0; i < packageExceptions[n].length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("\texception:" + packageExceptions[n][i]));
                }
            }
        }
    }
}

