/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.classloader.ClassGraph;
import com.ibm.ws.classloader.ReloadableClassLoader;
import java.io.File;
import java.util.ArrayList;

public class JarClassLoader
extends ReloadableClassLoader {
    private static final TraceComponent tc = Tr.register((Class)JarClassLoader.class, (String)"Websphere ClassLoader", null);
    protected ArrayList jarPaths = new ArrayList();
    protected boolean delegationMode = false;

    public JarClassLoader(String[] stringArray, ClassLoader classLoader, boolean bl) {
        super(classLoader);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JarClassLoader", (Object)stringArray);
        }
        this.setPaths(stringArray);
        this.delegationMode = bl;
        this.createLoader();
        Tr.exit((TraceComponent)tc, (String)"JarClassLoader");
    }

    public JarClassLoader(String[] stringArray, ClassLoader classLoader, boolean bl, boolean bl2) {
        super(classLoader, bl2);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"JarClassLoader", (Object)stringArray);
        }
        this.setPaths(stringArray);
        this.delegationMode = bl;
        this.createLoader();
        Tr.exit((TraceComponent)tc, (String)"JarClassLoader");
    }

    public JarClassLoader(String string, ClassLoader classLoader, ClassGraph classGraph, boolean bl) {
        this(new String[]{string}, classLoader, bl);
    }

    public void dispose(boolean bl) {
        super.dispose(bl);
        this.jarPaths = null;
    }

    public String[] getPaths() {
        return this.jarPaths.toArray(new String[0]);
    }

    public void addPaths(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.jarPaths.contains(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
            this.jarPaths.add(stringArray[i]);
        }
        if (this.classLoader != null) {
            this.classLoader.addPaths(arrayList.toArray(new String[0]));
        }
    }

    public void addNativeLibPaths(String[] stringArray) {
        if (this.classLoader != null) {
            this.classLoader.addNativeLibPaths(stringArray);
        }
    }

    public void removePaths(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.jarPaths.remove(stringArray[i]);
        }
        if (this.classLoader != null) {
            this.classLoader.removePaths(stringArray);
        }
    }

    protected void setPaths(String[] stringArray) {
        this.jarPaths = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.jarPaths.add(stringArray[i]);
        }
    }

    public boolean getDelegationMode() {
        return this.delegationMode;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append('@');
        stringBuffer.append(this.hashCode());
        stringBuffer.append(" Local Classpath: ");
        if (this.jarPaths != null) {
            n = this.jarPaths.size();
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.jarPaths.get(i));
                if (i == n - 1) continue;
                stringBuffer.append(File.pathSeparator);
            }
        }
        if (this.classLoader != null) {
            n = this.classLoader.getDelegationMode() ? 1 : 0;
            stringBuffer.append(" Delegation mode: ");
            stringBuffer.append(n != 0 ? "PARENT_FIRST" : "PARENT_LAST");
        }
        if (this.disposed) {
            stringBuffer.append("DISPOSED CLASSLOADER");
        }
        return stringBuffer.toString();
    }
}

