/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.classloader.ClassLoaderPlugin;
import com.ibm.ws.bootstrap.WSLauncher;
import com.ibm.ws.classloader.ClassProviderListener;
import com.ibm.ws.classloader.CompoundEnumeration;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.classloader.SinglePathClassProvider;
import com.ibm.ws.classloader.WsClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.util.ServerIdentityHelper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class CompoundClassLoader
extends SecureClassLoader
implements ClassProviderListener,
WsClassLoader {
    private static final TraceComponent tc;
    protected ClassLoader parent = null;
    protected String localClassPath = "";
    protected String[] nativelibpaths = new String[0];
    protected boolean delegate = false;
    protected String[] protectedPrefixes = null;
    protected SinglePathClassProvider[] providers = new SinglePathClassProvider[0];
    protected Vector reloadableParents = new Vector();
    protected HashSet badResources = new HashSet();
    protected Map codeSourcePermissions;
    protected static DynamicPolicy dynamicPolicy;
    protected ServerIdentityHelper serverIdentityHelper = null;
    public static ClassLoaderPlugin plugin;

    public CompoundClassLoader(String[] stringArray, ClassLoader classLoader, boolean bl) {
        super(classLoader);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("CompoundClassLoader this=" + this));
        }
        if (WSLauncher.isZOS()) {
            this.serverIdentityHelper = ServerIdentityHelper.getServerIdentityHelper();
        }
        this.parent = classLoader != null ? classLoader : CompoundClassLoader.getSystemClassLoader();
        this.delegate = bl;
        this.addPaths(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"CompoundClassLoader");
        }
    }

    public CompoundClassLoader(String[] stringArray, ClassLoader classLoader, String[] stringArray2, boolean bl) {
        this(stringArray, classLoader, bl);
        this.protectedPrefixes = stringArray2;
    }

    protected CompoundClassLoader(CompoundClassLoader compoundClassLoader) {
        super(compoundClassLoader.getParent());
        this.parent = compoundClassLoader.parent;
        this.localClassPath = compoundClassLoader.localClassPath;
        this.nativelibpaths = compoundClassLoader.nativelibpaths;
        this.protectedPrefixes = compoundClassLoader.protectedPrefixes;
        this.delegate = compoundClassLoader.delegate;
        this.providers = compoundClassLoader.providers;
        this.reloadableParents = compoundClassLoader.reloadableParents;
        this.codeSourcePermissions = compoundClassLoader.codeSourcePermissions;
        this.serverIdentityHelper = compoundClassLoader.serverIdentityHelper;
    }

    public void setDelegationMode(boolean bl) {
        this.delegate = bl;
    }

    public boolean getDelegationMode() {
        return this.delegate;
    }

    public CompoundClassLoader reload() {
        return this.reload(true);
    }

    public CompoundClassLoader reload(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("reload this=" + this));
        }
        int n = this.providers.length;
        for (int i = 0; i < n; ++i) {
            this.providers[i].reload();
        }
        return new CompoundClassLoader(this);
    }

    public void dispose(boolean bl) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dispose this=" + this));
        }
        this.clearBadResourceList();
        int n = this.providers.length;
        for (int i = 0; i < n; ++i) {
            this.providers[i].dispose();
        }
        this.reloadableParents.clear();
        this.localClassPath = "";
        this.nativelibpaths = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBadResourceList() {
        HashSet hashSet = this.badResources;
        synchronized (hashSet) {
            this.badResources.clear();
        }
    }

    public synchronized void addPaths(String[] stringArray) {
        ArrayList<SinglePathClassProvider> arrayList = new ArrayList<SinglePathClassProvider>();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new SinglePathClassProvider(stringArray[i]));
        }
        this.addProviders(arrayList);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addPaths complete this=" + this));
            Tr.debug((TraceComponent)tc, (String)("addPaths complete traversed=" + this.getClassPath()));
        }
    }

    public synchronized void addNativeLibPaths(String[] stringArray) {
        String[] stringArray2 = this.nativelibpaths;
        this.nativelibpaths = new String[stringArray2.length + stringArray.length];
        System.arraycopy(stringArray2, 0, this.nativelibpaths, 0, stringArray2.length);
        System.arraycopy(stringArray, 0, this.nativelibpaths, stringArray2.length, stringArray.length);
        if (tc.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(File.pathSeparatorChar).append(stringArray[i]);
            }
            Tr.debug((TraceComponent)tc, (String)("addNativeLibPaths = " + (stringBuffer.length() > 0 ? stringBuffer.substring(1) : "")));
        }
    }

    public void removePaths(String[] stringArray) {
        ArrayList<SinglePathClassProvider> arrayList = new ArrayList<SinglePathClassProvider>();
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (n = this.providers.length - 1; n >= 0; --n) {
            for (n2 = stringArray.length - 1; n2 >= 0; --n2) {
                if (!this.providers[n].getPath().equals(stringArray[n2])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                arrayList.add(this.providers[n]);
                stringBuffer.append(File.pathSeparatorChar).append(this.providers[n].getPath());
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing path: " + this.providers[n].getPath()));
            }
            this.providers[n].dispose();
            bl = false;
        }
        this.localClassPath = stringBuffer.length() > 0 ? stringBuffer.substring(1) : "";
        int n3 = arrayList.size();
        SinglePathClassProvider[] singlePathClassProviderArray = new SinglePathClassProvider[n3];
        singlePathClassProviderArray = arrayList.toArray(singlePathClassProviderArray);
        this.providers = singlePathClassProviderArray;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removePaths complete this=" + this));
            Tr.debug((TraceComponent)tc, (String)("removePaths complete traversed=" + this.getClassPath()));
        }
    }

    protected void addProviders(ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = this.providers.length;
        SinglePathClassProvider[] singlePathClassProviderArray = new SinglePathClassProvider[n + n2];
        StringBuffer stringBuffer = new StringBuffer();
        SinglePathClassProvider singlePathClassProvider = null;
        for (int i = 0; i < n; ++i) {
            singlePathClassProvider = (SinglePathClassProvider)arrayList.get(i);
            singlePathClassProviderArray[n2++] = singlePathClassProvider;
            stringBuffer.append(File.pathSeparatorChar).append(singlePathClassProvider.getPath());
        }
        if (stringBuffer.length() > 0) {
            this.localClassPath = this.localClassPath.length() == 0 ? stringBuffer.substring(1) : this.localClassPath.concat(stringBuffer.toString());
        }
        System.arraycopy(this.providers, 0, singlePathClassProviderArray, 0, this.providers.length);
        this.providers = singlePathClassProviderArray;
    }

    public void addClassProviderListener(ClassProviderListener classProviderListener) {
        this.reloadableParents.add(classProviderListener);
    }

    public void classLoadedFromFile(File file) {
        int n = this.reloadableParents.size();
        for (int i = 0; i < n; ++i) {
            ClassProviderListener classProviderListener = (ClassProviderListener)this.reloadableParents.elementAt(i);
            classProviderListener.classLoadedFromFile(file);
        }
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        boolean bl2;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("loadClass name=" + string + " this=" + super.toString()));
            }
            bl2 = tc.isDebugEnabled();
            boolean bl3 = this.checkForSystemPrefix(string);
            clazz = this.findLoadedClass(string);
            boolean bl4 = this.delegate;
            if (!bl4 && (string.startsWith("java.") || string.startsWith("[Ljava."))) {
                bl4 = true;
            }
            if (clazz == null) {
                if (bl4) {
                    try {
                        if (bl3) {
                            throw new ClassNotFoundException(string);
                        }
                        clazz = this.parent.loadClass(string);
                        if (bl2) {
                            Tr.debug((TraceComponent)tc, (String)("loaded " + string + " from parent"));
                        }
                        break block18;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = this.findClass(string, bl4);
                        if (bl2) {
                            Tr.debug((TraceComponent)tc, (String)("loaded " + string + " from this=" + this));
                        }
                        break block18;
                    }
                }
                clazz = this.findClass(string, bl4);
                if (clazz == null) {
                    if (bl3) {
                        throw new ClassNotFoundException(string);
                    }
                    clazz = this.parent.loadClass(string);
                    if (bl2) {
                        Tr.debug((TraceComponent)tc, (String)("loaded " + string + " from parent"));
                    }
                } else if (bl2) {
                    Tr.debug((TraceComponent)tc, (String)("loaded " + string + " from this=" + this));
                }
            }
        }
        ClassLoader classLoader = null;
        if (bl || bl2) {
            final Class<?> clazz2 = clazz;
            classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return clazz2.getClassLoader();
                }
            });
        }
        if (bl2) {
            Tr.debug((TraceComponent)tc, (String)("loaded " + string + " using classloader=" + classLoader));
        }
        if (bl && classLoader == this) {
            this.resolveClass(clazz);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadClass");
        }
        return clazz;
    }

    public void localResolveClass(Class clazz) {
        this.resolveClass(clazz);
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class findClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findClass name=" + string + " this=" + super.toString()));
        }
        if ((clazz = this.findLoadedClass(string)) == null) {
            SinglePathClassProvider singlePathClassProvider;
            byte[] byArray;
            block12: {
                byArray = null;
                singlePathClassProvider = null;
                boolean bl2 = tc.isDebugEnabled();
                Object object = null;
                try {
                    if (this.serverIdentityHelper != null) {
                        object = this.serverIdentityHelper.push();
                    }
                    int n = this.providers.length;
                    for (int i = 0; i < n; ++i) {
                        byArray = this.providers[i].getClassBytes(string, this);
                        if (byArray == null) continue;
                        if (bl2) {
                            Tr.debug((TraceComponent)tc, (String)("class " + string + " found in " + this.providers[i]));
                        }
                        singlePathClassProvider = this.providers[i];
                        break;
                    }
                    Object var11_10 = null;
                    if (object == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (object != null) {
                        this.serverIdentityHelper.pop(object);
                    }
                    throw throwable;
                }
                this.serverIdentityHelper.pop(object);
            }
            if (byArray == null) {
                if (!bl) {
                    return null;
                }
                throw new ClassNotFoundException(string);
            }
            if (plugin != null) {
                byArray = plugin.preDefineApplicationClass(string, byArray);
            }
            clazz = this._defineClass(string, byArray, singlePathClassProvider);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findClass");
        }
        return clazz;
    }

    protected Class _defineClass(String string, byte[] byArray, SinglePathClassProvider singlePathClassProvider) {
        Object object;
        Object object2;
        Object object3;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            object3 = string.substring(0, n);
            Package package_ = this.getPackage((String)object3);
            object2 = singlePathClassProvider.getManifest();
            if (package_ == null) {
                if (object2 != null) {
                    this.definePackage((String)object3, (Manifest)object2, singlePathClassProvider.getURL());
                } else {
                    this.definePackage((String)object3, null, null, null, null, null, null, null);
                }
            } else if (System.getSecurityManager() != null) {
                boolean bl;
                object = singlePathClassProvider.getURL();
                if (package_.isSealed()) {
                    bl = package_.isSealed((URL)object);
                } else {
                    boolean bl2 = bl = object2 == null || !this.isSealed((String)object3, (Manifest)object2);
                }
                if (!bl) {
                    throw new SecurityException("sealing violation on package=" + package_.getName() + " at codesource=" + object);
                }
            }
        }
        object3 = new CodeSource(singlePathClassProvider.getURL(), (Certificate[])null);
        try {
            return this.defineClass(string, byArray, 0, byArray.length, (CodeSource)object3);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            object2 = this.throwableToString(noClassDefFoundError);
            String string2 = noClassDefFoundError.getMessage();
            string2 = string2 != null ? string2.replace('/', '.') : "<unknown>";
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            printWriter.println("Error while defining class: " + string);
            printWriter.println("This error indicates that the class: " + string2);
            printWriter.println("could not be located while defining the class: " + string);
            printWriter.println("This is often caused by having the class at a higher point in the classloader hierarchy");
            printWriter.println("Dumping the current context classloader hierarchy:");
            printWriter.println("    ==> indicates defining classloader");
            printWriter.println("    *** indicates classloader where the missing class could have been found");
            ClassLoader classLoader = null;
            try {
                classLoader = Thread.currentThread().getContextClassLoader().loadClass(string2).getClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.dumpHiearchy(printWriter, this, classLoader);
            printWriter.println("---Original exception---");
            printWriter.println((String)object2);
            printWriter.println("--- end Original exception----");
            printWriter.flush();
            throw new NoClassDefFoundError(((StringWriter)object).toString());
        }
        catch (LinkageError linkageError) {
            object2 = this.throwableToString(linkageError);
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            ((PrintWriter)object).println("LinkageError while defining class: " + string);
            ((PrintWriter)object).println("Could not be defined due to: " + linkageError.getMessage());
            ((PrintWriter)object).println("This is often caused by having a class defined at multiple");
            ((PrintWriter)object).println("locations within the classloader hierarchy.  Other potential causes");
            ((PrintWriter)object).println("include compiling against an older or newer version of the class");
            ((PrintWriter)object).println("that has an incompatible method signature.");
            ((PrintWriter)object).println("Dumping the current context classloader hierarchy:");
            ((PrintWriter)object).println("    ==> indicates defining classloader");
            this.dumpHiearchy((PrintWriter)object, this, null);
            ((PrintWriter)object).println("---Original exception---");
            ((PrintWriter)object).println((String)object2);
            ((PrintWriter)object).println("--- end Original exception----");
            ((PrintWriter)object).flush();
            throw new LinkageError(stringWriter.toString());
        }
    }

    private void dumpHiearchy(PrintWriter printWriter, ClassLoader classLoader, ClassLoader classLoader2) {
        int n = 0;
        ClassLoader classLoader3 = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        while (classLoader3 != null) {
            String string = "   ";
            ClassLoader classLoader4 = classLoader3;
            if (classLoader3 instanceof ReloadableClassLoader) {
                classLoader4 = ((ReloadableClassLoader)classLoader3).getCurrentClassLoader();
            }
            if (classLoader4 == classLoader) {
                string = "==>";
            }
            if (classLoader4 == classLoader2) {
                string = "***";
            }
            printWriter.println(string + "[" + n++ + "] " + classLoader3);
            final ClassLoader classLoader5 = classLoader3;
            classLoader3 = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return classLoader5.getParent();
                }
            });
        }
    }

    private String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private boolean isSealed(String string, Manifest manifest) {
        String string2 = string.replace('.', '/').concat("/");
        Attributes attributes = manifest.getAttributes(string2);
        String string3 = null;
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        if (string3 == null && (attributes = manifest.getMainAttributes()) != null) {
            string3 = attributes.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(string3);
    }

    protected Package definePackage(String string, Manifest manifest, URL uRL) throws IllegalArgumentException {
        String string2 = string.replace('.', '/').concat("/");
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        URL uRL2 = null;
        Attributes attributes = manifest.getAttributes(string2);
        if (attributes != null) {
            string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            string9 = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (string3 == null) {
                string3 = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (string4 == null) {
                string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (string5 == null) {
                string5 = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (string6 == null) {
                string6 = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (string7 == null) {
                string7 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (string8 == null) {
                string8 = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (string9 == null) {
                string9 = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(string9)) {
            uRL2 = uRL;
        }
        return this.definePackage(string, string3, string4, string5, string6, string7, string8, uRL2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String string) {
        URL uRL;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource", (Object)string);
        }
        if (this.badResources.contains(string)) {
            return null;
        }
        if (this.delegate) {
            uRL = this.parent.getResource(string);
            if (uRL == null) {
                uRL = this.findResource(string);
            }
        } else {
            uRL = this.findResource(string);
            if (uRL == null) {
                uRL = this.parent.getResource(string);
            }
        }
        if (uRL == null) {
            HashSet hashSet = this.badResources;
            synchronized (hashSet) {
                this.badResources.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResource");
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected URL findResource(String string) {
        URL uRL;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"findResource", (Object)new Object[]{string});
            }
            uRL = null;
            boolean bl = tc.isDebugEnabled();
            Object object = null;
            try {
                if (this.serverIdentityHelper != null) {
                    object = this.serverIdentityHelper.push();
                }
                int n = this.providers.length;
                for (int i = 0; i < n; ++i) {
                    uRL = this.providers[i].getResource(string);
                    if (uRL == null) continue;
                    if (!bl) break;
                    Tr.debug((TraceComponent)tc, (String)("resource " + string + " found in " + this.providers[i]));
                    break;
                }
                Object var8_7 = null;
                if (object == null) break block7;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (object != null) {
                    this.serverIdentityHelper.pop(object);
                }
                throw throwable;
            }
            this.serverIdentityHelper.pop(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findResource");
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Enumeration findResources(String string) throws IOException {
        CompoundEnumeration compoundEnumeration = new CompoundEnumeration();
        boolean bl = tc.isDebugEnabled();
        Object object = null;
        try {
            if (this.serverIdentityHelper != null) {
                object = this.serverIdentityHelper.push();
            }
            int n = this.providers.length;
            for (int i = 0; i < n; ++i) {
                URL uRL;
                if (bl) {
                    Tr.debug((TraceComponent)tc, (String)("findResources: looking for resource " + string + " in " + this.providers[i]));
                }
                if ((uRL = this.providers[i].getResource(string)) == null) continue;
                compoundEnumeration.addCompoundElement(uRL);
            }
            Object var9_8 = null;
            if (object == null) return compoundEnumeration;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (object == null) throw throwable;
            this.serverIdentityHelper.pop(object);
            throw throwable;
        }
        this.serverIdentityHelper.pop(object);
        return compoundEnumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResourceAsStream", (Object)string);
        }
        InputStream inputStream = null;
        if (this.badResources.contains(string)) {
            return null;
        }
        if (this.delegate) {
            inputStream = this.parent.getResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.localGetResourceAsStream(string);
            }
        } else {
            inputStream = this.localGetResourceAsStream(string);
            if (inputStream == null) {
                inputStream = this.parent.getResourceAsStream(string);
            }
        }
        if (inputStream == null) {
            HashSet hashSet = this.badResources;
            synchronized (hashSet) {
                this.badResources.add(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getResourceAsStream is=" + inputStream));
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream localGetResourceAsStream(String string) {
        InputStream inputStream;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"localGetResourceAsStream", (Object)string);
            }
            inputStream = null;
            boolean bl = tc.isDebugEnabled();
            Object object = null;
            try {
                if (this.serverIdentityHelper != null) {
                    object = this.serverIdentityHelper.push();
                }
                int n = this.providers.length;
                for (int i = 0; i < n; ++i) {
                    if (bl) {
                        Tr.debug((TraceComponent)tc, (String)("looking for resource " + string + " in " + this.providers[i]));
                    }
                    if ((inputStream = this.providers[i].getResourceAsStream(string)) == null) continue;
                    if (!bl) break;
                    Tr.debug((TraceComponent)tc, (String)("resource " + string + " found in " + this.providers[i]));
                    break;
                }
                Object var8_7 = null;
                if (object == null) break block8;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (object != null) {
                    this.serverIdentityHelper.pop(object);
                }
                throw throwable;
            }
            this.serverIdentityHelper.pop(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("localGetResourceAsStream is=" + inputStream));
        }
        return inputStream;
    }

    private boolean checkForSystemPrefix(String string) {
        if (this.protectedPrefixes != null) {
            int n = this.protectedPrefixes.length;
            for (int i = 0; i < n; ++i) {
                if (!string.startsWith(this.protectedPrefixes[i])) continue;
                return true;
            }
        }
        return false;
    }

    protected String findLibrary(String string) {
        final String string2 = System.mapLibraryName(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("looking for library: " + string2));
        }
        try {
            return (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() {
                    File file;
                    File file2;
                    int n;
                    int n2 = CompoundClassLoader.this.nativelibpaths.length;
                    for (n = 0; n < n2; ++n) {
                        file2 = new File(CompoundClassLoader.this.nativelibpaths[n]);
                        if (!file2.isDirectory() || !(file = new File(file2, string2)).exists()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("native library found: " + file.getPath()));
                        }
                        return file.getPath();
                    }
                    n2 = CompoundClassLoader.this.providers.length;
                    for (n = 0; n < n2; ++n) {
                        file2 = new File(CompoundClassLoader.this.providers[n].getPath());
                        if (!file2.isDirectory() || !(file = new File(file2, string2)).exists()) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("library found: " + file.getPath()));
                        }
                        return file.getPath();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public String getClassPath() {
        String string = null;
        String string2 = null;
        if (this.parent instanceof WsClassLoader) {
            string2 = ((WsClassLoader)this.parent).getClassPath();
        } else if (this.parent instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)this.parent).getURLs();
            StringBuffer stringBuffer = new StringBuffer();
            int n = uRLArray.length;
            for (int i = 0; i < n; ++i) {
                if (!uRLArray[i].getProtocol().equals("file")) continue;
                stringBuffer.append(uRLArray[i].getFile() + File.pathSeparatorChar);
            }
            string2 = stringBuffer.toString();
        } else {
            string2 = System.getProperty("java.class.path");
        }
        string = string2 == null ? this.localClassPath : (this.localClassPath.length() == 0 ? string2 : (this.delegate ? string2 + File.pathSeparator + this.localClassPath : this.localClassPath + File.pathSeparator + string2));
        return string;
    }

    public CompoundClassLoader getCurrentClassLoader() {
        return this;
    }

    public String[] getPaths() {
        return this.localClassPath.split(File.pathSeparator);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("\n   Local ClassPath: ");
        stringBuffer.append(this.localClassPath);
        stringBuffer.append("\n   Delegation Mode: ");
        stringBuffer.append(this.delegate ? "PARENT_FIRST" : "PARENT_LAST");
        return stringBuffer.toString();
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = null;
        if (this.codeSourcePermissions != null) {
            permissionCollection = dynamicPolicy.getPermissions(codeSource, this.codeSourcePermissions);
        }
        if (permissionCollection == null) {
            permissionCollection = super.getPermissions(codeSource);
        }
        return permissionCollection;
    }

    public Map getCodeSourcePermissions() {
        return this.codeSourcePermissions;
    }

    public void setCodeSourcePermissions(Map map) {
        this.codeSourcePermissions = map;
        if (dynamicPolicy == null) {
            dynamicPolicy = DynamicPolicyFactory.getInstance();
        }
    }

    public boolean isAncestor(CompoundClassLoader compoundClassLoader) {
        CompoundClassLoader compoundClassLoader2;
        if (compoundClassLoader == this) {
            return true;
        }
        ClassLoader classLoader = this.getParent();
        if (classLoader instanceof ReloadableClassLoader && (compoundClassLoader2 = ((ReloadableClassLoader)classLoader).getCurrentClassLoader()).isAncestor(compoundClassLoader)) {
            return true;
        }
        return classLoader instanceof CompoundClassLoader && (compoundClassLoader2 = (CompoundClassLoader)classLoader).isAncestor(compoundClassLoader);
    }

    static {
        block3: {
            tc = Tr.register((Class)CompoundClassLoader.class, (String)"Websphere ClassLoader", null);
            plugin = null;
            String string = System.getProperty("com.ibm.websphere.classloader.plugin");
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    plugin = (ClassLoaderPlugin)clazz.newInstance();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.classloader.CompoundClassLoader", (String)"70");
                    throwable.printStackTrace();
                    if (!(throwable instanceof ExceptionInInitializerError)) break block3;
                    ((ExceptionInInitializerError)throwable).getException().printStackTrace();
                }
            }
        }
    }
}

