/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.Archive;
import com.ibm.etools.j2ee.commonarchivecore.ModuleRef;
import com.ibm.etools.j2ee.commonarchivecore.helpers.RuntimeClasspathEntry;
import com.ibm.ws.classloader.ClassGraph;
import com.ibm.ws.classloader.ClassGraphState;
import com.ibm.ws.classloader.ClassLoaderDump;
import com.ibm.ws.classloader.ClassLoaderListener;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ClassLoaderManager {
    private static TraceComponent tc = Tr.register((String)ClassLoaderManager.class.getName(), (String)"Websphere ClassLoader", null);
    protected ClassLoader parent = null;
    protected ReloadableClassLoader applicationClassLoader;
    protected EARFile earFile = null;
    protected HashMap moduleClassLoaderLookup = new HashMap();
    protected HashMap listenerListLookup = new HashMap();
    protected boolean disposed = false;
    protected HashSet timers = new HashSet();
    protected boolean overrideReload = false;
    protected long overrideReloadInterval = 0L;
    protected boolean processFarFiles = false;
    protected String specifiedWasPolicy = null;
    protected boolean specifiedLibraryDelegation;
    protected ClassLoader warParent = null;
    protected ClassGraphState classGraphState = null;
    private static boolean singleServerClassLoader = false;
    protected boolean singleWarClassLoader = false;
    private static boolean defaultDelegationMode = true;
    protected static JarClassLoader serverClassLoader = null;

    public static void setSingleServerClassLoader(boolean bl) {
        singleServerClassLoader = bl;
    }

    public static boolean getSingleServerClassLoader() {
        return singleServerClassLoader;
    }

    public static void setDefaultDelegationMode(boolean bl) {
        defaultDelegationMode = bl;
    }

    public static boolean getDefaultDelegationMode() {
        return defaultDelegationMode;
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, long l) {
        this(classLoader, eARFile, bl, stringArray, bl2, string, bl3, l, false);
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this(classLoader, eARFile, bl, stringArray, new String[0], bl2, string, bl3, l, false);
    }

    public ClassLoaderManager(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, String[] stringArray2, boolean bl2, String string, boolean bl3, long l, boolean bl4) {
        this.overrideReload = bl3;
        this.overrideReloadInterval = l;
        this.processFarFiles = bl4;
        this.specifiedLibraryDelegation = bl2;
        this.specifiedWasPolicy = string;
        this.initialize(classLoader, eARFile, bl, stringArray, stringArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize(ClassLoader classLoader, EARFile eARFile, boolean bl, String[] stringArray, String[] stringArray2) {
        com.ibm.etools.commonarchive.ModuleRef moduleRef;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        this.parent = classLoader;
        this.earFile = eARFile;
        this.singleWarClassLoader = bl;
        if (singleServerClassLoader) {
            object = classLoader;
            synchronized (object) {
                if (serverClassLoader == null) {
                    serverClassLoader = new JarClassLoader(new String[0], classLoader, defaultDelegationMode);
                    serverClassLoader.createLoader();
                }
            }
        }
        object = new ClassGraph(classLoader, stringArray, stringArray2, this.specifiedLibraryDelegation, bl);
        Iterator iterator = eARFile.getModuleRefs().iterator();
        while (iterator.hasNext()) {
            moduleRef = (com.ibm.etools.commonarchive.ModuleRef)iterator.next();
            ((ClassGraph)object).addModule((ModuleRef)moduleRef);
        }
        if (this.processFarFiles) {
            this.processFARFiles(eARFile, (ClassGraph)object);
        }
        this.warParent = ((ClassGraph)object).calculate(eARFile, this.specifiedWasPolicy);
        this.classGraphState = ((ClassGraph)object).getState();
        iterator = eARFile.getModuleRefs().iterator();
        while (iterator.hasNext()) {
            moduleRef = (com.ibm.etools.commonarchive.ModuleRef)iterator.next();
            ReloadableClassLoader reloadableClassLoader = ((ClassGraph)object).lookupClassLoader((ModuleRef)moduleRef);
            if (reloadableClassLoader == null) continue;
            this.moduleClassLoaderLookup.put(moduleRef, reloadableClassLoader);
            if (reloadableClassLoader != serverClassLoader) {
                this.createTimer(moduleRef);
            }
            ClassLoaderDump.addModule(moduleRef.getUri(), reloadableClassLoader);
        }
        this.applicationClassLoader = ((ClassGraph)object).lookupClassLoader(null);
        this.moduleClassLoaderLookup.put(null, this.applicationClassLoader);
        this.createTimer(null);
        ClassLoaderDump.addApplication(eARFile.getURI(), this.applicationClassLoader);
        ((ClassGraph)object).dispose();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ClassLoaderManager");
        }
    }

    public void addNewModule(com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        Object object;
        ClassGraph classGraph = new ClassGraph(this.classGraphState);
        classGraph.addModule((ModuleRef)moduleRef);
        classGraph.updateClassLoaders((EARFile)moduleRef.getEarFile(), this.specifiedWasPolicy, this.warParent);
        ReloadableClassLoader reloadableClassLoader = classGraph.lookupClassLoader((ModuleRef)moduleRef);
        String string = moduleRef != null ? moduleRef.getUri() : null;
        Iterator iterator = null;
        com.ibm.etools.commonarchive.ModuleRef moduleRef2 = null;
        Object var7_7 = null;
        if (reloadableClassLoader != null) {
            iterator = this.moduleClassLoaderLookup.keySet().iterator();
            while (iterator.hasNext()) {
                var7_7 = iterator.next();
                if (var7_7 == null || !(moduleRef2 = (com.ibm.etools.commonarchive.ModuleRef)var7_7).getUri().equals(string)) continue;
                object = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef2);
                this.moduleClassLoaderLookup.remove(moduleRef2);
                if (object == serverClassLoader) break;
                ((ReloadableClassLoader)object).dispose(true);
                break;
            }
            this.moduleClassLoaderLookup.put(moduleRef, reloadableClassLoader);
            if (reloadableClassLoader != serverClassLoader) {
                this.createTimer(moduleRef);
            }
            ClassLoaderDump.addModule(moduleRef.getUri(), reloadableClassLoader);
        }
        iterator = this.listenerListLookup.keySet().iterator();
        object = (Vector)this.listenerListLookup.get(null);
        while (iterator.hasNext()) {
            var7_7 = iterator.next();
            if (var7_7 == null || !(moduleRef2 = (com.ibm.etools.commonarchive.ModuleRef)var7_7).getUri().equals(string)) continue;
            object = (Vector)this.listenerListLookup.get(moduleRef2);
            this.listenerListLookup.remove(moduleRef2);
            break;
        }
        this.listenerListLookup.put(moduleRef, object);
    }

    protected void processFARFiles(EARFile eARFile, ClassGraph classGraph) {
        List list = eARFile.getFARFiles();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Archive archive = (Archive)list.get(i);
            RuntimeClasspathEntry[] runtimeClasspathEntryArray = archive.getLocalRuntimeClassPath();
            for (int j = 0; j < runtimeClasspathEntryArray.length; ++j) {
                arrayList.add(runtimeClasspathEntryArray[j].getAbsolutePath());
            }
            RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = archive.getDependencyClassPath();
            for (int j = 0; j < runtimeClasspathEntryArray2.length; ++j) {
                arrayList.add(runtimeClasspathEntryArray2[j].getAbsolutePath());
            }
        }
        if (arrayList.size() > 0) {
            String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
            classGraph.addUtilityJars(stringArray);
        }
    }

    public void dispose() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("dispose " + this.earFile.getURI()));
        }
        this.disposed = true;
        this.cancelAllTimers();
        this.parent = null;
        this.earFile = null;
        Iterator iterator = this.moduleClassLoaderLookup.values().iterator();
        while (iterator.hasNext()) {
            ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)iterator.next();
            if (reloadableClassLoader == serverClassLoader) continue;
            ClassLoaderDump.removeClassLoader(reloadableClassLoader);
            reloadableClassLoader.dispose(true);
        }
        this.classGraphState.dispose(serverClassLoader);
        this.moduleClassLoaderLookup.clear();
        this.listenerListLookup.clear();
        this.applicationClassLoader = null;
    }

    public ReloadableClassLoader lookupClassLoader(com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupClassLoader", (Object)moduleRef.getUri());
        }
        if ((reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader.getRemoved()) {
            reloadableClassLoader.setRemoved(false);
            reloadableClassLoader.reload();
            this.createTimer(moduleRef);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupClassLoader");
        }
        return reloadableClassLoader;
    }

    public void removeClassLoader(com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
        if (reloadableClassLoader != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.setRemoved(true);
            this.cancelTimer(moduleRef);
        }
    }

    public ClassLoader getApplicationClassLoader() {
        return this.applicationClassLoader;
    }

    public void setDelegationMode(com.ibm.etools.commonarchive.ModuleRef moduleRef, boolean bl) {
        ReloadableClassLoader reloadableClassLoader;
        if (!this.singleWarClassLoader && (reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.setDelegationMode(bl);
        }
    }

    public void addClassLoaderListener(ClassLoaderListener classLoaderListener, com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        Vector<ClassLoaderListener> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addClassLoaderListener", (Object)(moduleRef != null ? moduleRef.getUri() : "appClassLoader"));
        }
        if ((vector = (Vector<ClassLoaderListener>)this.listenerListLookup.get(moduleRef)) == null) {
            vector = new Vector<ClassLoaderListener>();
            this.listenerListLookup.put(moduleRef, vector);
        }
        vector.addElement(classLoaderListener);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addClassLoaderListener");
        }
    }

    public void removeClassLoaderListener(ClassLoaderListener classLoaderListener, com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeClassLoaderListener", (Object)moduleRef.getUri());
        }
        if ((vector = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
            vector.removeElement(classLoaderListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeClassLoaderListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reload");
        }
        HashMap hashMap = this.moduleClassLoaderLookup;
        synchronized (hashMap) {
            Iterator iterator = this.moduleClassLoaderLookup.values().iterator();
            while (iterator.hasNext()) {
                ReloadableClassLoader reloadableClassLoader = (ReloadableClassLoader)iterator.next();
                if (reloadableClassLoader == serverClassLoader) continue;
                reloadableClassLoader.reload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reload");
        }
    }

    public void reloadClassLoader(com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        ReloadableClassLoader reloadableClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reloadClassLoader");
        }
        if ((reloadableClassLoader = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef)) != null && reloadableClassLoader != serverClassLoader) {
            reloadableClassLoader.reload();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reloadClassLoader");
        }
    }

    public void createTimer(com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        Object object;
        long l = 0L;
        if (this.overrideReload) {
            l = this.overrideReloadInterval * 1000L;
        } else if (moduleRef != null && moduleRef.isWeb()) {
            object = null;
            try {
                object = (WebAppExtension)moduleRef.getExtensions();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.classloader.ClassLoaderManager.createTimer", (String)"278", (Object)this);
                Tr.error((TraceComponent)tc, (String)"Error loading web application extension {0}", (Object)exception);
            }
            if (object != null && object.isReloadingEnabled()) {
                l = object.getReloadInterval() * 1000;
            }
        } else {
            l = this.earFile.getExtensions().getReloadInterval() * 1000L;
        }
        if (l > 0L) {
            object = null;
            object = (ReloadableClassLoader)this.moduleClassLoaderLookup.get(moduleRef);
            if (object != serverClassLoader) {
                ((ReloadableClassLoader)object).enableReloading();
                ReloadTimerTask reloadTimerTask = new ReloadTimerTask(moduleRef, l);
                reloadTimerTask.alarm = AlarmManager.createDeferrable((long)l, (AlarmListener)reloadTimerTask);
                this.timers.add(reloadTimerTask);
            }
        }
    }

    public synchronized void cancelTimer(com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ReloadTimerTask reloadTimerTask = (ReloadTimerTask)iterator.next();
            if (reloadTimerTask.moduleRef != moduleRef || reloadTimerTask.alarm == null) continue;
            reloadTimerTask.alarm.cancel();
            this.timers.remove(reloadTimerTask);
            return;
        }
    }

    public void cancelAllTimers() {
        Iterator iterator = this.timers.iterator();
        while (iterator.hasNext()) {
            ReloadTimerTask reloadTimerTask = (ReloadTimerTask)iterator.next();
            if (reloadTimerTask.alarm == null) continue;
            reloadTimerTask.alarm.cancel();
        }
        this.timers.clear();
    }

    private boolean checkAndNotify(ReloadableClassLoader reloadableClassLoader, com.ibm.etools.commonarchive.ModuleRef moduleRef) {
        boolean bl = false;
        if (reloadableClassLoader.checkForUpdate()) {
            Vector vector;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"class has chanaged");
            }
            if ((vector = (Vector)this.listenerListLookup.get(moduleRef)) != null) {
                ClassLoaderListener classLoaderListener;
                for (int i = 0; i < vector.size(); ++i) {
                    classLoaderListener = (ClassLoaderListener)vector.elementAt(i);
                    classLoaderListener.classChanged((ModuleRef)moduleRef);
                }
                if (this.disposed) {
                    bl = true;
                } else if (moduleRef != null) {
                    String string = moduleRef.getUri();
                    classLoaderListener = null;
                    com.ibm.etools.commonarchive.ModuleRef moduleRef2 = null;
                    Iterator iterator = this.moduleClassLoaderLookup.keySet().iterator();
                    while (iterator.hasNext()) {
                        classLoaderListener = iterator.next();
                        if (classLoaderListener == null || !(moduleRef2 = (com.ibm.etools.commonarchive.ModuleRef)classLoaderListener).getUri().equals(string) || moduleRef2 == moduleRef) continue;
                        bl = true;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    private class ReloadTimerTask
    implements AlarmListener {
        public com.ibm.etools.commonarchive.ModuleRef moduleRef;
        public long reloadInterval;
        Alarm alarm;

        public ReloadTimerTask(com.ibm.etools.commonarchive.ModuleRef moduleRef, long l) {
            this.moduleRef = moduleRef;
            this.reloadInterval = l;
        }

        public void alarm(Object object) {
            ReloadableClassLoader reloadableClassLoader;
            boolean bl;
            if (!ClassLoaderManager.this.disposed && !(bl = ClassLoaderManager.this.checkAndNotify(reloadableClassLoader = (ReloadableClassLoader)ClassLoaderManager.this.moduleClassLoaderLookup.get(this.moduleRef), this.moduleRef))) {
                this.alarm = AlarmManager.createDeferrable((long)this.reloadInterval, (AlarmListener)this);
            }
        }
    }

    private static class CacheEntry {
        long lastModified;
        File origin;

        public CacheEntry(File file, long l) {
            this.origin = file;
            this.lastModified = l;
        }

        public String toString() {
            return this.origin.getPath() + " lastModfied : " + this.lastModified;
        }
    }
}

