/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SerialDeserialSubjectException;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.common.auth.WSPrincipalImpl;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.token.Token;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;

public class WSLoginHelperImpl {
    private static final AuthPermission GET_SUBJECT_PERMISSION = new AuthPermission("getSubject");
    private static final PrivilegedExceptionAction getSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSubjectAction.run()");
            }
            Subject subject = null;
            Subject subject2 = null;
            subject = ContextManagerFactory.getInstance().getInvocationSubject();
            subject2 = ContextManagerFactory.getInstance().getCallerSubject();
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubjectAction.run()", (Object)new Object[]{new Boolean(subject != null), new Boolean(subject2 != null)});
            }
            return new Subject[]{subject, subject2};
        }
    };
    private static final PrivilegedExceptionAction getNonForwardableSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getNonForwardableSubjectAction.run()");
            }
            Subject subject = null;
            Subject subject2 = null;
            Object var3_3 = null;
            Object var4_4 = null;
            Subject subject3 = null;
            subject3 = ContextManagerFactory.getInstance().getInvocationSubject();
            if (subject3 != null) {
                subject = this.createNonForwardableSubjectFromSubject(subject3);
            }
            subject3 = null;
            subject3 = ContextManagerFactory.getInstance().getCallerSubject();
            if (subject3 != null) {
                subject2 = this.createNonForwardableSubjectFromSubject(subject3);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubjectAction.run()");
            }
            return new Subject[]{subject, subject2};
        }

        private Subject createNonForwardableSubjectFromSubject(Subject subject) throws WSSecurityException, GeneralSecurityException {
            Iterator iterator;
            Object object;
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createNonForwardableSubjectFromSubject");
            }
            Subject subject2 = new Subject();
            WSCredentialImpl wSCredentialImpl = null;
            WSCredentialImpl wSCredentialImpl2 = null;
            WSCredentialImpl wSCredentialImpl3 = null;
            Hashtable hashtable = null;
            Set<Object> set = subject.getPublicCredentials();
            if (set != null && set.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got some public credentials to iterate through.");
                }
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    if (object == null || object instanceof Token) continue;
                    wSCredentialImpl = null;
                    wSCredentialImpl2 = null;
                    wSCredentialImpl3 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("public credentials:" + object));
                    }
                    if (object instanceof WSCredentialImpl) {
                        wSCredentialImpl = (WSCredentialImpl)object;
                    }
                    if (wSCredentialImpl != null && wSCredentialImpl.isForwardable()) {
                        hashtable = wSCredentialImpl.getTable();
                        wSCredentialImpl2 = new WSCredentialImpl(wSCredentialImpl.getRealmName(), wSCredentialImpl.getSecurityName(), wSCredentialImpl.getUniqueSecurityName(), wSCredentialImpl.getPrimaryGroupId(), wSCredentialImpl.getAccessId(), wSCredentialImpl.getRoles(), wSCredentialImpl.getGroupIds());
                        wSCredentialImpl3 = new WSCredentialImpl((WSCredential)wSCredentialImpl2, wSCredentialImpl.getOID(), new byte[0], false, 0L);
                        wSCredentialImpl3.setTable(hashtable);
                        subject2.getPublicCredentials().add(wSCredentialImpl3);
                        continue;
                    }
                    subject2.getPublicCredentials().add(object);
                }
            }
            if ((object2 = subject.getPrivateCredentials()) != null && object2.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got some private credentials to iterate through.");
                }
                object = object2.iterator();
                while (object.hasNext()) {
                    iterator = object.next();
                    if (iterator == null || iterator instanceof Token) continue;
                    wSCredentialImpl = null;
                    wSCredentialImpl2 = null;
                    wSCredentialImpl3 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("private credentials:" + iterator));
                    }
                    if (iterator instanceof WSCredentialImpl) {
                        wSCredentialImpl = (WSCredentialImpl)((Object)iterator);
                    }
                    if (wSCredentialImpl != null && wSCredentialImpl.isForwardable()) {
                        hashtable = wSCredentialImpl.getTable();
                        wSCredentialImpl2 = new WSCredentialImpl(wSCredentialImpl.getRealmName(), wSCredentialImpl.getSecurityName(), wSCredentialImpl.getUniqueSecurityName(), wSCredentialImpl.getPrimaryGroupId(), wSCredentialImpl.getAccessId(), wSCredentialImpl.getRoles(), wSCredentialImpl.getGroupIds());
                        wSCredentialImpl3 = new WSCredentialImpl((WSCredential)wSCredentialImpl2, wSCredentialImpl.getOID(), new byte[0], false, 0L);
                        wSCredentialImpl3.setTable(hashtable);
                        subject2.getPrivateCredentials().add(wSCredentialImpl3);
                        continue;
                    }
                    subject2.getPrivateCredentials().add(iterator);
                }
            }
            if ((object = subject.getPrincipals()) != null && object.size() > 0) {
                if (tc.isEntryEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Got some principals to iterate through.");
                }
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (e == null) continue;
                    if (tc.isEntryEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("principal:" + e));
                    }
                    subject2.getPrincipals().add((Principal)e);
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"createNonForwardableSubjectFromSubject");
            }
            return subject2;
        }
    };
    private static final PrivilegedExceptionAction getSerializableSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSerializableSubjectAction.run()");
            }
            Subject subject = null;
            Subject subject2 = null;
            WSCredential wSCredential = null;
            WSCredential[] wSCredentialArray = null;
            wSCredential = ContextManagerFactory.getInstance().getInvocationCredential();
            if (wSCredential != null) {
                subject = this.createSubjectFromWSCredential(wSCredential);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Invocation credential is null.");
            }
            wSCredentialArray = ContextManagerFactory.getInstance().getCallerCredentials();
            if (wSCredentialArray != null && wSCredentialArray[0] != null) {
                subject2 = this.createSubjectFromWSCredential(wSCredential);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Caller credential is null.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSerializableSubjectAction.run()");
            }
            return new Subject[]{subject, subject2};
        }

        private Subject createSubjectFromWSCredential(WSCredential wSCredential) throws WSSecurityException, GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSerializableSubjectAction.createSubjectFromWSCredential()");
            }
            Subject subject = null;
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipal wSPrincipal = ContextManagerFactory.getInstance().createPrincipal(wSCredential);
                subject.getPrincipals().add(wSPrincipal);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"credential is null, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSerializableSubjectAction.createSubjectFromWSCredential()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getUnauthSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getUnauthSubjectAction.run()");
            }
            Subject subject = null;
            WSCredential wSCredential = ContextManagerFactory.getInstance().getUnauthenticatedCredential();
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipal wSPrincipal = ContextManagerFactory.getInstance().createPrincipal(wSCredential);
                subject.getPrincipals().add(wSPrincipal);
                subject.getPublicCredentials().add(wSCredential);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No unauthenticated credential, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getUnauthSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final PrivilegedExceptionAction getSerializableUnauthSubjectAction = new PrivilegedExceptionAction(){

        public Object run() throws GeneralSecurityException {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getSerializableUnauthSubjectAction.run()");
            }
            Subject subject = null;
            WSCredential wSCredential = ContextManagerFactory.getInstance().getUnauthenticatedCredential();
            if (wSCredential != null) {
                subject = new Subject();
                WSPrincipal wSPrincipal = ContextManagerFactory.getInstance().createPrincipal(wSCredential);
                subject.getPrincipals().add(wSPrincipal);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No unauthenticated credential, null Subject is returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSerializableUnauthSubjectAction.run()");
            }
            return subject;
        }
    };
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$WSLoginHelperImpl == null ? (class$com$ibm$ws$security$auth$WSLoginHelperImpl = WSLoginHelperImpl.class$("com.ibm.ws.security.auth.WSLoginHelperImpl")) : class$com$ibm$ws$security$auth$WSLoginHelperImpl), null, (String)"com.ibm.ejs.resources.security");
    static /* synthetic */ Class class$com$ibm$websphere$security$UserRegistry;
    static /* synthetic */ Class class$com$ibm$ws$security$auth$WSLoginHelperImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential authenticate(String string, String string2, String string3) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("authenticate(username = \"" + string + "\", realmname = \"" + string2 + "\", password = \"XXXXXXXX\")"));
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential wSCredential = null;
        try {
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                wSCredential = ContextManagerFactory.getInstance().authenticate(string2, string, string3);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, no authentication is performed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"authenticate(username, realmname, password)");
            }
        }
        finally {
            WSLoginHelperImpl.enableAuthRetryForThread();
        }
        return wSCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential validate(byte[] byArray) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"validate(credToken)");
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential wSCredential = null;
        try {
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                wSCredential = ContextManagerFactory.getInstance().authenticate(WSLoginHelperImpl.getDefaultRealmName(), byArray);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, no validation is performed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"validate(credToken)");
            }
        }
        finally {
            WSLoginHelperImpl.enableAuthRetryForThread();
        }
        return wSCredential;
    }

    public static Subject getSubject() throws WSSecurityException {
        Subject[] subjectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject()");
        }
        if ((subjectArray = WSLoginHelperImpl.getSubjects()) != null && subjectArray[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSubject()");
            }
            return subjectArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject() - null Subject returned.");
        }
        return null;
    }

    public static Subject[] getSubjects() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSubject()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        Subject[] subjectArray = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Getting invocation and caller subjects from thread.");
                }
                subjectArray = (Subject[])AccessController.doPrivileged((PrivilegedExceptionAction)getSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getSubject", (String)"245");
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
            }
            subjectArray = new Subject[]{};
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSubject()", (Object)new Integer(subjectArray.length));
        }
        return subjectArray;
    }

    public static Subject getNonForwardableSubject() throws WSSecurityException {
        Subject[] subjectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNonForwardableSubjects()");
        }
        if ((subjectArray = WSLoginHelperImpl.getNonForwardableSubjects()) != null && subjectArray[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getNonForwardableSubject()");
            }
            return subjectArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNonForwardableSubject() - null Subject returned.");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Subject[] getNonForwardableSubjects() throws WSSecurityException {
        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)WSLoginHelperImpl.tc, (String)"getNonForwardableSubjects()");
        }
        if ((var0 = System.getSecurityManager()) != null) {
            var0.checkPermission(WSLoginHelperImpl.GET_SUBJECT_PERMISSION);
            if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        var1_1 = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Getting the subject from credential on the Current Thread of Execution");
                }
                var1_1 = (Subject[])AccessController.doPrivileged((PrivilegedExceptionAction)WSLoginHelperImpl.getNonForwardableSubjectAction);
                if (!WSLoginHelperImpl.tc.isDebugEnabled()) ** GOTO lbl25
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Got the subject from credential on the Current Thread of Execution");
            }
            catch (PrivilegedActionException var2_2) {
                var3_3 = var2_2.getException();
                FFDCFilter.processException((Throwable)var3_3, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getNonForwardableSubject", (String)"245");
                var1_1 = null;
                if (var3_3 instanceof WSSecurityException) {
                    throw (WSSecurityException)var3_3;
                }
                throw new WSSecurityException(var3_3.getMessage(), var3_3);
            }
        } else if (WSLoginHelperImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Security is disabled, null subject will be returned");
        }
lbl25:
        // 5 sources

        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)WSLoginHelperImpl.tc, (String)"getNonForwardableSubject()");
        }
        return var1_1;
    }

    public static Subject getSerializableSubject() throws WSSecurityException {
        Subject[] subjectArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSerializableSubject()");
        }
        if ((subjectArray = WSLoginHelperImpl.getSerializableSubjects()) != null && subjectArray[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getSerializableSubject()");
            }
            return subjectArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSerializableSubject() - null Subject returned.");
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static Subject[] getSerializableSubjects() throws WSSecurityException {
        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)WSLoginHelperImpl.tc, (String)"getSerializableSubjects()");
        }
        if ((var0 = System.getSecurityManager()) != null) {
            var0.checkPermission(WSLoginHelperImpl.GET_SUBJECT_PERMISSION);
            if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        var1_1 = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                if (WSLoginHelperImpl.tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Getting the serializable subject from credential on the current thread of execution");
                }
                var1_1 = (Subject[])AccessController.doPrivileged((PrivilegedExceptionAction)WSLoginHelperImpl.getSerializableSubjectAction);
                if (!WSLoginHelperImpl.tc.isDebugEnabled()) ** GOTO lbl25
                Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Got the serializable subject from credential on the current thread of execution");
            }
            catch (PrivilegedActionException var2_2) {
                var3_3 = var2_2.getException();
                FFDCFilter.processException((Throwable)var3_3, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getSerializableSubject", (String)"245");
                var1_1 = null;
                if (var3_3 instanceof WSSecurityException) {
                    throw (WSSecurityException)var3_3;
                }
                throw new WSSecurityException(var3_3.getMessage(), var3_3);
            }
        } else if (WSLoginHelperImpl.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)WSLoginHelperImpl.tc, (String)"Security is disabled, null subject will be returned");
        }
lbl25:
        // 5 sources

        if (WSLoginHelperImpl.tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)WSLoginHelperImpl.tc, (String)"getSerializableSubjects()");
        }
        return var1_1;
    }

    public static Subject getUnauthenticatedSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnauthenticatedSubjecy()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        Subject subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)getUnauthSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getUnauthenticatedSubject", (String)"431");
                subject = null;
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getUnauthenticatedSubjecy()");
        }
        return subject;
    }

    public static Subject getSerializableUnauthSubject() throws WSSecurityException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSerializableUnauthSubject()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        Subject subject = null;
        if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
            try {
                subject = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)getSerializableUnauthSubjectAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.getUnauthenticatedSubject", (String)"485");
                subject = null;
                if (exception instanceof WSSecurityException) {
                    throw (WSSecurityException)exception;
                }
                throw new WSSecurityException(exception.getMessage(), exception);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSerializableUnauthSubject()");
        }
        return subject;
    }

    public static Subject restoreSerializedSubject(Subject subject, WSCredential wSCredential) throws SerialDeserialSubjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreSerializedSubject()");
        }
        Subject subject2 = SubjectHelper.createSubjectFromWSCredential(wSCredential);
        Subject[] subjectArray = null;
        subjectArray = WSLoginHelperImpl.restoreSerializedSubjects(new Subject[]{subject}, subject2);
        if (subjectArray != null && subjectArray[0] != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"restoreSerializedSubject()");
            }
            return subjectArray[0];
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreSerializedSubject() - null Subject returned.");
        }
        return null;
    }

    public static Subject[] restoreSerializedSubjects(Subject[] subjectArray, Subject subject) throws SerialDeserialSubjectException {
        SecurityManager securityManager;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"restoreSerializedSubjects()");
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(GET_SUBJECT_PERMISSION);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Java 2 Security Permission Check passed");
            }
        }
        if (subjectArray != null) {
            for (int i = 0; i < subjectArray.length; ++i) {
                if (subjectArray[i] == null || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("Subject[" + i + "] in passed in subject array is not null."));
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Passed in Subject array is null");
            }
            throw new SerialDeserialSubjectException("Passed in Subject array is null");
        }
        if (subject != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Privileged subject is not null.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Privileged subject is not null.");
            }
            throw new SerialDeserialSubjectException("Privileged subject is null.");
        }
        Subject[] subjectArray2 = new Subject[subjectArray.length];
        for (int i = 0; i < subjectArray.length; ++i) {
            subjectArray2[i] = subjectArray[i] != null ? WSLoginHelperImpl.deserializeSubject(subjectArray[i], subject) : null;
        }
        return subjectArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Subject deserializeSubject(final Subject subject, Subject subject2) throws SerialDeserialSubjectException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"deserializeSubject()");
        }
        Subject subject4 = null;
        Subject subject3 = null;
        try {
            block15: {
                try {
                    if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                        try {
                            subject3 = ContextManagerFactory.getInstance().pushInvocationSubject(subject2);
                        }
                        catch (WSSecurityException wSSecurityException) {
                            SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException(wSSecurityException.getMessage());
                            serialDeserialSubjectException.addException(wSSecurityException);
                            throw serialDeserialSubjectException;
                        }
                        subject4 = (Subject)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                            public Object run() throws SerialDeserialSubjectException {
                                Subject subject2 = null;
                                Set<Principal> set = subject.getPrincipals();
                                if (set == null || set.isEmpty()) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"No Principals found from the serialized subject");
                                    }
                                    throw new SerialDeserialSubjectException();
                                }
                                InitialContext initialContext = null;
                                UserRegistry userRegistry = null;
                                Object object = null;
                                try {
                                    initialContext = new InitialContext();
                                    object = initialContext.lookup("UserRegistry");
                                    userRegistry = (UserRegistry)PortableRemoteObject.narrow((Object)object, (Class)(class$com$ibm$websphere$security$UserRegistry == null ? (class$com$ibm$websphere$security$UserRegistry = WSLoginHelperImpl.class$("com.ibm.websphere.security.UserRegistry")) : class$com$ibm$websphere$security$UserRegistry));
                                    if (userRegistry == null) {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"No User Registry is available, null Subject is returned");
                                        }
                                        throw new SerialDeserialSubjectException();
                                    }
                                    WSCredential wSCredential = null;
                                    WSCredential wSCredential2 = null;
                                    WSPrincipal wSPrincipal = null;
                                    subject2 = new Subject();
                                    Object[] objectArray = set.toArray();
                                    for (int i = 0; i < objectArray.length; ++i) {
                                        wSPrincipal = (WSPrincipal)objectArray[i];
                                        if (((WSPrincipalImpl)wSPrincipal).getUserName().compareTo(ContextManagerFactory.getInstance().getUnauthenticatedString()) == 0) {
                                            wSCredential = ContextManagerFactory.getInstance().getUnauthenticatedCredential();
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)"Restoring unauthenticated credential");
                                            }
                                        } else {
                                            if (tc.isDebugEnabled()) {
                                                Tr.debug((TraceComponent)tc, (String)("Restoring subject for: " + ((WSPrincipalImpl)wSPrincipal).getUserName()));
                                            }
                                            if ((wSCredential2 = userRegistry.createCredential(((WSPrincipalImpl)wSPrincipal).getUserName())) != null) {
                                                String string = ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.WSSecurityContextActiveForwardable", "true");
                                                boolean bl = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes"));
                                                String string2 = ContextManagerFactory.getInstance().getProperty("com.ibm.CSI.WSSecurityContextActiveOID", "NONE");
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)("OID: " + string2 + ", Forwardable: " + string));
                                                }
                                                byte[] byArray = wSCredential2.getCredentialToken();
                                                long l = wSCredential2.getExpiration();
                                                if (string2.equals("NONE")) {
                                                    if (tc.isDebugEnabled()) {
                                                        Tr.debug((TraceComponent)tc, (String)"Configured authetication mechanism is unknown. Failed to restore Subject.");
                                                    }
                                                    throw new SerialDeserialSubjectException("Configured authetication mechanism is unknown. Failed to restore Subject.");
                                                }
                                                wSCredential = new WSCredentialImpl(wSCredential2, string2, byArray, bl, l);
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Restored identity credential");
                                                }
                                            } else {
                                                if (tc.isDebugEnabled()) {
                                                    Tr.debug((TraceComponent)tc, (String)"Failed to restore the identity credential");
                                                }
                                                throw new SerialDeserialSubjectException();
                                            }
                                        }
                                        subject2.getPrincipals().add(wSPrincipal);
                                        subject2.getPublicCredentials().add(wSCredential);
                                    }
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Restoring Subject is completed");
                                    }
                                }
                                catch (NamingException namingException) {
                                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"576");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"Failed to get initial Naming Context. Failed to resolve for UserRegistry");
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.jaas.get.initCtx", (Object)new Object[]{namingException});
                                    SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException();
                                    serialDeserialSubjectException.addException(namingException);
                                    throw serialDeserialSubjectException;
                                }
                                catch (CustomRegistryException customRegistryException) {
                                    FFDCFilter.processException((Throwable)customRegistryException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"585");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)"CustomRegistryException is caught. Failed to create credential");
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.jaas.create.credential", (Object)new Object[]{customRegistryException});
                                    SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException();
                                    serialDeserialSubjectException.addException(customRegistryException);
                                    throw serialDeserialSubjectException;
                                }
                                catch (SerialDeserialSubjectException serialDeserialSubjectException) {
                                    throw serialDeserialSubjectException;
                                }
                                catch (Exception exception) {
                                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"594");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("An exception is caught: " + exception.toString()));
                                    }
                                    Tr.error((TraceComponent)tc, (String)"security.jaas.restore.exception", (Object)new Object[]{exception});
                                    SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException();
                                    serialDeserialSubjectException.addException(exception);
                                    throw serialDeserialSubjectException;
                                }
                                return subject2;
                            }
                        });
                        break block15;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Security is disabled, null subject will be returned");
                    }
                }
                catch (PrivilegedActionException privilegedActionException) {
                    SerialDeserialSubjectException serialDeserialSubjectException = (SerialDeserialSubjectException)privilegedActionException.getException();
                    FFDCFilter.processException((Throwable)serialDeserialSubjectException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"606");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"PrivilegedActionException is caught while serialized Subject is being restored");
                    }
                    Tr.error((TraceComponent)tc, (String)"security.jaas.priv.exception", (Object)new Object[]{serialDeserialSubjectException});
                    throw serialDeserialSubjectException;
                }
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                ContextManagerFactory.getInstance().popInvocationSubject(subject3);
                throw throwable;
            }
            catch (WSSecurityException wSSecurityException) {
                FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"631");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"InvalidCredentialType exception is caught while serialized Subject is being restored");
                }
                Tr.error((TraceComponent)tc, (String)"security.jaas.invalidType2.cred.exception", (Object)new Object[]{wSSecurityException});
                SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException(wSSecurityException.getMessage());
                serialDeserialSubjectException.addException(wSSecurityException);
                throw serialDeserialSubjectException;
            }
        }
        try {}
        catch (WSSecurityException wSSecurityException) {
            FFDCFilter.processException((Throwable)wSSecurityException, (String)"com.ibm.ws.security.auth.WSLoginHelperImpl.restoreSerializedSubject", (String)"631");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"InvalidCredentialType exception is caught while serialized Subject is being restored");
            }
            Tr.error((TraceComponent)tc, (String)"security.jaas.invalidType2.cred.exception", (Object)new Object[]{wSSecurityException});
            SerialDeserialSubjectException serialDeserialSubjectException = new SerialDeserialSubjectException(wSSecurityException.getMessage());
            serialDeserialSubjectException.addException(wSSecurityException);
            throw serialDeserialSubjectException;
        }
        ContextManagerFactory.getInstance().popInvocationSubject(subject3);
        if (!tc.isEntryEnabled()) return subject4;
        Tr.exit((TraceComponent)tc, (String)"deserializeSubject()");
        return subject4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSCredential refresh(String string, String string2, String string3) throws WSSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("refresh(username = \"" + string + "\", realmname = \"" + string2 + "\", password = \"XXXXXXXX\")"));
        }
        WSLoginHelperImpl.disableAuthRetryForThread();
        WSCredential wSCredential = null;
        try {
            if (ContextManagerFactory.getInstance().isCellSecurityEnabled()) {
                wSCredential = ContextManagerFactory.getInstance().authenticate(string2, string, string3);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"returned from login");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security is disabled, credential is not refreshed, null credential will be returned");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"refresh(username, realmname, password)");
            }
        }
        finally {
            WSLoginHelperImpl.enableAuthRetryForThread();
        }
        return wSCredential;
    }

    public static String getDefaultRealmName() {
        return ContextManagerFactory.getInstance().getDefaultRealm();
    }

    private WSLoginHelperImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"WSLoginHelperImpl()");
        }
        Tr.error((TraceComponent)tc, (String)"security.jaas.NoWSLoginHelperImpl");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"WSLoginHelperImpl()");
        }
    }

    private static void disableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(true));
    }

    private static void enableAuthRetryForThread() {
        ContextManagerFactory.getInstance().put("wssecurity.disableauthretry", new Boolean(false));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

