/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.core.EJBRunAs;
import java.io.Serializable;
import java.util.Iterator;
import javax.security.auth.Subject;

public class WS390CredentialToken
implements Cloneable,
Serializable {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$WS390CredentialToken == null ? (class$com$ibm$ws$security$auth$WS390CredentialToken = WS390CredentialToken.class$("com.ibm.ws.security.auth.WS390CredentialToken")) : class$com$ibm$ws$security$auth$WS390CredentialToken), (String)"Security", (String)"com.ibm.ejs.resources.security");
    private static final long serialVersionUID = 2436861906571951136L;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_DEFAULT = 1;
    public static final int TYPE_ROLE = 2;
    public static final int TYPE_CERT = 3;
    public static final int TYPE_AUDIT = 4;
    public static final int TYPE_USER = 5;
    public static final int TYPE_SERVER = 6;
    private int creds;
    private int type;
    private String mvsId;
    private String role;
    private String auditToken;
    private byte[] byteCert;
    private boolean clonedCreds = false;
    private boolean valid = false;
    static /* synthetic */ Class class$com$ibm$ws$security$auth$WS390CredentialToken;

    public WS390CredentialToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>");
        }
        this.creds = 0;
        this.mvsId = "";
        this.type = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public WS390CredentialToken(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Integer(n));
        }
        this.type = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    public WS390CredentialToken(int n, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{new Integer(n), string});
        }
        this.creds = n;
        this.mvsId = string;
        this.type = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    protected void setWS390CredentialToken(int n, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setWS390CredentialToken", (Object)new Object[]{new Integer(n), string});
        }
        this.creds = n;
        this.mvsId = string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setWS390CredentialToken");
        }
    }

    protected void setWS390CredentialToken(int n, String string, String string2, String string3, byte[] byArray, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setWS390CredentialToken", (Object)new Object[]{new Integer(n), string, string2, string3, byArray});
        }
        this.creds = n;
        this.mvsId = string;
        this.role = string2;
        this.auditToken = string3;
        this.byteCert = byArray;
        this.type = n2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setWS390CredentialToken");
        }
    }

    public Object clone() {
        return new WS390CredentialToken(this.creds, this.mvsId);
    }

    protected void setMVSid(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMVSid", (Object)string);
        }
        this.mvsId = string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMVSid");
        }
    }

    public void setNSCToken(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setNSCToken", (Object)new Integer(n));
        }
        this.creds = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setNSCToken");
        }
    }

    public void setRole(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setRole", (Object)string);
        }
        this.role = string;
        this.type = 2;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setRole");
        }
    }

    public void setId(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setId", (Object)string);
        }
        this.mvsId = string;
        this.type = 5;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setId");
        }
    }

    public void setAuditToken(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setAuditToken", (Object)string);
        }
        this.auditToken = string;
        this.type = 4;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAuditToken");
        }
    }

    public void setCertificate(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setCertificate", (Object)byArray);
        }
        this.byteCert = byArray;
        this.type = 3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCertificate");
        }
    }

    public void setDefault(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setDefault", (Object)string);
        }
        this.mvsId = string;
        this.type = 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDefault");
        }
    }

    public void setType(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setType", (Object)new Integer(n));
        }
        this.type = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setType");
        }
    }

    public synchronized int getNSCToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNSCToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNSCToken", (Object)new Integer(this.creds));
        }
        if (EJBRunAs.isNSCTokenValid(this.creds) == 0) {
            this.recreateNSCToken();
        }
        return this.creds;
    }

    public synchronized int recreateNSCToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCToken");
        }
        switch (this.type) {
            case 1: {
                int n = this.recreateNSCTokenForDefault();
                break;
            }
            case 2: {
                int n = this.recreateNSCTokenForRole();
                break;
            }
            case 3: {
                int n = this.recreateNSCTokenForCertificate();
                break;
            }
            case 4: {
                int n = this.recreateNSCTokenForAuditToken();
                break;
            }
            case 5: {
                int n = this.recreateNSCTokenForAuthorizedUser();
                break;
            }
            case 6: {
                int n = this.recreateNSCTokenForServer();
                break;
            }
            default: {
                if (!tc.isEntryEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"recreateNSCToken(): unknown cred type", (Object)new Integer(this.type));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCToken", (Object)new Integer(this.creds));
        }
        return this.creds;
    }

    private int recreateNSCTokenForDefault() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCTokenForDefault");
        }
        int n = EJBRunAs.getDefaultCredential(this, this.mvsId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCTokenForDefault", (Object)new Integer(n));
        }
        return n;
    }

    private int recreateNSCTokenForRole() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCTokenForRole");
        }
        int n = EJBRunAs.getRoleCredential(this, this.role);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCTokenForRole", (Object)new Integer(n));
        }
        return n;
    }

    private int recreateNSCTokenForCertificate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCTokenForCertificate");
        }
        int n = EJBRunAs.getCertCredential(this, this.byteCert.length, this.byteCert);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCTokenForCertificate", (Object)new Integer(n));
        }
        return n;
    }

    private int recreateNSCTokenForAuditToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCTokenForAuditToken");
        }
        int n = EJBRunAs.getMappedCredential(this, this.mvsId, this.auditToken);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCTokenForAuditToken", (Object)new Integer(n));
        }
        return n;
    }

    private int recreateNSCTokenForAuthorizedUser() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCTokenForAuthorizedUser");
        }
        int n = EJBRunAs.getCredential(this, this.mvsId);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCTokenForAuthorizedUser", (Object)new Integer(n));
        }
        return n;
    }

    private int recreateNSCTokenForServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recreateNSCTokenForServer");
        }
        int n = EJBRunAs.getServerCredential(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recreateNSCTokenForServer", (Object)new Integer(n));
        }
        return n;
    }

    public String getMVSid() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getMVSid");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getMVSid", (Object)this.mvsId);
        }
        return this.mvsId;
    }

    public void invalidate() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"invalidate");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invalidate");
        }
        this.valid = false;
    }

    public boolean isClonedNSC() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isClonedNSC");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isClonedNSC", (Object)new Boolean(this.clonedCreds));
        }
        return this.clonedCreds;
    }

    public boolean isValid() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isValid");
        }
        this.valid = EJBRunAs.isNSCTokenValid(this.creds) == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isValid", (Object)new Boolean(this.valid));
        }
        return this.valid;
    }

    public void setClonedNSC() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setClonedNSC");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setClonedNSC");
        }
        this.clonedCreds = true;
    }

    public static WS390CredentialToken get390CredFromSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"get390CredFromSubject", (Object)subject);
        }
        WS390CredentialToken wS390CredentialToken = null;
        Iterator<Object> iterator = subject.getPrivateCredentials().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof WS390CredentialToken)) continue;
            wS390CredentialToken = (WS390CredentialToken)object;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"get390CredFromSubject", wS390CredentialToken);
        }
        return wS390CredentialToken;
    }

    public String toString() {
        return super.toString() + ",NSCToken=" + this.creds + ",mvsId=" + this.mvsId;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        if (object instanceof WS390CredentialToken) {
            return this.mvsId.equals(((WS390CredentialToken)object).mvsId);
        }
        return false;
    }

    public int hashCode() {
        return this.creds;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

