/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.auth;

import com.ibm.ISecurityL13SupportImpl.SecurityUIDGenerator;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.SSLConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.auth.distWSCredentialImpl;
import com.ibm.ws.security.auth.zOSWSCredentialImpl;
import com.ibm.ws.security.util.AccessController;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Enumeration;

public class ServerCredSigner {
    private KeyStore ks = null;
    private KeyPairGenerator rsaKeyPairGen = null;
    private KeyPair rsaKeyPair = null;
    private Signature sig = null;
    private PublicKey rsaPub = null;
    private PrivateKey rsaPriv = null;
    private MessageDigest md = null;
    boolean init = false;
    private SecurityConfiguration secConfig = null;
    private static String CRYPTO_ALGORITHM = "RSA";
    private static final String MESSAGE_DIGEST_ALGORITHM = "SHA";
    private static ServerCredSigner scs = null;
    private static final String _uniqueServerID = SecurityUIDGenerator.createUID();
    private static final byte[] _uniqueServerIDBytes = _uniqueServerID.getBytes();
    private static byte[] _uniqueServerCipher = null;
    private static final String _uniqueWSCredID = SecurityUIDGenerator.createUID();
    private static final byte[] _uniqueWSCredIDBytes = _uniqueWSCredID.getBytes();
    private static byte[] _uniqueWSCredCipher = null;
    private static byte[] nullByteArray = new byte[0];
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ws$security$auth$ServerCredSigner == null ? (class$com$ibm$ws$security$auth$ServerCredSigner = ServerCredSigner.class$("com.ibm.ws.security.auth.ServerCredSigner")) : class$com$ibm$ws$security$auth$ServerCredSigner), null, (String)"com.ibm.ISecurityL13SupportImpl.sec");
    static /* synthetic */ Class class$com$ibm$ws$security$auth$ServerCredSigner;

    public static ServerCredSigner getInstance() {
        if (scs == null) {
            scs = new ServerCredSigner();
        }
        return scs;
    }

    private ServerCredSigner() {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception initializing ServerCredSigner.", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.constructor", (String)"92", (Object)this);
        }
    }

    private void initialize() throws WSSecurityException {
        Object object;
        if (!ConfigURLProperties.isSecurityEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Security disabed, not initializing server cred signer.");
            }
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        this.init = false;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Initializing server cred signer.");
        }
        this.secConfig = VaultImpl.getSecurityConfiguration();
        if (this.secConfig != null && this.secConfig.processIsServer() && (object = this.secConfig.getCSIInboundSSLConfig()) != null) {
            string7 = ((SSLConfiguration)object).getKeyStoreServerAlias();
            string2 = ((SSLConfiguration)object).getSSLKeyFile();
            string3 = ((SSLConfiguration)object).getSSLKeyPassword();
            string4 = ((SSLConfiguration)object).getSSLKeyManager();
            string6 = ((SSLConfiguration)object).getSSLKeyStoreProvider();
            string5 = ((SSLConfiguration)object).getSSLContextProvider();
            string = ((SSLConfiguration)object).getSSLKeyStoreType();
            string8 = ((SSLConfiguration)object).getHardwareTokenLibraryFile();
            string9 = ((SSLConfiguration)object).getHardwareTokenPassword();
            string10 = ((SSLConfiguration)object).getHardwareTokenType();
            string11 = ((SSLConfiguration)object).getJCEProvider();
            this.init = true;
        }
        if (this.init) {
            block70: {
                block69: {
                    object = "main";
                    String string12 = "";
                    if (Security.getProvider(string6) == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)(string6 + " was not installed.  Install it now."));
                        }
                        try {
                            Security.addProvider((Provider)Class.forName(string6).newInstance());
                        }
                        catch (Exception exception) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Cannot install provider.", (Object)new Object[]{exception});
                            }
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"172", (Object)this);
                            return;
                        }
                    }
                    try {
                        if (string2 != null && string2 != "" && string3 != null && string3 != "") {
                            this.ks = KeyStore.getInstance(string, string6);
                            FileInputStream fileInputStream = null;
                            final String string13 = string2;
                            try {
                                fileInputStream = (FileInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                    public Object run() throws FileNotFoundException {
                                        return new FileInputStream(string13);
                                    }
                                });
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"204", (Object)this);
                                throw (FileNotFoundException)privilegedActionException.getException();
                            }
                            this.ks.load(fileInputStream, string3 == null ? null : string3.toCharArray());
                            String string14 = null;
                            Enumeration<String> enumeration = this.ks.aliases();
                            while (enumeration.hasMoreElements()) {
                                string14 = enumeration.nextElement();
                                if (string7 == null || !string7.equalsIgnoreCase(string14)) continue;
                            }
                            if (this.ks != null && string14 != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("Server alias chosen -> " + string14));
                                }
                                if (string3 != null) {
                                    this.rsaPriv = (PrivateKey)this.ks.getKey(string14, string3.toCharArray());
                                    this.rsaPub = this.ks.getCertificate(string14).getPublicKey();
                                } else {
                                    this.rsaPriv = (PrivateKey)this.ks.getKey(string14, string9.toCharArray());
                                    this.rsaPub = this.ks.getCertificate(string14).getPublicKey();
                                }
                                if (this.rsaPriv != null) {
                                    CRYPTO_ALGORITHM = this.rsaPriv.getAlgorithm();
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Error:  Either keystore or alias is null.");
                            }
                            break block69;
                        }
                        try {
                            this.rsaKeyPairGen = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, string11);
                        }
                        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("RSA KeyPair Generator not found in " + string11 + " provider."), (Object)new Object[]{noSuchAlgorithmException});
                            }
                            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"253", (Object)this);
                        }
                        catch (NoSuchProviderException noSuchProviderException) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Provider " + string11 + " not found."), (Object)new Object[]{noSuchProviderException});
                            }
                            FFDCFilter.processException((Throwable)noSuchProviderException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"258", (Object)this);
                        }
                        this.rsaKeyPairGen.initialize(512);
                        this.rsaKeyPair = this.rsaKeyPairGen.generateKeyPair();
                        if (this.rsaKeyPair == null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Key generation failure. KeyPair was not generated.");
                            }
                        } else {
                            this.rsaPub = this.rsaKeyPair.getPublic();
                            this.rsaPriv = this.rsaKeyPair.getPrivate();
                        }
                    }
                    catch (IOException iOException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"IOException while loading keystore.");
                        }
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"284", (Object)this);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"JSAS0633E: NoSuchAlgorithmException - This exception is thrown when a particular cryptographic algorithm is requested but is not available in the environment.");
                        }
                        FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"291", (Object)this);
                    }
                    catch (KeyStoreException keyStoreException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"JSAS0634E: KeyStoreException - This is the generic KeyStore exception.");
                        }
                        FFDCFilter.processException((Throwable)keyStoreException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"298", (Object)this);
                    }
                    catch (UnrecoverableKeyException unrecoverableKeyException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"JSAS0635E: UnrecoverableKeyException - This exception is thrown if a key in the keystore cannot be recovered.");
                        }
                        FFDCFilter.processException((Throwable)unrecoverableKeyException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"305", (Object)this);
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"JSAS0636E: NoSuchProviderException - This exception is thrown when a particular security provider is requested but is not available in the environment.");
                        }
                        FFDCFilter.processException((Throwable)noSuchProviderException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"312", (Object)this);
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"JSAS0011E: java.lang.Exception - This is a generic java exception.");
                        }
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"318", (Object)this);
                    }
                }
                try {
                    if (this.rsaPriv != null && this.rsaPub != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("PrivateKey format: " + this.rsaPriv.getFormat()));
                            Tr.debug((TraceComponent)tc, (String)("PrivateKey algorithm: " + this.rsaPriv.getAlgorithm()));
                            Tr.debug((TraceComponent)tc, (String)("PublicKey format: " + this.rsaPub.getFormat()));
                            Tr.debug((TraceComponent)tc, (String)("PublicKey algorithm: " + this.rsaPub.getAlgorithm()));
                        }
                        break block70;
                    }
                    try {
                        this.rsaKeyPairGen = KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, string11);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("RSA KeyPair Generator not found in " + string11 + " provider."), (Object)new Object[]{noSuchAlgorithmException});
                        }
                        FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"342", (Object)this);
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Provider " + string11 + " not found."), (Object)new Object[]{noSuchProviderException});
                        }
                        FFDCFilter.processException((Throwable)noSuchProviderException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"347", (Object)this);
                    }
                    this.rsaKeyPairGen.initialize(512);
                    this.rsaKeyPair = this.rsaKeyPairGen.generateKeyPair();
                    if (this.rsaKeyPair == null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Key generation failure. KeyPair was not generated.");
                        }
                    } else {
                        this.rsaPub = this.rsaKeyPair.getPublic();
                        this.rsaPriv = this.rsaKeyPair.getPrivate();
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"JSAS0011E: java.lang.Exception - This is a generic java exception.", (Object)new Object[]{exception});
                    }
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"372", (Object)this);
                }
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Loading " + CRYPTO_ALGORITHM + " from " + string11));
                }
                this.sig = Signature.getInstance(CRYPTO_ALGORITHM, string11);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RSA cipher not found in " + string11 + " provider."), (Object)new Object[]{noSuchAlgorithmException});
                }
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"388", (Object)this);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Provider " + string11 + " not found."), (Object)new Object[]{noSuchProviderException});
                }
                FFDCFilter.processException((Throwable)noSuchProviderException, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"395", (Object)this);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"411", (Object)this);
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Get a SHA message digest instance from " + string11));
                }
                this.md = MessageDigest.getInstance(MESSAGE_DIGEST_ALGORITHM, string11);
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error getting SHA instance. ", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.initialize", (String)"427", (Object)this);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"WARNING: Did not successfully load the server cred signer, might be in client-side process.");
        }
    }

    public synchronized byte[] encryptString(String string) {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception initializing ServerCredSigner.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.encryptString", (String)"449", (Object)this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from encryptString because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (string == null || string.length() == 0) {
            return nullByteArray;
        }
        byte[] byArray = null;
        try {
            this.sig.initSign(this.rsaPriv);
            this.sig.update(string.getBytes());
            byArray = this.sig.sign();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error encrypting: ", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", (String)"478", (Object)this);
            return null;
        }
        return byArray;
    }

    public synchronized String decryptString(byte[] byArray) {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception initializing ServerCredSigner.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.decryptString", (String)"496", (Object)this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from decryptString because of security disabled or not initialized.");
            }
            return null;
        }
        if (byArray == null) {
            return null;
        }
        byte[] byArray2 = byArray;
        try {
            this.sig.initVerify(this.rsaPub);
            this.sig.update(byArray2);
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error decrypting: ", (Object)new Object[]{exception});
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.verify", (String)"524", (Object)this);
            return null;
        }
        return byArray2.toString();
    }

    protected synchronized byte[] getEncryptedServerSigner() {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception initializing ServerCredSigner.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.getEncryptedServerSigner", (String)"544", (Object)this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from getEncryptedServerSigner because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (_uniqueServerCipher == null) {
            try {
                this.sig.initSign(this.rsaPriv);
                this.sig.update(_uniqueServerIDBytes);
                _uniqueServerCipher = this.sig.sign();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error encrypting: ", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", (String)"571", (Object)this);
                return null;
            }
        }
        return _uniqueServerCipher;
    }

    protected synchronized byte[] getEncryptedWSCredSigner() {
        if (this.sig == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception initializing ServerCredSigner.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.getEncryptedWSCredSigner", (String)"590", (Object)this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from getEncryptedWSCredSigner because of security disabled or not initialized.");
            }
            return nullByteArray;
        }
        if (_uniqueWSCredCipher == null) {
            Object var1_2 = null;
            try {
                this.sig.initSign(this.rsaPriv);
                this.sig.update(_uniqueWSCredIDBytes);
                _uniqueWSCredCipher = this.sig.sign();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error encrypting: ", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.getEncryptedSigner", (String)"618", (Object)this);
                return null;
            }
        }
        return _uniqueWSCredCipher;
    }

    protected synchronized boolean isServerCred(WSCredential wSCredential) {
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from isServerCred because of security disabled or not initialized.");
            }
            return false;
        }
        if (wSCredential instanceof distWSCredentialImpl) {
            if (((distWSCredentialImpl)wSCredential).getServerCredCipher() != null && _uniqueServerCipher != null) {
                return Arrays.equals(_uniqueServerCipher, ((distWSCredentialImpl)wSCredential).getServerCredCipher());
            }
            return false;
        }
        if (wSCredential instanceof zOSWSCredentialImpl) {
            if (((zOSWSCredentialImpl)wSCredential).getServerCredCipher() != null && _uniqueServerCipher != null) {
                return Arrays.equals(_uniqueServerCipher, ((zOSWSCredentialImpl)wSCredential).getServerCredCipher());
            }
            return false;
        }
        if (((WSCredentialImpl)wSCredential).getServerCredCipher() != null && _uniqueServerCipher != null) {
            return Arrays.equals(_uniqueServerCipher, ((WSCredentialImpl)wSCredential).getServerCredCipher());
        }
        return false;
    }

    protected synchronized boolean isWSCred(WSCredential wSCredential) {
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from isWSCred because of security disabled or not initialized.");
            }
            return false;
        }
        if (wSCredential instanceof distWSCredentialImpl) {
            if (((distWSCredentialImpl)wSCredential).getWSCredCipher() != null && _uniqueWSCredCipher != null) {
                return Arrays.equals(_uniqueWSCredCipher, ((distWSCredentialImpl)wSCredential).getWSCredCipher());
            }
            return false;
        }
        if (wSCredential instanceof zOSWSCredentialImpl) {
            if (((zOSWSCredentialImpl)wSCredential).getWSCredCipher() != null && _uniqueWSCredCipher != null) {
                return Arrays.equals(_uniqueWSCredCipher, ((zOSWSCredentialImpl)wSCredential).getWSCredCipher());
            }
            return false;
        }
        if (((WSCredentialImpl)wSCredential).getWSCredCipher() != null && _uniqueWSCredCipher != null) {
            return Arrays.equals(_uniqueWSCredCipher, ((WSCredentialImpl)wSCredential).getWSCredCipher());
        }
        return false;
    }

    public synchronized byte[] getOneWayHash(String string) {
        if (this.md == null && ConfigURLProperties.isSecurityEnabled()) {
            try {
                this.initialize();
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Exception initializing ServerCredSigner.", (Object)new Object[]{exception});
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.auth.ServerCredSigner.getOneWayHash", (String)"703", (Object)this);
            }
        }
        if (!ConfigURLProperties.isSecurityEnabled() || this.secConfig == null || !this.secConfig.processIsServer()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Returning from getOneWayHash because of security disabled or not initialized.");
            }
            return null;
        }
        this.md.reset();
        this.md.update(string.getBytes());
        return this.md.digest();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

