/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.IExtendedSecurity._LoginHelper;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsPackage.CredentialsNotSet;
import com.ibm.ISecurityLocalObjectBaseL13Impl.CurrentImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.LoginHelperImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityLocalObjectBasicAuthImpl.CredentialsImpl;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.InvalidOIDException;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.WSCredentialImpl;
import com.ibm.ws.security.util.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertPath;
import java.util.ArrayList;
import java.util.Hashtable;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CSI.X509CertificateChainHelper;
import org.omg.Security.Attribute;
import org.omg.Security.AttributeType;
import org.omg.Security.CredentialType;
import org.omg.Security.ExtensibleFamily;
import org.omg.SecurityLevel2.Credentials;
import org.omg.SecurityLevel2.LoginFailed;

public class CredentialsHelper {
    protected static final int PUBLIC = 0;
    protected static final int ACCESSID = 1;
    protected static final int PRIMARYGROUPID = 2;
    protected static final int GROUPID = 3;
    protected static final int ROLE = 4;
    protected static final int HOSTNAME = 5;
    protected static final short ibm_family_definer = 8;
    protected static final short ibm_family = 2;
    protected static final short omg_family_definer = 0;
    protected static final short omg_family = 1;
    protected static AttributeType[] secAttrType;
    private static Credentials serverBAcred;
    private static Credentials serverTokenCred;
    public static IntHolder expiry_time_now;
    private static final int omg_attribute_count = 5;
    private static final int ibm_attribute_count = 1;
    private static final int max_attribute_count = 6;
    public static VaultImpl vault;
    public static CurrentImpl current;
    private static final WebSphereRuntimePermission perm;

    public static String getUserName(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        if (credentialsImpl != null) {
            return credentialsImpl.getPublic();
        }
        return null;
    }

    public static void setUserName(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, String string) {
        if (credentialsImpl != null) {
            credentialsImpl.setPublic(string);
        }
    }

    public static byte[] getUserNameBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        byte[] byArray = null;
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                byArray = attributeArray[0].value;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getUserNameBytes", (String)"162");
            String string = "CredentialsHelper.getUserNameBytes";
            String string2 = "Exception reading bytes from credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public static void setUserNameBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, byte[] byArray) {
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                attributeArray[0].value = byArray;
                credentialsImpl.set_attributes(attributeArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.setUserNameBytes", (String)"187");
            String string = "CredentialsHelper.setUserNameBytes";
            String string2 = "Exception writing bytes to credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
    }

    public static String getAccessID(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        if (credentialsImpl != null) {
            return credentialsImpl.getAccessId();
        }
        return null;
    }

    public static void setAccessID(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, String string) {
        if (credentialsImpl != null) {
            credentialsImpl.setAccessId(string);
        }
    }

    public static byte[] getAccessIDBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        byte[] byArray = null;
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                byArray = attributeArray[1].value;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getAccessIDBytes", (String)"263");
            String string = "CredentialsHelper.getAccessIDBytes";
            String string2 = "Exception reading string from credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public static void setAccessIDBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, byte[] byArray) {
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                attributeArray[1].value = byArray;
                credentialsImpl.set_attributes(attributeArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getAccessIDBytes", (String)"290");
            String string = "CredentialsHelper.setAccessIDBytes";
            String string2 = "Exception writing accessId bytes to credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
    }

    public static String getPrimaryGroupID(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        if (credentialsImpl != null) {
            return credentialsImpl.getPrimaryGroupId();
        }
        return null;
    }

    public static void setPrimaryGroupID(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, String string) {
        if (credentialsImpl != null) {
            credentialsImpl.setPrimaryGroupId(string);
        }
    }

    public static byte[] getPrimaryGroupIDBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        byte[] byArray = null;
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                byArray = attributeArray[2].value;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getPrimaryGroupIDBytes", (String)"376");
            String string = "CredentialsHelper.getPrimaryGroupIDBytes";
            String string2 = "Exception reading string from credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public static void setPrimaryGroupIDBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, byte[] byArray) {
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                attributeArray[2].value = byArray;
                credentialsImpl.set_attributes(attributeArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.setPrimaryGroupIDBytes", (String)"402");
            String string = "CredentialsHelper.setPrimaryGroupIDBytes";
            String string2 = "Exception writing primaryGroupID bytes to credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
    }

    public static ArrayList getGroupIDs(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String[] stringArray;
            if (credentialsImpl != null && (stringArray = credentialsImpl.getGroupIds()) != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    arrayList.add(stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getGroupIDs", (String)"433");
            String string = "CredentialsHelper.getGroupIDs";
            String string2 = "Exception reading string array from credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
        return arrayList;
    }

    public static void setGroupIDs(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, ArrayList arrayList) {
        try {
            if (credentialsImpl != null) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                String[] stringArray = new String[]{};
                if (arrayList != null) {
                    stringArray = arrayList.toArray(new String[0]);
                }
                credentialsImpl.setGroupIds(stringArray);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.setGroupIDs", (String)"462");
            String string = "CredentialsHelper.setGroupIDs";
            String string2 = "Exception writing groupIds to credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
    }

    public static byte[] getGroupIDBytes(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        byte[] byArray = null;
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                byArray = attributeArray[3].value;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getGroupIDBytes", (String)"489");
            String string = "CredentialsHelper.getGroupIDBytes";
            String string2 = "Exception reading string array from credential.";
            SecurityLogger.debugMessage(string, string2);
            SecurityLogger.traceException(string, exception, 0, 0);
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public static String getRole(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        String string = "";
        try {
            if (credentialsImpl != null && credentialsImpl.is_valid(expiry_time_now)) {
                Attribute[] attributeArray = credentialsImpl.get_attributes(secAttrType);
                string = StringBytesConversion.getConvertedString(attributeArray[4].value);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.getRole", (String)"517");
            String string2 = "CredentialsHelper.getRole";
            String string3 = "Exception reading string from credential.";
            SecurityLogger.debugMessage(string2, string3);
            SecurityLogger.traceException(string2, exception, 0, 0);
        }
        if (string == null) {
            string = new String("");
        }
        return string;
    }

    public static String getHostName(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        if (credentialsImpl != null) {
            return credentialsImpl.getHostName();
        }
        return null;
    }

    public static void setHostName(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl, String string) {
        if (credentialsImpl != null) {
            credentialsImpl.setHostName(string);
        }
    }

    public static final WSCredential mapCorbaToWS(com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl) {
        com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl2;
        String string = "";
        String string2 = "CredentialsHelper.mapCorbaToWS";
        if (credentialsImpl == null) {
            return null;
        }
        WSCredential wSCredential = credentialsImpl.getWSCredential();
        if (wSCredential != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Returning existing WS cred.";
                SecurityLogger.debugMessage(string2, string);
            }
            if ((credentialsImpl2 = ((WSCredentialImpl)wSCredential).getCORBACred()) == null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Existing WS cred does not reference CORBA cred, getting a new reference.";
                    SecurityLogger.debugMessage(string2, string);
                }
                wSCredential = null;
            }
        }
        if (wSCredential == null) {
            credentialsImpl2 = credentialsImpl;
            try {
                wSCredential = (WSCredential)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return new WSCredentialImpl((Credentials)credentialsImpl2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Exception occurred creating new WS cred.";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.traceException(string2, privilegedActionException, 0, 0);
                }
                FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.mapCorbaToWS", (String)"479");
            }
            credentialsImpl.setWSCredential(wSCredential);
            if (SecurityLogger.debugTraceEnabled) {
                string = "Creating new WS cred.";
                SecurityLogger.debugMessage(string2, string);
            }
        }
        return wSCredential;
    }

    public static final Credentials mapWSToCorba(WSCredential wSCredential) {
        String string = "";
        String string2 = "CredentialsImpl.mapWSToCorba";
        if (wSCredential == null) {
            return null;
        }
        Credentials credentials = ((WSCredentialImpl)wSCredential).getCORBACred();
        if (credentials == null) {
            com.ibm.ISecurityLocalObjectBaseL13Impl.CredentialsImpl credentialsImpl = null;
            VaultImpl vaultImpl = VaultImpl.getInstance();
            if (wSCredential.isUnauthenticated()) {
                return CredentialsHelper.getCurrent().get_unauthenticated_credential();
            }
            try {
                String[] stringArray;
                Object object;
                String string3;
                if (wSCredential.isBasicAuth()) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Mapping basic auth credential, realm = " + wSCredential.getRealmName() + ", security name = " + wSCredential.getSecurityName();
                        SecurityLogger.debugMessage(string2, string);
                    }
                    credentialsImpl = new CredentialsImpl(vaultImpl);
                } else if (OID.compareOIDs(wSCredential.getOID(), "oid:1.3.18.0.2.30.2") || OID.compareOIDs(wSCredential.getOID(), "oid:1.2.840.113554.1.2.2") || OID.compareOIDs(wSCredential.getOID(), "oid:1.3.18.0.2.30.3")) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Mapping Forwardable credential, realm = " + wSCredential.getRealmName() + ", security name = " + wSCredential.getSecurityName();
                        SecurityLogger.debugMessage(string2, string);
                    }
                    credentialsImpl = new com.ibm.ISecurityLocalObjectTokenBaseImpl.CredentialsImpl(vaultImpl, wSCredential.getOID(), wSCredential.isForwardable());
                } else if (OID.compareOIDs(wSCredential.getOID(), "No OID for this mechanism")) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Mapping Non-Forwardable credential, realm = " + wSCredential.getRealmName() + ", security name = " + wSCredential.getSecurityName();
                        SecurityLogger.debugMessage(string2, string);
                    }
                    credentialsImpl = new com.ibm.ISecurityLocalObjectLocalOSImpl.CredentialsImpl(vaultImpl);
                } else {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Invalid OID encountered from the passed-in credential: " + wSCredential.getOID();
                        SecurityLogger.debugMessage(string2, string);
                    }
                    throw new InvalidOIDException(wSCredential.getOID());
                }
                String string4 = vaultImpl.getORB().getLocalHost();
                if (string4 == null || string4.length() == 0) {
                    string4 = "localHost";
                }
                if ((string3 = wSCredential.getRealmSecurityName()).length() > 0) {
                    credentialsImpl.setUniqueID(string3);
                }
                if (wSCredential.isBasicAuth()) {
                    credentialsImpl.setPublic(string3);
                    credentialsImpl.setUniqueSecurityName(wSCredential.getUniqueSecurityName());
                    credentialsImpl.setAccessId(string3);
                } else {
                    if (wSCredential.getSecurityName() != null && wSCredential.getSecurityName().length() > 0 && wSCredential.getRealmName() != null && wSCredential.getRealmName().length() > 0) {
                        object = wSCredential.getSecurityName();
                        stringArray = wSCredential.getRealmName();
                        if (((String)object).length() > 0 && stringArray.length() > 0) {
                            string3 = RealmSecurityName.getRealmSecurityName((String)stringArray, (String)object);
                        }
                    }
                    credentialsImpl.setPublic(string3);
                    credentialsImpl.setUniqueSecurityName(wSCredential.getUniqueSecurityName());
                    credentialsImpl.setAccessId(wSCredential.getAccessId());
                    credentialsImpl.setPrimaryGroupId(wSCredential.getPrimaryGroupId());
                    object = wSCredential.getGroupIds();
                    stringArray = new String[]{};
                    if (object != null) {
                        stringArray = object.toArray(new String[0]);
                    }
                    credentialsImpl.setGroupIds(stringArray);
                    object = null;
                    object = wSCredential.getRoles();
                    stringArray = new String[]{};
                    if (object != null) {
                        stringArray = object.toArray(new String[0]);
                    }
                    credentialsImpl.setRoles(stringArray);
                }
                credentialsImpl.setHostName(string4);
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Extracted  realmSecurityName == " + string3;
                    SecurityLogger.debugMessage(string2, string);
                }
                object = null;
                stringArray = wSCredential;
                try {
                    object = (Hashtable)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)stringArray){
                        private final /* synthetic */ WSCredential val$wsCredPriv;
                        {
                            this.val$wsCredPriv = wSCredential;
                        }

                        public Object run() throws Exception {
                            return ((WSCredentialImpl)this.val$wsCredPriv).getTable();
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Exception getting hashtable from wsCred.";
                        SecurityLogger.debugMessage(string2, string);
                        SecurityLogger.traceException(string2, privilegedActionException, 0, 0);
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.mapWSToCorba", (String)"639");
                }
                credentialsImpl.setTable((Hashtable)object);
                CertPath certPath = null;
                try {
                    certPath = (CertPath)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((WSCredential)stringArray){
                        private final /* synthetic */ WSCredential val$wsCredPriv;
                        {
                            this.val$wsCredPriv = wSCredential;
                        }

                        public Object run() throws Exception {
                            return this.val$wsCredPriv.get("wssecurity.setAttributForIdentityAssertion");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Exception occurred getting data from WS cred.";
                        SecurityLogger.debugMessage(string2, string);
                        SecurityLogger.traceException(string2, privilegedActionException, 0, 0);
                    }
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.mapCorbaToWS", (String)"667");
                }
                if (certPath != null) {
                    Any any = vaultImpl.getORB().create_any();
                    X509CertificateChainHelper.insert((Any)any, (byte[])certPath.getEncoded());
                    byte[] byArray = new CSIUtil().getCodec().encode_value(any);
                    credentialsImpl.setAttributForIdentityAssertion("ClientCertificate", byArray);
                } else {
                    credentialsImpl.setAttributForIdentityAssertion("ClientAuthenticationToken", StringBytesConversion.getConvertedBytes(string3));
                }
                long l = wSCredential.getExpiration();
                if (l == -1L || l == 0L) {
                    l = 0L;
                }
                credentialsImpl.setExpiration(l);
                credentialsImpl.set_credential_token(string3, wSCredential.getCredentialToken(), l);
                credentialsImpl.setWSCredential(wSCredential);
                ((WSCredentialImpl)wSCredential).setCORBACred((Credentials)credentialsImpl);
            }
            catch (CredentialsNotSet credentialsNotSet) {
                FFDCFilter.processException((Throwable)((Object)credentialsNotSet), (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.mapWSToCorba", (String)"593");
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Error setting credential token.";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.traceException(string2, (Exception)((Object)credentialsNotSet), 0, 0);
                }
                return null;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.CredentialsHelper.mapWSToCorba", (String)"604");
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Exception caught: " + exception.toString();
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.traceException(string2, exception, 0, 0);
                }
                return null;
            }
            return credentialsImpl;
        }
        if (SecurityLogger.debugTraceEnabled) {
            string = "Returning existing Corba cred.";
            SecurityLogger.debugMessage(string2, string);
        }
        return credentials;
    }

    public static CurrentImpl getCurrent() {
        String string = "CredentialsHelper.getCurrent";
        Object var1_1 = null;
        if (vault == null) {
            vault = VaultImpl.getInstance();
        }
        if (vault != null && current == null) {
            current = vault.getCurrent();
        }
        return current;
    }

    public static Object runAsSystem(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return CredentialsHelper.runAs(privilegedExceptionAction, "System");
    }

    public static Object runAsReceivedClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return CredentialsHelper.runAs(privilegedExceptionAction, "ReceivedClient");
    }

    public static Object runAsClient(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        return CredentialsHelper.runAs(privilegedExceptionAction, "Client");
    }

    public static Object runAs(PrivilegedExceptionAction privilegedExceptionAction, String string) throws PrivilegedActionException {
        SecurityManager securityManager;
        String string2 = "";
        String string3 = "CredentialsHelper.runAs";
        if (ConfigURLProperties.isSecurityEnabled() && (securityManager = System.getSecurityManager()) != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString();
                SecurityLogger.debugMessage(string3, string2);
            }
            securityManager.checkPermission((Permission)perm);
        }
        securityManager = null;
        Credentials credentials = null;
        Object var6_6 = null;
        if (ConfigURLProperties.isSecurityEnabled()) {
            try {
                Credentials credentials2 = null;
                if (string.equals("System")) {
                    credentials2 = CredentialsHelper.getServerTokenCredential();
                    if (credentials2 != null) {
                        credentials = CredentialsHelper.pushReceivedCredential(credentials2);
                    }
                } else if (string.equals("Client")) {
                    credentials2 = CredentialsHelper.retrieveCredential();
                } else if (string.equals("ReceivedClient")) {
                    credentials2 = CredentialsHelper.getReceivedCredential();
                }
                if (credentials2 != null) {
                    securityManager = CredentialsHelper.pushInvocationCredential(credentials2);
                }
            }
            catch (Exception exception) {
                block29: {
                    try {
                        if (securityManager != null) {
                            CredentialsHelper.popInvocationCredential((Credentials)securityManager);
                            securityManager = null;
                        }
                        if (credentials != null) {
                            CredentialsHelper.popReceivedCredential(credentials);
                            credentials = null;
                        }
                    }
                    catch (Exception exception2) {
                        if (credentials == null) break block29;
                        CredentialsHelper.popReceivedCredential(credentials);
                        credentials = null;
                    }
                }
                throw new PrivilegedActionException(exception);
            }
        }
        try {
            var6_6 = privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            block30: {
                if (ConfigURLProperties.isSecurityEnabled()) {
                    try {
                        if (securityManager != null) {
                            CredentialsHelper.popInvocationCredential((Credentials)securityManager);
                            securityManager = null;
                        }
                        if (credentials != null) {
                            CredentialsHelper.popReceivedCredential(credentials);
                            credentials = null;
                        }
                    }
                    catch (Exception exception3) {
                        if (credentials == null) break block30;
                        CredentialsHelper.popReceivedCredential(credentials);
                        credentials = null;
                    }
                }
            }
            throw new PrivilegedActionException(exception);
        }
        if (ConfigURLProperties.isSecurityEnabled()) {
            try {
                CredentialsHelper.popInvocationCredential((Credentials)securityManager);
                if (credentials != null) {
                    CredentialsHelper.popReceivedCredential(credentials);
                    credentials = null;
                }
            }
            catch (Exception exception) {
                if (securityManager != null) {
                    CredentialsHelper.popInvocationCredential((Credentials)securityManager);
                    securityManager = null;
                }
                if (credentials != null) {
                    CredentialsHelper.popReceivedCredential(credentials);
                    credentials = null;
                }
                throw new PrivilegedActionException(exception);
            }
        }
        return var6_6;
    }

    private static Credentials getServerTokenCredential() {
        String string = "";
        String string2 = "CredentialsHelper.getServerTokenCredential";
        Credentials credentials = null;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString();
                SecurityLogger.debugMessage(string2, string);
            }
            securityManager.checkPermission((Permission)perm);
        }
        if ((credentials = CredentialsHelper.getServerBasicAuthCredential()) != null) {
            return CredentialsHelper.getServerActualCredential(credentials);
        }
        return null;
    }

    private static Credentials getServerBasicAuthCredential() {
        block16: {
            String string = "";
            String string2 = "CredentialsHelper.getServerBasicAuthCredential";
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Performing Java 2 Security Permission Check ...Expecting : " + perm.toString();
                    SecurityLogger.debugMessage(string2, string);
                }
                securityManager.checkPermission((Permission)perm);
            }
            if (serverBAcred == null) {
                try {
                    String string3;
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "Getting server basic auth credentials.";
                        SecurityLogger.debugMessage(string2, string);
                    }
                    VaultImpl vaultImpl = VaultImpl.getInstance();
                    String string4 = "";
                    if (vaultImpl != null) {
                        string3 = vaultImpl.getSecurityConfiguration().getprincipalName();
                        string4 = RealmSecurityName.getRealm(string3);
                    }
                    string3 = null;
                    if (CredentialsHelper.getCurrent() != null) {
                        string3 = CredentialsHelper.getCurrent().login_helper();
                    }
                    if (string3 == null) break block16;
                    try {
                        try {
                            String string5 = string3;
                            String string6 = string4;
                            serverBAcred = (Credentials)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((_LoginHelper)string5, string6){
                                private final /* synthetic */ _LoginHelper val$helper;
                                private final /* synthetic */ String val$myRealm;
                                {
                                    this.val$helper = _LoginHelper2;
                                    this.val$myRealm = string;
                                }

                                public Object run() throws LoginFailed {
                                    return ((LoginHelperImpl)this.val$helper).request_login_controlled(null, this.val$myRealm, null, null, null, true, false);
                                }
                            });
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ws.security.core.SecurityContext.getServerTokenCredential", (String)"607");
                            throw privilegedActionException.getException();
                        }
                    }
                    catch (LoginFailed loginFailed) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "LoginFailed exception getting server cred.";
                            SecurityLogger.debugMessage(string2, string);
                            SecurityLogger.traceException(string2, (Exception)((Object)loginFailed), 0, 0);
                        }
                        serverBAcred = null;
                        FFDCFilter.processException((Throwable)loginFailed, (String)"com.ibm.ws.security.core.SecurityContext.getServerTokenCredential", (String)"619");
                    }
                    catch (Exception exception) {
                        if (SecurityLogger.debugTraceEnabled) {
                            string = "Exception logging in to get server cred.";
                            SecurityLogger.debugMessage(string2, string);
                            SecurityLogger.traceException(string2, exception, 0, 0);
                        }
                        serverBAcred = null;
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.getServerTokenCredential", (String)"628");
                    }
                }
                catch (Exception exception) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string = "unable to obtain own credential or credential expired";
                        SecurityLogger.debugMessage(string2, string);
                        SecurityLogger.traceException(string2, exception, 0, 0);
                    }
                    serverBAcred = null;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.getServerTokenCredential", (String)"639");
                }
            }
        }
        return serverBAcred;
    }

    private static Credentials getServerActualCredential(Credentials credentials) {
        String string = "";
        String string2 = "CredentialsHelper.getServerActualCredential";
        boolean bl = false;
        try {
            bl = serverTokenCred.is_valid(expiry_time_now);
        }
        catch (Exception exception) {
            bl = false;
        }
        if (serverTokenCred != null && bl) {
            return serverTokenCred;
        }
        try {
            credentials = ((CredentialsImpl)credentials).get_mapped_credentials(null, "", null);
        }
        catch (Exception exception) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception occurred in getServerActualCredential";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.getServerActualCredential", (String)"664");
            credentials = null;
        }
        return credentials;
    }

    private static Credentials pushInvocationCredential(Credentials credentials) {
        String string = "";
        String string2 = "CredentialsHelper.pushInvocationCredential";
        Credentials credentials2 = null;
        try {
            credentials2 = CredentialsHelper.getCurrent().get_credentials(CredentialType.SecInvocationCredentials);
            CredentialsHelper.getCurrent().set_credentials(CredentialType.SecInvocationCredentials, credentials);
        }
        catch (Exception exception) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception occurred in pushInvocationCredential";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.pushInvocationCredential", (String)"689");
        }
        return credentials2;
    }

    private static Credentials retrieveCredential() {
        Credentials credentials = CredentialsHelper.getReceivedCredential();
        if (credentials == null) {
            credentials = CredentialsHelper.getInvocationCredential();
        }
        return credentials;
    }

    private static void popInvocationCredential(Credentials credentials) {
        String string = "";
        String string2 = "CredentialsHelper.popInvocationCredential";
        try {
            CredentialsHelper.getCurrent().set_credentials(CredentialType.SecInvocationCredentials, credentials);
        }
        catch (Exception exception) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception occurred in popInvocationCredential";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.popInvocationCredential", (String)"717");
        }
    }

    private static Credentials pushReceivedCredential(Credentials credentials) {
        String string = "";
        String string2 = "CredentialsHelper.pushReceivedCredential";
        Credentials credentials2 = null;
        try {
            credentials2 = CredentialsHelper.getReceivedCredential();
            Credentials[] credentialsArray = new Credentials[]{credentials};
            CredentialsHelper.getCurrent().set_received_credentials(credentialsArray);
        }
        catch (Exception exception) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception occurred in pushReceivedCredential";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.pushReceivedCredential", (String)"1159");
        }
        return credentials2;
    }

    private static void popReceivedCredential(Credentials credentials) {
        String string = "";
        String string2 = "CredentialsHelper.popReceivedCredential";
        try {
            Credentials[] credentialsArray = new Credentials[]{credentials};
            CredentialsHelper.getCurrent().set_received_credentials(credentialsArray);
        }
        catch (Exception exception) {
            if (SecurityLogger.debugTraceEnabled) {
                string = "Exception occurred in popReceivedCredential";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.popReceivedCredential", (String)"1179");
        }
    }

    private static Credentials getReceivedCredential() {
        String string = "";
        String string2 = "CredentialsHelper.getReceivedCredential";
        Credentials[] credentialsArray = new Credentials[1];
        IntHolder intHolder = new IntHolder(0);
        boolean bl = false;
        if (CredentialsHelper.getCurrent() != null) {
            try {
                credentialsArray = CredentialsHelper.getCurrent().received_credentials();
                if (credentialsArray != null && credentialsArray[0] != null) {
                    bl = credentialsArray[0].is_valid(intHolder);
                }
            }
            catch (Exception exception) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Unable to obtain received credential from getCurrent().";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.traceException(string2, exception, 0, 0);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.getReceivedCredential", (String)"749");
                bl = false;
            }
        }
        if (bl && credentialsArray != null && credentialsArray[0] != null) {
            return credentialsArray[0];
        }
        return null;
    }

    private static Credentials getInvocationCredential() {
        String string = "";
        String string2 = "CredentialsHelper.getInvocationCredential";
        Credentials credentials = null;
        IntHolder intHolder = new IntHolder(0);
        boolean bl = false;
        if (CredentialsHelper.getCurrent() != null) {
            try {
                credentials = CredentialsHelper.getCurrent().get_credentials(CredentialType.SecInvocationCredentials);
                if (credentials != null) {
                    bl = credentials.is_valid(intHolder);
                }
            }
            catch (Exception exception) {
                if (SecurityLogger.debugTraceEnabled) {
                    string = "Unable to obtain invocation credential from getCurrent().";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.traceException(string2, exception, 0, 0);
                }
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.core.SecurityContext.getInvocationCredential", (String)"796");
                bl = false;
            }
        }
        if (bl && credentials != null) {
            return credentials;
        }
        return null;
    }

    static {
        serverBAcred = null;
        serverTokenCred = null;
        expiry_time_now = new IntHolder(0);
        vault = null;
        current = null;
        perm = new WebSphereRuntimePermission("SecurityContext");
        secAttrType = new AttributeType[6];
        ExtensibleFamily extensibleFamily = new ExtensibleFamily(0, 1);
        ExtensibleFamily extensibleFamily2 = new ExtensibleFamily(8, 2);
        CredentialsHelper.secAttrType[0] = new AttributeType(extensibleFamily, 1);
        CredentialsHelper.secAttrType[1] = new AttributeType(extensibleFamily, 2);
        CredentialsHelper.secAttrType[2] = new AttributeType(extensibleFamily, 3);
        CredentialsHelper.secAttrType[3] = new AttributeType(extensibleFamily, 4);
        CredentialsHelper.secAttrType[4] = new AttributeType(extensibleFamily, 5);
        CredentialsHelper.secAttrType[5] = new AttributeType(extensibleFamily2, 2);
    }
}

