/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedServerRequestInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityLocalObjectBaseL13Impl.RequestHolder;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;

public final class CDRInputMessage {
    private byte msgType;
    private byte minor;
    private byte major;
    private int seqNum = 0;
    private int sidLen = 0;
    private String mechType;
    private byte[] sessionBytes = null;
    private String sessionID = "";
    private String hostName = "";
    private short errorCode = 0;
    private boolean returnErrorToClient = false;
    private boolean secCtxFound = false;
    private CDRInputStream cis = null;
    private String subMsg = "";
    private String secName = "";
    private byte[] secNameBytes = null;
    private int secNameBytesLength = 0;
    private byte[] credToken = null;
    private int credTokenLength = 0;
    boolean failedAuthn = false;
    private byte[] accessID = null;
    private byte[] primaryGroupID = null;
    private byte[] groupIDBytes = null;
    private int groupIDBytesLength = 0;
    private String role = "";
    private String clientHostName = "";
    private int serviceContextID = 0;

    public CDRInputMessage(RequestHolder requestHolder, boolean bl) {
        this.initialize(requestHolder, bl);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void initialize(RequestHolder var1_1, boolean var2_2) {
        var3_3 = "CDRInputMessage.initialize";
        var4_4 = null;
        try {
            var5_5 = false;
            var6_7 = null;
            if (var2_2) {
                var7_8 /* !! */  = (ClientRequestInfo)var1_1.requestInfo();
                try {
                    var6_7 = ((ExtendedClientRequestInfo)var7_8 /* !! */ ).getReplyServiceContext(1229081868);
                    if (var6_7 != null) {
                        this.serviceContextID = 1229081868;
                        this.secCtxFound = true;
                        if (SecurityLogger.debugTraceEnabled) {
                            var4_4 = "Found OMG service context in the message.";
                            SecurityLogger.debugMessage(var3_3, var4_4);
                        }
                    }
                }
                catch (Exception var8_9) {
                    FFDCFilter.processException((Throwable)var8_9, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"147", (Object)this);
                    var4_4 = "System exception while accessing reply service context.";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                if (var6_7 == null) {
                    try {
                        var6_7 = ((ExtendedClientRequestInfo)var7_8 /* !! */ ).getReplyServiceContext(-2004318072);
                        if (var6_7 != null) {
                            this.serviceContextID = -2004318072;
                            this.secCtxFound = true;
                            if (SecurityLogger.debugTraceEnabled) {
                                var4_4 = "Found IBM service context in the message.";
                                SecurityLogger.debugMessage(var3_3, var4_4);
                            }
                        }
                    }
                    catch (Exception var8_10) {
                        FFDCFilter.processException((Throwable)var8_10, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"178", (Object)this);
                        var4_4 = "System exception while accessing reply service context.";
                        SecurityLogger.debugMessage(var3_3, var4_4);
                    }
                }
            } else {
                var7_8 /* !! */  = (ServerRequestInfo)var1_1.requestInfo();
                try {
                    var6_7 = ((ExtendedServerRequestInfo)var7_8 /* !! */ ).getRequestServiceContext(1229081868);
                    if (var6_7 != null) {
                        this.serviceContextID = 1229081868;
                        this.secCtxFound = true;
                        if (SecurityLogger.debugTraceEnabled) {
                            var4_4 = "Found OMG service context in the message.";
                            SecurityLogger.debugMessage(var3_3, var4_4);
                        }
                    }
                }
                catch (Exception var8_11) {
                    FFDCFilter.processException((Throwable)var8_11, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"213", (Object)this);
                    var4_4 = "System exception while accessing request service context.";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                if (var6_7 == null) {
                    try {
                        var6_7 = ((ExtendedServerRequestInfo)var7_8 /* !! */ ).getRequestServiceContext(-2004318072);
                        if (var6_7 != null) {
                            this.serviceContextID = -2004318072;
                            this.secCtxFound = true;
                            if (SecurityLogger.debugTraceEnabled) {
                                var4_4 = "Found IBM service context in the message.";
                                SecurityLogger.debugMessage(var3_3, var4_4);
                            }
                        }
                    }
                    catch (Exception var8_12) {
                        FFDCFilter.processException((Throwable)var8_12, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"244", (Object)this);
                        var4_4 = "System exception while accessing request service context.";
                        SecurityLogger.debugMessage(var3_3, var4_4);
                    }
                }
            }
            if (var6_7 == null) {
                if (SecurityLogger.debugTraceEnabled) {
                    var4_4 = "No security service context found in the message.";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                return;
            }
            var7_8 /* !! */  = (ClientRequestInfo)var6_7.context_data;
            if (SecurityLogger.debugTraceEnabled) {
                var4_4 = "Security context data is " + ((ClientRequestInfo)var7_8 /* !! */ ).length + " bytes in length";
                SecurityLogger.debugMessage(var3_3, var4_4);
                if (SecurityLogger.traceByteArrays) {
                    SecurityLogger.debugMessage(var3_3, (byte[])var7_8 /* !! */ );
                }
            }
            this.cis = ORB.createCDRInputStream(null, (byte[])var7_8 /* !! */ , (int)((ClientRequestInfo)var7_8 /* !! */ ).length);
            this.cis.consumeEndian();
            try {
                this.mechType = this.cis.read_string();
            }
            catch (MARSHAL var8_14) {
                FFDCFilter.processException((Throwable)var8_14, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"327", (Object)this);
                var4_4 = "security.JSAS0027E";
                SecurityLogger.logError(var4_4, new Object[]{var3_3, var8_14});
                throw var8_14;
            }
            this.msgType = this.cis.read_octet();
            this.minor = this.cis.read_octet();
            this.major = this.cis.read_octet();
            this.seqNum = this.cis.read_ulong();
            this.sidLen = this.cis.read_ulong();
            this.sessionBytes = new byte[this.sidLen];
            this.cis.read_octet_array(this.sessionBytes, 0, this.sidLen);
            this.sessionID = StringBytesConversion.getConvertedString(this.sessionBytes);
            try {
                this.hostName = this.cis.read_string();
            }
            catch (MARSHAL var8_15) {
                FFDCFilter.processException((Throwable)var8_15, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"356", (Object)this);
                var4_4 = "security.JSAS0027E";
                SecurityLogger.logError(var4_4, new Object[]{var3_3, var8_15});
                throw var8_15;
            }
            if (this.msgType == 2) {
                try {
                    if (this.mechType.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                        var8_16 = this.cis.read_ulong();
                        var9_23 = new byte[var8_16];
                        if (var8_16 > 0) {
                            this.cis.read_octet_array(var9_23, 0, var8_16);
                        } else {
                            var9_23 = new byte[]{};
                        }
                        this.secName = StringBytesConversion.getConvertedString(var9_23);
                    } else {
                        this.secName = this.cis.read_string();
                    }
                }
                catch (MARSHAL var8_17) {
                    FFDCFilter.processException((Throwable)var8_17, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"391", (Object)this);
                    var4_4 = "security.JSAS0027E";
                    SecurityLogger.logError(var4_4, new Object[]{var3_3, var8_17});
                    throw var8_17;
                }
                if (this.mechType.equals(VaultConstants.LTPA_MECH_TYPE)) {
                    try {
                        this.credTokenLength = this.cis.read_ulong();
                        this.credToken = new byte[this.credTokenLength];
                        this.cis.read_octet_array(this.credToken, 0, this.credTokenLength);
                    }
                    catch (MARSHAL var8_18) {
                        FFDCFilter.processException((Throwable)var8_18, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"410", (Object)this);
                        var4_4 = "security.JSAS0027E";
                        SecurityLogger.logError(var4_4, new Object[]{var3_3, var8_18});
                        throw var8_18;
                    }
                }
                if (this.mechType.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                    try {
                        var8_19 = this.cis.read_ulong();
                        this.accessID = new byte[var8_19];
                        if (var8_19 > 0) {
                            this.cis.read_octet_array(this.accessID, 0, var8_19);
                        } else {
                            this.accessID = new byte[0];
                        }
                        var9_24 = this.cis.read_ulong();
                        this.primaryGroupID = new byte[var9_24];
                        if (var9_24 > 0) {
                            this.cis.read_octet_array(this.primaryGroupID, 0, var9_24);
                        } else {
                            this.primaryGroupID = new byte[0];
                        }
                        this.groupIDBytesLength = this.cis.read_ulong();
                        this.groupIDBytes = new byte[this.groupIDBytesLength];
                        if (this.groupIDBytesLength > 0) {
                            this.cis.read_octet_array(this.groupIDBytes, 0, this.groupIDBytesLength);
                        } else {
                            this.groupIDBytes = new byte[0];
                        }
                        this.role = this.cis.read_string();
                        if (this.role == null) {
                            this.role = new String("");
                        }
                        this.clientHostName = this.cis.read_string();
                        if (this.clientHostName != null) ** GOTO lbl186
                        this.clientHostName = new String("");
                    }
                    catch (Exception var8_20) {
                        FFDCFilter.processException((Throwable)var8_20, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"455", (Object)this);
                        var4_4 = "security.JSAS0027E";
                        SecurityLogger.logError(var4_4, new Object[]{var3_3, var8_20});
                        throw var8_20;
                    }
                } else {
                    var8_21 = null;
                    try {
                        var8_21 = this.cis.read_string();
                    }
                    catch (MARSHAL var9_25) {
                        FFDCFilter.processException((Throwable)var9_25, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"471", (Object)this);
                        var4_4 = "security.JSAS0027E";
                        SecurityLogger.logError(var4_4, new Object[]{var3_3, var9_25});
                        throw var9_25;
                    }
                    this.credToken = StringBytesConversion.getConvertedBytes(var8_21);
                }
lbl186:
                // 4 sources

                if (this.credToken == null) {
                    this.credToken = new byte[0];
                }
            } else if (this.msgType == 5 || this.msgType == 7) {
                try {
                    this.errorCode = this.cis.read_octet();
                }
                catch (Exception var8_22) {
                    FFDCFilter.processException((Throwable)var8_22, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"493", (Object)this);
                    this.errorCode = (short)5;
                }
                switch (this.errorCode) {
                    case 1: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg240", "Login failed.") + " " + SecurityMessages.getMsgOrUseDefault("ErrMsg205", "User ID or password was invalid.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 3: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg240", "Login failed.") + " " + SecurityMessages.getMsgOrUseDefault("ErrMsg210", "Password expired.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 2: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg215", "Account locked.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 4: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg220", "Service unavailable.");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 5: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg225", "Internal error.");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 0: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg230", "Reason unknown.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 6: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg240", "Login failed.") + " " + SecurityMessages.getMsgOrUseDefault("ErrMsg235", "Client authentication required.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 7: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg201", "Authentication failed.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 11: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg202", "Credential token expired.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 13: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg203", "Invalid credential token.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 17: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg204", "Invalid security name.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 22: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg206", "Validation failed.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 9: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg207", "Internal error: method not implemented.");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 10: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg208", "Internal error: system exception.");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 12: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg209", "Duplicate security attribute type.");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 14: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg211", "Invalid security attribute type.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 15: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg212", "Invalid security credential.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 18: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg213", "Internal error: java exception");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 8: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg214", "Authentication not supported.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 16: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg216", "Invalid security mechanism.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 19: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg217", "Security mechanism not supported.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 20: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg218", "Security server not available.");
                        this.returnErrorToClient = true;
                        break;
                    }
                    case 21: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg219", "Unsupported realm.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    case 23: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg221", "Validation not supported.");
                        this.returnErrorToClient = true;
                        this.failedAuthn = true;
                        break;
                    }
                    default: {
                        this.subMsg = SecurityMessages.getMsgOrUseDefault("ErrMsg230", "Reason unknown.");
                        this.returnErrorToClient = true;
                    }
                }
                if (SecurityLogger.debugTraceEnabled) {
                    var4_4 = "Error \"" + this.subMsg + "\" returned from Security Server while attempting authentication for user " + this.secName + ".";
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                if (this.mechType.equals(VaultConstants.LOCAL_OS_MECH_TYPE)) {
                    var4_4 = "target hostName = " + this.hostName + ", client hostName = " + this.clientHostName + ", secName = " + this.secName;
                    SecurityLogger.debugMessage(var3_3, var4_4);
                } else {
                    var4_4 = "target hostName = " + this.hostName;
                    SecurityLogger.debugMessage(var3_3, var4_4);
                }
                var4_4 = "MechType = " + this.mechType + ", msgType = " + this.msgType + ", major = " + this.major + ", minor = " + this.minor;
                SecurityLogger.debugMessage(var3_3, var4_4);
                var4_4 = "Session id length = " + this.sidLen + ", session id = " + this.sessionID + ", target sequence number = " + this.seqNum + ", host name = " + this.hostName;
                SecurityLogger.debugMessage(var3_3, var4_4);
            }
        }
        catch (Throwable var5_6) {
            FFDCFilter.processException((Throwable)var5_6, (String)"com.ibm.ISecurityUtilityImpl.CDRInputMessage.initialize", (String)"715", (Object)this);
            var4_4 = SecurityMessages.getMsgOrUseDefault("JSAS0208E", "JSAS0208E: Internal error: system exception.  Take down all the error information and contact support for more assistance.");
            SecurityLogger.debugMessage(var3_3, var4_4);
            if (SecurityLogger.traceEnabled) {
                SecurityLogger.traceException(var3_3, var5_6, 0, 0);
            }
            throw new INTERNAL("Unexpected Java Exception: " + var5_6.toString());
        }
    }

    public byte msgType() {
        return this.msgType;
    }

    public byte major() {
        return this.major;
    }

    public byte minor() {
        return this.minor;
    }

    public int seqNum() {
        return this.seqNum;
    }

    public int sidLen() {
        return this.sidLen;
    }

    public byte[] sessionBytes() {
        return this.sessionBytes;
    }

    public boolean returnErrorToClient() {
        return this.returnErrorToClient;
    }

    public String sessionID() {
        return this.sessionID;
    }

    public String hostName() {
        return this.hostName;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String subMsg() {
        return this.subMsg;
    }

    public boolean secCtxFound() {
        return this.secCtxFound;
    }

    public CDRInputStream cis() {
        return this.cis;
    }

    public String mechType() {
        return this.mechType;
    }

    public String secName() {
        return this.secName;
    }

    public byte[] credToken() {
        return this.credToken;
    }

    public boolean failedAuthn() {
        return this.failedAuthn;
    }

    public byte[] secNameBytes() {
        return this.secNameBytes;
    }

    public byte[] accessID() {
        return this.accessID;
    }

    public byte[] primaryGroupID() {
        return this.primaryGroupID;
    }

    public byte[] groupIDBytes() {
        return this.groupIDBytes;
    }

    public int groupIDBytesLength() {
        return this.groupIDBytesLength;
    }

    public String role() {
        return this.role;
    }

    public String clientHostName() {
        return this.clientHostName;
    }

    public int serviceContextID() {
        return this.serviceContextID;
    }
}

