/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityUtilityImpl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityL13SupportImpl.SecurityMessages;
import com.ibm.ISecurityUtilityImpl.FullFileName;
import com.ibm.ISecurityUtilityImpl.RepositoryInconsistencyException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.omg.CORBA.portable.InputStream;

public class BootstrapRepository
extends Hashtable {
    private static final long serialVersionUID = 394927413429792344L;
    long updateTimestamp = 0L;
    String repositoryName = null;

    public BootstrapRepository(String string) {
        this.repositoryName = string;
        this.load();
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        String string = "BootstrapRepository.load";
        String string2 = null;
        boolean bl = true;
        long l = 0L;
        RandomAccessFile randomAccessFile = null;
        if (stringArray.length != 1) {
            System.out.println("Usage: BootstrapRepository <repositoryName || IOR:<ior>>");
            System.exit(0);
        }
        if (stringArray[0].startsWith("IOR:")) {
            bl = false;
        } else {
            serializable = new File(stringArray[0]);
            try {
                randomAccessFile = new RandomAccessFile((File)serializable, "r");
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.main", (String)"125");
                if (SecurityLogger.traceEnabled) {
                    string2 = SecurityMessages.getMsgOrUseDefault("ErrMsg462", "I/O Error trying to open the security bootstrap repository.");
                    SecurityLogger.traceMessage(string, string2);
                }
                return;
            }
        }
        serializable = new Properties();
        ((Properties)serializable).put("org.omg.CORBA.ORBClass", "com.ibm.CORBA.iiop.ORB");
        ORB oRB = (ORB)ORB.init((String[])stringArray, (Properties)serializable);
        try {
            Date date;
            if (bl) {
                long l2 = randomAccessFile.readLong();
                date = new Date(l2);
                System.out.println("Reading from bootstrap repository file (last update: " + date + ").,.");
                System.out.println("");
            }
            String string3 = "";
            String string4 = "";
            while (true) {
                if (bl) {
                    string3 = randomAccessFile.readUTF();
                    string4 = randomAccessFile.readUTF();
                } else {
                    string4 = stringArray[0];
                }
                if (string4.startsWith("IOR:")) {
                    string4 = string4.substring(4);
                }
                date = null;
                try {
                    byte[] byArray = new byte[string4.length() / 2];
                    for (int i = 0; i < byArray.length; ++i) {
                        byArray[i] = (byte)Integer.parseInt(string4.substring(i * 2, i * 2 + 2), 16);
                    }
                    date = ORB.createIOR((ORB)oRB);
                    CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
                    cDRInputStream.consumeEndian();
                    date.read((InputStream)cDRInputStream);
                    if (bl) {
                        System.out.println("\n\n****************** IOR #" + ++l + " ******************");
                    } else {
                        System.out.println("\n\n");
                    }
                    System.out.println(date.stringify());
                    System.out.println("");
                    System.out.println("Typeid:");
                    System.out.println(" " + date.getTypeId());
                    System.out.println("");
                    System.out.println("IIOP Profile:");
                    Profile profile = date.getProfile();
                    System.out.println(" GIOP = v" + profile.getMajor() + "." + profile.getMinor());
                    System.out.println(" Host = " + profile.getHost());
                    System.out.println(" Port = " + profile.getPort());
                    System.out.println(" Object Key  = [ " + BootstrapRepository.ByteHex(profile.getObjectKey()) + " ]");
                    System.out.println("");
                    System.out.println("Tagged components present:");
                    BootstrapRepository.PrintComponentList(date.getProfile().getTaggedComponents());
                    System.out.println("");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.main", (String)"225");
                    SecurityLogger.logException(string, exception, 0, 0);
                }
                if (bl) continue;
                System.exit(0);
            }
        }
        catch (EOFException eOFException) {
            FFDCFilter.processException((Throwable)eOFException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.main", (String)"238");
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.main", (String)"248");
                string2 = "security.JSAS1457I";
                SecurityLogger.logWarning(string2, new Object[]{string, iOException});
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.main", (String)"256");
            string2 = "security.JSAS0463E";
            SecurityLogger.logError(string2, new Object[]{string, iOException});
        }
        try {
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.main", (String)"269");
            string2 = "security.JSAS1457I";
            SecurityLogger.logWarning(string2, new Object[]{string, iOException});
        }
    }

    public static void PrintComponentList(Profile.TaggedComponent[] taggedComponentArray) {
        if (taggedComponentArray == null || taggedComponentArray.length == 0) {
            System.out.println(" none");
        } else {
            block17: for (int i = 0; i < taggedComponentArray.length; ++i) {
                switch (taggedComponentArray[i].tag()) {
                    default: {
                        System.out.println(" Unknown");
                        continue block17;
                    }
                    case 0: {
                        System.out.println(" TAG_ORB_TYPE");
                        continue block17;
                    }
                    case 1: {
                        System.out.println(" TAG_CODE_SETS");
                        continue block17;
                    }
                    case 2: {
                        System.out.println(" TAG_POLICIES");
                        continue block17;
                    }
                    case 3: {
                        System.out.println(" TAG_ALTERNATE_IIOP_ADDRESS");
                        continue block17;
                    }
                    case 13: {
                        System.out.println(" TAG_ASSOCIATION_OPTIONS");
                        continue block17;
                    }
                    case 14: {
                        System.out.println(" TAG_SEC_NAME");
                        continue block17;
                    }
                    case 15: {
                        System.out.println(" TAG_SPKM_1_SEC_MECH");
                        continue block17;
                    }
                    case 16: {
                        System.out.println(" TAG_SPKM_2_SEC_MECH");
                        continue block17;
                    }
                    case 17: {
                        System.out.println(" TAG_KerberosV5_SEC_MECH");
                        continue block17;
                    }
                    case 18: {
                        System.out.println(" TAG_CSI_ECMA_Secret_SEC_MECH");
                        continue block17;
                    }
                    case 19: {
                        System.out.println(" TAG_CSI_ECMA_Hybrid_SEC_MECH");
                        continue block17;
                    }
                    case 20: {
                        System.out.println(" TAG_SSL_SEC_TRANS");
                        CDRInputStream cDRInputStream = ORB.createCDRInputStream(null, (byte[])taggedComponentArray[i].componentData(), (int)taggedComponentArray[i].componentData().length);
                        cDRInputStream.consumeEndian();
                        short s = cDRInputStream.read_short();
                        short s2 = cDRInputStream.read_short();
                        short s3 = cDRInputStream.read_short();
                        System.out.println("\tsslPort=" + s3 + ", qopTargetSupports=" + s + ", qopTargetRequires=" + s2);
                        continue block17;
                    }
                    case 21: {
                        System.out.println(" TAG_CSI_ECMA_Public_SEC_MECH");
                        continue block17;
                    }
                    case 22: {
                        System.out.println(" TAG_GENERIC_SEC_MECH");
                        continue block17;
                    }
                    case 25: {
                        System.out.println(" TAG_JAVA_CODEBASE");
                    }
                }
            }
        }
    }

    public static String FullHex(int n, int n2) {
        String string = Integer.toHexString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return "0x" + string.toUpperCase();
    }

    public static String ByteHex(byte[] byArray) {
        String string = "";
        for (int i = 0; i < byArray.length; ++i) {
            String string2 = "0" + Integer.toHexString(byArray[i]);
            string = string + string2.substring(string2.length() - 2);
        }
        return string.toUpperCase();
    }

    protected void load() {
        String string = "BootstrapRepository.load";
        String string2 = null;
        File file = new File(this.repositoryName);
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.load", (String)"382", (Object)this);
            if (SecurityLogger.traceEnabled) {
                string2 = SecurityMessages.getMsgOrUseDefault("ErrMsg462", "I/O Error trying to open the security bootstrap repository.");
                SecurityLogger.traceMessage(string, string2);
            }
            return;
        }
        try {
            this.updateTimestamp = randomAccessFile.readLong();
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Reading from bootstrap repository file.";
                SecurityLogger.debugMessage(string, string2);
            }
            while (true) {
                String string3 = randomAccessFile.readUTF();
                String string4 = randomAccessFile.readUTF();
                this.put(string3, string4);
            }
        }
        catch (EOFException eOFException) {
            FFDCFilter.processException((Throwable)eOFException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.load", (String)"427", (Object)this);
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.load", (String)"436", (Object)this);
                string2 = "security.JSAS1457I";
                SecurityLogger.logWarning(string2, new Object[]{string, iOException});
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.load", (String)"444", (Object)this);
            string2 = "security.JSAS0463E";
            SecurityLogger.logError(string2, new Object[]{string, iOException});
        }
    }

    public void store() throws RepositoryInconsistencyException {
        String string = "BootstrapRepository.store";
        String string2 = null;
        File file = new File(this.repositoryName);
        File file2 = new File(FullFileName.getPathName(this.repositoryName));
        if (file2 != null && !file2.exists()) {
            file2.mkdirs();
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.store", (String)"498", (Object)this);
            string2 = "security.JSAS0462E";
            SecurityLogger.logError(string2, new Object[]{string, iOException});
        }
        try {
            long l = randomAccessFile.readLong();
            if (this.updateTimestamp != l) {
                this.load();
                l = randomAccessFile.readLong();
                if (this.updateTimestamp != l) {
                    if (SecurityLogger.debugTraceEnabled) {
                        string2 = "RepositoryInconsistencyException";
                        SecurityLogger.debugMessage(string, string2);
                    }
                    throw new RepositoryInconsistencyException();
                }
            }
            randomAccessFile.seek(0L);
        }
        catch (EOFException eOFException) {
            FFDCFilter.processException((Throwable)eOFException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.store", (String)"536", (Object)this);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.store", (String)"541", (Object)this);
            string2 = "security.JSAS0463E";
            SecurityLogger.logError(string2, new Object[]{string, iOException});
            return;
        }
        try {
            Date date = new Date();
            randomAccessFile.writeLong(date.getTime());
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Writing the repository.";
                SecurityLogger.debugMessage(string, string2);
            }
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = (String)this.get(string3);
                randomAccessFile.writeUTF(string3);
                randomAccessFile.writeUTF(string4);
            }
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ISecurityUtilityImpl.BootstrapRepository.store", (String)"586", (Object)this);
            string2 = "security.JSAS0464E";
            SecurityLogger.logError(string2, new Object[]{string, iOException});
        }
    }
}

