/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.ExtendedIORInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityTaggedComponentAssistorImpl;
import com.ibm.ISecurityLocalObjectBaseL13Impl.VaultImpl;
import com.ibm.ISecurityUtilityImpl.ConfigURLProperties;
import com.ibm.ISecurityUtilityImpl.ObjectList;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitializer;

public class SecurityComponentFactory
extends LocalObject
implements ORBInitializer,
IORInterceptor {
    private static final long serialVersionUID = 47242221431011068L;
    private static final String ADMIN_CLASS = "adminsec.txt";
    private Object lock = new Object();
    private boolean _attemptingToInitialize = false;
    private static Hashtable _assistorCache = null;
    private ORB _orb = null;
    private SecurityTaggedComponentAssistorImpl[] _assistorList = null;
    private SecurityConfiguration _securityConfiguration = null;
    private VaultImpl _vault = null;
    private String name = "SecurityIORInterceptor";
    private boolean indirect = false;
    private ObjectList list = null;

    public String name() {
        return this.name;
    }

    public void destroy() {
        if (SecurityLogger.debugTraceEnabled) {
            String string = "SecurityComponentFactory.destroy";
            String string2 = "In the destroy method";
            SecurityLogger.debugMessage(string, string2);
        }
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
        block3: {
            String string = "SecurityComponentFactory.pre_init";
            if (ConfigURLProperties.isSecurityEnabled()) {
                try {
                    oRBInitInfo.add_ior_interceptor((IORInterceptor)this);
                    SecurityLogger.logAudit(string, "security.IORInterceptor");
                }
                catch (DuplicateName duplicateName) {
                    FFDCFilter.processException((Throwable)duplicateName, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityComponentFactory.pre_init", (String)"137", (Object)((Object)this));
                    if (!SecurityLogger.debugTraceEnabled) break block3;
                    String string2 = "Exception occurred adding IORInterceptor.";
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.traceException(string, (Exception)((Object)duplicateName), 0, 0);
                }
            }
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        String string = "SecurityComponentFactory.post_init";
        String string2 = "";
        if (ConfigURLProperties.isSecurityEnabled()) {
            this._vault = VaultImpl.getInstance();
            if (this._vault != null) {
                this._orb = this._vault.getORB();
                SecurityComponentFactory securityComponentFactory = this;
                this._securityConfiguration = securityComponentFactory._vault.getSecurityConfiguration();
                try {
                    this._assistorList = SecurityTaggedComponentAssistorImpl.create(this._orb, this._securityConfiguration, this._vault.getMechanismFactory(), this._vault.getSecurityConnectionInterceptor());
                    _assistorCache = new Hashtable();
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityComponentFactory.post_init", (String)"189", (Object)((Object)this));
                    string2 = "Java Exception creating SecurityTaggedComponentAssistorImpl.";
                    SecurityLogger.debugMessage(string, string2);
                    SecurityLogger.logException(string, exception, 0, 0);
                }
                this.list = new ObjectList(ADMIN_CLASS);
            }
        }
    }

    public static String constructServerName(String string, int n) {
        String string2 = null;
        Integer n2 = new Integer(n);
        String string3 = string.replace('.', '-');
        string2 = string3 + "." + n2.toString();
        return string2;
    }

    protected static void clearCachedComponentData() {
        _assistorCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void establish_components(IORInfo iORInfo) {
        Object object;
        String string;
        String string2;
        block23: {
            string2 = "SecurityComponentFactory.establish_components";
            string = null;
            if (SecurityLogger.debugTraceEnabled) {
                string = "Calling establish_components.";
                SecurityLogger.debugMessage(string2, string);
            }
            if (!ConfigURLProperties.isSecurityEnabled()) {
                string = "Security disabled.";
                SecurityLogger.debugMessage(string2, string);
                return;
            }
            if (!ConfigURLProperties.isServerSecurityEnabled()) {
                String string3;
                string = "Server Security is disabled, checking to see if admin class.";
                SecurityLogger.debugMessage(string2, string);
                object = ((ExtendedIORInfo)iORInfo).getTarget();
                if (object != null && !this.list.find(string3 = object.getClass().getName())) {
                    string = "Not adding tagged components for user class: " + string3;
                    SecurityLogger.debugMessage(string2, string);
                    return;
                }
            }
            if (SecurityLogger.debugTraceEnabled) {
                object = ((ExtendedIORInfo)iORInfo).getTarget();
                if (object != null) {
                    String string4 = object.getClass().getName();
                    string = "Adding tagged components for class name: " + object.getClass().getName();
                    SecurityLogger.debugMessage(string2, string);
                } else {
                    string = "Adding tagged components for UNKNOWN class name (getTarget() returned null) .";
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            try {
                object = ((ExtendedIORInfo)iORInfo).getProfile();
                byte[] byArray = object.getTaggedComponent(777);
                byte[] byArray2 = object.getTaggedComponent(20);
                if (byArray != null && byArray2 != null) {
                    string = "Tagged components already added.";
                    SecurityLogger.debugMessage(string2, string);
                    return;
                }
                String string5 = (String)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Profile)object){
                    private final /* synthetic */ Profile val$taggedProfile;
                    {
                        this.val$taggedProfile = profile;
                    }

                    public Object run() throws Exception {
                        return SecurityConnectionInterceptor.getHostfromProfile(this.val$taggedProfile);
                    }
                });
                if (string5 == null || string5.trim().length() == 0) {
                    string = "security.JSAS0467E";
                    SecurityLogger.logError(string, new Object[]{string2});
                    return;
                }
                if (SecurityLogger.debugTraceEnabled) {
                    string = "The profile host and port for accessing Assistor are: " + string5 + ":" + object.getPort();
                    SecurityLogger.debugMessage(string2, string);
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityComponentFactory.establish_components", (String)"279", (Object)((Object)this));
                if (!SecurityLogger.debugTraceEnabled) break block23;
                string = "Exception occurred accessing IOR tagged profile.";
                SecurityLogger.debugMessage(string2, string);
                SecurityLogger.traceException(string2, exception, 0, 0);
            }
        }
        object = this.lock;
        synchronized (object) {
            if (!this._attemptingToInitialize) {
                string = "Attempting to initialize.";
                SecurityLogger.debugMessage(string2, string);
                try {
                    void var5_14;
                    Object var5_11 = null;
                    for (int i = 0; i < this._assistorList.length; ++i) {
                        if (this._securityConfiguration.getProtocol().compareToIgnoreCase("ibm") == 0) {
                            if (this._assistorList[i].getConnectionType() != 2) continue;
                            string = "Found local SSL tagged component assistor... getting component data.";
                            SecurityLogger.debugMessage(string2, string);
                            ComponentData[] componentDataArray = this._assistorList[i].getComponentData(new byte[0]);
                            break;
                        }
                        string = "Found local tagged component assistor... getting component data.";
                        SecurityLogger.debugMessage(string2, string);
                        ComponentData[] componentDataArray = this._assistorList[i].getComponentData(new byte[0]);
                        break;
                    }
                    if (var5_14 != null) {
                        string = "Total number of tagged components: " + ((void)var5_14).length;
                        SecurityLogger.debugMessage(string2, string);
                        TaggedComponent taggedComponent = null;
                        for (int i = 0; i < ((void)var5_14).length; ++i) {
                            string = "Adding tagged component ID: " + var5_14[i].componentID;
                            SecurityLogger.debugMessage(string2, string);
                            taggedComponent = new TaggedComponent(var5_14[i].componentID, var5_14[i].componentBodyValue);
                            iORInfo.add_ior_component(taggedComponent);
                        }
                    }
                    if (!SecurityLogger.debugTraceEnabled) return;
                    string = "No security tagged components applied to IOR during create.";
                    SecurityLogger.debugMessage(string2, string);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityComponentFactory.establish_components", (String)"379", (Object)((Object)this));
                    if (!SecurityLogger.traceEnabled) throw new INTERNAL(string, 1229066438, CompletionStatus.COMPLETED_NO);
                    string = "Exception adding tagged components to IOR.";
                    SecurityLogger.debugMessage(string2, string);
                    SecurityLogger.traceException(string2, exception, 0, 0);
                    throw new INTERNAL(string, 1229066438, CompletionStatus.COMPLETED_NO);
                }
            } else {
                string = "Already initializing.";
                SecurityLogger.debugMessage(string2, string);
            }
            return;
        }
    }
}

