/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ISecurityLocalObjectBaseL13Impl;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.IExtendedSecurityPriv.ComponentData;
import com.ibm.IExtendedSecurityPriv.ComponentDataHolder;
import com.ibm.IExtendedSecurityPriv.ObjectDoesNotExistHere;
import com.ibm.ISecurityL13SupportImpl.SecurityLogger;
import com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor;
import com.ibm.ISecurityUtilityImpl.RealmSecurityName;
import com.ibm.ISecurityUtilityImpl.SSLClientAuthType;
import com.ibm.ISecurityUtilityImpl.SecurityConfiguration;
import com.ibm.ISecurityUtilityImpl.SecurityTaggedComponent;
import com.ibm.ISecurityUtilityImpl.VaultConstants;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.orbssl.SSLServerConnectionData;
import org.omg.CORBA.SystemException;

public final class SSLCompoundTaggedComponent
extends SecurityTaggedComponent {
    private int _tagLength = 0;
    private boolean _littleEndian = false;
    private short _major_version = 1;
    private short _minor_version = 0;
    private int _SSLPort = 0;
    private String _targetRealmName = null;
    private String _targetSecurityName = null;
    private int _sslClientAuthType = 0;

    public static final ComponentDataHolder getSSLCompoundComponentData(SecurityConfiguration securityConfiguration, SecurityConnectionInterceptor securityConnectionInterceptor, String string) throws ObjectDoesNotExistHere {
        String string2 = "SSLCompoundTaggedComponent.getSSLCompoundComponentData";
        String string3 = null;
        try {
            int n = securityConfiguration.getauthenticationTarget();
            int n2 = 0;
            byte[] byArray = null;
            String string4 = null;
            String string5 = null;
            boolean bl = true;
            if (n == 0 || n == 4) {
                string3 = "Invalid authenticationTarget. Cannot build SSL compound tag.";
                SecurityLogger.debugMessage(string2, string3);
                return null;
            }
            switch (n) {
                case 5: {
                    n2 = 0;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                case 1: {
                    n2 = 6;
                    break;
                }
                case 2: {
                    n2 = 8;
                    break;
                }
                case 6: {
                    n2 = 4;
                }
            }
            byArray = new byte[]{1, 0};
            string4 = RealmSecurityName.getRealm(string);
            string5 = RealmSecurityName.getSecurityName(string);
            short s = 0;
            if (securityConfiguration.claimClientAuthenticationSupported() || securityConfiguration.claimServerAuthenticationSupported() || securityConfiguration.claimMessageReplayDetectionSupported() || securityConfiguration.claimMessageOutOfSequenceDetectionSupported() || securityConfiguration.claimMessageIntegritySupported() || securityConfiguration.claimMessageConfidentialitySupported()) {
                if (securityConfiguration.claimClientAuthenticationSupported()) {
                    s = (short)(s + 64);
                }
                if (securityConfiguration.claimServerAuthenticationSupported()) {
                    s = (short)(s + 32);
                }
                if (securityConfiguration.claimMessageReplayDetectionSupported()) {
                    s = (short)(s + 8);
                }
                if (securityConfiguration.claimMessageOutOfSequenceDetectionSupported()) {
                    s = (short)(s + 16);
                }
                if (securityConfiguration.claimMessageIntegritySupported()) {
                    s = (short)(s + 2);
                }
                if (securityConfiguration.claimMessageConfidentialitySupported()) {
                    s = (short)(s + 4);
                }
            } else {
                s = 1;
            }
            short s2 = 0;
            if (securityConfiguration.claimClientAuthenticationRequired() || securityConfiguration.claimServerAuthenticationRequired() || securityConfiguration.claimMessageReplayDetectionRequired() || securityConfiguration.claimMessageOutOfSequenceDetectionRequired() || securityConfiguration.claimMessageIntegrityRequired() || securityConfiguration.claimMessageConfidentialityRequired()) {
                s2 = 16384;
                if (securityConfiguration.claimClientAuthenticationRequired()) {
                    s2 = (short)(s2 + 64);
                }
                if (securityConfiguration.claimServerAuthenticationRequired()) {
                    s2 = (short)(s2 + 32);
                }
                if (securityConfiguration.claimMessageReplayDetectionRequired()) {
                    s2 = (short)(s2 + 8);
                }
                if (securityConfiguration.claimMessageOutOfSequenceDetectionRequired()) {
                    s2 = (short)(s2 + 16);
                }
                if (securityConfiguration.claimMessageIntegrityRequired()) {
                    s2 = (short)(s2 + 2);
                }
                if (securityConfiguration.claimMessageConfidentialityRequired()) {
                    s2 = (short)(s2 + 4);
                }
            } else {
                s2 = 1;
            }
            int n3 = 0;
            SSLServerConnectionData sSLServerConnectionData = securityConnectionInterceptor.getSASRegisteredSSLServerConnectionDataObject();
            if (sSLServerConnectionData != null) {
                n3 = sSLServerConnectionData.getServerPort();
                if (n3 == 0) {
                    string3 = "security.JSAS0446E";
                    SecurityLogger.logError(string3, new Object[]{string2});
                }
            } else {
                n3 = securityConfiguration.getSSLPort();
            }
            CDROutputStream cDROutputStream = ORB.createCDROutputStream(null);
            cDROutputStream.putEndian();
            cDROutputStream.write_octet(byArray[0]);
            cDROutputStream.write_octet(byArray[1]);
            cDROutputStream.write_long(n2);
            cDROutputStream.write_short(s);
            cDROutputStream.write_short(s2);
            cDROutputStream.write_short((short)n3);
            cDROutputStream.write_string(string4);
            cDROutputStream.write_string(string5);
            byte[] byArray2 = cDROutputStream.toByteArray();
            ComponentDataHolder componentDataHolder = new ComponentDataHolder();
            componentDataHolder.value = new ComponentData(1229081864, byArray2);
            return componentDataHolder;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SSLCompoundTaggedComponent.getSSLCompoundComponentData", (String)"254");
            return null;
        }
    }

    public static synchronized SSLCompoundTaggedComponent getSSLCompoundTaggedComponent(Profile profile, IOR iOR) {
        byte[] byArray = null;
        SSLCompoundTaggedComponent sSLCompoundTaggedComponent = null;
        try {
            byArray = profile.getTaggedComponent(1229081864);
            if (byArray == null) {
                Profile profile2 = iOR.getProfile(0);
                byArray = profile2.getTaggedComponent(1229081864);
            }
            if (byArray != null) {
                sSLCompoundTaggedComponent = new SSLCompoundTaggedComponent(byArray);
            }
            return sSLCompoundTaggedComponent;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SSLCompoundTaggedComponent.getSSLCompoundTaggedComponent", (String)"298");
            return null;
        }
    }

    private SSLCompoundTaggedComponent(byte[] byArray) {
        String string = "SSLCompoundTaggedComponent.SSLCompoundTaggedComponent";
        String string2 = null;
        try {
            if (byArray[0] != 0) {
                this._littleEndian = true;
            }
            CDRInputStream cDRInputStream = ORB.createCDRInputStream(null, (byte[])byArray, (int)byArray.length, (boolean)this._littleEndian);
            this._tagLength = byArray.length;
            this.set_tagID(1229081864);
            cDRInputStream.consumeEndian();
            this._major_version = cDRInputStream.read_octet();
            this._minor_version = cDRInputStream.read_octet();
            this._sslClientAuthType = cDRInputStream.read_long();
            this._targetCoalescedSuppQOP = cDRInputStream.read_short();
            this._targetCoalescedReqQOP = cDRInputStream.read_short();
            this._SSLPort = cDRInputStream.read_short();
            this._targetRealmName = cDRInputStream.read_string();
            this._targetSecurityName = cDRInputStream.read_string();
            if (this._targetRealmName != null && this._targetRealmName.length() != 0 && this._targetSecurityName != null && this._targetSecurityName.length() != 0) {
                this.set_targetCompleteName(RealmSecurityName.getRealmSecurityName(this._targetRealmName, this._targetSecurityName));
            }
            if (SecurityLogger.debugTraceEnabled) {
                string2 = "Basic Auth SSL Tag values: sslPort =  " + this._SSLPort + ", target requires  = " + this._targetCoalescedReqQOP + ", target supports = " + this._targetCoalescedSuppQOP + ", target client authentication type: " + (String)SSLClientAuthType.strings.get(new Integer(this._sslClientAuthType));
                SecurityLogger.debugMessage(string, string2);
            }
        }
        catch (SystemException systemException) {
            FFDCFilter.processException((Throwable)systemException, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SSLCompoundTaggedComponent.SSLCompoundTaggedComponent", (String)"386", (Object)this);
            string2 = "security.JSAS0449E";
            SecurityLogger.logError(string2, new Object[]{string, systemException});
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ISecurityLocalObjectBaseL13Impl.SSLCompoundTaggedComponent.SSLCompoundTaggedComponent", (String)"392", (Object)this);
            string2 = "security.JSAS0449E";
            SecurityLogger.logError(string2, new Object[]{string, exception});
        }
    }

    public int get_sslClientAuthType() {
        return this._sslClientAuthType;
    }

    public String get_targetSecurityName() {
        return this._targetSecurityName;
    }

    public int get_SSLPort() {
        return this._SSLPort;
    }

    public String get_targetRealmName() {
        return this._targetRealmName;
    }

    public String getMechanismType() {
        return VaultConstants.SSL_MECH_TYPE;
    }
}

