/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector2.spi;

import com.ibm.connector2.spi.Identifier;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class UniqueID
implements Identifier {
    static final String copyright = "(c) Copyright IBM Corporation 1998, 2000.";
    private byte[] fieldID = new byte[20];
    private static long counter = 0L;
    private static Object counterLock = new Object();
    private static byte[] fourByte = new byte[4];
    private static byte[] eightByte = new byte[8];

    public UniqueID() {
        long currentSeed = 0L;
        long currentTime = 0L;
        byte[] host = fourByte;
        byte[] currentSeedByte = eightByte;
        byte[] currentTimeByte = eightByte;
        try {
            host = InetAddress.getLocalHost().getAddress();
        }
        catch (UnknownHostException unknownHostException) {}
        try {
            Object object = counterLock;
            synchronized (object) {
                currentSeed = ++counter % Long.MAX_VALUE;
                currentTime = System.currentTimeMillis();
            }
            currentSeedByte = this.convertToByte(currentSeed);
            currentTimeByte = this.convertToByte(currentTime);
        }
        catch (Throwable throwable) {}
        int i = 0;
        while (i < 4) {
            this.fieldID[i] = host[i];
            ++i;
        }
        i = 4;
        while (i < 12) {
            this.fieldID[i] = currentTimeByte[i - 4];
            ++i;
        }
        i = 12;
        while (i < 20) {
            this.fieldID[i] = currentSeedByte[i - 12];
            ++i;
        }
    }

    private byte[] convertToByte(long sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00000000000000L) >>> 56), (byte)((sb & 0xFF000000000000L) >>> 48), (byte)((sb & 0xFF0000000000L) >>> 40), (byte)((sb & 0xFF00000000L) >>> 32), (byte)((sb & 0xFF000000L) >>> 24), (byte)((sb & 0xFF0000L) >>> 16), (byte)((sb & 0xFF00L) >>> 8), (byte)(sb & 0xFFL)};
        return tb;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        try {
            Identifier newID = (Identifier)obj;
            if (this.fieldID.length != newID.toBytes().length) {
                return false;
            }
            byte[] byteID = newID.toBytes();
            int i = 0;
            while (i < byteID.length) {
                if (this.fieldID[i] != byteID[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public byte[] toBytes() {
        return this.fieldID;
    }

    public String toString() {
        try {
            return new String(this.fieldID, "cp437");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.fieldID);
        }
        catch (Throwable throwable) {
            return new String(this.fieldID);
        }
    }
}

