/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.connector2.spi;

import com.ibm.connector2.spi.ConnectionPoolProperties;
import com.ibm.connector2.spi.DefaultConnectionPoolProperties;
import com.ibm.connector2.spi.PoolManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;

public class DefaultConnectionManager
implements ConnectionManager,
ConnectionEventListener {
    static final String copyright = "(c) Copyright IBM Corporation 2000.";
    private static PoolManager poolManager = null;
    private static PrintWriter logWriter = null;
    private transient Object affinityID = null;
    private ConnectionPoolProperties connectionPoolProperties;
    private transient Hashtable sharedConnections = new Hashtable();

    public DefaultConnectionManager() {
        this.connectionPoolProperties = new DefaultConnectionPoolProperties();
    }

    public Object allocateConnection(ManagedConnectionFactory factory, ConnectionRequestInfo requestInfo) throws ResourceException {
        this.logTrace(" >>> DefaultConnectionManager.allocateConnection()");
        if (logWriter != null) {
            if (factory != null) {
                factory.setLogWriter(logWriter);
            }
            if (poolManager != null) {
                poolManager.setLogWriter(logWriter);
            }
        }
        ManagedConnection managed = null;
        Connection connection = null;
        managed = poolManager == null ? factory.createManagedConnection(null, requestInfo) : poolManager.reserve(factory, this.connectionPoolProperties, null, requestInfo, this.affinityID, true);
        if (this.sharedConnections.containsKey(managed)) {
            Integer count = (Integer)this.sharedConnections.get(managed);
            this.sharedConnections.put(managed, new Integer(count + 1));
        } else {
            managed.addConnectionEventListener((ConnectionEventListener)this);
            this.sharedConnections.put(managed, new Integer(1));
        }
        connection = (Connection)managed.getConnection(null, requestInfo);
        this.logTrace(" <<< DefaultConnectionManager.allocateConnection()");
        return connection;
    }

    public void connectionClosed(ConnectionEvent event) {
        this.logTrace(" >>> DefaultConnectionManager.connectionClosed()");
        ManagedConnection mc = (ManagedConnection)event.getSource();
        Integer count = (Integer)this.sharedConnections.get(mc);
        if (count == 1) {
            this.sharedConnections.remove(mc);
            mc.removeConnectionEventListener((ConnectionEventListener)this);
            if (poolManager == null) {
                try {
                    mc.destroy();
                }
                catch (ResourceException resourceException) {}
            } else {
                try {
                    poolManager.release(mc, this.affinityID);
                }
                catch (ApplicationServerInternalException applicationServerInternalException) {}
            }
        } else {
            if (poolManager == null) {
                try {
                    mc.destroy();
                }
                catch (ResourceException resourceException) {}
                return;
            }
            this.sharedConnections.put(mc, new Integer(count - 1));
        }
        this.logTrace(" <<< DefaultConnectionManager.connectionClosed()");
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this.logTrace(" >>> DefaultConnectionManager.connectionErrorOccurred()");
        ManagedConnection mc = (ManagedConnection)event.getSource();
        this.sharedConnections.remove(mc);
        if (poolManager == null) {
            try {
                mc.destroy();
            }
            catch (ResourceException resourceException) {}
        } else {
            try {
                poolManager.delete(mc, this.affinityID);
            }
            catch (ApplicationServerInternalException applicationServerInternalException) {}
        }
        this.logTrace(" <<< DefaultConnectionManager.connectionErrorOccurred()");
    }

    public void localTransactionCommitted(ConnectionEvent event) {
    }

    public void localTransactionRolledback(ConnectionEvent event) {
    }

    public void localTransactionStarted(ConnectionEvent event) {
    }

    private synchronized void logTrace(String msg) {
        if (logWriter != null) {
            logWriter.println(msg);
            logWriter.flush();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.sharedConnections = new Hashtable();
    }

    public void setAffinityID(Object aAffinityID) {
        this.affinityID = aAffinityID;
    }

    public void setConnectionPoolProperties(ConnectionPoolProperties aPoolProperties) {
        this.connectionPoolProperties = aPoolProperties;
    }

    public static void setLogWriter(PrintWriter newLogWriter) {
        logWriter = newLogWriter;
    }

    public static void setPoolManager(PoolManager newPoolManager) {
        poolManager = newPoolManager;
    }
}

