/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.Realm;
import com.ibm.security.krb5.internal.EncKDCRepPart;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.PAData;
import com.ibm.security.krb5.internal.RealmException;
import com.ibm.security.krb5.internal.Ticket;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Vector;

public class KDCRep {
    public int pvno;
    public int msgType;
    public PAData[] pAData;
    public Realm crealm;
    public PrincipalName cname;
    public Ticket ticket;
    public EncryptedData encPart;
    public EncKDCRepPart encKDCRepPart;

    public KDCRep(PAData[] pADataArray, Realm realm, PrincipalName principalName, Ticket ticket, EncryptedData encryptedData, int n2) {
        this.pvno = 5;
        this.msgType = n2;
        this.pAData = pADataArray;
        this.crealm = realm;
        this.cname = principalName;
        this.ticket = ticket;
        this.encPart = encryptedData;
    }

    public KDCRep() {
    }

    public KDCRep(byte[] byArray, int n2) throws Asn1Exception, KrbApErrException, RealmException, IOException {
        this.a(new DerValue(byArray), n2);
    }

    public KDCRep(DerValue derValue, int n2) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.a(derValue, n2);
    }

    public void decrypt(EncryptionKey encryptionKey) throws Asn1Exception, IOException, KrbException, RealmException {
        this.encKDCRepPart = new EncKDCRepPart(this.encPart.decrypt(encryptionKey), this.msgType);
    }

    protected void a(DerValue derValue, int n2) throws Asn1Exception, RealmException, IOException, KrbApErrException {
        if ((derValue.getTag() & 0x1F) != n2) {
            if (Krb5Debug.on(9)) {
                Krb5Debug krb5Debug = new Krb5Debug(KDCRep.a("\u0018>\u000fJ\u0016#@") + Thread.currentThread().getName() + KDCRep.a("iZ"));
                krb5Debug.out(5, KDCRep.a("mDr88\u00179\u001e}\u0003iZ%v\u001a'Re8\u0016=\u0019#|\u001a=\u001dll\u00124Z%kS") + derValue.getTag() + KDCRep.a("s\b)iS'\u0003<}S:\tl") + n2);
            }
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if (derValue2.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 0) {
            this.pvno = derValue3.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        derValue3 = derValue2.getData().getDerValue();
        if ((derValue3.getTag() & 0x1F) == 1) {
            this.msgType = derValue3.getData().getBigInteger().intValue();
            if (this.msgType != n2) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((derValue2.getData().peekByte() & 0x1F) == 2) {
            derValue3 = derValue2.getData().getDerValue();
            Vector vector = new Vector();
            DerValue[] derValueArray = derValue3.getData().getSequence(1);
            this.pAData = new PAData[derValueArray.length];
            for (int i2 = 0; i2 < derValueArray.length; ++i2) {
                this.pAData[i2] = new PAData(derValueArray[i2]);
            }
        } else {
            this.pAData = null;
        }
        this.crealm = Realm.parse(derValue2.getData(), (byte)3, false);
        this.cname = PrincipalName.parse(derValue2.getData(), (byte)4, false);
        this.ticket = Ticket.parse(derValue2.getData(), (byte)5, false);
        this.encPart = EncryptedData.parse(derValue2.getData(), (byte)6, false);
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.pvno));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.msgType));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        if (this.pAData != null && this.pAData.length > 0) {
            DerOutputStream derOutputStream3 = new DerOutputStream();
            for (int i2 = 0; i2 < this.pAData.length; ++i2) {
                derOutputStream3.write(this.pAData[i2].asn1Encode());
            }
            derOutputStream2 = new DerOutputStream();
            derOutputStream2.write((byte)48, derOutputStream3);
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        }
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), this.crealm.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)4), this.cname.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)5), this.ticket.asn1Encode());
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)6), this.encPart.asn1Encode());
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        derOutputStream = new DerOutputStream();
        derOutputStream.write(DerValue.createTag((byte)64, (boolean)true, (byte)((byte)this.msgType)), derOutputStream2);
        return derOutputStream.toByteArray();
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 83;
                        break;
                    }
                    case 1: {
                        n5 = 122;
                        break;
                    }
                    case 2: {
                        n5 = 76;
                        break;
                    }
                    case 3: {
                        n5 = 24;
                        break;
                    }
                    default: {
                        n5 = 115;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

