/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5.internal;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.internal.AuthorizationDataEntry;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.util.Vector;

public class AuthorizationData
implements Cloneable {
    public AuthorizationDataEntry[] entry;

    private AuthorizationData() {
    }

    public AuthorizationData(AuthorizationDataEntry[] authorizationDataEntryArray) {
        this.entry = authorizationDataEntryArray;
    }

    public AuthorizationData(AuthorizationDataEntry authorizationDataEntry) {
        this.entry = new AuthorizationDataEntry[1];
        this.entry[0] = authorizationDataEntry;
    }

    public Object clone() {
        AuthorizationData authorizationData = new AuthorizationData();
        if (this.entry != null) {
            authorizationData.entry = new AuthorizationDataEntry[this.entry.length];
            for (int i2 = 0; i2 < this.entry.length; ++i2) {
                authorizationData.entry[i2] = (AuthorizationDataEntry)this.entry[i2].clone();
            }
        }
        return authorizationData;
    }

    public AuthorizationData(DerValue derValue) throws Asn1Exception, IOException {
        Vector<AuthorizationDataEntry> vector = new Vector<AuthorizationDataEntry>();
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        while (derValue.getData().available() > 0) {
            vector.addElement(new AuthorizationDataEntry(derValue.getData().getDerValue()));
        }
        if (vector.size() > 0) {
            this.entry = new AuthorizationDataEntry[vector.size()];
            vector.copyInto(this.entry);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerValue[] derValueArray = new DerValue[this.entry.length];
        for (int i2 = 0; i2 < this.entry.length; ++i2) {
            derValueArray[i2] = new DerValue(this.entry[i2].asn1Encode());
        }
        derOutputStream.putSequence(derValueArray);
        return derOutputStream.toByteArray();
    }

    public static AuthorizationData parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new AuthorizationData(derValue2);
    }

    public void writeAuth(b b2) throws IOException {
        b2.a(this.entry.length);
        for (int i2 = 0; i2 < this.entry.length; ++i2) {
            this.entry[i2].writeEntry(b2);
        }
    }
}

