/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;

public class HostAddresses
implements Cloneable {
    public HostAddress[] addresses;

    public HostAddresses(HostAddress[] hostAddressArray) {
        this.addresses = hostAddressArray;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int n2) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException(HostAddresses.a("*d\n\r|\u0016}\u0017=|*j\u0013;"), null);
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
        }
        this.addresses = hostAddressArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new HostAddress[this.addresses.length];
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                hostAddresses.addresses[i2] = (HostAddress)this.addresses[i2].clone();
            }
        }
        return hostAddresses;
    }

    public boolean inList(HostAddress hostAddress) {
        if (this.addresses != null) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (!this.addresses[i2].equals(hostAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (this.addresses[i2].equals(hostAddresses.addresses[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new HostAddress(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new HostAddress[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                derOutputStream.write(this.addresses[i2].asn1Encode());
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(b b2) throws IOException {
        b2.a(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            b2.b(this.addresses[i2].addrType);
            b2.a(this.addresses[i2].address.length);
            b2.write(this.addresses[i2].address, 0, this.addresses[i2].address.length);
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            try {
                if (this.addresses[i2].addrType != 2 && this.addresses[i2].addrType != 23) continue;
                arrayList.add(this.addresses[i2].getInetAddress());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        return arrayList.toArray(inetAddressArray);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        Object object;
        String string = null;
        InetAddress[] inetAddressArray = null;
        HostAddresses hostAddresses = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
            for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
            }
            hostAddresses = new HostAddresses(hostAddressArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (Krb5Debug.on(9)) {
            object = new Krb5Debug(HostAddresses.a(",d\r*X\u0000o\f;j\u0017n\rd") + Thread.currentThread().getName() + HostAddresses.a("^+"));
            ((Krb5Debug)object).out(9, HostAddresses.a("Z5@~R\u0016i5:z6n\u000f~u\u000bh\u001f29\u0005o\u001a,|\u0017x\u001b-9\u0002d\f~") + string + HostAddresses.a("Dj\f;#D"));
            for (int i3 = 0; i3 < inetAddressArray.length; ++i3) {
                ((Krb5Debug)object).out(9, HostAddresses.a("n\u0002") + inetAddressArray[i3]);
            }
        }
        return hostAddresses;
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            this.addresses[i2] = new HostAddress(inetAddressArray[i2]);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 100;
                        break;
                    }
                    case 1: {
                        n5 = 11;
                        break;
                    }
                    case 2: {
                        n5 = 126;
                        break;
                    }
                    case 3: {
                        n5 = 94;
                        break;
                    }
                    default: {
                        n5 = 25;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

