/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptionKey;
import com.ibm.security.krb5.internal.KdcErrException;
import com.ibm.security.krb5.internal.KrbApErrException;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.crypto.m;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.math.BigInteger;

public class EncryptedData
implements Cloneable {
    int a;
    Integer b;
    byte[] c;
    byte[] d;
    public static final int ETYPE_NULL = 0;
    public static final int ETYPE_DES_CBC_CRC = 1;
    public static final int ETYPE_DES_CBC_MD4 = 2;
    public static final int ETYPE_DES_CBC_MD5 = 3;
    public static final int ETYPE_DES3_CBC_SHA1 = 16;
    public static final int KERB_ETYPE_AES_HMAC_SHA1_128 = 17;
    public static final int KERB_ETYPE_AES_HMAC_SHA1_256 = 18;
    public static final int KERB_ETYPE_RC4_HMAC = 23;
    public static final int KERB_ETYPE_RC4_HMAC_EXP = 24;

    private EncryptedData() {
    }

    public Object clone() {
        EncryptedData encryptedData = new EncryptedData();
        encryptedData.a = this.a;
        if (this.b != null) {
            encryptedData.b = new Integer(this.b);
        }
        if (this.c != null) {
            encryptedData.c = new byte[this.c.length];
            System.arraycopy(this.c, 0, encryptedData.c, 0, this.c.length);
        }
        return encryptedData;
    }

    public EncryptedData(int n2, Integer n3, byte[] byArray) {
        this.a = n2;
        this.b = n3;
        this.c = byArray;
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray) throws KdcErrException, KrbCryptoException {
        m m2 = m.a(encryptionKey.getEType());
        this.c = m2.encrypt(byArray, encryptionKey.getBytes());
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, int n2) throws KdcErrException, KrbCryptoException {
        m m2 = m.a(encryptionKey.getEType());
        this.c = m2.encrypt(byArray, encryptionKey.getBytes(), n2);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, byte[] byArray2, int n2) throws KdcErrException, KrbCryptoException {
        m m2 = m.a(encryptionKey.getEType());
        this.c = m2.encrypt(byArray, encryptionKey.getBytes(), byArray2, n2);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public EncryptedData(EncryptionKey encryptionKey, byte[] byArray, byte[] byArray2) throws KdcErrException, KrbCryptoException {
        m m2 = m.a(encryptionKey.getEType());
        this.c = m2.encrypt(byArray2, encryptionKey.getBytes(), byArray);
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    EncryptedData(String string, byte[] byArray) throws KdcErrException, KrbCryptoException {
        EncryptionKey encryptionKey = new EncryptionKey(string);
        m m2 = m.a(encryptionKey.getEType());
        this.c = m2.encrypt(byArray, encryptionKey.getBytes());
        this.a = encryptionKey.getEType();
        this.b = encryptionKey.getKeyVersionNumber();
    }

    public byte[] decrypt(EncryptionKey encryptionKey) throws KdcErrException, KrbApErrException, KrbCryptoException {
        m m2 = m.a(this.a);
        m2.decrypt(this.c, encryptionKey.getBytes());
        this.d = this.c;
        this.c = null;
        return m2.decryptedData(this.d);
    }

    public byte[] decrypt(EncryptionKey encryptionKey, int n2) throws KdcErrException, KrbApErrException, KrbCryptoException {
        m m2 = m.a(this.a);
        m2.decrypt(this.c, encryptionKey.getBytes(), n2);
        this.d = this.c;
        this.c = null;
        return m2.decryptedData(this.d);
    }

    public byte[] decrypt(EncryptionKey encryptionKey, byte[] byArray) throws KdcErrException, KrbApErrException, KrbCryptoException {
        m m2 = m.a(this.a);
        m2.decrypt(this.c, encryptionKey.getBytes(), byArray);
        this.d = this.c;
        this.c = null;
        return m2.decryptedData(this.d);
    }

    byte[] a(String string) throws KdcErrException, KrbApErrException, KrbCryptoException {
        EncryptionKey encryptionKey = new EncryptionKey(string);
        m m2 = m.a(this.a);
        m2.decrypt(this.c, encryptionKey.getBytes());
        this.d = this.c;
        this.c = null;
        return m2.decryptedData(this.d);
    }

    public byte[] decryptedData() throws KdcErrException {
        if (this.d != null) {
            m m2 = m.a(this.a);
            return m2.decryptedData(this.d);
        }
        return null;
    }

    public EncryptedData(DerValue derValue) throws Asn1Exception, IOException {
        DerValue derValue2 = null;
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        if ((derValue.getData().peekByte() & 0x1F) == 1) {
            derValue2 = derValue.getData().getDerValue();
            int n2 = derValue2.getData().getBigInteger().intValue();
            this.b = new Integer(n2);
        } else {
            this.b = null;
        }
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 2) {
            throw new Asn1Exception(906);
        }
        this.c = derValue2.getData().getOctetString();
        if (derValue.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(BigInteger.valueOf(this.a));
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        if (this.b != null) {
            derOutputStream2.putInteger(BigInteger.valueOf(this.b.intValue()));
            derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
            derOutputStream2 = new DerOutputStream();
        }
        derOutputStream2.putOctetString(this.c);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static EncryptedData parse(DerInputStream derInputStream, byte by, boolean bl2) throws Asn1Exception, IOException {
        if (bl2 && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptedData(derValue2);
    }

    public byte[] reset(byte[] byArray, boolean bl2) {
        if (this.isRc4HMacEncType()) {
            return byArray;
        }
        byte[] byArray2 = null;
        if (bl2) {
            if ((byArray[1] & 0xFF) < 128) {
                byArray2 = new byte[byArray[1] + 2];
                System.arraycopy(byArray, 0, byArray2, 0, byArray[1] + 2);
            } else if ((byArray[1] & 0xFF) > 128) {
                int n2 = byArray[1] & 0x7F;
                int n3 = 0;
                for (int i2 = 0; i2 < n2; ++i2) {
                    n3 |= (byArray[i2 + 2] & 0xFF) << 8 * (n2 - i2 - 1);
                }
                byArray2 = new byte[n3 + n2 + 2];
                System.arraycopy(byArray, 0, byArray2, 0, n3 + n2 + 2);
            }
        } else {
            byArray2 = new byte[byArray.length - byArray[byArray.length - 1]];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length - byArray[byArray.length - 1]);
        }
        return byArray2;
    }

    public int getEType() {
        return this.a;
    }

    public Integer getKeyVersionNumber() {
        return this.b;
    }

    public byte[] getBytes() {
        return this.c;
    }

    public static int stringToEncType(String string) throws Exception {
        if (string == null) {
            I18NException.throwException(EncryptedData.b("%FJ5[\u0005Pr n\u000e`R+w\u0005T"));
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u000fVUj3\bQEtm\u0003R\u0017")) || string.equalsIgnoreCase(EncryptedData.b("\u000fVUj3\u0003^G:3\u0018[Gh")) || string.equalsIgnoreCase(EncryptedData.b("\u000fVUj3\bQEtm\u0003R\u0017tu\u000f")) || string.equalsIgnoreCase(EncryptedData.b("\u000fVUj3\bQEtv\u0006REtm\u0003R\u0017tu\u000f"))) {
            return 16;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u000fVUt}\tP\u000b:l\b"))) {
            return 1;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u000fVUt}\tP\u000b4z^"))) {
            return 3;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u0019P\u0012tv\u0006RE"))) {
            return 23;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u0019P\u0012tv\u0006REt{\u0013C"))) {
            return 24;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\nAE?q\u001eA\u000b1s\nP"))) {
            return 23;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\nAE?q\u001eA\u000b1s\nP\u000b<f\u001b"))) {
            return 24;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\nVUh,S\u001eE-mF[K8}F@N8/F\n\u0010"))) {
            return 17;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\nVUk+]\u001eE-mF[K8}F@N8/F\n\u0010"))) {
            return 18;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u000fVUt}\tP\u000b4z_"))) {
            return 2;
        }
        if (string.equalsIgnoreCase(EncryptedData.b("\u0005FJ5"))) {
            return 0;
        }
        I18NException.throwException(EncryptedData.b(")RB\u001cp\bg_){8GT0p\f"), new String[]{string});
        return -999;
    }

    public boolean isSupportedEncType() {
        return EncryptedData.isSupportedEncType(this.a);
    }

    public static boolean isSupportedEncType(int n2) {
        return n2 == 16 || n2 == 1 || n2 == 3 || n2 == 23 || n2 == 24 || n2 == 17 || n2 == 18 || n2 == 0;
    }

    public String encTypeToString() {
        return EncryptedData.encTypeToString(this.a);
    }

    public static String encTypeToString(int n2) {
        switch (n2) {
            case 16: {
                return EncryptedData.b("\u000fVUj3\bQEtm\u0003R\u0017");
            }
            case 1: {
                return EncryptedData.b("\u000fVUt}\tP\u000b:l\b");
            }
            case 3: {
                return EncryptedData.b("\u000fVUt}\tP\u000b4z^");
            }
            case 23: {
                return EncryptedData.b("\u0019P\u0012tv\u0006RE");
            }
            case 24: {
                return EncryptedData.b("\u0019P\u0012tv\u0006REt{\u0013C");
            }
            case 17: {
                return EncryptedData.b("\nVUh,S\u001eE-mF[K8}F@N8/F\n\u0010y");
            }
            case 18: {
                return EncryptedData.b("\nVUk+]\u001eE-mF[K8}F@N8/F\n\u0010");
            }
            case 2: {
                return EncryptedData.b("\u000fVUt}\tP\u000b4z_");
            }
            case 0: {
                return EncryptedData.b("\u0005FJ5");
            }
        }
        I18NException.throwIllegalArgumentException(EncryptedData.b(")RB\u001cp\bg_){"), new Integer[]{new Integer(n2)});
        return null;
    }

    public boolean isDesEncType() {
        return this.a == 16 || this.a == 3 || this.a == 1;
    }

    public static boolean isDesEncType(int n2) {
        return n2 == 16 || n2 == 3 || n2 == 1;
    }

    public boolean isRc4HMacEncType() {
        return this.a == 23 || this.a == 24;
    }

    public static boolean isRc4HMacEncType(int n2) {
        return n2 == 23 || n2 == 24;
    }

    public boolean isAESEncType() {
        return this.a == 17 || this.a == 18;
    }

    public static boolean issAESEncType(int n2) {
        return n2 == 17 || n2 == 18;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String b(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl2 = true;
        block6: do {
            if (bl2 && !(bl2 = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 107;
                        break;
                    }
                    case 1: {
                        n5 = 51;
                        break;
                    }
                    case 2: {
                        n5 = 38;
                        break;
                    }
                    case 3: {
                        n5 = 89;
                        break;
                    }
                    default: {
                        n5 = 30;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

