/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.odc;

public abstract class ODCPropertyType {
    public static final ODCPropertyType STRING = new ODCPropertyType(String.class, "String"){

        public String toString(Object object) {
            return (String)object;
        }

        public Object fromString(String string) {
            return string;
        }
    };
    public static final ODCPropertyType INTEGER = new ODCPropertyType(Integer.class, "Integer"){

        public String toString(Object object) {
            return object.toString();
        }

        public Object fromString(String string) {
            return Integer.valueOf(string);
        }
    };
    public static final ODCPropertyType LONG = new ODCPropertyType(Long.class, "Long"){

        public String toString(Object object) {
            return object.toString();
        }

        public Object fromString(String string) {
            return Long.valueOf(string);
        }
    };
    public static final ODCPropertyType FLOAT = new ODCPropertyType(Float.class, "Float"){

        public String toString(Object object) {
            return object.toString();
        }

        public Object fromString(String string) {
            return Float.valueOf(string);
        }
    };
    public static final ODCPropertyType BOOLEAN = new ODCPropertyType(Boolean.class, "Boolean"){

        public String toString(Object object) {
            return object.toString();
        }

        public Object fromString(String string) {
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("'" + string + "' is neither 'true' nor 'false'");
        }
    };
    private final Class clazz;
    private final String name;

    protected ODCPropertyType(Class clazz) {
        this(clazz, clazz.getName());
    }

    protected ODCPropertyType(Class clazz, String string) {
        this.clazz = clazz;
        this.name = string;
    }

    public abstract String toString(Object var1);

    public abstract Object fromString(String var1);

    public Class getClazz() {
        return this.clazz;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

