/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.ws390.proxy.servant;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.runtime.ServerName;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerProxy;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ServantInitializationListener;
import com.ibm.ws.util.ServantInitializedException;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;

public class ServantProxyHelper
implements ServantInitializationListener {
    private static PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
    public static ServantProxyHelper instance = null;
    private static final TraceComponent tc = TrUtil.register(ServantProxyHelper.class);
    private ArrayList odcTreeList = new ArrayList();
    private ODCControllerProxy proxy = null;
    private String servantToken = ServerName.getPrintableStoken();
    private byte[] stoken = ServerName.getStoken();
    private boolean thisServantElected = false;
    private boolean helperStopped = false;

    public static synchronized ServantProxyHelper getInstance() {
        if (instance == null) {
            instance = new ServantProxyHelper();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ODC Servant Proxy Helper initialized.");
            }
        }
        return instance;
    }

    private void initODCControllerProxy() {
        try {
            ORB oRB = platformHelper.getGlobalORB();
            this.proxy = (ODCControllerProxy)oRB.resolve_initial_references("ODCControllerProxy");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Obtained ODCControllerProxy reference");
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Could not initialize Controller ODC Proxy.");
            }
            TrUtil.warning(throwable, this, "initODCControllerProxy", tc);
        }
    }

    private void registerListener() {
        try {
            platformHelper.registerListener((ServantInitializationListener)this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registered as servant initialization listener.");
            }
        }
        catch (ServantInitializedException servantInitializedException) {
            TrUtil.warning(servantInitializedException, this, "registerListener", tc);
        }
    }

    private ServantProxyHelper() {
        this.registerListener();
        this.initODCControllerProxy();
    }

    public void handleProxiedEvents(ODCTree oDCTree, ODCEvent[] oDCEventArray) {
        String string = "handleProxiedEvents() ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        if (oDCEventArray == null || oDCEventArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No events in the array. Tree: " + oDCTree.getName()));
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting servantToken in the Event.");
        }
        for (int i = 0; i < oDCEventArray.length; ++i) {
            ODCEventImpl oDCEventImpl = (ODCEventImpl)oDCEventArray[i];
            oDCEventImpl.setAttachment(this.servantToken);
        }
        ODCTreeImpl oDCTreeImpl = (ODCTreeImpl)oDCTree;
        try {
            oDCTreeImpl.performEvents(this.getClass().getName(), oDCEventArray);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Applied Proxied Controller Events on Servant ODC Tree");
            }
        }
        catch (Throwable throwable) {
            TrUtil.error(throwable, this, string, tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
    }

    public void manageTree(ODCTree oDCTree) {
        this.odcTreeList.add(oDCTree);
    }

    public void stopHelper() {
        this.helperStopped = true;
    }

    public void handleLocalEvents(ODCTree oDCTree, ODCEvent[] oDCEventArray) {
        String string = "handleLocalEvents() ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string);
        }
        try {
            if (oDCEventArray == null || oDCEventArray.length == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No events in the array. Tree: " + oDCTree.getName()));
                }
                return;
            }
            if (this.helperStopped) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Helper Stop issued.");
                }
                return;
            }
            if (this.thisServantElected) {
                ODCEventImpl oDCEventImpl = (ODCEventImpl)oDCEventArray[0];
                if (oDCEventImpl.getAttachment() == null) {
                    this.proxy.handleProxiedEvents(oDCTree.getName(), oDCEventArray, this.servantToken);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ODCEvents proxied to Controller");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"ODCEvents proxied by Controller. Ignore.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"This is not the elected Servant, ignore events.");
            }
        }
        catch (Exception exception) {
            TrUtil.warning(exception, this, string, tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
    }

    public void servantInitialized(String string) {
        String string2 = "servantInitialized() ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string2, (Object)string);
        }
        try {
            if (this.proxy != null) {
                this.proxy.servantInitialized(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Servant initialized: " + string));
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Controller ODC Proxy could not be called.");
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, string2, tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string2);
        }
    }

    public String electThisServant() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("This Servant elected to proxy ODCEvents: " + this.servantToken));
        }
        this.thisServantElected = true;
        for (int i = 0; i < this.odcTreeList.size(); ++i) {
            ODCTreeImpl oDCTreeImpl = (ODCTreeImpl)this.odcTreeList.get(i);
            ODCEvent[] oDCEventArray = oDCTreeImpl.getEvents(false);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("synching tree: " + oDCTreeImpl.getName()));
            }
            this.handleLocalEvents(oDCTreeImpl, oDCEventArray);
        }
        return this.servantToken;
    }
}

