/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.ws390.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerEventListener;
import com.ibm.ws.odc.ws390.proxy.controller.ODCControllerProxyHelper;
import com.ibm.ws.odc.ws390.proxy.servant.ODCServantEventListener;
import com.ibm.ws.odc.ws390.proxy.servant.ServantProxyHelper;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCTree;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ODCProxyManager
extends ComponentImpl {
    private static final TraceComponent tc = TrUtil.register(ODCProxyManager.class);
    private static PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
    private static ODCProxyManager instance = null;
    private static List treesToRun = new LinkedList();
    private List runningTrees = new ArrayList();

    public static synchronized ODCProxyManager getInstance() throws ODCException {
        if (instance == null) {
            throw new ODCException(ODCProxyManager.class.getName() + " service is not started");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void manageTree(ODCTree oDCTree) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"manageTree", (Object)oDCTree);
        }
        if (platformHelper.isZOS()) {
            List list = treesToRun;
            synchronized (list) {
                if (instance == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ODCProxyManager not started yet");
                    }
                    treesToRun.add(oDCTree);
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"ODCProxyManager has been started already");
                    }
                    instance.createProxy(oDCTree);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No need to proxy ODC Trees on Disributed WAS");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"manageTree", (Object)oDCTree);
        }
    }

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (platformHelper.isZOS()) {
            AdminService adminService = AdminServiceFactory.getAdminService();
            if (adminService.getProcessType().equals("UnManagedProcess")) {
                throw new ComponentDisabledException("ODC Proxy Manager disabled on standalone");
            }
        } else {
            throw new ComponentDisabledException("ODC Proxy Manager disabled on Distributed WAS");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        instance = this;
        List list = treesToRun;
        synchronized (list) {
            while (treesToRun.size() > 0) {
                ODCTree oDCTree = (ODCTree)treesToRun.remove(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("starting tree " + oDCTree));
                }
                try {
                    this.createProxy(oDCTree);
                }
                catch (ODCException oDCException) {
                    throw new RuntimeWarning((Throwable)((Object)oDCException));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        if (platformHelper.isZOS()) {
            if (platformHelper.isControlJvm()) {
                ODCControllerProxyHelper.getInstance().stopHelper();
            } else if (platformHelper.isServantJvm() || platformHelper.isCRAJvm()) {
                ServantProxyHelper.getInstance().stopHelper();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    private void createProxy(ODCTree oDCTree) throws ODCException {
        String string = "createProxy() ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)string, (Object)oDCTree.getName());
        }
        if (platformHelper.isZOS()) {
            if (platformHelper.isControlJvm()) {
                ODCControllerProxyHelper oDCControllerProxyHelper = ODCControllerProxyHelper.getInstance();
                oDCControllerProxyHelper.manageTree(oDCTree);
                ODCControllerEventListener oDCControllerEventListener = new ODCControllerEventListener(oDCTree);
                oDCTree.addListener(oDCControllerEventListener);
            } else if (platformHelper.isServantJvm() || platformHelper.isCRAJvm()) {
                ServantProxyHelper servantProxyHelper = ServantProxyHelper.getInstance();
                servantProxyHelper.manageTree(oDCTree);
                ODCServantEventListener oDCServantEventListener = new ODCServantEventListener(oDCTree);
                oDCTree.addListener(oDCServantEventListener);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown z/OS JVM Type.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)string);
        }
    }
}

