/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCHelper;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCTree;

public class ApplicationQuiescer
implements ODCListener {
    public static final String QUIESCING_STATE = "QUIESCING";
    public static final String QUIESCED_STATE = "QUIESCED";
    private static TraceComponent tc = TrUtil.register(ApplicationQuiescer.class);
    private final ODCHelper odc;
    private final ODCNode serverApp;
    private final ODCEdgeType proxyContainer2ServerApp;
    private final ODCEventType[] interestEvents;

    public static void quiesceMyApplication(String string) throws Exception {
        ODCNode oDCNode = TargetTree.getMyServer();
        if (oDCNode == null) {
            throw new RuntimeException("myServer is null");
        }
        ApplicationQuiescer.quiesceApplication(oDCNode, string);
    }

    public static void quiesceApplication(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"quiesceApplication", (Object)new Object[]{oDCNode, string});
        }
        ApplicationQuiescer applicationQuiescer = new ApplicationQuiescer(oDCNode, string);
        applicationQuiescer.quiesceApplication();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"quiesceApplication", (Object)new Object[]{oDCNode, string});
        }
    }

    public static boolean isQuiesceState(String string) {
        return string.equals(QUIESCING_STATE) || string.equals(QUIESCED_STATE);
    }

    private ApplicationQuiescer(String string) throws Exception {
        this(TargetTree.getMyServer(), string);
    }

    private ApplicationQuiescer(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor", (Object)new Object[]{oDCNode, string});
        }
        this.odc = ODCHelper.getInstance();
        this.proxyContainer2ServerApp = this.odc.mgr.findEdgeType(this.odc.proxyContainer, this.odc.serverApplication);
        this.interestEvents = new ODCEventType[]{this.proxyContainer2ServerApp};
        this.serverApp = oDCNode.getNode(this.odc.serverApplication, string);
        if (this.serverApp == null) {
            throw new Exception("'" + string + "' is not running on server " + oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor", (Object)string);
        }
    }

    private void quiesceApplication() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"quiesce", (Object)this);
        }
        this.serverApp.setProperty(this.odc.serverApplicationState, QUIESCING_STATE);
        this.waitForQuiesceCompletion();
        this.serverApp.setProperty(this.odc.serverApplicationState, QUIESCED_STATE);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"quiesce", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void waitForQuiesceCompletion() throws ODCException {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForQuiesceCompletion", (Object)this);
            }
            if (!this.isQuiesced()) {
                ODCTree oDCTree = this.serverApp.getTree();
                oDCTree.addListener(this);
                try {
                    block11: {
                        try {
                            if (this.isQuiesced()) break block11;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("waiting for quiesce for complete for " + this));
                            }
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Object var4_3 = null;
                            oDCTree.removeListener(this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("done waiting for quiesce completion of " + this));
                            }
                            break block12;
                        }
                    }
                    Object var4_2 = null;
                    oDCTree.removeListener(this);
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    oDCTree.removeListener(this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("done waiting for quiesce completion of " + this));
                    }
                    throw throwable;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("done waiting for quiesce completion of " + this));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"waitForQuiesceCompletion", (Object)this);
        }
    }

    public ODCEventType[] interestEventTypes() {
        return this.interestEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(ODCEvent oDCEvent) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleEvent " + oDCEvent));
        }
        if (this.isQuiesced()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"notifying that quiesce is complete");
            }
            ApplicationQuiescer applicationQuiescer = this;
            synchronized (applicationQuiescer) {
                this.notify();
            }
        }
    }

    private boolean isQuiesced() throws ODCException {
        int n = this.serverApp.nodeCount(this.odc.proxyContainer);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(n + " ODR(s) are routing to " + this));
        }
        return n == 0;
    }

    public String toString() {
        return this.serverApp.toString();
    }
}

