/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc.cell;

import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.application.EjbModule;
import com.ibm.etools.application.Module;
import com.ibm.etools.application.WebModule;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.j2ee.commonarchivecore.ModuleFile;
import com.ibm.etools.j2ee.commonarchivecore.helpers.ArchiveOptions;
import com.ibm.etools.j2ee.commonarchivecore.strategy.LoadStrategy;
import com.ibm.etools.webapplication.ServletMapping;
import com.ibm.etools.webservice.wsdd.WebServiceDescription;
import com.ibm.etools.webservice.wsdd.WebServices;
import com.ibm.websphere.channel.framework.ChainData;
import com.ibm.websphere.management.application.AppNotification;
import com.ibm.websphere.management.application.EditionHelper;
import com.ibm.websphere.management.application.EditionInfo;
import com.ibm.websphere.management.repository.ConfigChangeNotifier;
import com.ibm.websphere.management.repository.ConfigRepositoryEvent;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.models.config.appdeployment.DeploymentTarget;
import com.ibm.websphere.models.config.appdeployment.DeploymentTargetMapping;
import com.ibm.websphere.models.config.appdeployment.ModuleDeployment;
import com.ibm.websphere.models.config.appdeployment.ServerTarget;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.applicationserver.webcontainer.WebContainer;
import com.ibm.websphere.models.config.host.HostAlias;
import com.ibm.websphere.models.config.host.VirtualHost;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.ipc.Transport;
import com.ibm.websphere.models.config.processexec.JavaProcessDef;
import com.ibm.websphere.models.config.processexec.JavaVirtualMachine;
import com.ibm.websphere.models.config.processexec.ProcessDef;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.proxy.DeployedObjectProxyConfig;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.models.config.topology.cell.Cell;
import com.ibm.websphere.models.config.topology.cluster.ClusterMember;
import com.ibm.websphere.models.config.topology.cluster.ServerCluster;
import com.ibm.websphere.models.config.topology.node.Node;
import com.ibm.websphere.plugincfg.generator.VariableManager;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.service.Admin;
import com.ibm.ws.management.service.ConfigChangeListener;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.cell.TargetTree;
import com.ibm.ws.odc.cell.TreeBuilderHelper;
import com.ibm.ws.odc.util.ApplicationQuiescer;
import com.ibm.ws.odc.util.ServerServiceFinder;
import com.ibm.ws.odc.util.ServiceHandle;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.ws.runtime.component.WebContainerImpl;
import com.ibm.ws.runtime.deploy.DeployedApplication;
import com.ibm.ws.runtime.deploy.DeployedModule;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.deploy.DeployedObjectEvent;
import com.ibm.ws.runtime.deploy.DeployedObjectListener;
import com.ibm.ws.runtime.service.ApplicationMgr;
import com.ibm.ws.runtime.service.ConfigRoot;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.runtime.service.Server;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.ThreadPool;
import com.ibm.ws.webcontainer.util.EncodeCloneID;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.ChainEventListener;
import com.ibm.wsspi.channel.framework.ChannelFrameworkService;
import com.ibm.wsspi.channel.framework.exception.ChainGroupException;
import com.ibm.wsspi.channel.framework.exception.ChainNotInboundException;
import com.ibm.wsspi.channel.framework.exception.NoCFEndPointException;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;

public class TreeBuilder
extends TreeBuilderHelper
implements DeployedObjectListener,
NotificationListener,
AppNotification.Listener,
PropertyChangeListener,
ConfigChangeListener,
ChainEventListener {
    public static final String SPEED_FACTOR_OVERRIDE_SPEC = "SpeedFactorOverrideSpec";
    private static final TraceComponent tc = TrUtil.register(TreeBuilder.class);
    protected static final String SEP = File.separator;
    protected static final Integer DOWN_WEIGHT = new Integer(0);
    protected static final Integer DEFAULT_UP_WEIGHT = new Integer(1);
    protected static final Integer ANY_PORT = new Integer(-1);
    protected static final Object initPassBack = new String("init");
    protected static final Object discoveryPassBack = new String("discoveryEvent");
    protected static final Object appStartStopPassBack = new String("appStartStopPassBack");
    protected static final boolean isZos;
    protected static final boolean isZosServantOrCRA;
    protected static final PlatformHelper platformHelper;
    protected final Set vhostExcludes = new HashSet();
    protected final Set chainExcludes = new HashSet();
    protected final Set upNodes = new HashSet();
    protected final HashMap serverUpWeights = new HashMap();
    protected final VariableManager varMgr = new VariableManager();
    protected final HashMap appsRead = new HashMap();
    protected final String[] jmxProcessEvents = new String[]{"websphere.process.failed", "websphere.process.starting", "websphere.process.running", "websphere.process.stopping", "websphere.process.stopped"};
    protected final NotificationFilterSupport jmxProcessFilter = this.getFilter(this.jmxProcessEvents);
    protected ODCNode odcMyCell = null;
    protected ODCNode odcMyNode = null;
    protected ODCNode odcMyServer = null;
    protected ODCNode odcMyProxyContainer = null;
    protected final String nodesDir;
    protected String myServerState = "STARTING";
    protected Integer lastNonZeroServerWeight = DEFAULT_UP_WEIGHT;
    protected ODCTreeImpl targetTree;
    protected boolean listenersAdded = false;
    protected ObjectName appManagementName = null;
    protected boolean initialized = false;
    protected Object sslDirect;
    protected Object sslOffLoad;
    protected Object sslOnLoad;
    public static final String APP_CHANGES = "app_changes";
    public static final String SERVICEPOLICY_UPDATE_REQD = "servicepolicy_update_reqd";
    public static final String NODEGROUP_UPDATE_REQD = "nodegroup_update_reqd";

    public TreeBuilder() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"constructor");
        }
        this.targetTree = (ODCTreeImpl)this.odc.mgr.getTree("target", this.odc.cellGroup);
        TargetTree.setTree(this.targetTree);
        if (this.inDMgr) {
            this.odc.mgr.getTree("proxy", this.odc.cellGroup);
        }
        Class<?> clazz = Class.forName("com.ibm.wsspi.dwlm.client.ProtocolMap");
        this.sslDirect = clazz.getField("DIRECT").get(clazz);
        this.sslOffLoad = clazz.getField("SSL_OFFLOAD").get(clazz);
        this.sslOnLoad = clazz.getField("SSL_ONLOAD").get(clazz);
        this.nodesDir = "cells/" + this.myCellName + "/nodes/";
        this.initSet(System.getProperty("com.ibm.ws.odc.vhostExcludes", "admin_host"), this.vhostExcludes);
        this.initSet(System.getProperty("com.ibm.ws.odc.chainExcludes", "WCInboundAdmin,WCInboundAdminSecure"), this.chainExcludes);
        if (this.inDMgr) {
            this.vhostExcludes.clear();
            this.chainExcludes.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public void start() throws Exception {
        Server server;
        ServiceHandle serviceHandle;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"start");
            }
            if (!isZosServantOrCRA) {
                serviceHandle = ServiceHandle.obtain(Server.class);
                if (serviceHandle != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"add property change listener");
                    }
                    server = (Server)serviceHandle.getService();
                    server.addPropertyChangeListener("state", (PropertyChangeListener)this);
                    serviceHandle.release();
                }
                if ((serviceHandle = ServiceHandle.obtain(Admin.class)) != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"add config change listener");
                    }
                    server = (Admin)serviceHandle.getService();
                    server.addConfigChangeListener((ConfigChangeListener)this);
                    serviceHandle.release();
                }
            }
            if (!(this.inNodeAgent || isZos && !isZosServantOrCRA)) {
                try {
                    serviceHandle = ServiceHandle.obtain(ChannelFrameworkService.class);
                    if (serviceHandle != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"add chain event listener");
                        }
                        server = (ChannelFrameworkService)serviceHandle.getService();
                        server.addGroupEventListener((ChainEventListener)this, WebContainerImpl.class.getName());
                        serviceHandle.release();
                    }
                }
                catch (ChainGroupException chainGroupException) {
                    if (!tc.isDebugEnabled()) break block16;
                    Tr.debug((TraceComponent)tc, (String)"WebContainer chain not configured.");
                }
            }
        }
        if (this.inNodeAgent || platformHelper.isZOS() && platformHelper.isControlJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Not registering with ApplicationMgr");
            }
        } else {
            serviceHandle = ServiceHandle.obtain(ApplicationMgr.class);
            if (serviceHandle == null) {
                throw new RuntimeWarning("unable to find ApplicationMgr service");
            }
            server = (ApplicationMgr)serviceHandle.getService();
            server.addDeployedObjectListener((DeployedObjectListener)this);
            serviceHandle.release();
        }
        this.init();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stop");
            }
            try {
                Server server;
                ServiceHandle serviceHandle;
                block16: {
                    if (!isZosServantOrCRA) {
                        serviceHandle = ServiceHandle.obtain(Server.class);
                        if (serviceHandle != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"remove property change listener");
                            }
                            server = (Server)serviceHandle.getService();
                            server.removePropertyChangeListener("state", (PropertyChangeListener)this);
                            serviceHandle.release();
                        }
                        if ((serviceHandle = ServiceHandle.obtain(Admin.class)) != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"remove config change listener");
                            }
                            server = (Admin)serviceHandle.getService();
                            server.removeConfigChangeListener((ConfigChangeListener)this);
                            serviceHandle.release();
                        }
                    }
                    if (!(this.inNodeAgent || isZos && !isZosServantOrCRA)) {
                        try {
                            serviceHandle = ServiceHandle.obtain(ChannelFrameworkService.class);
                            if (serviceHandle != null) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"remove chain event listener");
                                }
                                server = (ChannelFrameworkService)serviceHandle.getService();
                                server.removeGroupEventListener((ChainEventListener)this, WebContainerImpl.class.getName());
                                serviceHandle.release();
                            }
                        }
                        catch (ChainGroupException chainGroupException) {
                            if (!tc.isDebugEnabled()) break block16;
                            Tr.debug((TraceComponent)tc, (String)"WebContainer chain not configured.");
                        }
                    }
                }
                if (!(this.inNodeAgent || platformHelper.isZOS() && platformHelper.isControlJvm())) {
                    serviceHandle = ServiceHandle.obtain(ApplicationMgr.class);
                    if (serviceHandle == null) {
                        throw new RuntimeWarning("unable to find ApplicationMgr service");
                    }
                    server = (ApplicationMgr)serviceHandle.getService();
                    server.removeDeployedObjectListener((DeployedObjectListener)this);
                    serviceHandle.release();
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block17;
                Tr.debug((TraceComponent)tc, (String)("problem during stop: " + throwable + ": " + throwable.getMessage()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init");
        }
        if (this.initialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"init", (Object)"already initialized");
            }
            return;
        }
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.init");
            try {
                this.buildTargetTree();
                this.targetTree.commitTransaction();
                this.initialized = true;
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "init", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(DeployedObjectEvent deployedObjectEvent) throws RuntimeError, RuntimeWarning {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stateChanged", (Object)deployedObjectEvent);
        }
        if (!(string = deployedObjectEvent.getPropertyName()).equals("state")) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stateChanged", (Object)("ignoring property " + string));
            }
            return;
        }
        DeployedApplication deployedApplication = null;
        DeployedModule deployedModule = null;
        DeployedObject deployedObject = deployedObjectEvent.getDeployedObject();
        ModuleFile moduleFile = deployedObject.getModuleFile();
        if (moduleFile.isEARFile()) {
            deployedApplication = (DeployedApplication)deployedObject;
        } else if (moduleFile.isWARFile()) {
            deployedModule = (DeployedModule)deployedObject;
            deployedApplication = deployedModule.getDeployedApplication();
        } else if (moduleFile.isEJBJarFile()) {
            deployedModule = (DeployedModule)deployedObject;
            deployedApplication = deployedModule.getDeployedApplication();
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"stateChanged", (Object)"TreeBuilder: not EAR, WAR or EJBJar file");
            }
            return;
        }
        String string2 = deployedApplication.getName();
        if (EditionHelper.isEditionSupportEnabled()) {
            try {
                string2 = this.getAppNameOfActiveEdition(this.odcMyNode.getName(), this.odcMyServer.getName(), string2);
            }
            catch (Exception exception) {
                throw new RuntimeError("Could not determine active application edition");
            }
        }
        String string3 = deployedModule != null ? deployedModule.getName() : "null";
        Object object = deployedObjectEvent.getNewValue();
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.stateChanged");
            try {
                if (deployedModule == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("app " + string2 + " state changed to " + object));
                    }
                    if (object.equals("STARTING")) {
                        this.obtainAppNode(string2);
                    }
                    ODCNode oDCNode = this.targetTree.createNode(string2, this.odc.serverApplication, this.odcMyServer);
                    oDCNode.setProperty(this.odc.serverApplicationState, object);
                } else if (moduleFile.isWARFile()) {
                    if (object.equals("STARTED")) {
                        ODCNode oDCNode;
                        ODCNode oDCNode2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("webmodule started: app=" + string2 + ", webmodule=" + string3));
                        }
                        if ((oDCNode2 = this.odcMyCell.getNode(this.odc.application, string2)) != null && (oDCNode = oDCNode2.getNode(this.odc.webModule, string3)) != null) {
                            oDCNode.addNode(this.odcMyServer);
                        }
                    } else if (object.equals("STOPPING")) {
                        ODCNode oDCNode;
                        ODCNode oDCNode3;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("webmodule stopping: app=" + string2 + ", webmodule=" + string3));
                        }
                        if ((oDCNode3 = this.odcMyCell.getNode(this.odc.application, string2)) != null && (oDCNode = oDCNode3.getNode(this.odc.webModule, string3)) != null) {
                            oDCNode.removeNode(this.odcMyServer);
                        }
                    }
                } else if (moduleFile.isEJBJarFile() && deployedModule != null) {
                    if (object.equals("STARTED")) {
                        ODCNode oDCNode;
                        ODCNode oDCNode4;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ejbmodule starting: app=" + string2 + ", ejbjar=" + string3));
                        }
                        if ((oDCNode4 = this.odcMyCell.getNode(this.odc.application, string2)) != null && (oDCNode = oDCNode4.getNode(this.odc.ejbModule, string3)) != null) {
                            oDCNode.addNode(this.odcMyServer);
                        }
                    } else if (object.equals("STOPPING")) {
                        ODCNode oDCNode;
                        ODCNode oDCNode5;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("ejbmodule stopping: app=" + string2 + ", ejbjar=" + string3));
                        }
                        if ((oDCNode5 = this.odcMyCell.getNode(this.odc.application, string2)) != null && (oDCNode = oDCNode5.getNode(this.odc.ejbModule, string3)) != null) {
                            oDCNode.removeNode(this.odcMyServer);
                        }
                    }
                }
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "stateChanged", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stateChanged");
        }
    }

    protected void buildTargetTree() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"buildTargetTree");
        }
        this.readCell(this.targetTree.getRoot(), this.myCellName);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"buildTargetTree");
        }
    }

    protected ODCNode readCell(ODCNode oDCNode, String string) throws Exception {
        File file;
        Object object;
        int n;
        Object object2;
        String string2;
        File file2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readCell", (Object)new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.cell, oDCNode);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("myCell=" + this.myCellName + "; cell=" + string));
        }
        if (string.equals(this.myCellName)) {
            this.odcMyCell = oDCNode2;
            TargetTree.setMyCell(oDCNode2);
        }
        Repository repository = this.getRepository(oDCNode2.getName(), null, null);
        Cell cell = (Cell)repository.getConfigRoot().getResource(0, "cell.xml").getContents().get(0);
        this.initCell(cell, oDCNode2);
        oDCNode2.setBooleanProperty(this.odc.cellIsWebSphere, true);
        String string3 = this.getDir(oDCNode2.getName(), null, null);
        this.readVirtualHostGroups(oDCNode2);
        if (this.inDMgr) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"reading applications directory");
            }
            if ((file2 = new File(string2 = this.joinDir(string3, "applications"))).exists()) {
                object2 = file2.listFiles(this.directoryFilter);
                if (object2 == null) {
                    throw new IOException("unable to read applications directory: " + string2);
                }
                for (n = 0; n < ((File[])object2).length; ++n) {
                    Object object3;
                    object = object2[n].getName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("ear directory name = " + (String)object));
                    }
                    if (EditionHelper.isEditionSupportEnabled()) {
                        object3 = object2[n].listFiles();
                        if (object3 == null) {
                            throw new IOException("unable to read app edition directory: " + (String)object);
                        }
                        for (int i = 0; i < ((File[])object3).length; ++i) {
                            String string4 = ((File)object3[i]).getName();
                            String string5 = null;
                            if (!string4.endsWith(".ear")) continue;
                            string5 = string4.substring(0, string4.length() - 4);
                            ODCNode oDCNode3 = this.obtainAppNode(string5);
                            oDCNode3.setProperty(this.odc.appRoot, object);
                        }
                        continue;
                    }
                    if (object.endsWith(".ear")) {
                        object = object.substring(0, object.length() - 4);
                    }
                    object3 = this.obtainAppNode((String)object);
                    object3.setProperty(this.odc.appRoot, object);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reading clusters directory");
        }
        if ((file2 = new File(string2 = this.joinDir(string3, "clusters"))).exists()) {
            object2 = file2.listFiles(this.directoryFilter);
            if (object2 == null) {
                throw new IOException("unable to read clusters directory: " + string2);
            }
            for (n = 0; n < ((File[])object2).length; ++n) {
                try {
                    this.readCluster(oDCNode2, object2[n].getName());
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "readCluster", tc);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reading nodes directory");
        }
        if ((file = new File((String)(object2 = this.joinDir(string3, "nodes")))).exists()) {
            object = file.listFiles(this.directoryFilter);
            if (object == null) {
                throw new IOException("unable to read nodes directory: " + (String)object2);
            }
            for (int i = 0; i < ((File[])object).length; ++i) {
                try {
                    this.readNode(oDCNode2, object[i].getName());
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "readCell", tc);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readCell", (Object)oDCNode2);
        }
        return oDCNode2;
    }

    protected void initCell(Cell cell, ODCNode oDCNode) throws Exception {
        this.addCellCustomProperties(cell, oDCNode);
    }

    protected void addCellCustomProperties(Cell cell, ODCNode oDCNode) throws Exception {
        this.addCustomProperties(cell.getProperties(), oDCNode);
    }

    protected ODCNode readNode(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readNode", (Object)new Object[]{oDCNode, string});
        }
        if (!this.shouldReadNode(oDCNode.getName(), string)) {
            return null;
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.node, oDCNode);
        boolean bl = this.isMyNode(oDCNode.getName(), string);
        if (bl) {
            this.odcMyNode = oDCNode2;
            TargetTree.setMyNode(oDCNode2);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("found my node: " + this.odcMyNode));
            }
        }
        Repository repository = this.getRepository(oDCNode.getName(), string, null);
        this.varMgr.setVariableMap(repository.getConfigRoot(), 1);
        Node node = (Node)repository.getConfigRoot().getResource(3, "node.xml").getContents().get(0);
        this.initNode(node, oDCNode2);
        ServerIndex serverIndex = (ServerIndex)repository.getConfigRoot().getResource(3, "serverindex.xml").getContents().get(0);
        String string2 = serverIndex.getHostName();
        if (string2 == null) {
            string2 = oDCNode2.getName();
        }
        oDCNode2.setProperty(this.odc.nodeHostName, string2);
        String string3 = this.getDir(oDCNode.getName(), string, null);
        String string4 = this.joinDir(string3, "servers");
        File file = new File(string4);
        if (file.exists()) {
            File[] fileArray = file.listFiles(this.directoryFilter);
            if (fileArray == null) {
                throw new IOException("unable to read servers directory: " + string4);
            }
            for (int i = 0; i < fileArray.length; ++i) {
                try {
                    this.readServer(oDCNode, oDCNode2, fileArray[i].getName());
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "readNode", tc);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readNode", (Object)oDCNode2);
        }
        return oDCNode2;
    }

    protected void initNode(Repository repository, Node node, ODCNode oDCNode) throws Exception {
        Resource resource;
        block3: {
            resource = null;
            try {
                resource = repository.getConfigRoot().getResource(3, "resources.xml");
            }
            catch (Exception exception) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)exception.getLocalizedMessage());
            }
        }
        if (resource != null) {
            oDCNode.setBooleanProperty(this.odc.nodeIsWebSphere, true);
        }
        this.addNodeCustomProperties(node, oDCNode);
    }

    protected void initNode(Node node, ODCNode oDCNode) throws Exception {
        oDCNode.setBooleanProperty(this.odc.nodeIsWebSphere, true);
        this.addNodeCustomProperties(node, oDCNode);
    }

    protected void addNodeCustomProperties(Node node, ODCNode oDCNode) throws Exception {
        this.addCustomProperties(node.getProperties(), oDCNode);
    }

    protected ODCNode readServer(ODCNode oDCNode, ODCNode oDCNode2, String string) throws Exception {
        Transport transport;
        Object object;
        ODCNode oDCNode3;
        Object object2;
        Object object3;
        Object object4;
        com.ibm.websphere.models.config.process.Server server;
        Object object5;
        Object object6;
        Repository repository;
        ServerIndex serverIndex;
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readServer", (Object)new Object[]{oDCNode2, string});
        }
        if (!this.shouldReadServer(oDCNode.getName(), oDCNode2.getName(), string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readServer", (Object)"should not read");
            }
            return null;
        }
        ODCNode oDCNode4 = this.targetTree.createNode(string, this.odc.server, oDCNode2);
        boolean bl = this.isMyServer(oDCNode.getName(), oDCNode2.getName(), string);
        if (bl) {
            this.odcMyServer = oDCNode4;
            TargetTree.setMyServer(oDCNode4);
            oDCNode4.setProperty(this.odc.serverState, this.myServerState);
        }
        if ((string2 = (serverIndex = (ServerIndex)(repository = this.getRepository(oDCNode.getName(), oDCNode2.getName(), string)).getConfigRoot().getResource(3, "serverindex.xml").getContents().get(0)).getHostName()) == null) {
            string2 = oDCNode2.getName();
        }
        Object object7 = null;
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            object6 = (ServerEntry)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("server entry for " + object6.getServerName()));
            }
            if (!object6.getServerName().equals(string)) continue;
            object7 = object6;
            break;
        }
        if (object7 == null) {
            throw new ODCException("no server entry for " + string + " was found in serverindex.xml");
        }
        object6 = object7.getServerType();
        oDCNode4.setProperty(this.odc.serverType, object6);
        oDCNode4.setProperty(this.odc.serverIsODR, new Boolean(Util.isODR((String)object6)));
        boolean bl2 = Util.isProxy((String)object6);
        if (bl2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"is proxy");
            }
            object5 = this.targetTree.createNode("proxy", this.odc.proxyContainer, oDCNode4);
            if (bl) {
                this.odcMyProxyContainer = object5;
                TargetTree.setMyProxyContainer((ODCNode)object5);
            }
            iterator = object7.getSpecialEndpoints().iterator();
            while (iterator.hasNext()) {
                server = (NamedEndPoint)iterator.next();
                object4 = server.getEndPointName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("endpoint name = " + (String)object4));
                }
                if (((String)object4).equals("PROXY_HTTP_ADDRESS")) {
                    object3 = this.targetTree.createNode("http", this.odc.transport, oDCNode4);
                    object3.setProperty(this.odc.transportProtocol, "http");
                    object3.setProperty(this.odc.transportHost, string2);
                    object3.setProperty(this.odc.transportPort, new Integer(server.getEndPoint().getPort()));
                    object3.setProperty(this.odc.transportODR, Boolean.TRUE);
                    this.addDefaultChannelChain((ODCNode)object3, false);
                    continue;
                }
                if (!((String)object4).equals("PROXY_HTTPS_ADDRESS")) continue;
                object3 = this.targetTree.createNode("https", this.odc.transport, oDCNode4);
                object3.setProperty(this.odc.transportProtocol, "https");
                object3.setProperty(this.odc.transportHost, string2);
                object3.setProperty(this.odc.transportPort, new Integer(server.getEndPoint().getPort()));
                object3.setProperty(this.odc.transportODR, Boolean.TRUE);
                this.addDefaultChannelChain((ODCNode)object3, true);
            }
        }
        if ((object5 = repository.getConfigRoot().getResource(4, "server.xml").getContents()).size() <= 0) {
            throw new ODCException("no resources for: " + oDCNode.getName() + ":" + oDCNode2.getName() + ":" + string);
        }
        server = (com.ibm.websphere.models.config.process.Server)object5.get(0);
        object4 = this.getAppServer(server);
        object3 = server.getProcessDefinitions().iterator();
        ProcessDef processDef = null;
        JavaProcessDef javaProcessDef = null;
        while (object3.hasNext()) {
            processDef = (ProcessDef)object3.next();
            if (!(processDef instanceof JavaProcessDef)) continue;
            javaProcessDef = (JavaProcessDef)processDef;
            object2 = javaProcessDef.getJvmEntries().iterator();
            while (object2.hasNext()) {
                oDCNode3 = (JavaVirtualMachine)object2.next();
                object = oDCNode3.getSystemProperties().iterator();
                while (object.hasNext()) {
                    transport = (Property)object.next();
                    if (transport.getName().equals("GENERIC_SERVER_TYPE")) {
                        oDCNode4.setProperty(this.odc.serverType, transport.getValue());
                        continue;
                    }
                    if (!transport.getName().equals("GENERIC_SERVER_SUB_TYPE")) continue;
                    oDCNode4.setProperty(this.odc.serverSubType, transport.getValue());
                }
            }
        }
        object2 = null;
        if (object4 != null) {
            String string3;
            Object object8;
            EndPoint endPoint;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing appserver config: " + object4.getName()));
            }
            this.setDefaultThreadPool(oDCNode4);
            oDCNode3 = this.getWebContainer((ApplicationServer)object4);
            if (oDCNode3 != null) {
                object = oDCNode3.getTransports().iterator();
                while (object.hasNext()) {
                    transport = (Transport)object.next();
                    endPoint = transport.getAddress();
                    object8 = this.targetTree.createNode(Integer.toString(endPoint.getPort()), this.odc.transport, oDCNode4);
                    string3 = endPoint.getHost();
                    if (string3 == null || string3.equals("") || string3.equals("*")) {
                        object8.setProperty(this.odc.transportHost, string2);
                    } else {
                        object8.setProperty(this.odc.transportHost, string3);
                    }
                    object8.setProperty(this.odc.transportPort, new Integer(endPoint.getPort()));
                    String string4 = transport.isSslEnabled() ? "https" : "http";
                    object8.setProperty(this.odc.transportProtocol, string4);
                    this.addDefaultChannelChain((ODCNode)object8, transport.isSslEnabled());
                }
            }
            object = object4.getProperties();
            for (int i = 0; i < object.size(); ++i) {
                endPoint = (Property)object.get(i);
                object8 = endPoint.getName();
                string3 = endPoint.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("custom property: name=" + (String)object8 + ", value=" + string3));
                }
                if (!((String)object8).equalsIgnoreCase(SPEED_FACTOR_OVERRIDE_SPEC)) continue;
                object2 = string3;
            }
        }
        if (!((String)object6).equals("NODE_AGENT")) {
            oDCNode3 = this.addServerToCluster(oDCNode4);
            object = oDCNode3.getTransientProperties();
            if (object2 != null) {
                oDCNode3.setProperty(this.odc.clusterSpeedFactorOverrideSpec, object2);
                ((Properties)object).setProperty(SPEED_FACTOR_OVERRIDE_SPEC, oDCNode4.getPath());
            } else {
                String string5 = ((Properties)object).getProperty(SPEED_FACTOR_OVERRIDE_SPEC);
                if (string5 != null && string5.equals(oDCNode4.getPath())) {
                    oDCNode3.setProperty(this.odc.clusterSpeedFactorOverrideSpec, null);
                    ((Properties)object).setProperty(SPEED_FACTOR_OVERRIDE_SPEC, null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readServer", (Object)oDCNode4);
        }
        return oDCNode4;
    }

    protected void setDefaultThreadPool(ODCNode oDCNode) throws Exception {
        ServiceHandle serviceHandle;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDefaultThreadPool", (Object)oDCNode);
        }
        if ((serviceHandle = ServiceHandle.obtain(ChannelFrameworkService.class)) != null) {
            ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)serviceHandle.getService();
            ThreadPool threadPool = channelFrameworkService.getDefaultThreadPool();
            serviceHandle.release();
            if (threadPool != null) {
                oDCNode.setIntProperty(this.odc.serverThreadPoolMin, threadPool.getMinimumPoolSize());
                oDCNode.setIntProperty(this.odc.serverThreadPoolMax, threadPool.getMaximumPoolSize());
                oDCNode.setBooleanProperty(this.odc.serverThreadPoolIsGrowable, threadPool.isGrowAsNeeded());
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"setDefaultThreadPool", (Object)"success");
                }
            } else if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setDefaultThreadPool", (Object)"null default thread pool");
            }
        } else if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setDefaultThreadPool", (Object)"ChannelFrameworkService not found");
        }
    }

    protected ODCNode addServerToCluster(ODCNode oDCNode) throws Exception {
        Object object;
        String string;
        File file;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addServerToCluster", (Object)oDCNode);
        }
        String string2 = oDCNode.getName();
        String string3 = oDCNode.getParent().getName();
        ODCNode oDCNode2 = oDCNode.getParent().getParent();
        String string4 = this.getDir(oDCNode2.getName(), null, null);
        Repository repository = this.getRepository(oDCNode2.getName(), null, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"reading clusters directory");
        }
        if ((file = new File(string = this.joinDir(string4, "clusters"))).exists()) {
            object = file.listFiles(this.directoryFilter);
            if (object == null) {
                throw new IOException("unable to read clusters directory: " + string);
            }
            for (int i = 0; i < ((File[])object).length; ++i) {
                try {
                    String string5 = object[i].getName();
                    String string6 = "clusters" + SEP + string5 + SEP + "cluster.xml";
                    Iterator iterator = repository.getConfigRoot().getResource(0, string6).getContents().iterator();
                    while (iterator.hasNext()) {
                        ServerCluster serverCluster = (ServerCluster)iterator.next();
                        Iterator iterator2 = serverCluster.getMembers().iterator();
                        while (iterator2.hasNext()) {
                            ClusterMember clusterMember = (ClusterMember)iterator2.next();
                            if (!clusterMember.getNodeName().equals(string3) || !clusterMember.getMemberName().equals(string2)) continue;
                            ODCNode oDCNode3 = this.targetTree.createNode(serverCluster.getName(), this.odc.cluster, oDCNode2);
                            oDCNode3.addNode(oDCNode);
                            this.setServerPropsByCluster(oDCNode, clusterMember);
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)("added to real cluster " + oDCNode3.getName()));
                            }
                            return oDCNode3;
                        }
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "addServerToCluster", tc);
                }
            }
        }
        object = oDCNode.getParent().getName() + ":" + oDCNode.getName();
        ODCNode oDCNode4 = this.targetTree.createNode((String)object, this.odc.cluster, oDCNode2);
        oDCNode4.setProperty(this.odc.clusterType, "single-server");
        oDCNode4.setBooleanProperty(this.odc.clusterIsReal, false);
        oDCNode4.addNode(oDCNode);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addServerToCluster", (Object)("added to fake cluster " + oDCNode4.getPath()));
        }
        return oDCNode4;
    }

    protected void readVirtualHostGroups(ODCNode oDCNode) throws Exception {
        VirtualHost virtualHost;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readVirtualHostGroups", (Object)oDCNode);
        }
        List list = this.getNames(oDCNode, this.odc.vhostGroup);
        Repository repository = this.getRepository(oDCNode.getName(), null, null);
        Iterator iterator = repository.getConfigRoot().getResource(0, "virtualhosts.xml").getContents().iterator();
        while (iterator.hasNext()) {
            virtualHost = (VirtualHost)iterator.next();
            list.remove(virtualHost.getName());
            this.readVirtualHostGroup(oDCNode, virtualHost);
        }
        virtualHost = list.iterator();
        while (virtualHost.hasNext()) {
            ODCNode oDCNode2 = oDCNode.getNode(this.odc.vhostGroup, (String)virtualHost.next());
            if (oDCNode2 == null) continue;
            oDCNode.removeNode(oDCNode2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readVirtualHostGroups");
        }
    }

    protected ODCNode readVirtualHostGroup(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readVirtualHostGroup", (Object)new Object[]{oDCNode, string});
        }
        Repository repository = this.getRepository(oDCNode.getName(), null, null);
        Iterator iterator = repository.getConfigRoot().getResource(0, "virtualhosts.xml").getContents().iterator();
        while (iterator.hasNext()) {
            VirtualHost virtualHost = (VirtualHost)iterator.next();
            if (!virtualHost.getName().equals(string)) continue;
            ODCNode oDCNode2 = this.readVirtualHostGroup(oDCNode, virtualHost);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readVirtualHostGroup");
            }
            return oDCNode2;
        }
        throw new ODCException("virtual host group " + string + " not found");
    }

    protected ODCNode readVirtualHostGroup(ODCNode oDCNode, VirtualHost virtualHost) throws Exception {
        Object object;
        String string;
        HostAlias hostAlias;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readVirtualHostGroup", (Object)new Object[]{oDCNode, virtualHost});
        }
        if (this.vhostExcludes.contains(virtualHost.getName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"readVirtualHostGroup", (Object)"excluded");
            }
            return null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processing " + virtualHost.getName()));
        }
        ODCNode oDCNode2 = this.targetTree.createNode(virtualHost.getName(), this.odc.vhostGroup, oDCNode);
        List list = this.getNames(oDCNode2, this.odc.vhost);
        Iterator iterator = virtualHost.getAliases().iterator();
        while (iterator.hasNext()) {
            String string2;
            hostAlias = (HostAlias)iterator.next();
            string = hostAlias.getHostname() + ":" + hostAlias.getPort();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processing vhost " + string));
            }
            if ((object = hostAlias.getHostname()) != null && (((String)object).equals("") || ((String)object).equals("*"))) {
                object = null;
            }
            Integer n = (string2 = hostAlias.getPort()) == null || string2.equals("") || string2.equals("*") ? ANY_PORT : new Integer(string2);
            ODCNode oDCNode3 = this.targetTree.createNode(string, this.odc.vhost, oDCNode2);
            oDCNode3.setProperty(this.odc.vhostHost, object);
            oDCNode3.setProperty(this.odc.vhostPort, n);
            list.remove(string);
        }
        hostAlias = list.iterator();
        while (hostAlias.hasNext()) {
            string = (String)hostAlias.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing " + string));
            }
            if ((object = oDCNode2.getNode(this.odc.vhost, string)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removing vhost " + string));
                }
                oDCNode2.removeNode((ODCNode)object);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("vhost not found to remove: " + string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readVirtualHostGroup", (Object)oDCNode2);
        }
        return oDCNode2;
    }

    protected ODCNode readCluster(ODCNode oDCNode, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readCluster", (Object)new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.cluster, oDCNode);
        this.readCluster(oDCNode2);
        oDCNode2.setProperty(this.odc.clusterType, "static");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readCluster", (Object)oDCNode2);
        }
        return oDCNode2;
    }

    protected void readCluster(ODCNode oDCNode) throws Exception {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readCluster", (Object)oDCNode);
        }
        LinkedList<ODCNode> linkedList = new LinkedList<ODCNode>();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.server);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            linkedList.add(oDCNodeArray[i]);
        }
        ODCNode oDCNode2 = oDCNode.getParent();
        Repository repository = this.getRepository(oDCNode2.getName(), null, null);
        String string = "clusters" + SEP + oDCNode.getName() + SEP + "cluster.xml";
        Iterator iterator = repository.getConfigRoot().getResource(0, string).getContents().iterator();
        while (iterator.hasNext()) {
            object2 = (ServerCluster)iterator.next();
            object = object2.getMembers().iterator();
            while (object.hasNext()) {
                boolean bl;
                ClusterMember clusterMember = (ClusterMember)object.next();
                String string2 = clusterMember.getNodeName();
                String string3 = clusterMember.getMemberName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cluster member: node=" + string2 + ",server="), (Object)string3);
                }
                boolean bl2 = string2.equals(this.myNodeName);
                if (!this.inDMgr && !bl2) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("skipping ... not my node: " + string2));
                    continue;
                }
                boolean bl3 = bl = bl2 && string3.equals(this.myServerName);
                ODCNode oDCNode3 = this.getServerNode(string2, string3);
                if (oDCNode3 == null) continue;
                if (!linkedList.remove(oDCNode3)) {
                    ODCNode oDCNode4;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("adding server " + oDCNode3.getPath() + " to cluster " + oDCNode.getPath()));
                    }
                    if ((oDCNode4 = oDCNode3.getNode(this.odc.cluster)) != null) {
                        oDCNode4.removeNode(oDCNode3);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("removed server" + oDCNode3.getPath() + "from cluster " + oDCNode4.getPath() + " prior to adding"));
                        }
                    }
                    oDCNode.addNode(oDCNode3);
                }
                this.setServerPropsByCluster(oDCNode3, clusterMember);
            }
        }
        if (this.inDMgr) {
            object2 = linkedList.iterator();
            while (object2.hasNext()) {
                object = (ODCNode)object2.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removing server reference " + object.getPath() + " from cluster " + oDCNode.getPath()));
                }
                oDCNode.removeNode((ODCNode)object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readCluster");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ODCNode readApplication(ODCNode oDCNode, String string) {
        ODCNode oDCNode2;
        block33: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"readApplication", (Object)new Object[]{oDCNode, string});
            }
            oDCNode2 = null;
            EARFile eARFile = null;
            try {
                Object object;
                String string2;
                EditionInfo[] editionInfoArray;
                String string3;
                Repository repository = this.getRepository(oDCNode.getName(), null, null);
                ConfigRoot configRoot = repository.getConfigRoot();
                String string4 = "";
                ApplicationDeployment applicationDeployment = null;
                String[] stringArray = null;
                boolean bl = this.isSystemApp(string);
                if (bl) {
                    string3 = this.getSystemAppDeploymentPath(repository, string);
                    editionInfoArray = (Deployment)this.getResource(configRoot, string3 + SEP + "deployment.xml").getContents().get(0);
                    applicationDeployment = (ApplicationDeployment)editionInfoArray.getDeployedObject();
                    eARFile = this.getEAR(string3);
                } else {
                    if (EditionHelper.isEditionSupportEnabled()) {
                        stringArray = EditionHelper.getAppAndEdition((String)string);
                        configRoot.setValue(1, stringArray[0] + ".ear");
                    } else {
                        configRoot.setValue(1, string + ".ear");
                    }
                    string4 = "deployments" + SEP + string;
                    string3 = string4 + SEP + "deployment.xml";
                    editionInfoArray = (Deployment)configRoot.getResource(1, string3).getContents().get(0);
                    applicationDeployment = (ApplicationDeployment)editionInfoArray.getDeployedObject();
                    string2 = configRoot.getAbsolutePath(1, "") + SEP + string4;
                    eARFile = this.getEAR(string2);
                }
                string3 = eARFile.getDeploymentDescriptor();
                oDCNode2 = this.targetTree.createNode(string, this.odc.application, oDCNode);
                oDCNode2.setBooleanProperty(this.odc.applicationIsSystem, bl);
                if (stringArray != null) {
                    oDCNode2.setProperty(this.odc.appEdition, stringArray[1]);
                    editionInfoArray = EditionHelper.getApplicationEditions((String)stringArray[0]);
                    for (int i = 0; i < editionInfoArray.length; ++i) {
                        String string5 = EditionHelper.getCompositeName((String)editionInfoArray[i].getAppName(), (String)editionInfoArray[i].getEdition());
                        if (!string5.equalsIgnoreCase(string)) continue;
                        oDCNode2.setProperty(this.odc.appState, editionInfoArray[i].getEditionState());
                        break;
                    }
                }
                editionInfoArray = this.getNodes(oDCNode2, this.odc.webModule);
                editionInfoArray.addAll(this.getNodes(oDCNode2, this.odc.ejbModule));
                string2 = applicationDeployment.getModules();
                for (int i = 0; i < string2.size(); ++i) {
                    object = (ModuleDeployment)string2.get(i);
                    ODCNode oDCNode3 = null;
                    try {
                        Module module = object.getAltDD() != null ? string3.getModuleHavingAltDD(object.getAltDD()) : string3.getModule(object.getUri());
                        String string6 = object.getUri();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("processing module " + string6));
                        }
                        ODCNode oDCNode4 = null;
                        Iterator iterator = object.getTargetMappings().iterator();
                        while (iterator.hasNext()) {
                            DeploymentTarget deploymentTarget = ((DeploymentTargetMapping)iterator.next()).getTarget();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("target=" + deploymentTarget));
                            }
                            if (deploymentTarget instanceof ServerTarget) {
                                ServerTarget serverTarget = (ServerTarget)deploymentTarget;
                                if (bl && this.inDMgr) {
                                    oDCNode4 = this.getFakeClusterNode(this.odcMyNode.getName(), this.odcMyServer.getName());
                                    continue;
                                }
                                oDCNode4 = this.getFakeClusterNode(serverTarget.getNodeName(), serverTarget.getName());
                                continue;
                            }
                            if (deploymentTarget == null) continue;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("target class is " + deploymentTarget.getClass().getName()));
                            }
                            oDCNode4 = this.getClusterNode(deploymentTarget.getName());
                        }
                        if (oDCNode4 == null) {
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug((TraceComponent)tc, (String)("module " + module.getUri() + " not deployed to cluster or server"));
                            continue;
                        }
                        if (module.isWebModule()) {
                            oDCNode3 = this.processWebModule(configRoot, module, string6, (Set)editionInfoArray, oDCNode4, oDCNode2, eARFile, string4, (List)((Object)string2));
                        } else if (module.isEjbModule()) {
                            oDCNode3 = this.processEjbModule(configRoot, module, string6, (Set)editionInfoArray, oDCNode4, oDCNode2, eARFile, (ModuleDeployment)object, string);
                        }
                        if (!bl || !this.inDMgr || oDCNode3 == null) continue;
                        oDCNode3.addNode(this.odcMyServer);
                        continue;
                    }
                    catch (Throwable throwable) {
                        TrUtil.warning(throwable, this, "readWebModule", tc);
                        if (oDCNode3 == null) continue;
                        oDCNode2.removeNode(oDCNode3);
                        oDCNode3 = null;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"removing modules which no longer exist");
                }
                Iterator iterator = editionInfoArray.iterator();
                while (iterator.hasNext()) {
                    object = (ODCNode)iterator.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("remove " + object));
                    }
                    oDCNode2.removeNode((ODCNode)object);
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    throwable.printStackTrace(System.out);
                }
                if (oDCNode2 == null) break block33;
                try {
                    oDCNode.removeNode(oDCNode2);
                }
                catch (Throwable throwable2) {
                    TrUtil.warning(throwable2, this, "readApplicationCleanup", tc);
                }
                oDCNode2 = null;
            }
            finally {
                if (eARFile != null) {
                    eARFile.close();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readApplication", oDCNode2);
        }
        return oDCNode2;
    }

    protected ODCNode processWebModule(ConfigRoot configRoot, Module module, String string, Set set, ODCNode oDCNode, ODCNode oDCNode2, EARFile eARFile, String string2, List list) throws Exception {
        Object object;
        ODCNode oDCNode3;
        ODCNode oDCNode4;
        EList eList;
        block19: {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Web module: " + string));
            }
            eList = null;
            String string3 = string2 + SEP + "proxy-deployment.xml";
            try {
                eList = configRoot.getResource(1, string3).getContents();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!tc.isDebugEnabled()) break block19;
                Tr.debug((TraceComponent)tc, (String)(string3 + " was not found"));
            }
        }
        DeployedObjectProxyConfig deployedObjectProxyConfig = this.getProxyDeployment(eList, string);
        Boolean bl = Boolean.TRUE;
        String string4 = null;
        if (deployedObjectProxyConfig != null) {
            if (!deployedObjectProxyConfig.isEnableProxy()) {
                bl = Boolean.FALSE;
            }
            if (deployedObjectProxyConfig.getTransportProtocol() != null) {
                string4 = deployedObjectProxyConfig.getTransportProtocol().getName();
            }
        }
        ODCNode oDCNode5 = null;
        WebModule webModule = (WebModule)module;
        String string5 = ((WebAppBinding)eARFile.getBindings(module)).getVirtualHostName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("virtual host: " + string5));
        }
        if (string5 == null || string5.equals("")) {
            string5 = "default_host";
        }
        if ((oDCNode4 = this.getVHostGroupNode(string5)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"virtual host group not found; skipping web module");
            }
            return oDCNode5;
        }
        oDCNode5 = this.createWebModuleNode(string, oDCNode2);
        oDCNode5.setProperty(this.odc.webModuleRoutingEnabled, bl);
        this.setWebModuleProtocolMap(oDCNode5, string4);
        set.remove(oDCNode5);
        if (oDCNode != null) {
            oDCNode5.addNode(oDCNode);
        }
        String string6 = TreeBuilder.normalizeContextRoot(webModule.getContextRoot());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("context root: " + string6));
        }
        if ((oDCNode3 = oDCNode5.getNode(this.odc.vhostGroup)) != oDCNode4) {
            if (oDCNode3 != null) {
                oDCNode5.removeNode(oDCNode3);
            }
            oDCNode5.addNode(oDCNode4);
        }
        WebAppExtension webAppExtension = eARFile.getExtensions(webModule);
        oDCNode5.setProperty(this.odc.webModuleContextRoot, string6);
        oDCNode5.setProperty(this.odc.webModuleFileServingEnabled, new Boolean(webAppExtension.isFileServingEnabled()));
        oDCNode5.setProperty(this.odc.webModuleServeServletsByName, new Boolean(webAppExtension.isSetServeServletsByClassnameEnabled()));
        if (webAppExtension.isFileServingEnabled()) {
            this.addURI(oDCNode5, "/*");
        }
        this.addURI(oDCNode5, "/*.jsp");
        this.addURI(oDCNode5, "/*.jsv");
        this.addURI(oDCNode5, "/*.jsw");
        if (webAppExtension.isSetServeServletsByClassnameEnabled()) {
            this.addURI(oDCNode5, "/servlet/*");
        }
        Iterator iterator = eARFile.getDeploymentDescriptor(webModule).getServletMappings().iterator();
        while (iterator.hasNext()) {
            object = (ServletMapping)iterator.next();
            this.addURI(oDCNode5, object.getUrlPattern());
        }
        object = this.getWebServicesUrlPatterns(eARFile, list, (Module)webModule).iterator();
        String string7 = null;
        while (object.hasNext()) {
            string7 = (String)object.next();
            this.addURI(oDCNode5, string7);
        }
        if (string7 != null) {
            this.processWSDLs(eARFile, webModule, oDCNode5);
        }
        return oDCNode5;
    }

    protected ODCNode processEjbModule(ConfigRoot configRoot, Module module, String string, Set set, ODCNode oDCNode, ODCNode oDCNode2, EARFile eARFile, ModuleDeployment moduleDeployment, String string2) throws Exception {
        return null;
    }

    protected ODCNode createWebModuleNode(String string, ODCNode oDCNode) throws Exception {
        ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.webModule, oDCNode);
        oDCNode2.setProperty(this.odc.webModuleId, this.getModuleId(oDCNode2));
        return oDCNode2;
    }

    protected String getModuleId(ODCNode oDCNode) throws Exception {
        int n;
        ODCNode oDCNode2 = oDCNode.getParent();
        ODCNode oDCNode3 = oDCNode2.getParent();
        String string = oDCNode2.getName();
        String string2 = (String)oDCNode2.getProperty(this.odc.appEdition);
        if (string2 != null && (n = string2.length()) > 0) {
            string = string.substring(0, string.length() - (n + 8));
        }
        String string3 = oDCNode3.getName() + "/" + string + "/" + oDCNode.getName();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("modId='" + string3 + ", modPath=" + oDCNode.getPath()));
        }
        return string3;
    }

    protected void processWSDLs(EARFile eARFile, WebModule webModule, ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processWSDLs", (Object)new Object[]{eARFile, webModule, oDCNode});
        }
        Iterator iterator = this.getWsdls(eARFile, webModule).iterator();
        while (iterator.hasNext()) {
            this.processWsdl((String)iterator.next(), oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processWSDLs");
        }
    }

    private void processWsdl(String string, ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"processWsdl", (Object)new Object[]{string, oDCNode});
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.wsdl.xml.WSDLReaderImpl");
            Class<?> clazz2 = Class.forName("javax.wsdl.Definition");
            Class<?> clazz3 = Class.forName("com.ibm.wsdl.ServiceImpl");
            Class<?> clazz4 = Class.forName("javax.wsdl.Port");
            Class<?> clazz5 = Class.forName("javax.wsdl.extensions.ExtensibilityElement");
            Class<?> clazz6 = Class.forName("javax.wsdl.extensions.soap.SOAPAddress");
            Class<?> clazz7 = Class.forName("javax.wsdl.extensions.soap.SOAPOperation");
            Class<?> clazz8 = Class.forName("com.ibm.ws.webservices.engine.types.URI");
            Class<?> clazz9 = Class.forName("javax.wsdl.Binding");
            Class<?> clazz10 = Class.forName("javax.wsdl.BindingOperation");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getMethod("readWSDL", classArray);
            Constructor<?> constructor = clazz.getConstructor(null);
            Object obj = constructor.newInstance(null);
            Object object = method.invoke(obj, string);
            Method method2 = clazz2.getMethod("getServices", null);
            Iterator iterator = ((Map)method2.invoke(object, null)).values().iterator();
            while (iterator.hasNext()) {
                Object v = iterator.next();
                Method method3 = clazz3.getMethod("getPorts", null);
                Iterator iterator2 = ((Map)method3.invoke(v, null)).values().iterator();
                while (iterator2.hasNext()) {
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object object6;
                    Object v2 = iterator2.next();
                    Method method4 = clazz4.getMethod("getName", null);
                    ODCNode oDCNode2 = this.targetTree.createNode((String)method4.invoke(v2, null), this.odc.webService, oDCNode);
                    Method method5 = clazz4.getMethod("getExtensibilityElements", null);
                    Iterator iterator3 = ((List)method5.invoke(v2, null)).iterator();
                    while (iterator3.hasNext()) {
                        object6 = iterator3.next();
                        if (!clazz6.isInstance(object6)) continue;
                        object5 = clazz6.getMethod("getLocationURI", null);
                        object4 = (String)((Method)object5).invoke(object6, null);
                        if (((String)object4).indexOf((String)(object3 = (String)oDCNode.getProperty(this.odc.webModuleContextRoot))) == 0) {
                            object4 = ((String)object4).substring(((String)object3).length());
                        }
                        object2 = this.targetTree.createNode((String)object4, this.odc.uri, oDCNode);
                        oDCNode2.addNode((ODCNode)object2);
                        break;
                    }
                    object6 = clazz4.getMethod("getBinding", null);
                    object5 = ((Method)object6).invoke(v2, null);
                    object4 = clazz9.getMethod("getBindingOperations", null);
                    object3 = ((List)((Method)object4).invoke(object5, null)).iterator();
                    block5: while (object3.hasNext()) {
                        object2 = object3.next();
                        Method method6 = clazz10.getMethod("getExtensibilityElements", null);
                        iterator3 = ((List)method6.invoke(object2, null)).iterator();
                        while (iterator3.hasNext()) {
                            Object e = iterator3.next();
                            if (!clazz7.isInstance(e)) continue;
                            Method method7 = clazz7.getMethod("getSoapActionURI", null);
                            String string2 = (String)method7.invoke(e, null);
                            Method method8 = clazz10.getMethod("getName", null);
                            if (string2.length() <= 0) continue;
                            ODCNode oDCNode3 = this.targetTree.createNode((String)method8.invoke(object2, null), this.odc.webServiceOperation, oDCNode2);
                            oDCNode3.setProperty(this.odc.SOAPAction, string2);
                            continue block5;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "processWsdl", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"processWsdl", (Object)oDCNode);
        }
    }

    private List getWsdls(EARFile eARFile, WebModule webModule) throws Exception {
        String string;
        AnnotatedElement annotatedElement;
        LinkedList<String> linkedList = new LinkedList<String>();
        ModuleFile moduleFile = eARFile.getModuleRef((Module)webModule).getModuleFile();
        boolean bl = webModule.isWebModule();
        WebServices webServices = null;
        Class<?> clazz = Class.forName("com.ibm.ws.webservices.WSConstants");
        if (bl) {
            annotatedElement = clazz.getDeclaredField("WSKEY_WSWEBSERVER_XMLFILE");
            string = (String)((Field)annotatedElement).get(null);
        } else {
            string = (String)clazz.getField("WSKEY_WSSERVER_XMLFILE").get(null);
        }
        try {
            annotatedElement = Class.forName("com.ibm.ws.webservices.WSModels");
            Class[] classArray = new Class[]{LoadStrategy.class, String.class};
            Method method = ((Class)annotatedElement).getMethod("getWebServices", classArray);
            webServices = (WebServices)method.invoke(null, moduleFile.getLoadStrategy(), string);
            Iterator iterator = webServices.getWebServiceDescriptions().iterator();
            while (iterator.hasNext()) {
                WebServiceDescription webServiceDescription = (WebServiceDescription)iterator.next();
                String string2 = webServiceDescription.getWsdlFile();
                if (SEP.equals("\\")) {
                    string2.replaceAll("/", "\\\\");
                } else {
                    string2.replaceAll("/", SEP);
                }
                String string3 = moduleFile.getAbsolutePath() + SEP + string2;
                linkedList.add(string3);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webservices.deploy.PluginCfgHelper.getWebServicesUrlPatterns", (String)"155");
        }
        return linkedList;
    }

    protected DeployedObjectProxyConfig getProxyDeployment(EList eList, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProxyDeployment", (Object)new Object[]{eList, string});
        }
        if (eList != null) {
            for (int i = 0; i < eList.size(); ++i) {
                DeployedObjectProxyConfig deployedObjectProxyConfig = (DeployedObjectProxyConfig)eList.get(i);
                if (!deployedObjectProxyConfig.getDeployedObjectConfigName().equals(string)) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"getProxyDeployment", (Object)deployedObjectProxyConfig);
                }
                return deployedObjectProxyConfig;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getProxyDeployment", (Object)"null");
        }
        return null;
    }

    protected void addDefaultChannelChain(ODCNode oDCNode, boolean bl) throws Exception {
        this.addDefaultChannelChain(oDCNode, bl, false);
    }

    protected void addDefaultChannelChain(ODCNode oDCNode, boolean bl, boolean bl2) throws Exception {
        ODCNode oDCNode2;
        String string = bl ? "https" : "http";
        ODCNode oDCNode3 = this.targetTree.createNode(string, this.odc.channelChain, oDCNode, bl2);
        ODCNode oDCNode4 = this.targetTree.createNode("http", this.odc.channel, oDCNode3, bl2);
        oDCNode4.setProperty(this.odc.channelFactoryClass, "com.ibm.ws.http.channel.outbound.impl.HttpOutboundChannelFactory");
        if (bl) {
            oDCNode2 = this.targetTree.createNode("ssl", this.odc.channel, oDCNode3, bl2);
            oDCNode2.setProperty(this.odc.channelFactoryClass, "com.ibm.ws.ssl.channel.impl.SSLChannelFactory");
        }
        oDCNode2 = this.targetTree.createNode("tcp", this.odc.channel, oDCNode3, bl2);
        oDCNode2.setProperty(this.odc.channelFactoryClass, "com.ibm.ws.tcp.channel.impl.TCPChannelFactory");
    }

    protected void addURI(ODCNode oDCNode, String string) throws ODCException {
        if (!string.startsWith("*") && !string.startsWith("/")) {
            string = "/" + string;
        }
        this.targetTree.createNode(string, this.odc.uri, oDCNode);
    }

    protected List getWebServicesUrlPatterns(EARFile eARFile, List list, Module module) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWebServicesUrlPatterns", (Object)new Object[]{eARFile, module});
        }
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = Class.forName("com.ibm.ws.webservices.deploy.PluginCfgHelper");
        Class[] classArray = new Class[]{EARFile.class, List.class, Module.class};
        Method method = clazz.getMethod("getWebServicesUrlPatterns", classArray);
        List list2 = (List)method.invoke(null, eARFile, list, module);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWebServicesUrlPatterns");
        }
        return list2;
    }

    protected String getRouterModuleName(EARFile eARFile, EjbModule ejbModule) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getRouterModuleName", (Object)new Object[]{eARFile, ejbModule});
        }
        Class<?> clazz = Class.forName("com.ibm.ws.webservices.deploy.PluginCfgHelper");
        Class[] classArray = new Class[]{EARFile.class, EjbModule.class};
        Method method = clazz.getMethod("getRouterModuleName", classArray);
        String string = (String)method.invoke(null, eARFile, ejbModule);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getRouterModuleName", (Object)string);
        }
        return string;
    }

    protected ApplicationServer getAppServer(com.ibm.websphere.models.config.process.Server server) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getAppServer", (Object)server);
        }
        Iterator iterator = server.getComponents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ApplicationServer)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getAppServer", e);
            }
            return (ApplicationServer)e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getAppServer", (Object)"null");
        }
        return null;
    }

    protected WebContainer getWebContainer(ApplicationServer applicationServer) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getWebContainer", (Object)applicationServer);
        }
        Iterator iterator = applicationServer.getComponents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof WebContainer)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getWebContainer", e);
            }
            return (WebContainer)e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getWebContainer", (Object)"null");
        }
        return null;
    }

    protected ODCNode getNodeNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNodeNode", (Object)string);
        }
        ODCNode oDCNode = null;
        try {
            oDCNode = this.odcMyCell.getNode(this.odc.node, string);
            if (oDCNode == null) {
                oDCNode = this.readNode(this.odcMyCell, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getNodeNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNodeNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    protected ODCNode getServerNode(String string, String string2) {
        return this.getServerNode(this.getNodeNode(string), string2);
    }

    protected ODCNode getServerNode(ODCNode oDCNode, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerNode", (Object)new Object[]{oDCNode, string});
        }
        ODCNode oDCNode2 = null;
        try {
            if (oDCNode != null && (oDCNode2 = oDCNode.getNode(this.odc.server, string)) == null) {
                oDCNode2 = this.readServer(this.odcMyCell, oDCNode, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getServerNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerNode", (Object)oDCNode2);
        }
        return oDCNode2;
    }

    protected ODCNode getVHostGroupNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getVhostGroupNode", (Object)string);
        }
        if (this.vhostExcludes.contains(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getVhostGroupNode", (Object)"excluded");
            }
            return null;
        }
        ODCNode oDCNode = null;
        try {
            oDCNode = this.odcMyCell.getNode(this.odc.vhostGroup, string);
            if (oDCNode == null) {
                oDCNode = this.readVirtualHostGroup(this.odcMyCell, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getVHostGroupNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getVhostGroupNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    protected ODCNode obtainAppNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"obtainAppNode", (Object)string);
        }
        ODCNode oDCNode = null;
        oDCNode = (ODCNode)this.appsRead.get(string);
        if (oDCNode == null) {
            try {
                oDCNode = this.targetTree.createNode(string, this.odc.application, this.odcMyCell);
                if (oDCNode != null) {
                    this.appsRead.put(string, oDCNode);
                }
                this.readApplication(this.odcMyCell, string);
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "obtainAppNode:" + string, tc);
                this.appsRead.remove(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainAppNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    protected void removeAppNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeAppNode", (Object)string);
        }
        try {
            this.appsRead.remove(string);
            ODCNode oDCNode = this.odcMyCell.getNode(this.odc.application, string);
            if (oDCNode != null) {
                oDCNode.remove();
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "removeAppNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeAppNode");
        }
    }

    protected ODCNode getClusterNode(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getClusterNode", (Object)string);
        }
        ODCNode oDCNode = null;
        try {
            oDCNode = this.odcMyCell.getNode(this.odc.cluster, string);
            if (oDCNode == null) {
                oDCNode = this.readCluster(this.odcMyCell, string);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getClusterNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getClusterNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    protected ODCNode getFakeClusterNode(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getFakeClusterNode", (Object)new Object[]{string, string2});
        }
        ODCNode oDCNode = null;
        String string3 = string + ":" + string2;
        try {
            oDCNode = this.targetTree.createNode(string3, this.odc.cluster, this.odcMyCell);
            oDCNode.setBooleanProperty(this.odc.clusterIsReal, false);
            ODCNode oDCNode2 = this.getServerNode(string, string2);
            if (oDCNode2 != null) {
                oDCNode.addNode(oDCNode2);
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "getFakeClusterNode", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getFakeClusterNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    protected void setMyServerState(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMyServerState", (Object)string);
        }
        if (string.equals(this.myServerState)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setMyServerState", (Object)"no change");
            }
            return;
        }
        String string2 = this.myServerState;
        this.myServerState = string;
        if (this.odcMyServer == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setMyServerState", (Object)"my server is null");
            }
            return;
        }
        try {
            this.odcMyServer.setProperty(this.odc.serverState, string);
            if (string2.equals("STARTED")) {
                Integer n = (Integer)this.odcMyServer.getProperty(this.odc.serverWeight);
                if (n != 0) {
                    this.lastNonZeroServerWeight = n;
                }
                this.odcMyServer.setProperty(this.odc.serverWeight, DOWN_WEIGHT);
            } else if (string.equals("STARTED")) {
                this.odcMyServer.setProperty(this.odc.serverWeight, this.lastNonZeroServerWeight);
                this.addListeners();
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "setMyServerState", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMyServerState");
        }
    }

    protected void setMyServerWeight(Integer n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setMyServerWeight", (Object)n);
        }
        try {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setMyServerState");
            }
            Integer n2 = (Integer)this.odcMyServer.getProperty(this.odc.serverWeight);
            if (n != 0) {
                this.lastNonZeroServerWeight = n;
            }
            this.odcMyServer.setProperty(this.odc.serverWeight, DOWN_WEIGHT);
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "setMyServerWeight", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setMyServerWeight");
        }
    }

    protected void addListeners() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addListeners");
        }
        if (!this.listenersAdded) {
            try {
                if (this.inDMgr) {
                    this.addAppListeners();
                }
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addAppListeners", tc);
            }
            try {
                if (this.inDMgr) {
                    this.addDiscoveryListener();
                }
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addDiscoveryListener", tc);
            }
        }
        this.listenersAdded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addListeners");
        }
    }

    protected void addAppListeners() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addAppListener");
        }
        ObjectName objectName = new ObjectName("WebSphere:type=Application,*");
        NotificationFilterSupport notificationFilterSupport = this.getFilter("j2ee.state.stopping", "j2ee.state.running");
        this.adminService.addNotificationListenerExtended(objectName, (NotificationListener)this, (NotificationFilter)notificationFilterSupport, appStartStopPassBack);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addAppListener");
        }
    }

    protected void addDiscoveryListener() throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addDiscoveryListener");
        }
        if (!this.inDMgr) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addClusterListeners", (Object)"not dmgr");
            }
            return;
        }
        ObjectName objectName = this.getMBeanName("WebSphere:type=DeploymentManager,node=" + this.myNodeName + ",process=" + this.myServerName + ",*", "DeploymentManager");
        NotificationFilterSupport notificationFilterSupport = this.getFilter("websphere.process.running");
        this.adminService.addNotificationListener(objectName, (NotificationListener)this, null, discoveryPassBack);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addDiscoveryListener");
        }
    }

    protected void addNodeListener(String string) throws Exception {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNodeListener", (Object)string);
        }
        if (!this.inDMgr) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addNodeListener", (Object)"not dmgr");
            }
            return;
        }
        ODCNode oDCNode = this.getNodeNode(string);
        boolean bl2 = bl = oDCNode != null ? this.addNodeListener(oDCNode) : false;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNodeListener", (Object)new Boolean(bl));
        }
    }

    protected boolean addNodeListener(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNodeListener", (Object)oDCNode);
        }
        try {
            ObjectName objectName = this.getMBeanName("WebSphere:type=NodeAgent,node=" + oDCNode.getName() + ",*", "NodeAgent");
            this.adminService.addNotificationListener(objectName, (NotificationListener)this, (NotificationFilter)this.jmxProcessFilter, (Object)oDCNode);
            this.nodeIsUp(oDCNode);
        }
        catch (Throwable throwable) {
            TrUtil.error(throwable, this, "addNodeListener", tc);
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNodeListener", (Object)"true");
        }
        return true;
    }

    protected void nodeIsUp(ODCNode oDCNode) throws Exception {
        ODCNode oDCNode2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"nodeIsUp", (Object)oDCNode.getName());
        }
        if ((oDCNode2 = oDCNode.getNode(this.odc.server, "nodeagent")) != null) {
            oDCNode2.setProperty(this.odc.serverState, "STARTED");
            this.markServerUp(oDCNode2);
        }
        ObjectName objectName = new ObjectName("WebSphere:type=Server,node=" + oDCNode.getName() + ",*");
        Iterator iterator = this.adminService.queryNames(objectName, null).iterator();
        while (iterator.hasNext()) {
            ObjectName objectName2 = (ObjectName)iterator.next();
            String string = objectName2.getKeyProperty("process");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("server is up: node=" + oDCNode.getName() + ", server=" + string));
            }
            if (string.equals("nodeagent")) continue;
            ODCNode oDCNode3 = this.getServerNode(oDCNode, string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("server=" + oDCNode3));
            }
            if (oDCNode3 == null) continue;
            this.markServerUp(oDCNode3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"nodeIsUp", (Object)oDCNode.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markServerUp(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markServerUp", (Object)oDCNode);
        }
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            oDCNode = this.targetTree.refreshNode(oDCNode);
            if (oDCNode == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"markServerUp", (Object)"server is no longer up");
                }
                return;
            }
            this.targetTree.beginTransaction("TreeBuilder.serverUp");
            try {
                oDCNode.setProperty(this.odc.serverWeight, this.getServerUpWeight(oDCNode));
                if (this.inDMgr && (this.odcMyServer == null || !this.odcMyServer.getPath().equals(oDCNode.getPath()))) {
                    ODCNode oDCNode2 = oDCNode.getParent();
                    String string = "WebSphere:type=Application,node=" + oDCNode2.getName() + ",Server=" + oDCNode.getName() + ",*";
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("app query string = " + string));
                    }
                    ObjectName objectName = new ObjectName(string);
                    Iterator iterator = this.adminService.queryNames(objectName, null).iterator();
                    while (iterator.hasNext()) {
                        ODCNode oDCNode3;
                        ObjectName objectName2 = (ObjectName)iterator.next();
                        String string2 = objectName2.getKeyProperty("name");
                        if (EditionHelper.isEditionSupportEnabled()) {
                            string2 = this.getAppNameOfActiveEdition(oDCNode2.getName(), oDCNode.getName(), string2);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("app " + string2 + " is up"));
                        }
                        if ((oDCNode3 = this.obtainAppNode(string2)) == null) continue;
                        this.appOnServerChange(oDCNode3, oDCNode, true);
                    }
                }
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "markServerUp", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markServerUp");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markServerDown(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"markServerDown", (Object)oDCNode);
        }
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.serverDown");
            try {
                oDCNode.setProperty(this.odc.serverWeight, DOWN_WEIGHT);
                ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.webModule);
                for (int i = 0; i < oDCNodeArray.length; ++i) {
                    oDCNode.removeNode(oDCNodeArray[i]);
                }
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "markServerDown", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"markServerDown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNotification", (Object)new Object[]{notification, object});
        }
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.jmx");
            try {
                this.handleJMXNotification(notification, object);
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "handleNotification", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleNotification");
        }
    }

    protected void handleJMXNotification(Notification notification, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleJMXNotification", (Object)new Object[]{notification, object});
        }
        try {
            String string = notification.getType();
            Object object2 = notification.getUserData();
            if (object == discoveryPassBack) {
                if (object2 instanceof Properties) {
                    Properties properties = (Properties)object2;
                    String string2 = (String)properties.get("nodeName");
                    String string3 = (String)properties.get("processName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("process " + string3 + " is " + string + " on node " + string2));
                        Tr.debug((TraceComponent)tc, (String)("properties=" + properties));
                    }
                    if (string3.equals("nodeagent")) {
                        if (string.equals("websphere.process.running")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("node agent is running on " + string2));
                            }
                            this.addNodeListener(string2);
                            this.upNodes.add(string2);
                        } else if (this.upNodes.remove(string2)) {
                            ODCNode oDCNode;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("node agent is NOT running on " + string2));
                            }
                            if ((oDCNode = this.odcMyCell.getNode(this.odc.node, string2)) != null) {
                                ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.server);
                                for (int i = 0; i < oDCNodeArray.length; ++i) {
                                    this.markServerDown(oDCNodeArray[i]);
                                }
                            }
                        }
                    }
                }
            } else if (object == appStartStopPassBack) {
                ODCNode oDCNode;
                String string4;
                ObjectName objectName = (ObjectName)notification.getSource();
                String string5 = objectName.getKeyProperty("name");
                String string6 = objectName.getKeyProperty("node");
                ODCNode oDCNode2 = this.getServerNode(string6, string4 = objectName.getKeyProperty("Server"));
                if (oDCNode2 == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleJMXNotification", (Object)("server not found: " + string4));
                    }
                    return;
                }
                if (EditionHelper.isEditionSupportEnabled()) {
                    string5 = this.getAppNameOfActiveEdition(string6, string4, string5);
                }
                if ((oDCNode = this.obtainAppNode(string5)) == null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"handleJMXNotification", (Object)("app not found: " + string5));
                    }
                    return;
                }
                if (string.equals("j2ee.state.starting")) {
                    ODCNode oDCNode3 = this.targetTree.createNode(string5, this.odc.serverApplication, oDCNode2);
                    oDCNode3.setProperty(this.odc.serverApplicationState, "STARTING");
                } else {
                    String string7;
                    ODCNode oDCNode4 = oDCNode2.getNode(this.odc.serverApplication, string5);
                    if (oDCNode4 == null) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"handleJMXNotification", (Object)("serverApplication not found: " + string5));
                        }
                        return;
                    }
                    String string8 = (String)oDCNode4.getProperty(this.odc.serverApplicationState);
                    if (string.equals("j2ee.state.running")) {
                        this.appOnServerChange(oDCNode, oDCNode2, true);
                        string7 = "STARTED";
                    } else if (string.equals("j2ee.state.stopping")) {
                        this.appOnServerChange(oDCNode, oDCNode2, false);
                        string7 = "STOPPING";
                    } else if (string.equals("j2ee.state.stopped")) {
                        string7 = "STOPPED";
                    } else if (string.equals("j2ee.state.failed")) {
                        string7 = "ERROR";
                    } else {
                        string7 = "ERROR";
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("unknown J2EE state: " + string));
                        }
                    }
                    if (this.serverAppStateChange(string8, string7)) {
                        oDCNode4.setProperty(this.odc.serverApplicationState, string7);
                    }
                }
            } else if (object instanceof ODCNode) {
                ODCNode oDCNode = (ODCNode)object;
                if (oDCNode.is(this.odc.node)) {
                    ODCNode oDCNode5 = oDCNode;
                    boolean bl = string.equals("websphere.process.running");
                    Properties properties = (Properties)object2;
                    String string9 = (String)properties.get("processName");
                    ODCNode oDCNode6 = this.getServerNode(oDCNode5, string9);
                    if (oDCNode6 != null) {
                        if (bl) {
                            this.markServerUp(oDCNode6);
                        } else {
                            this.markServerDown(oDCNode6);
                        }
                        if (string.equals("websphere.process.running")) {
                            oDCNode6.setProperty(this.odc.serverState, "STARTED");
                        } else if (string.equals("websphere.process.starting")) {
                            oDCNode6.setProperty(this.odc.serverState, "STARTING");
                        } else if (string.equals("websphere.process.stopped")) {
                            oDCNode6.setProperty(this.odc.serverState, "STOPPED");
                        } else if (string.equals("websphere.process.stopping")) {
                            oDCNode6.setProperty(this.odc.serverState, "STOPPING");
                        } else {
                            oDCNode6.setProperty(this.odc.serverState, "ERROR");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"server not found");
                    }
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"ODC_UnknownNotify", (Object)notification.getType());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleJMXNotification");
            }
        }
        catch (Exception exception) {
            TrUtil.warning(exception, this, "handleJMXNotification", tc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appEventReceived(AppNotification appNotification) {
        String string = (String)appNotification.props.get("appname");
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appEventReceived", (Object)new Object[]{string, appNotification});
        }
        if (appNotification.taskName.equals("InstallApplication") && appNotification.taskStatus.equals("Completed")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("installed application " + string));
            }
        } else if (appNotification.taskName.equals("UninstallApplication") && appNotification.taskStatus.equals("Completed")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("uninstalled application " + string));
            }
            ODCTreeImpl oDCTreeImpl = this.targetTree;
            synchronized (oDCTreeImpl) {
                this.targetTree.beginTransaction("uninstall application");
                try {
                    this.removeAppNode(string);
                    this.targetTree.commitTransaction();
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "uninstallApp", tc);
                    this.targetTree.rollbackTransaction();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appEventReceived");
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("propertyChange server state: " + string));
        }
        this.setMyServerState(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configChanged(ConfigRepositoryEvent configRepositoryEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"configChanged", (Object)configRepositoryEvent);
        }
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.configChanged");
            try {
                this.handleConfigChange(configRepositoryEvent);
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "TreeBuilder.configChanged", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"configChanged");
        }
    }

    public void handleConfigChange(ConfigRepositoryEvent configRepositoryEvent) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleConfigChange", (Object)configRepositoryEvent);
        }
        ConfigChangeNotifier[] configChangeNotifierArray = configRepositoryEvent.getChanges();
        ArrayList arrayList = new ArrayList();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        hashMap.put(APP_CHANGES, arrayList);
        hashMap.put(SERVICEPOLICY_UPDATE_REQD, Boolean.FALSE);
        hashMap.put(NODEGROUP_UPDATE_REQD, Boolean.FALSE);
        for (int i = 0; i < configChangeNotifierArray.length; ++i) {
            ConfigChangeNotifier configChangeNotifier = configChangeNotifierArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("change=" + configChangeNotifier));
            }
            this.handleDocChange(configChangeNotifier, hashMap);
        }
        this.doConfigChangePostProcessing(this.odcMyCell, hashMap);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleConfigChange");
        }
    }

    protected void handleDocChange(ConfigChangeNotifier configChangeNotifier, HashMap hashMap) throws Exception {
        String string = configChangeNotifier.getUri();
        if (string.endsWith("/cell.xml")) {
            this.handleCellChange(configChangeNotifier);
        } else if (string.endsWith("/cluster.xml")) {
            this.handleClusterChange(configChangeNotifier);
        } else if (string.endsWith("/node.xml") && string.indexOf("/nodes/") != -1) {
            this.handleNodeChange(configChangeNotifier);
        } else if (string.startsWith(this.nodesDir) && string.endsWith("/server.xml")) {
            this.handleServerChange(configChangeNotifier);
        } else if (string.endsWith("/virtualhosts.xml")) {
            this.readVirtualHostGroups(this.odcMyCell);
        } else if (string.startsWith(this.applicationsDir)) {
            Object object;
            List list = (List)hashMap.get(APP_CHANGES);
            String[] stringArray = string.split("/");
            Object object2 = stringArray[3];
            if (EditionHelper.isEditionSupportEnabled()) {
                if (string.endsWith("ibm-edition-metadata.props")) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 4);
                    EditionInfo[] editionInfoArray = EditionHelper.getApplicationEditions((String)object2);
                    for (int i = 0; i < editionInfoArray.length; ++i) {
                        String string2 = EditionHelper.getCompositeName((String)editionInfoArray[i].getAppName(), (String)editionInfoArray[i].getEdition());
                        int n = configChangeNotifier.getChangeType();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("change to application " + string2));
                        }
                        AppChange appChange = null;
                        for (int j = 0; j < list.size(); ++j) {
                            AppChange appChange2 = (AppChange)list.get(j);
                            if (!string2.equals(appChange2.appName) || n != appChange2.change) continue;
                            appChange = appChange2;
                            if (!tc.isDebugEnabled()) break;
                            Tr.debug((TraceComponent)tc, (String)("event already exists: " + appChange));
                            break;
                        }
                        if (appChange != null) continue;
                        appChange = new AppChange(string2, n);
                        list.add(appChange);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("new event: " + appChange));
                    }
                    return;
                }
                String string3 = this.applicationsDir + (String)object2 + "/" + "deltas" + "/";
                if (string.indexOf(string3) != -1) {
                    return;
                }
                object = null;
                if (string.endsWith(".ear")) {
                    object = string.split("/")[4];
                    object = ((String)object).substring(0, ((String)object).length() - 4);
                } else {
                    object = string.split("/")[5];
                }
                object2 = object;
            } else {
                object2 = ((String)object2).substring(0, ((String)object2).length() - 4);
            }
            int n = configChangeNotifier.getChangeType();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("change to application " + (String)object2));
            }
            if (n == 1 && !stringArray[stringArray.length - 1].equals("application.xml")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("ignoring delete of " + string));
                }
                return;
            }
            object = null;
            for (int i = 0; i < list.size(); ++i) {
                AppChange appChange = (AppChange)list.get(i);
                if (!((String)object2).equals(appChange.appName) || n != appChange.change) continue;
                object = appChange;
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("event already exists: " + object));
                break;
            }
            if (object == null) {
                object = new AppChange((String)object2, n);
                list.add(object);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("new event: " + object));
                }
            }
        }
    }

    protected void doConfigChangePostProcessing(ODCNode oDCNode, HashMap hashMap) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doConfigChangePostProcessing: processing application changes");
        }
        List list = (List)hashMap.get(APP_CHANGES);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            AppChange appChange = (AppChange)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("appchange:" + appChange));
            }
            switch (appChange.change) {
                case 0: {
                    this.readApplication(oDCNode, appChange.appName);
                    break;
                }
                case 2: {
                    this.readApplication(oDCNode, appChange.appName);
                    break;
                }
                case 1: {
                    ODCNode oDCNode2 = oDCNode.getNode(this.odc.application, appChange.appName);
                    if (oDCNode2 == null) break;
                    this.handleAppNodeDeletion(oDCNode2);
                }
            }
        }
    }

    protected void handleCellChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleCellChange " + configChangeNotifier));
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        if (stringArray.length > 1 && stringArray[0].equalsIgnoreCase("cells")) {
            string2 = stringArray[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cellName=" + string2));
        }
        if (string2 == null) {
            return;
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: {
                this.readCell(this.targetTree.getRoot(), string2);
                break;
            }
            case 2: {
                ODCNode oDCNode = this.targetTree.getRoot().getNode(this.odc.cell, string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cell=" + oDCNode));
                }
                if (oDCNode == null) break;
                this.readCellXml(oDCNode);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleCellChange complete");
        }
    }

    protected void handleServerChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleServerChange", (Object)configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (stringArray.length > 6 && stringArray[stringArray.length - 7].equalsIgnoreCase("cells") && stringArray[stringArray.length - 5].equalsIgnoreCase("nodes") && stringArray[stringArray.length - 3].equalsIgnoreCase("servers")) {
            string2 = stringArray[stringArray.length - 6];
            string3 = stringArray[stringArray.length - 4];
            string4 = stringArray[stringArray.length - 2];
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleServerChange: cellName is ", string2);
            }
            return;
        }
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleServerChange: nodeName is ", string3);
            }
            return;
        }
        if (string4 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleServerChange: serverName is ", string4);
            }
            return;
        }
        if (!this.shouldReadServer(string2, string3, string4)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleServerChange", (Object)"ignore change");
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot().getNode(this.odc.cell, string2);
        ODCNode oDCNode3 = oDCNode2 != null ? oDCNode2.getNode(this.odc.node, string3) : null;
        ODCNode oDCNode4 = oDCNode = oDCNode3 != null ? oDCNode3.getNode(this.odc.server, string4) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell=" + oDCNode2 + ", node=" + oDCNode3 + ", server=" + oDCNode));
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: 
            case 2: {
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                if (oDCNode3 == null) {
                    this.readNode(oDCNode2, string3);
                    break;
                }
                this.readServer(oDCNode2, oDCNode3, string4);
                break;
            }
            case 1: {
                if (oDCNode == null) break;
                oDCNode3.removeNode(oDCNode);
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleServerChange");
        }
    }

    protected void handleClusterChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleClusterChange", (Object)configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        if (stringArray.length > 3 && stringArray[0].equalsIgnoreCase("cells") && stringArray[2].equalsIgnoreCase("clusters")) {
            string2 = stringArray[1];
            string3 = stringArray[3];
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleClusterChange: cellName is ", string2);
            }
            return;
        }
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleClusterChange: clusterName is ", string3);
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot().getNode(this.odc.cell, string2);
        ODCNode oDCNode3 = oDCNode = oDCNode2 != null ? oDCNode2.getNode(this.odc.cluster, string3) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell=" + oDCNode2 + ", cluster=" + oDCNode));
        }
        ODCNode oDCNode4 = null;
        if (configChangeNotifier.getChangeType() != 1) {
            ServerCluster serverCluster = (ServerCluster)this.loadRootObject(string);
            String string4 = serverCluster.getNodeGroupName();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Obtained nodeGroupName of cluster = " + string4));
            }
            if (string4 != null && (oDCNode4 = oDCNode2.getNode(this.odc.nodeGroup, string4)) == null) {
                oDCNode4 = this.targetTree.createNode(string4, this.odc.nodeGroup, oDCNode2);
                this.readNodeGroup(oDCNode2, oDCNode4.getPath(), string4);
            }
        }
        if (oDCNode4 != null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Obtained nodeGroup ODCNode. name=." + oDCNode4.getName() + " path=" + oDCNode4.getPath()));
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("add cluster: " + string2 + "/" + string3));
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                oDCNode = this.readCluster(oDCNode2, string3);
                this.clusterAdded(oDCNode);
                if (oDCNode4 != null) {
                    oDCNode.addNode(oDCNode4);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("cluster created. name=" + oDCNode.getName() + " path = " + oDCNode.getPath()));
                }
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)("cluster children of type nodeGroup=" + oDCNode.childCount(this.odc.nodeGroup)));
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("mod cluster: " + string2 + "/" + string3));
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                if (oDCNode == null) {
                    oDCNode = this.readCluster(oDCNode2, string3);
                    this.clusterAdded(oDCNode);
                    if (oDCNode4 != null) {
                        oDCNode.addNode(oDCNode4);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cluster created. name=" + oDCNode.getName() + " path = " + oDCNode.getPath()));
                    }
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)("cluster children of type nodeGroup=" + oDCNode.childCount(this.odc.nodeGroup)));
                    break;
                }
                this.readCluster(oDCNode);
                this.clusterModified(oDCNode);
                if (!oDCNode.getProperty(this.odc.clusterType).equals("static")) break;
                oDCNode.addNode(oDCNode4);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("del cluster: " + string2 + "/" + string3));
                }
                if (oDCNode == null) break;
                this.clusterRemoved(oDCNode);
                oDCNode.remove();
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleClusterChange");
        }
    }

    protected void clusterAdded(ODCNode oDCNode) throws Exception {
    }

    protected void clusterModified(ODCNode oDCNode) throws Exception {
    }

    protected void clusterRemoved(ODCNode oDCNode) throws Exception {
    }

    protected void handleNodeChange(ConfigChangeNotifier configChangeNotifier) throws Exception {
        ODCNode oDCNode;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"handleNodeChange", (Object)configChangeNotifier);
        }
        String string = configChangeNotifier.getUri();
        String[] stringArray = string.split("/");
        String string2 = null;
        String string3 = null;
        if (stringArray.length > 3 && stringArray[0].equalsIgnoreCase("cells") && stringArray[2].equalsIgnoreCase("nodes")) {
            string2 = stringArray[1];
            string3 = stringArray[3];
        }
        if (string2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleNodeChange: cellName is ", string2);
            }
            return;
        }
        if (string3 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleNodeChange: nodeName is ", string3);
            }
            return;
        }
        if (!this.shouldReadNode(string2, string3)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"handleNodeChange", (Object)"ignore change");
            }
            return;
        }
        ODCNode oDCNode2 = this.targetTree.getRoot().getNode(this.odc.cell, string2);
        ODCNode oDCNode3 = oDCNode = oDCNode2 != null ? oDCNode2.getNode(this.odc.node, string3) : null;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("cell=" + oDCNode2 + ", node=" + oDCNode));
        }
        switch (configChangeNotifier.getChangeType()) {
            case 0: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("add node: " + string2 + "/" + string3));
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                this.readNode(oDCNode2, string3);
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("mod cluster: " + string2 + "/" + string3));
                }
                if (oDCNode2 == null) {
                    this.readCell(this.targetTree.getRoot(), string2);
                    break;
                }
                if (oDCNode == null) {
                    this.readNode(oDCNode2, string3);
                    break;
                }
                Repository repository = this.getRepository(oDCNode2.getName(), string3, null);
                Node node = (Node)repository.getConfigRoot().getResource(3, "node.xml").getContents().get(0);
                this.initNode(repository, node, oDCNode);
                break;
            }
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("del cluster: " + string2 + "/" + string3));
                }
                if (oDCNode == null) break;
                oDCNode.remove();
                break;
            }
            default: {
                throw new IllegalStateException("unknown change type: " + configChangeNotifier.getChangeType());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleClusterChange");
        }
    }

    protected void handleAppNodeDeletion(ODCNode oDCNode) throws Exception {
        this.odcMyCell.removeNode(oDCNode);
    }

    protected void appOnServerChange(ODCNode oDCNode, ODCNode oDCNode2, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"appOnServerChange", (Object)new Object[]{oDCNode, oDCNode2, new Boolean(bl)});
        }
        try {
            ODCNode[] oDCNodeArray = oDCNode.getNodes(this.odc.webModule);
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                ODCNode oDCNode3 = oDCNodeArray[i];
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("webmodule=" + oDCNode3));
                }
                ODCNode[] oDCNodeArray2 = oDCNode3.getNodes(this.odc.cluster);
                for (int j = 0; j < oDCNodeArray2.length; ++j) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("cluster=" + oDCNodeArray2[j]));
                    }
                    ODCNode[] oDCNodeArray3 = oDCNodeArray2[j].getNodes(this.odc.server);
                    for (int k = 0; k < oDCNodeArray3.length; ++k) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("server=" + oDCNodeArray3[k]));
                        }
                        if (oDCNode2 != oDCNodeArray3[k]) continue;
                        if (bl) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("linking " + oDCNode2 + " to " + oDCNode3));
                            }
                            oDCNode2.addNode(oDCNode3);
                            continue;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("unlinking " + oDCNode2 + " from " + oDCNode3));
                        }
                        oDCNode2.removeNode(oDCNode3);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "appOnServerChange", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"appOnServerChange");
        }
    }

    protected void setServerPropsByCluster(ODCNode oDCNode, ClusterMember clusterMember) throws ODCException {
        String string = "";
        if (clusterMember.getUniqueId() != null) {
            string = EncodeCloneID.encodeString((String)clusterMember.getUniqueId());
        }
        oDCNode.setProperty(this.odc.serverCloneId, string);
        Integer n = new Integer(clusterMember.getWeight());
        this.setServerUpWeight(oDCNode, n);
        if (oDCNode.getProperty(this.odc.serverState).equals("STARTED")) {
            oDCNode.setProperty(this.odc.serverWeight, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer getServerUpWeight(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerUpWeight", (Object)oDCNode);
        }
        Integer n = null;
        HashMap hashMap = this.serverUpWeights;
        synchronized (hashMap) {
            n = (Integer)this.serverUpWeights.get(oDCNode.getPath());
            if (n == null) {
                n = DEFAULT_UP_WEIGHT;
                this.serverUpWeights.put(oDCNode.getPath(), n);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerUpWeight", (Object)n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setServerUpWeight(ODCNode oDCNode, Integer n) throws ODCException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setServerUpWeight: server=" + oDCNode + ",weight=" + n));
        }
        HashMap hashMap = this.serverUpWeights;
        synchronized (hashMap) {
            this.serverUpWeights.put(oDCNode.getPath(), n);
        }
    }

    public void addCustomProperties(EList eList, ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addCustomProperties", (Object)oDCNode);
        }
        ODCNodeType oDCNodeType = oDCNode.getType();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            try {
                ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl;
                String string = property.getName();
                String string2 = property.getValue();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("custom property: name=" + string + ", value=" + string2));
                }
                if ((oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCNodeType.getPropertyDescriptor(string)) != null) {
                    Object object = oDCPropertyDescriptorImpl.fromString(string2);
                    oDCNode.setProperty(oDCPropertyDescriptorImpl, object);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("unknown " + oDCNodeType + " custom property"));
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addCustomProperty", tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCustomProperties", (Object)oDCNode);
        }
    }

    public static String getCustomValue(EList eList, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCustomValue", (Object)string);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            String string2 = property.getName();
            if (!string2.equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getCustomValue", (Object)property.getValue());
            }
            return property.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCustomValue", (Object)"null");
        }
        return null;
    }

    protected String getEARPath(ODCNode oDCNode, String string) throws Exception {
        ConfigRoot configRoot;
        String string2;
        String string3;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"getEARPath", (Object)string);
            }
            string3 = null;
            string2 = string + ".ear";
            Repository repository = this.getRepository(oDCNode.getName(), null, null);
            configRoot = repository.getConfigRoot();
            configRoot.setValue(1, string2);
            String string4 = "deployments" + SEP + string;
            String string5 = string4 + SEP + "deployment.xml";
            try {
                Deployment deployment = (Deployment)configRoot.getResource(1, string5).getContents().get(0);
                ApplicationDeployment applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
                string3 = applicationDeployment.isUseMetadataFromBinaries() ? applicationDeployment.getBinariesURL() : configRoot.getAbsolutePath(1, "") + SEP + string4;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"failed to read app through deployments", (Object)throwable);
            }
        }
        if (string3 == null) {
            string3 = configRoot.getAbsolutePath(1, "") + SEP + string2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEARPath", string3);
        }
        return string3;
    }

    protected EARFile getEAR(String string) throws Exception {
        return this.getEAR(string, false);
    }

    protected EARFile getEAR(String string, boolean bl) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getEAR", (Object)string);
        }
        CommonarchiveFactory commonarchiveFactory = (CommonarchiveFactory)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore").getEFactoryInstance();
        ArchiveOptions archiveOptions = new ArchiveOptions();
        archiveOptions.setIsReadOnly(true);
        archiveOptions.setUseJavaReflection(bl);
        EARFile eARFile = commonarchiveFactory.openEARFile(archiveOptions, string);
        eARFile.getDeploymentDescriptor();
        eARFile.getBindings();
        eARFile.getExtensions();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEAR", (Object)eARFile);
        }
        return eARFile;
    }

    protected Set getNodes(ODCNode oDCNode, ODCNodeType oDCNodeType) throws ODCException {
        HashSet<ODCNode> hashSet = new HashSet<ODCNode>();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            hashSet.add(oDCNodeArray[i]);
        }
        return hashSet;
    }

    protected List getNames(ODCNode oDCNode, ODCNodeType oDCNodeType) throws ODCException {
        LinkedList<String> linkedList = new LinkedList<String>();
        ODCNode[] oDCNodeArray = oDCNode.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            linkedList.add(oDCNodeArray[i].getName());
        }
        return linkedList;
    }

    public void chainInitialized(ChainData chainData) {
    }

    public void chainStarted(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chainStarted", (Object)new Object[]{chainData});
        }
        try {
            ServiceHandle serviceHandle = ServiceHandle.obtain(ChannelFrameworkService.class);
            if (serviceHandle != null) {
                ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)serviceHandle.getService();
                CFEndPoint cFEndPoint = channelFrameworkService.getEndPoint(chainData.getName());
                serviceHandle.release();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CFEndPoint=", (Object)cFEndPoint);
                }
                if (cFEndPoint != null) {
                    this.addChannelChain(this.odcMyServer, cFEndPoint);
                }
            }
        }
        catch (ChainNotInboundException chainNotInboundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("chain not inbound: " + (Object)((Object)chainNotInboundException)));
            }
        }
        catch (NoCFEndPointException noCFEndPointException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("no CF endpoint: " + (Object)((Object)noCFEndPointException)));
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "chainStarted", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chainStarted ");
        }
    }

    public void chainStopped(ChainData chainData) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"chainStopped", (Object)new Object[]{chainData});
        }
        try {
            ServiceHandle serviceHandle = ServiceHandle.obtain(ChannelFrameworkService.class);
            if (serviceHandle != null) {
                ChannelFrameworkService channelFrameworkService = (ChannelFrameworkService)serviceHandle.getService();
                CFEndPoint cFEndPoint = channelFrameworkService.getEndPoint(chainData.getName());
                serviceHandle.release();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"returned CFEndPoint:", (Object)cFEndPoint);
                }
                if (cFEndPoint != null) {
                    this.removeChannelChain(this.odcMyServer, cFEndPoint);
                }
            }
        }
        catch (ChainNotInboundException chainNotInboundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("chain not inbound: " + (Object)((Object)chainNotInboundException)));
            }
        }
        catch (NoCFEndPointException noCFEndPointException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("no CF endpoint: " + (Object)((Object)noCFEndPointException)));
            }
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "chainStopped", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"chainStopped ");
        }
    }

    public void chainUpdated(ChainData chainData) {
    }

    public void chainDestroyed(ChainData chainData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addChannelChain(ODCNode oDCNode, CFEndPoint cFEndPoint) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addChannelChain", (Object)new Object[]{oDCNode, cFEndPoint});
        }
        if (this.chainExcludes.contains(cFEndPoint.getName())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addChannelChain", (Object)"chain excluded");
            }
            return;
        }
        if (this.vhostExcludes.contains(cFEndPoint.getVhost())) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"addChannelChain", (Object)"vhost excluded");
            }
            return;
        }
        String string = this.getTransportName(cFEndPoint);
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.addChannelChain");
            try {
                ODCNode oDCNode2 = this.targetTree.createNode(string, this.odc.transport, oDCNode, cFEndPoint.isLocal());
                oDCNode2.setProperty(this.odc.transportProtocol, cFEndPoint.isSSLEnabled() ? "https" : "http");
                oDCNode2.setProperty(this.odc.transportHost, cFEndPoint.getAddress().getHostName());
                oDCNode2.setIntProperty(this.odc.transportPort, cFEndPoint.getPort());
                ODCNode oDCNode3 = this.targetTree.createNode(cFEndPoint.getName(), this.odc.channelChain, oDCNode2, cFEndPoint.isLocal());
                oDCNode3.setProperty(this.odc.channelChainCFEndpoint, cFEndPoint);
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "addChannelChain", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addChannelChain");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeChannelChain(ODCNode oDCNode, CFEndPoint cFEndPoint) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeChannelChain", (Object)new Object[]{oDCNode, cFEndPoint});
        }
        String string = this.getTransportName(cFEndPoint);
        ODCTreeImpl oDCTreeImpl = this.targetTree;
        synchronized (oDCTreeImpl) {
            this.targetTree.beginTransaction("TreeBuilder.removeChannelChain");
            try {
                ODCNode oDCNode2 = oDCNode.getNode(this.odc.transport, string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("transport=" + oDCNode2));
                }
                if (oDCNode2 != null) {
                    ODCNode oDCNode3 = oDCNode2.getNode(this.odc.channelChain, cFEndPoint.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("chain=" + oDCNode3));
                    }
                    if (oDCNode3 != null) {
                        oDCNode3.remove();
                    }
                }
                this.targetTree.commitTransaction();
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "removeChannelChain", tc);
                this.targetTree.rollbackTransaction();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeChannelChain");
        }
    }

    protected String getTransportName(CFEndPoint cFEndPoint) {
        String string = Integer.toString(cFEndPoint.getPort());
        if (cFEndPoint.isLocal()) {
            string = string + "#local";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("transportName=" + string));
        }
        return string;
    }

    protected boolean serverAppStateChange(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serverAppStateChange", (Object)new Object[]{string, string2});
        }
        if (!string2.equals("STARTING") && !string2.equals("STARTED") && ApplicationQuiescer.isQuiesceState(string)) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"serverAppStateChange", (Object)"no change");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serverAppStateChange", (Object)"change");
        }
        return true;
    }

    protected void setWebModuleProtocolMap(ODCNode oDCNode, String string) throws Exception {
        oDCNode.setProperty(this.odc.webModuleProtocolMap, this.getProtocolMap(string));
    }

    public Object getProtocolMap(String string) {
        if (string == null || string.equalsIgnoreCase("ClientProtocol")) {
            return this.sslDirect;
        }
        if (string.equalsIgnoreCase("HTTP")) {
            return this.sslOffLoad;
        }
        if (string.equalsIgnoreCase("HTTPS")) {
            return this.sslOnLoad;
        }
        return this.sslDirect;
    }

    protected void initSet(String string, Set set) {
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            set.add(stringArray[i]);
        }
    }

    protected static String normalizeContextRoot(String string) {
        if (string == null) {
            return "/";
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected String getAppNameOfActiveEdition(String string, String string2, String string3) throws Exception {
        List list = this.getDeployedApplicationEditions(string, string2, string3);
        String string4 = EditionHelper.getActiveEditionOnServer((String)string3, (List)list);
        String string5 = EditionHelper.getCompositeName((String)string3, (String)string4);
        return string5;
    }

    protected List getDeployedApplicationEditions(String string, String string2, String string3) throws Exception {
        Object object;
        Repository repository = this.getRepository(this.odcMyCell.getName(), string, string2);
        ServerIndex serverIndex = (ServerIndex)repository.getConfigRoot().getResource(3, "serverindex.xml").getContents().get(0);
        String string4 = serverIndex.getHostName();
        if (string4 == null) {
            string4 = string;
        }
        Object object2 = null;
        Iterator iterator = serverIndex.getServerEntries().iterator();
        while (iterator.hasNext()) {
            object = (ServerEntry)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("server entry for " + object.getServerName()));
            }
            if (!object.getServerName().equals(string2)) continue;
            object2 = object;
            break;
        }
        object = new ArrayList();
        if (object2 != null) {
            object = object2.getDeployedApplications();
        }
        return object;
    }

    protected ServerEntry getServerEntry(String string) throws Exception {
        Resource resource;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getServerEntry", (Object)string);
        }
        Repository repository = this.getRepository(this.myCellName, this.myNodeName, this.myServerName);
        try {
            resource = repository.getConfigRoot().getResource(3, string);
        }
        catch (Exception exception) {
            throw new ConfigurationWarning("Error loading " + string, (Throwable)exception);
        }
        EList eList = ((ServerIndex)resource.getContents().get(0)).getServerEntries();
        ServerEntry serverEntry = null;
        for (int i = 0; i < eList.size() && serverEntry == null; ++i) {
            ServerEntry serverEntry2 = (ServerEntry)eList.get(i);
            if (!serverEntry2.getServerName().equals(this.myServerName)) continue;
            serverEntry = serverEntry2;
        }
        if (serverEntry == null) {
            throw new ConfigurationWarning("Error loading server " + this.myServerName + " in " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getServerEntry", serverEntry);
        }
        return serverEntry;
    }

    protected boolean isSystemApp(String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSystemApp", (Object)string);
        }
        if (this.inDMgr) {
            ServerEntry serverEntry = this.getServerEntry("systemapps.xml");
            EList eList = serverEntry.getDeployedApplications();
            int n = eList.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)eList.get(i);
                if (!string.equals(string2 = this.getApplicationName(string2))) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"isSystemApp", (Object)"true");
                }
                return true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSystemApp", (Object)"false");
        }
        return false;
    }

    protected String getSystemAppDeploymentPath(Repository repository, String string) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getSystemAppDeploymentPath", (Object)string);
        }
        ServerEntry serverEntry = this.getServerEntry("systemapps.xml");
        EList eList = serverEntry.getDeployedApplications();
        String string2 = null;
        int n = eList.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)eList.get(i);
            String string4 = this.getApplicationName(string3);
            if (!string.equals(string4)) continue;
            string2 = this.expandVariable(string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getSystemAppDeploymentPath", string2);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String expandVariable(String string) throws IllegalArgumentException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"expandVariable", (Object)string);
        }
        VariableMap variableMap = null;
        String string2 = null;
        try {
            variableMap = (VariableMap)ServerServiceFinder.getServerService(VariableMap.class);
            string2 = variableMap != null ? variableMap.expand(string) : string;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"expandVariable", (Object)string2);
            }
            String string3 = string2;
            return string3;
        }
        finally {
            if (variableMap != null) {
                ServerServiceFinder.releaseServerService(variableMap);
            }
        }
    }

    protected String getApplicationName(String string) {
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        return string2.substring(0, string2.lastIndexOf(".ear"));
    }

    protected boolean isApplicationsDirName(String string) {
        return string.equals("applications") || string.equals("systemApps");
    }

    protected void readNodeGroup(ODCNode oDCNode, String string, String string2) throws Exception {
    }

    protected void readCellXml(ODCNode oDCNode) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"readCellXml", (Object)oDCNode);
        }
        Repository repository = this.getRepository(oDCNode.getName(), null, null);
        Cell cell = (Cell)repository.getConfigRoot().getResource(0, "cell.xml").getContents().get(0);
        this.initCell(cell, oDCNode);
        oDCNode.setBooleanProperty(this.odc.cellIsWebSphere, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readCellXml", (Object)oDCNode);
        }
    }

    protected boolean shouldReadNode(String string, String string2) throws Exception {
        if (!string.equals(this.myCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"don't read node: not my cell");
            }
            return false;
        }
        if (this.ownsConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read node: config owner");
            }
            return true;
        }
        if (!string2.equals(this.myNodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"don't read node: not my node");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"read node: my node");
        }
        return true;
    }

    protected boolean shouldReadServer(String string, String string2, String string3) throws Exception {
        if (!string.equals(this.myCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"don't read server: not my cell");
            }
            return false;
        }
        if (this.ownsConfig) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"read server: config owner");
            }
            return true;
        }
        if (!string2.equals(this.myNodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"don't read server: not my node");
            }
            return false;
        }
        if (!string3.equals(this.myServerName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"don't read server: not my server");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"read server: my server");
        }
        return true;
    }

    protected boolean isMyCell(String string) throws Exception {
        if (!string.equals(this.myCellName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"not my cell");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"is my cell");
        }
        return true;
    }

    protected boolean isMyNode(String string, String string2) throws Exception {
        if (!this.isMyCell(string)) {
            return false;
        }
        if (!string2.equals(this.myNodeName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"not my node");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"is my node");
        }
        return true;
    }

    protected boolean isMyServer(String string, String string2, String string3) throws Exception {
        if (!this.isMyNode(string, string2)) {
            return false;
        }
        if (!string3.equals(this.myServerName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"not my server");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"is my server");
        }
        return true;
    }

    protected Object loadRootObject(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"loadRootObject", (Object)string);
        }
        Object object = null;
        try {
            DocumentContentSource documentContentSource = ConfigRepositoryFactory.getConfigRepository().extract(string);
            if (documentContentSource != null) {
                WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
                URI uRI = URI.createFileURI((String)documentContentSource.getDocument().getURI());
                Resource resource = wASResourceSetImpl.createResource(uRI);
                resource.load(documentContentSource.getSource(), new HashMap());
                object = resource.getContents().get(0);
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("SPTreeBuilder::loadRootObject:: Exception caught loading URI " + string + ". Exception " + exception.getClass().getName() + " " + exception.getMessage()));
            }
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.odc.sp.SPTreeBuilder", (String)"598", null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"loadRootObject", object);
        }
        return object;
    }

    protected Resource getResource(ConfigRoot configRoot, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResource");
        }
        Resource resource = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.ibm.ws.runtime.service.ConfigRootImpl");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.debug((TraceComponent)tc, (String)classNotFoundException.toString(), (Object)classNotFoundException);
        }
        Class[] classArray = new Class[]{String.class};
        Object[] objectArray = new Object[]{string};
        try {
            Method method = clazz.getMethod("getResourceAbsolute", classArray);
            resource = (Resource)method.invoke((Object)configRoot, objectArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Tr.debug((TraceComponent)tc, (String)noSuchMethodException.toString(), (Object)noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.debug((TraceComponent)tc, (String)illegalAccessException.toString(), (Object)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.debug((TraceComponent)tc, (String)invocationTargetException.toString(), (Object)invocationTargetException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResource");
        }
        return resource;
    }

    static {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        isZos = platformHelper.isZOS();
        isZosServantOrCRA = platformHelper.isZOS() && (platformHelper.isServantJvm() || platformHelper.isCRAJvm());
        TreeBuilder.platformHelper = PlatformHelperFactory.getPlatformHelper();
    }

    protected class AppChange {
        public final String appName;
        public final int change;

        public AppChange(String string, int n) {
            this.appName = string;
            this.change = n;
        }

        public boolean equals(Object object) {
            AppChange appChange = (AppChange)object;
            return this.appName.equals(appChange.appName) && this.change == appChange.change;
        }

        public String toString() {
            switch (this.change) {
                case 0: {
                    return "app doc added for app " + this.appName;
                }
                case 2: {
                    return "app doc modified for app " + this.appName;
                }
                case 1: {
                    return "app doc deleted for app " + this.appName;
                }
            }
            return "unknown change to application " + this.appName;
        }
    }
}

