/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeImpl;
import com.ibm.ws.odc.ODCEventEdgeChangeImpl;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.ODCEventNodeChangeImpl;
import com.ibm.ws.odc.ODCEventSetPropertyImpl;
import com.ibm.ws.odc.ODCManagerImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.bb.BBTree;
import com.ibm.ws.odc.util.DoPrivUtil;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.wsspi.odc.ODCEdge;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEvent;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCEventNodeChange;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCListener;
import com.ibm.wsspi.odc.ODCManager;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCTransaction;
import com.ibm.wsspi.odc.ODCTransactionListener;
import com.ibm.wsspi.odc.ODCTree;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ODCTreeImpl
implements ODCTree {
    private static final TraceComponent tc = TrUtil.register(ODCTreeImpl.class);
    private static final TraceComponent tcSave = Save.access$000();
    private static final ODCListener[] nullODCListenerArray = new ODCListener[0];
    private static final ODCEvent[] nullEventArray = new ODCEvent[0];
    private static final ODCNode[] nullNodeArray = new ODCNodeImpl[0];
    private static final ODCEdge[] nullEdgeArray = new ODCEdgeImpl[0];
    public final ODCManagerImpl mgr;
    private final String name;
    private final ODCNodeImpl root;
    private final Map nodeMap = new LinkedHashMap();
    private final Map edgeMap = new LinkedHashMap();
    private final List listeners = new LinkedList();
    private final List consumers = new LinkedList();
    private boolean running;
    private File file;
    private BBTree bbTree = null;
    private final List transactionStack = new ArrayList();
    private boolean currentlyCancelingTransactions = false;
    private long generationNumber = 0L;
    static /* synthetic */ Class class$com$ibm$ws$odc$ODCTreeImpl$Save;

    public ODCTreeImpl(ODCManagerImpl oDCManagerImpl, String string, ODCNodeType oDCNodeType) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"ODCTreeImpl", (Object)string);
        }
        this.mgr = oDCManagerImpl;
        this.name = string;
        this.root = new ODCNodeImpl(string, oDCNodeType, this);
        this.nodeMap.put(this.root.getPath(), this.root);
        this.root.obtainRef(true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ODCTreeImpl");
        }
    }

    public long getGenerationNumber() {
        return this.generationNumber;
    }

    public ODCEvent[] getEvents(boolean bl) {
        ArrayList arrayList = new ArrayList();
        this.root.getEvents(bl, arrayList);
        return arrayList.toArray(nullEventArray);
    }

    public synchronized void performEvents(String string, ODCEvent[] oDCEventArray) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performEvents", (Object)string);
        }
        this.beginTransaction(string);
        try {
            for (int i = 0; i < oDCEventArray.length; ++i) {
                Object object;
                ODCEventImpl oDCEventImpl;
                ODCEventImpl oDCEventImpl2 = (ODCEventImpl)oDCEventArray[i];
                oDCEventImpl2.setGenerationNumber(this.generationNumber);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("event=" + oDCEventImpl2));
                }
                if (oDCEventImpl2 instanceof ODCEventEdgeChange) {
                    oDCEventImpl = (ODCEventEdgeChangeImpl)oDCEventImpl2;
                    object = ((ODCEventEdgeChangeImpl)oDCEventImpl).getEdge();
                    if (((ODCEventEdgeChangeImpl)oDCEventImpl).isAdd()) {
                        this.obtainEdge(((ODCEventEdgeChangeImpl)oDCEventImpl).serEdgePath, ((ODCEventEdgeChangeImpl)oDCEventImpl).serParentPath, ((ODCEventEdgeChangeImpl)oDCEventImpl).serChildPath, oDCEventImpl.isLocal(), oDCEventImpl.getAttachment());
                        continue;
                    }
                    this.releaseEdge(((ODCEventEdgeChangeImpl)oDCEventImpl).serEdgePath, oDCEventImpl.isLocal(), oDCEventImpl.getAttachment());
                    continue;
                }
                if (oDCEventImpl2 instanceof ODCEventNodeChange) {
                    oDCEventImpl = (ODCEventNodeChangeImpl)oDCEventImpl2;
                    if (((ODCEventNodeChangeImpl)oDCEventImpl).isAdd()) {
                        object = this.obtainNode(((ODCEventNodeChangeImpl)oDCEventImpl).serNodeName, ((ODCEventNodeChangeImpl)oDCEventImpl).serTypeName, ((ODCEventNodeChangeImpl)oDCEventImpl).serNodePath, ((ODCEventNodeChangeImpl)oDCEventImpl).serParentPath, oDCEventImpl.isLocal(), oDCEventImpl.getAttachment());
                        if (object != null || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"obtaineNode returns null");
                        continue;
                    }
                    this.releaseNode(((ODCEventNodeChangeImpl)oDCEventImpl).serNodePath, oDCEventImpl.isLocal(), oDCEventImpl.getAttachment());
                    continue;
                }
                if (oDCEventImpl2 instanceof ODCEventSetProperty) {
                    oDCEventImpl = (ODCEventSetPropertyImpl)oDCEventImpl2;
                    object = (ODCPropertyDescriptorImpl)this.mgr.findNodeType(((ODCEventSetPropertyImpl)oDCEventImpl).serPropertyTypeName).findPropertyDescriptor(((ODCEventSetPropertyImpl)oDCEventImpl).serPropertyName);
                    oDCEventImpl.setEventType((ODCEventType)object);
                    ODCNode oDCNode = this.obtainNode(((ODCEventSetPropertyImpl)oDCEventImpl).serNodeName, ((ODCEventSetPropertyImpl)oDCEventImpl).serTypeName, ((ODCEventSetPropertyImpl)oDCEventImpl).serNodePath, ((ODCEventSetPropertyImpl)oDCEventImpl).serParentPath, oDCEventImpl.isLocal(), oDCEventImpl.getAttachment());
                    if (oDCNode == null) {
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"obtaineNode returned null.");
                        continue;
                    }
                    ((ODCEventSetPropertyImpl)oDCEventImpl).setNode(oDCNode);
                    ((ODCNodeImpl)oDCNode).setProperty((ODCEventSetProperty)((Object)oDCEventImpl));
                    if (oDCNode.isLocal() || this.bbTree == null || !((ODCPropertyDescriptorImpl)object).global) continue;
                    this.bbTree.setProperty(oDCNode, ((ODCPropertyDescriptorImpl)object).name, ((ODCEventSetPropertyImpl)oDCEventImpl).getNewValue());
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Set Property on BBTree.");
                    }
                    if (this.isInTransaction()) continue;
                    this.bbTree.post();
                    continue;
                }
                throw new ODCException("unsupported event type: " + oDCEventImpl2.getClass().getName());
            }
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "performTransaction", tc);
            this.rollbackTransaction();
            if (throwable instanceof ODCException) {
                throw (ODCException)((Object)throwable);
            }
            throw new ODCException(throwable);
        }
    }

    public synchronized ODCNode refreshNode(ODCNode oDCNode) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"refreshNode", (Object)oDCNode);
        }
        if (oDCNode != null && oDCNode.getTree() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attempting to refresh node");
            }
            oDCNode = this.getNode(oDCNode.getPath());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"refreshNode", (Object)oDCNode);
        }
        return oDCNode;
    }

    public void setBBTree(BBTree bBTree) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setBBTree: " + bBTree));
        }
        this.bbTree = bBTree;
    }

    public ODCNodeImpl[] getAllNodes() {
        return (ODCNodeImpl[])this.nodeMap.values().toArray(nullNodeArray);
    }

    public ODCEdgeImpl[] getAllEdges() {
        return (ODCEdgeImpl[])this.edgeMap.values().toArray(nullEdgeArray);
    }

    public synchronized ODCNode createNode(String string, ODCNodeType oDCNodeType, ODCNode oDCNode) throws ODCException {
        return this.createNode(string, oDCNodeType, oDCNode, false);
    }

    public synchronized ODCNode createNode(String string, ODCNodeType oDCNodeType, ODCNode oDCNode, boolean bl) throws ODCException {
        String string2;
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createNode", (Object)new Object[]{string, oDCNodeType, oDCNode, new Boolean(bl)});
        }
        if ((oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string2 = this.makeNodePath(string, oDCNodeType.getName(), oDCNode.getPath()))) == null) {
            oDCNodeImpl = new ODCNodeImpl(string, oDCNodeType, oDCNode, bl);
            this.nodeMap.put(string2, oDCNodeImpl);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("created node (local): " + oDCNodeImpl));
            }
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(true, oDCNodeImpl, true);
            this.notifyListeners(oDCEventNodeChangeImpl);
        }
        oDCNodeImpl.obtainRef(true);
        this.obtainEdge((ODCNodeImpl)oDCNode, oDCNodeImpl);
        if (!bl && this.bbTree != null) {
            this.bbTree.addNode(oDCNodeImpl);
            if (!this.isInTransaction()) {
                this.bbTree.post();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createNode", (Object)oDCNodeImpl);
        }
        return oDCNodeImpl;
    }

    public ODCNode obtainNode(String string, String string2, String string3, String string4) throws ODCException {
        return this.obtainNode(string, string2, string3, string4, false, null);
    }

    public synchronized ODCNode obtainNode(String string, String string2, String string3, String string4, boolean bl, Object object) throws ODCException {
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"obtainNode", (Object)new Object[]{string, string2, string3, string4});
        }
        if ((oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string3)) == null) {
            ODCNodeType oDCNodeType = this.mgr.findNodeType(string2);
            ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)this.nodeMap.get(string4);
            if (oDCNodeImpl2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"obtainNode", (Object)("parent node not found: " + string4));
                }
                return null;
            }
            oDCNodeImpl = new ODCNodeImpl(string, oDCNodeType, oDCNodeImpl2, false);
            this.nodeMap.put(string3, oDCNodeImpl);
            oDCNodeImpl.setTree(this);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("created node (local2) " + oDCNodeImpl));
            }
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(true, oDCNodeImpl, bl);
            if (object != null) {
                oDCEventNodeChangeImpl.setAttachment(object);
                if (!oDCNodeImpl.isLocal() && this.bbTree != null) {
                    this.bbTree.addNode(oDCNodeImpl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Added Node to BBTree for posting.");
                    }
                    if (!this.isInTransaction()) {
                        this.bbTree.post();
                    }
                }
            }
            this.notifyListeners(oDCEventNodeChangeImpl);
        }
        oDCNodeImpl.obtainRef(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainNode", (Object)oDCNodeImpl);
        }
        return oDCNodeImpl;
    }

    public synchronized void releaseNode(ODCNode oDCNode, boolean bl) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseNode", (Object)new Object[]{oDCNode, new Boolean(bl), "local"});
        }
        if (oDCNode == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releaseNode", (Object)"null");
            }
            return;
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        if (bl || oDCNodeImpl.releaseRef(true)) {
            this.nodeMap.remove(oDCNodeImpl.getPath());
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unregistered node (local): " + oDCNodeImpl));
            }
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(false, oDCNode, true);
            this.notifyListeners(oDCEventNodeChangeImpl);
            oDCNodeImpl.setTree(null);
        }
        if (!oDCNode.isLocal() && this.bbTree != null) {
            this.bbTree.removeNode(oDCNode);
            if (!this.isInTransaction()) {
                this.bbTree.post();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseNode", (Object)oDCNode);
        }
    }

    public void releaseNode(String string) throws ODCException {
        this.releaseNode(string, false, null);
    }

    public synchronized void releaseNode(String string, boolean bl, Object object) throws ODCException {
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseNode", (Object)new Object[]{string, new Boolean(bl)});
        }
        if ((oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string)) != null && oDCNodeImpl.releaseRef(bl)) {
            this.nodeMap.remove(string);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("unregistered node (remote): " + oDCNodeImpl));
            }
            ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(false, oDCNodeImpl, bl);
            if (object != null) {
                oDCEventNodeChangeImpl.setAttachment(object);
                if (!oDCNodeImpl.isLocal() && this.bbTree != null) {
                    this.bbTree.removeNode(oDCNodeImpl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Released Node from BBTree.");
                    }
                    if (!this.isInTransaction()) {
                        this.bbTree.post();
                    }
                }
            }
            this.notifyListeners(oDCEventNodeChangeImpl);
            oDCNodeImpl.setTree(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseNode", (Object)oDCNodeImpl);
        }
    }

    public synchronized ODCEdge obtainEdge(ODCNode oDCNode, ODCNode oDCNode2) throws ODCException {
        boolean bl;
        String string;
        ODCEdgeImpl oDCEdgeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"obtainEdge", (Object)new Object[]{oDCNode, oDCNode2, "local"});
        }
        if ((oDCEdgeImpl = (ODCEdgeImpl)this.edgeMap.get(string = Util.makeEdgeLongName(oDCNode, oDCNode2))) == null) {
            ODCEdgeType oDCEdgeType = oDCNode.getType().findEdgeType(oDCNode2.getType());
            oDCEdgeImpl = new ODCEdgeImpl(string, oDCNode, oDCNode2, oDCEdgeType);
            this.edgeMap.put(string, oDCEdgeImpl);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("created edge (local): " + oDCEdgeImpl));
            }
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(true, oDCEdgeImpl, true);
            ((ODCNodeImpl)oDCNode).addEdge((ODCNodeImpl)oDCNode2);
            this.notifyListeners(oDCEventEdgeChangeImpl);
        }
        oDCEdgeImpl.obtainRef(true);
        boolean bl2 = bl = oDCNode.isLocal() || oDCNode2.isLocal();
        if (!bl && this.bbTree != null) {
            this.bbTree.addEdge(oDCEdgeImpl);
            if (!this.isInTransaction()) {
                this.bbTree.post();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainEdge", (Object)oDCEdgeImpl);
        }
        return oDCEdgeImpl;
    }

    public ODCEdge obtainEdge(String string, String string2, String string3) throws ODCException {
        return this.obtainEdge(string, string2, string3, false, null);
    }

    public synchronized ODCEdge obtainEdge(String string, String string2, String string3, boolean bl, Object object) throws ODCException {
        ODCEdgeImpl oDCEdgeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"obtainEdge", (Object)new Object[]{string, string2, string3, new Boolean(bl)});
        }
        if ((oDCEdgeImpl = (ODCEdgeImpl)this.edgeMap.get(string)) == null) {
            ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string2);
            ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)this.nodeMap.get(string3);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("parent = " + oDCNodeImpl + "; child = " + oDCNodeImpl2));
            }
            if (oDCNodeImpl == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"obtainEdge", (Object)"parent not found");
                }
                return null;
            }
            if (oDCNodeImpl2 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"obtainEdge", (Object)"child of edge not found");
                }
                return null;
            }
            ODCEdgeType oDCEdgeType = oDCNodeImpl.getType().findEdgeType(oDCNodeImpl2.getType());
            oDCEdgeImpl = new ODCEdgeImpl(string, oDCNodeImpl, oDCNodeImpl2, oDCEdgeType);
            this.edgeMap.put(string, oDCEdgeImpl);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("created edge " + (bl ? "(local): " : "(remote): ") + oDCEdgeImpl));
            }
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(true, oDCEdgeImpl, bl);
            if (object != null) {
                boolean bl2;
                oDCEventEdgeChangeImpl.setAttachment(object);
                boolean bl3 = bl2 = oDCNodeImpl.isLocal() || oDCNodeImpl2.isLocal();
                if (!bl2 && this.bbTree != null) {
                    this.bbTree.addEdge(oDCEdgeImpl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Added edge to BBTree for posting.");
                    }
                    if (!this.isInTransaction()) {
                        this.bbTree.post();
                    }
                }
            }
            oDCNodeImpl.addEdge(oDCNodeImpl2);
            this.notifyListeners(oDCEventEdgeChangeImpl);
        }
        oDCEdgeImpl.obtainRef(bl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"obtainEdge", (Object)oDCEdgeImpl);
        }
        return oDCEdgeImpl;
    }

    public synchronized void releaseEdge(ODCNode oDCNode, ODCNode oDCNode2, boolean bl) throws ODCException {
        boolean bl2;
        String string;
        ODCEdgeImpl oDCEdgeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseEdge", (Object)new Object[]{oDCNode, oDCNode2});
        }
        if ((oDCEdgeImpl = (ODCEdgeImpl)this.edgeMap.get(string = Util.makeEdgeLongName(oDCNode, oDCNode2))) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releaseEdge", (Object)"not found");
            }
            return;
        }
        if (bl || oDCEdgeImpl.releaseRef(true)) {
            this.edgeMap.remove(string);
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(false, oDCEdgeImpl, true);
            this.notifyListeners(oDCEventEdgeChangeImpl);
            ((ODCNodeImpl)oDCNode).removeEdge((ODCNodeImpl)oDCNode2);
        }
        boolean bl3 = bl2 = oDCNode.isLocal() || oDCNode2.isLocal();
        if (!bl2 && this.bbTree != null) {
            this.bbTree.removeEdge(oDCEdgeImpl);
            if (!this.isInTransaction()) {
                this.bbTree.post();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseEdge", (Object)oDCEdgeImpl);
        }
    }

    public void releaseEdge(String string) throws ODCException {
        this.releaseEdge(string, false, null);
    }

    public synchronized void releaseEdge(String string, boolean bl, Object object) throws ODCException {
        ODCEdgeImpl oDCEdgeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseEdge", (Object)string);
        }
        if ((oDCEdgeImpl = (ODCEdgeImpl)this.edgeMap.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releaseEdge", (Object)"not found");
            }
            return;
        }
        if (oDCEdgeImpl.releaseRef(bl)) {
            this.edgeMap.remove(string);
            ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCEdgeImpl.getSrcNode();
            ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)oDCEdgeImpl.getDstNode();
            ODCEventEdgeChangeImpl oDCEventEdgeChangeImpl = new ODCEventEdgeChangeImpl(false, oDCEdgeImpl, bl);
            if (object != null) {
                boolean bl2;
                oDCEventEdgeChangeImpl.setAttachment(object);
                boolean bl3 = bl2 = oDCNodeImpl.isLocal() || oDCNodeImpl2.isLocal();
                if (!bl2 && this.bbTree != null) {
                    this.bbTree.removeEdge(oDCEdgeImpl);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Removed edge from BBTree.");
                    }
                    if (!this.isInTransaction()) {
                        this.bbTree.post();
                    }
                }
            }
            this.notifyListeners(oDCEventEdgeChangeImpl);
            oDCNodeImpl.removeEdge(oDCNodeImpl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseEdge", (Object)oDCEdgeImpl);
        }
    }

    public void setProperty(ODCNode oDCNode, ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl, Object object) throws ODCException {
        this.setProperty(oDCNode, oDCPropertyDescriptorImpl, object, true);
    }

    public synchronized void setProperty(ODCNode oDCNode, ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl, Object object, boolean bl) throws ODCException {
        ((ODCNodeImpl)oDCNode).obtainRef(bl);
        if (!oDCNode.isLocal() && this.bbTree != null && oDCPropertyDescriptorImpl.global) {
            this.bbTree.setProperty(oDCNode, oDCPropertyDescriptorImpl.name, object);
            if (!this.isInTransaction()) {
                this.bbTree.post();
            }
        }
    }

    public String makeNodePath(String string, String string2, String string3) throws ODCException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3).append("/").append(string2).append("/").append(string);
        return stringBuffer.toString();
    }

    private boolean isInTransaction() throws ODCException {
        return this.transactionStack.size() > 0;
    }

    public ODCNode getRoot() {
        return this.root;
    }

    public ODCManager getManager() {
        return this.mgr;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
        this.flushToFile();
    }

    public String getName() {
        return this.name;
    }

    public void flushToFile() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"flushToFile");
        }
        if (!tcSave.isDebugEnabled()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flushToFile", (Object)"debug is not enabled");
            }
            return;
        }
        if (this.file == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flushToFile", (Object)"no backing file");
            }
            return;
        }
        if (this.root == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"flushToFile", (Object)"no root");
            }
            return;
        }
        try {
            PrintStream printStream = new PrintStream(DoPrivUtil.getOutputStream(this.file));
            this.root.print(printStream, this.file.getParentFile());
            printStream.close();
        }
        catch (IOException iOException) {
            TrUtil.warning(iOException, this, "flushToFile", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushToFile");
        }
    }

    public void print(PrintStream printStream) throws ODCException, IOException {
        this.root.print(printStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ODCListener oDCListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addListener", (Object)oDCListener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(oDCListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addListener");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ODCListener oDCListener) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeListener", (Object)oDCListener);
        }
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(oDCListener);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeListener");
        }
    }

    public synchronized void performTransaction(ODCTransaction oDCTransaction, Object object) throws ODCException {
        this.beginTransaction(oDCTransaction.getClass().getName());
        try {
            oDCTransaction.performODCTransaction(object);
            this.commitTransaction();
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, this, "performTransaction", tc);
            this.rollbackTransaction();
            if (throwable instanceof ODCException) {
                throw (ODCException)((Object)throwable);
            }
            throw new ODCException(throwable);
        }
    }

    public void beginTransaction(String string) {
        Transaction transaction = new Transaction(string, ++this.generationNumber);
        this.transactionStack.add(transaction);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("BEGIN TRANSACTION: " + transaction));
        }
    }

    public void commitTransaction() throws ODCException {
        ODCListener[] oDCListenerArray;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"commitTransaction");
        }
        Transaction transaction = this.popTransaction();
        Transaction transaction2 = this.topTransaction();
        if (transaction2 != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("NESTED COMMIT TRANSACTION: " + transaction.name + " to " + transaction2.name));
            }
            for (int i = 0; i < transaction.events.size(); ++i) {
                transaction2.events.add(transaction.events.get(i));
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"commitTransaction", (Object)"returned to enclosing transaction");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("COMMIT TRANSACTION: " + transaction));
        }
        this.flushToFile();
        Iterator iterator = transaction.events.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof ODCEventSetProperty) || (oDCListenerArray = (ODCListener[])object).getNode().getTree() != null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("node removed; ignoring event: " + object));
            }
            iterator.remove();
        }
        object = transaction.events.toArray(nullEventArray);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TRANSACTION " + transaction.generationNumber + ": notifying listeners"));
        }
        oDCListenerArray = this.getListeners();
        for (int i = 0; i < oDCListenerArray.length; ++i) {
            ODCListener oDCListener = oDCListenerArray[i];
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("TRANSACTION " + transaction.generationNumber + ": begin notifying listener " + oDCListener));
            }
            if (oDCListener instanceof ODCTransactionListener) {
                try {
                    ((ODCTransactionListener)oDCListener).handleEvents((ODCEvent[])object);
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "commitTransaction", tc);
                }
            } else {
                for (int j = 0; j < ((E)object).length; ++j) {
                    Object e = object[j];
                    if (!this.isInterested(oDCListener, e.getEventType())) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("notify: listener=" + oDCListener + ", event=" + e));
                    }
                    try {
                        oDCListener.handleEvent((ODCEvent)e);
                        continue;
                    }
                    catch (Throwable throwable) {
                        TrUtil.warning(throwable, this, "commitTransaction", tc);
                    }
                }
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("TRANSACTION " + transaction.generationNumber + ": done notifying listener " + oDCListener));
        }
        if (this.bbTree != null) {
            this.bbTree.post();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"commitTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"rollbackTransaction");
        }
        Transaction transaction = this.popTransaction();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ROLLBACK TRANSACTION: " + transaction));
        }
        if (transaction == null) {
            throw new IllegalStateException("no transaction to rollback");
        }
        this.currentlyCancelingTransactions = true;
        try {
            while (transaction.events.size() > 0) {
                ODCEventImpl oDCEventImpl = (ODCEventImpl)transaction.events.remove(transaction.events.size() - 1);
                try {
                    oDCEventImpl.reverseEvent();
                    oDCEventImpl.performEvent(this);
                }
                catch (Throwable throwable) {
                    TrUtil.warning(throwable, this, "rollbackTransaction", tc);
                }
            }
        }
        finally {
            this.currentlyCancelingTransactions = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"rollbackTransaction");
        }
    }

    private Transaction popTransaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"popTransaction");
        }
        int n = this.transactionStack.size();
        Transaction transaction = null;
        if (n > 0) {
            transaction = (Transaction)this.transactionStack.remove(n - 1);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"popTransaction", transaction);
        }
        return transaction;
    }

    private Transaction topTransaction() {
        int n = this.transactionStack.size();
        Transaction transaction = n == 0 ? null : (Transaction)this.transactionStack.get(n - 1);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("top=" + transaction));
        }
        return transaction;
    }

    public void startConsumers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"startConsumers");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startConsumers");
        }
    }

    public void stopConsumers() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stopConsumers");
        }
        if (!this.running) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopConsumers");
        }
    }

    public synchronized ODCNodeImpl getNode(String string) {
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)this.nodeMap.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNode of " + string + " = " + oDCNodeImpl));
        }
        return oDCNodeImpl;
    }

    public ODCNodeImpl findNode(String string) throws ODCException {
        ODCNodeImpl oDCNodeImpl = this.getNode(string);
        if (oDCNodeImpl == null) {
            throw new ODCException("node not found: " + string);
        }
        return oDCNodeImpl;
    }

    public synchronized ODCEdgeImpl getEdge(String string) throws ODCException {
        ODCEdgeImpl oDCEdgeImpl = (ODCEdgeImpl)this.edgeMap.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getEdge of " + string + " = " + oDCEdgeImpl));
        }
        return oDCEdgeImpl;
    }

    public ODCEdgeImpl findEdge(String string) throws ODCException {
        ODCEdgeImpl oDCEdgeImpl = this.getEdge(string);
        if (oDCEdgeImpl == null) {
            throw new ODCException("edge not found: " + string);
        }
        return oDCEdgeImpl;
    }

    public void registerNode(ODCNodeImpl oDCNodeImpl, boolean bl) throws ODCException {
        if (oDCNodeImpl.isRegistered()) {
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("register " + oDCNodeImpl));
        }
        this.nodeMap.put(oDCNodeImpl.getPath(), oDCNodeImpl);
        oDCNodeImpl.setRegistered(true);
        ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(true, oDCNodeImpl, bl);
        this.notifyListeners(oDCEventNodeChangeImpl);
    }

    public void unregisterNode(ODCNode oDCNode, boolean bl) throws ODCException {
        ODCNodeImpl oDCNodeImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unregisterNode", (Object)oDCNode);
        }
        if (!(oDCNodeImpl = (ODCNodeImpl)oDCNode).isRegistered()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unregisterNode", (Object)"not registered");
            }
            return;
        }
        ODCNode[] oDCNodeArray = oDCNode.getParents();
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            ODCNodeImpl oDCNodeImpl2 = (ODCNodeImpl)oDCNodeArray[i];
            if (!oDCNodeImpl2.isRegistered()) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unregisterNode", (Object)new Object[]{"parent registered", oDCNodeImpl2});
            }
            return;
        }
        this.nodeMap.remove(oDCNode.getPath());
        oDCNodeImpl.setRegistered(false);
        ODCEventNodeChangeImpl oDCEventNodeChangeImpl = new ODCEventNodeChangeImpl(false, oDCNode, bl);
        this.notifyListeners(oDCEventNodeChangeImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"unregisterNode");
        }
    }

    protected void notifyListeners(ODCEvent oDCEvent) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyListeners", (Object)oDCEvent);
        }
        if (this.currentlyCancelingTransactions) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"notifyListeners", (Object)"canceling transaction");
            }
            return;
        }
        ((ODCEventImpl)oDCEvent).setGenerationNumber(this.generationNumber);
        if (this.transactionStack.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"in a transaction");
            }
            this.topTransaction().events.add(oDCEvent);
        } else {
            this.flushToFile();
            this.notifyListenersNow(oDCEvent);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyListeners");
        }
    }

    private void notifyListenersNow(ODCEvent oDCEvent) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyListenersNow", (Object)oDCEvent);
        }
        ODCEventType oDCEventType = oDCEvent.getEventType();
        ODCListener[] oDCListenerArray = this.getListeners();
        for (int i = 0; i < oDCListenerArray.length; ++i) {
            if (!this.isInterested(oDCListenerArray[i], oDCEventType)) continue;
            try {
                oDCListenerArray[i].handleEvent(oDCEvent);
                continue;
            }
            catch (Throwable throwable) {
                TrUtil.warning(throwable, this, "notifyListeners", tc);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyListenersNow");
        }
    }

    private boolean isInterested(ODCListener oDCListener, ODCEventType oDCEventType) {
        ODCEventType[] oDCEventTypeArray;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isInterested", (Object)oDCEventType);
        }
        if ((oDCEventTypeArray = oDCListener.interestEventTypes()) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isInterested", (Object)"all interests");
            }
            return true;
        }
        for (int i = 0; i < oDCEventTypeArray.length; ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("interest=" + oDCEventTypeArray[i]));
            }
            if (oDCEventTypeArray[i] != oDCEventType) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"isInterested", (Object)"true");
            }
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isInterested", (Object)"false");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ODCListener[] getListeners() {
        List list = this.listeners;
        synchronized (list) {
            return this.listeners.toArray(nullODCListenerArray);
        }
    }

    public String toString() {
        return this.name;
    }

    public void waitForInitializationCompletion(int n) throws Exception {
        if (this.bbTree != null) {
            this.bbTree.waitForInitializationCompletion(n);
        }
    }

    private static class Save {
        private static final TraceComponent tc = TrUtil.register(class$com$ibm$ws$odc$ODCTreeImpl$Save == null ? (class$com$ibm$ws$odc$ODCTreeImpl$Save = ODCTreeImpl.class$("com.ibm.ws.odc.ODCTreeImpl$Save")) : class$com$ibm$ws$odc$ODCTreeImpl$Save);

        private Save() {
        }

        static /* synthetic */ TraceComponent access$000() {
            return tc;
        }
    }

    private class Transaction {
        public final String name;
        public final long generationNumber;
        public final List events = new ArrayList();

        public Transaction(String string, long l) {
            this.name = string;
            this.generationNumber = l;
        }

        public String toString() {
            return this.generationNumber + ":" + this.name;
        }
    }
}

