/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.ComponentDisabledException;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.ConfigurationWarning;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.odc.ODCFactory;
import com.ibm.ws.odc.cell.TreeBuilder;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.runtime.component.ComponentImpl;
import com.ibm.ws.util.PlatformHelperFactory;

public class ODCService
extends ComponentImpl {
    private static final TraceComponent tc = TrUtil.register(ODCService.class);
    private static ODCFactory odcFactory;
    private TreeBuilder treeBuilder = null;

    public void initialize(Object object) throws ConfigurationWarning, ConfigurationError, ComponentDisabledException {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"initialize", (Object)object);
        }
        if (PlatformHelperFactory.getPlatformHelper().isCRAJvm()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ODCService disabled in z/OS CRA.");
            }
            throw new ComponentDisabledException();
        }
        try {
            clazz = Class.forName("com.ibm.ws.xd.odc.XDODCFactory");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = ODCFactory.class;
        }
        try {
            odcFactory = (ODCFactory)clazz.newInstance();
            this.treeBuilder = odcFactory.createTreeBuilder();
        }
        catch (Throwable throwable) {
            throw new ComponentDisabledException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start() throws RuntimeWarning, RuntimeError {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"start");
        }
        try {
            this.treeBuilder.start();
        }
        catch (Throwable throwable) {
            throw new RuntimeWarning(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"stop");
        }
        try {
            this.treeBuilder.stop();
        }
        catch (Throwable throwable) {
            TrUtil.warning(throwable, (Object)this, "stop", tc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public static ODCFactory getODCFactory() {
        return odcFactory;
    }
}

