/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeTypeImpl;
import com.ibm.ws.odc.ODCManagerImpl;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCSchemaParser;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCEdgeCardinality;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCSchema;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;

public final class ODCSchemaImpl
implements ODCSchema {
    private static final TraceComponent tc = TrUtil.register(ODCSchemaImpl.class);
    private final ODCManagerImpl mgr;
    private final ArrayList nodeTypes = new ArrayList();
    private final ArrayList edgeTypes = new ArrayList();
    private ODCEdgeTypeImpl[][] edgeMatrix = new ODCEdgeTypeImpl[0][0];
    private int rCount = 0;

    ODCSchemaImpl(ODCManagerImpl oDCManagerImpl) {
        this.mgr = oDCManagerImpl;
    }

    public ODCNodeType createNodeType(String string) throws ODCException {
        return this.addNodeType(string);
    }

    public ODCNodeType getNodeType(String string) {
        for (int i = 0; i < this.nodeTypes.size(); ++i) {
            ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)this.nodeTypes.get(i);
            if (!string.equalsIgnoreCase(oDCNodeTypeImpl.name)) continue;
            return oDCNodeTypeImpl;
        }
        return null;
    }

    public ODCNodeType findNodeType(String string) throws ODCException {
        ODCNodeType oDCNodeType = this.getNodeType(string);
        if (oDCNodeType == null) {
            throw new ODCException("undefined node type: " + string);
        }
        return oDCNodeType;
    }

    public ODCEdgeType createEdgeType(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2, ODCEdgeCardinality oDCEdgeCardinality, boolean bl) throws ODCException {
        return this.addEdgeType((ODCNodeTypeImpl)oDCNodeType, (ODCNodeTypeImpl)oDCNodeType2, oDCEdgeCardinality, bl);
    }

    public ODCEdgeType getEdgeType(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) {
        return this.getEdgeType((ODCNodeTypeImpl)oDCNodeType, (ODCNodeTypeImpl)oDCNodeType2);
    }

    public ODCEdgeType findEdgeType(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) throws ODCException {
        ODCEdgeType oDCEdgeType = this.getEdgeType(oDCNodeType, oDCNodeType2);
        if (oDCEdgeType == null) {
            throw new ODCException("there is no relationship between '" + oDCNodeType + "' and '" + oDCNodeType2 + "'");
        }
        return oDCEdgeType;
    }

    public int nodeTypeCount() {
        return this.nodeTypes.size();
    }

    public int edgeTypeCount() {
        return this.edgeTypes.size();
    }

    public ODCNodeTypeImpl getNodeType(int n) {
        return (ODCNodeTypeImpl)this.nodeTypes.get(n);
    }

    public ODCEdgeTypeImpl getEdgeType(int n) {
        return (ODCEdgeTypeImpl)this.edgeTypes.get(n);
    }

    public ODCEdgeTypeImpl getEdgeType(ODCNodeTypeImpl oDCNodeTypeImpl, ODCNodeTypeImpl oDCNodeTypeImpl2) {
        return this.edgeMatrix[oDCNodeTypeImpl.index][oDCNodeTypeImpl2.index];
    }

    private ODCNodeTypeImpl addNodeType(String string) {
        ODCNodeTypeImpl oDCNodeTypeImpl = new ODCNodeTypeImpl(string, this.nodeTypes.size(), this);
        this.nodeTypes.add(oDCNodeTypeImpl);
        this.enlargeEdgeMatrix();
        return oDCNodeTypeImpl;
    }

    ODCEdgeTypeImpl addEdgeType(ODCNodeTypeImpl oDCNodeTypeImpl, ODCNodeTypeImpl oDCNodeTypeImpl2, ODCEdgeCardinality oDCEdgeCardinality, boolean bl) throws ODCException {
        ODCEdgeTypeImpl oDCEdgeTypeImpl = this.edgeMatrix[oDCNodeTypeImpl.index][oDCNodeTypeImpl2.index];
        ODCEdgeTypeImpl oDCEdgeTypeImpl2 = this.edgeMatrix[oDCNodeTypeImpl2.index][oDCNodeTypeImpl.index];
        if (oDCEdgeTypeImpl == null) {
            this.edgeMatrix[oDCNodeTypeImpl.index][oDCNodeTypeImpl2.index] = oDCEdgeTypeImpl = new ODCEdgeTypeImpl(oDCNodeTypeImpl, oDCNodeTypeImpl2, oDCEdgeCardinality, bl, this.rCount++);
            this.edgeTypes.add(oDCEdgeTypeImpl);
        }
        if (oDCEdgeTypeImpl2 == null) {
            this.edgeMatrix[oDCNodeTypeImpl2.index][oDCNodeTypeImpl.index] = oDCEdgeTypeImpl2 = new ODCEdgeTypeImpl(oDCNodeTypeImpl2, oDCNodeTypeImpl, oDCEdgeCardinality.getReverse(), bl, this.rCount++);
            this.edgeTypes.add(oDCEdgeTypeImpl2);
        }
        oDCEdgeTypeImpl.setChild(true);
        oDCEdgeTypeImpl2.setParent(true);
        return oDCEdgeTypeImpl;
    }

    private void enlargeEdgeMatrix() {
        int n;
        int n2 = this.edgeMatrix.length;
        int n3 = this.nodeTypes.size();
        ODCEdgeTypeImpl[][] oDCEdgeTypeImplArray = new ODCEdgeTypeImpl[n3][n3];
        for (n = 0; n < n2; ++n) {
            oDCEdgeTypeImplArray[n] = new ODCEdgeTypeImpl[n3];
            System.arraycopy(this.edgeMatrix[n], 0, oDCEdgeTypeImplArray[n], 0, n2);
        }
        for (n = n2; n < n3; ++n) {
            oDCEdgeTypeImplArray[n] = new ODCEdgeTypeImpl[n3];
        }
        this.edgeMatrix = oDCEdgeTypeImplArray;
    }

    public void augment(InputStream inputStream) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"augmentSchema");
        }
        ODCSchemaParser oDCSchemaParser = new ODCSchemaParser(this.mgr);
        oDCSchemaParser.parse(inputStream, this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"augmentSchema");
        }
    }

    public void print(PrintStream printStream) {
        printStream.println("Node types:");
        Iterator iterator = this.nodeTypes.iterator();
        while (iterator.hasNext()) {
            printStream.println("   " + iterator.next().toString());
        }
        printStream.println("Edge types:");
        iterator = this.edgeTypes.iterator();
        while (iterator.hasNext()) {
            printStream.println("   " + iterator.next().toString());
        }
    }
}

