/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCProperties;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.util.TrUtil;
import java.util.ArrayList;

public class ODCPropertiesFactory {
    private static final TraceComponent tc = TrUtil.register(ODCPropertiesFactory.class);
    private final ArrayList propDescriptors = new ArrayList();
    private final ODCNodeTypeImpl nodeType;
    private static final ODCPropertyDescriptorImpl[] EMPTY = new ODCPropertyDescriptorImpl[0];

    public ODCPropertiesFactory(ODCNodeTypeImpl oDCNodeTypeImpl) {
        this.nodeType = oDCNodeTypeImpl;
    }

    public synchronized void registerPropertyDescriptor(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"registerPropertyDescriptor", (Object)oDCPropertyDescriptorImpl);
        }
        if (oDCPropertyDescriptorImpl.index != -1) {
            throw new IllegalStateException("descriptor already registered: " + oDCPropertyDescriptorImpl.name);
        }
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl2 = this.getPropertyDescriptor(oDCPropertyDescriptorImpl.name);
        if (oDCPropertyDescriptorImpl2 != null) {
            throw new IllegalArgumentException("property already registered: " + oDCPropertyDescriptorImpl.name);
        }
        oDCPropertyDescriptorImpl.index = this.propDescriptors.size();
        this.propDescriptors.add(oDCPropertyDescriptorImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerPropertyDescriptor");
        }
    }

    public synchronized ODCPropertyDescriptorImpl getPropertyDescriptor(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropertyDescriptor", (Object)oDCPropertyDescriptorImpl);
        }
        if ((oDCPropertyDescriptorImpl2 = this.getPropertyDescriptor(oDCPropertyDescriptorImpl.name)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropertyDescriptor", (Object)"found");
            }
            return oDCPropertyDescriptorImpl2;
        }
        this.registerPropertyDescriptor(oDCPropertyDescriptorImpl);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPropertyDescriptor", (Object)"registered");
        }
        return oDCPropertyDescriptorImpl;
    }

    public synchronized ODCPropertyDescriptorImpl getPropertyDescriptor(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropertyDescriptor", (Object)string);
        }
        for (int i = 0; i < this.propDescriptors.size(); ++i) {
            ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)this.propDescriptors.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("desc=" + oDCPropertyDescriptorImpl));
            }
            if (!oDCPropertyDescriptorImpl.name.equals(string)) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getPropertyDescriptor", (Object)"found");
            }
            return oDCPropertyDescriptorImpl;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPropertyDescriptor", (Object)"null");
        }
        return null;
    }

    public synchronized ODCPropertyDescriptorImpl findPropertyDescriptor(String string) {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findPropertyDescriptor", (Object)string);
        }
        if ((oDCPropertyDescriptorImpl = this.getPropertyDescriptor(string)) == null) {
            throw new IllegalArgumentException("unknown property name: " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findPropertyDescriptor", (Object)oDCPropertyDescriptorImpl);
        }
        return oDCPropertyDescriptorImpl;
    }

    public synchronized ODCPropertyDescriptorImpl[] getPropertyDescriptors() {
        return this.propDescriptors.toArray(EMPTY);
    }

    public synchronized ODCPropertyDescriptorImpl[] getPropertyDescriptors(ODCPropertyDescriptorImpl[] oDCPropertyDescriptorImplArray) {
        return this.propDescriptors.toArray(oDCPropertyDescriptorImplArray);
    }

    public int numberOfPropertyDescriptors() {
        return this.propDescriptors.size();
    }

    public synchronized ODCProperties create() {
        return new ODCProperties(this, this.nodeType);
    }

    public synchronized void clear() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"clear property descriptors");
        }
        this.propDescriptors.clear();
    }
}

