/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ws.odc.ODCEdgeTypeImpl;
import com.ibm.ws.odc.ODCManagerImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCSchema;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ODCParser
extends DefaultHandler
implements ErrorHandler {
    private final ArrayList nodeStack = new ArrayList();
    private final ODCManagerImpl mgr;
    private final ODCSchema schema;
    private final ODCTreeImpl tree;
    private String sFilename;
    private String sErrorMessage;
    private SAXParser parser;
    private boolean bParsedSuccessfully;
    private ODCNodeImpl root = null;
    private final List links = new LinkedList();

    public ODCParser(ODCTreeImpl oDCTreeImpl) throws ODCException {
        this.tree = oDCTreeImpl;
        this.mgr = oDCTreeImpl.mgr;
        this.schema = this.mgr.getSchema();
        try {
            this.parser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exception) {
            throw new ODCException(exception);
        }
        this.sFilename = null;
        this.bParsedSuccessfully = false;
        this.sErrorMessage = null;
    }

    public synchronized ODCTreeImpl parse(InputStream inputStream) throws ODCException, IOException {
        try {
            this.bParsedSuccessfully = false;
            this.sErrorMessage = null;
            this.parser.parse(inputStream, (DefaultHandler)this);
            this.resolveLinks();
            ODCTreeImpl oDCTreeImpl = this.tree;
            return oDCTreeImpl;
        }
        catch (SAXException sAXException) {
            throw new ODCException(sAXException);
        }
        finally {
            this.nodeStack.clear();
            this.links.clear();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            String string4 = string3;
            if (string4.equalsIgnoreCase("property")) {
                String string5 = this.getAttr(attributes, "name");
                String string6 = this.getAttr(attributes, "value");
                ODCNodeImpl oDCNodeImpl = this.top();
                ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCNodeImpl.getType().findPropertyDescriptor(string5);
                if (oDCPropertyDescriptorImpl.valueInFile) {
                    int n;
                    byte[] byArray;
                    File file = this.tree.getFile().getParentFile();
                    File file2 = new File(file, string6 = string6.replace('/', File.pathSeparatorChar));
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    int n2 = fileInputStream.read(byArray = new byte[n = (int)file2.length()]);
                    if (n2 != n) {
                        throw new IOException("tried to read " + n + " bytes but only read " + n2 + " from " + file2.getPath());
                    }
                    string6 = new String(byArray);
                }
                throw new SAXException("property fromString not implemented");
            }
            if (string4.equalsIgnoreCase("link")) {
                String string7 = this.getAttr(attributes, "name");
                this.links.add(new Link(this.top(), string7));
            } else {
                ODCNodeImpl oDCNodeImpl = this.top();
                ODCNodeType oDCNodeType = this.schema.getNodeType(string4);
                if (oDCNodeType != null) {
                    ODCNodeImpl oDCNodeImpl2 = oDCNodeImpl == null ? new ODCNodeImpl(this.getAttr(attributes, "name"), (ODCNodeTypeImpl)oDCNodeType, this.tree) : new ODCNodeImpl(this.getAttr(attributes, "name"), (ODCNodeTypeImpl)oDCNodeType, oDCNodeImpl, false);
                    this.push(oDCNodeImpl2);
                }
            }
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.out);
            throw new SAXException(throwable.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string3;
        if (!string4.equalsIgnoreCase("property") && !string4.equalsIgnoreCase("link")) {
            this.pop(string4);
        }
    }

    public void error(SAXParseException sAXParseException) {
        System.out.println("ERROR: " + sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) {
        System.out.println("FATAL: " + sAXParseException);
    }

    public void warning(SAXParseException sAXParseException) {
        System.out.println("WARN: " + sAXParseException);
    }

    private void push(ODCNodeImpl oDCNodeImpl) throws SAXException {
        this.nodeStack.add(oDCNodeImpl);
    }

    private ODCNodeImpl pop(String string) throws SAXException {
        int n = this.nodeStack.size();
        if (n <= 0) {
            this.parseError("no matching begin for tag " + string);
        }
        this.root = (ODCNodeImpl)this.nodeStack.remove(n - 1);
        return this.root;
    }

    private ODCNodeImpl top() {
        int n = this.nodeStack.size();
        if (n == 0) {
            return null;
        }
        return (ODCNodeImpl)this.nodeStack.get(n - 1);
    }

    private String getAttr(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new SAXException("attribute '" + string + "' not defined");
        }
        return string2;
    }

    private void parseError(String string) throws SAXException {
        throw new SAXException(string);
    }

    private void resolveLinks() throws ODCException {
        while (this.links.size() > 0) {
            ODCNodeType oDCNodeType;
            Link link = (Link)this.links.remove(0);
            ODCNodeImpl oDCNodeImpl = this.tree.getNode(link.toName);
            if (oDCNodeImpl == null) {
                throw new ODCException("unresolved link name: " + link.toName);
            }
            ODCNodeType oDCNodeType2 = link.fromNode.getType();
            ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeType2.getEdgeType(oDCNodeType = oDCNodeImpl.getType());
            if (oDCEdgeTypeImpl == null) {
                throw new ODCException("nesting of " + oDCNodeType.getName() + " within " + oDCNodeType2.getName() + " is not allowed");
            }
            if (!oDCEdgeTypeImpl.isChild()) {
                throw new ODCException("nesting of " + oDCNodeType.getName() + " within " + oDCNodeType2.getName() + " is backwards");
            }
            if (!oDCEdgeTypeImpl.linked) {
                throw new ODCException("link not allowed from " + oDCNodeType2.getName() + " to " + oDCNodeType.getName());
            }
            link.fromNode.addChild(oDCNodeImpl);
        }
    }

    private class Link {
        public final ODCNodeImpl fromNode;
        public final String toName;

        public Link(ODCNodeImpl oDCNodeImpl, String string) {
            this.fromNode = oDCNodeImpl;
            this.toName = string;
        }
    }
}

