/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEdgeImpl;
import com.ibm.ws.odc.ODCEdgeTypeImpl;
import com.ibm.ws.odc.ODCEventEdgeChangeImpl;
import com.ibm.ws.odc.ODCEventNodeChangeImpl;
import com.ibm.ws.odc.ODCEventSetPropertyImpl;
import com.ibm.ws.odc.ODCNodeTypeImpl;
import com.ibm.ws.odc.ODCObjectImpl;
import com.ibm.ws.odc.ODCProperties;
import com.ibm.ws.odc.ODCPropertyDescriptorImpl;
import com.ibm.ws.odc.ODCSchemaImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.wsspi.odc.ODCEdgeType;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCEventType;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCNodeType;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import com.ibm.wsspi.odc.ODCTree;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ODCNodeImpl
extends ODCObjectImpl
implements ODCNode {
    private static final TraceComponent tc = TrUtil.register(ODCNodeImpl.class);
    private String name;
    private String typedName;
    private ODCNodeTypeImpl type;
    private int index;
    private final ODCNodeImpl parent;
    private final boolean local;
    private ODCTreeImpl tree;
    private ODCProperties props;
    private NodeList allParents = new NodeList();
    private NodeList[] typedParents;
    private NodeList allChildren = new NodeList();
    private NodeList[] typedChildren;
    private boolean registered;
    private final Properties transientProperties = new Properties();
    private Object sync;
    private static final ODCNodeImpl[] nullNodeArray = new ODCNodeImpl[0];

    public ODCNodeImpl(String string, ODCNodeType oDCNodeType, ODCTree oDCTree) {
        this.parent = null;
        this.local = false;
        this.setTree(oDCTree);
        this.init(string, (ODCNodeTypeImpl)oDCNodeType, "");
    }

    public ODCNodeImpl(String string, ODCNodeType oDCNodeType, ODCNode oDCNode, boolean bl) throws ODCException {
        this.parent = (ODCNodeImpl)oDCNode;
        this.local = bl;
        this.setTree(oDCNode.getTree());
        this.init(string, (ODCNodeTypeImpl)oDCNodeType, oDCNode.getPath());
    }

    private void init(String string, ODCNodeTypeImpl oDCNodeTypeImpl, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{string, oDCNodeTypeImpl, string2});
        }
        this.name = string;
        this.type = oDCNodeTypeImpl;
        this.typedName = "/" + oDCNodeTypeImpl.name + "/" + string;
        this.longName = string2 + this.typedName;
        this.index = oDCNodeTypeImpl.index;
        this.sync = this;
        this.registered = false;
        this.initTypedParents(oDCNodeTypeImpl.schema);
        this.initTypedChildren(oDCNodeTypeImpl.schema);
        this.props = oDCNodeTypeImpl.propertiesFactory.create();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"constructor");
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocal() {
        return this.local;
    }

    public String getTypedName() {
        return this.typedName;
    }

    public String getPath() {
        return this.longName;
    }

    public ODCNodeType getType() {
        return this.type;
    }

    public boolean is(ODCNodeType oDCNodeType) {
        return this.type == oDCNodeType;
    }

    public Properties getTransientProperties() {
        return this.transientProperties;
    }

    public ODCTree getTree() {
        return this.tree;
    }

    public void setTree(ODCTree oDCTree) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setTree", (Object)oDCTree);
        }
        this.tree = (ODCTreeImpl)oDCTree;
        this.sync = oDCTree != null ? oDCTree : this;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setTree");
        }
    }

    public ODCNode[] getNodes() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getNodes");
        }
        ODCNode[] oDCNodeArray = this.getParents();
        ODCNode[] oDCNodeArray2 = this.getChildren();
        ODCNode[] oDCNodeArray3 = new ODCNode[oDCNodeArray.length + oDCNodeArray2.length];
        System.arraycopy(oDCNodeArray, 0, oDCNodeArray3, 0, oDCNodeArray.length);
        System.arraycopy(oDCNodeArray2, 0, oDCNodeArray3, oDCNodeArray.length, oDCNodeArray2.length);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getNodes", (Object)oDCNodeArray3);
        }
        return oDCNodeArray3;
    }

    public int nodeCount() {
        return this.allParents.size() + this.allChildren.size();
    }

    public ODCNode getNode(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeImpl.oneCheck(this.type, oDCNodeType);
        NodeList nodeList = this.getTypedList(oDCNodeType);
        if (nodeList.size() == 0) {
            return null;
        }
        return nodeList.get(0);
    }

    public ODCNode getNode(ODCNodeType oDCNodeType, String string) throws ODCException {
        ODCNode[] oDCNodeArray = this.getNodes(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            if (!string.equals(oDCNodeArray[i].getName())) continue;
            return oDCNodeArray[i];
        }
        return null;
    }

    public ODCNode[] getNodes(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeImpl.manyCheck(this.type, oDCNodeType);
        int n = ((ODCNodeTypeImpl)oDCNodeType).index;
        return this.getTypedList(oDCNodeType).toArray();
    }

    public int nodeCount(ODCNodeType oDCNodeType) throws ODCException {
        NodeList nodeList = this.typedParents[((ODCNodeTypeImpl)oDCNodeType).index];
        NodeList nodeList2 = this.typedChildren[((ODCNodeTypeImpl)oDCNodeType).index];
        if (nodeList != null) {
            if (nodeList2 != null) {
                return nodeList.size() + nodeList2.size();
            }
            return nodeList.size();
        }
        if (nodeList2 != null) {
            return nodeList2.size();
        }
        throw new ODCException(this.type.getName() + " has no relationship to " + oDCNodeType.getName());
    }

    public void addNode(ODCNode oDCNode) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addNode", (Object)oDCNode);
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNode.getType();
        ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeTypeImpl);
        if (oDCEdgeType == null) {
            throw new ODCException("a '" + this.type.name + "' can have no relationship to a '" + oDCNodeTypeImpl.name + "'");
        }
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException("a '" + this.type.name + "' can be both a parent and a child of a '" + oDCNodeTypeImpl.name + "'; must use addChild() to disambiguate");
        }
        if (oDCEdgeType.isParent()) {
            oDCNode.addChild(this);
        } else {
            this.addChild(oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addNode");
        }
    }

    public void removeNode(ODCNode oDCNode) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeNode", (Object)oDCNode);
        }
        ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNode;
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNode.getType();
        ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeTypeImpl);
        if (oDCEdgeType == null) {
            throw new ODCException("a '" + this.type.name + "' can have no relationship to a '" + oDCNodeTypeImpl.name + "'");
        }
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException("a '" + this.type.name + "' can be both a parent and a child of a '" + oDCNodeTypeImpl.name + "'; must use removeChild() to disambiguate");
        }
        if (oDCEdgeType.isParent()) {
            oDCNode.removeChild(this);
        } else {
            this.removeChild(oDCNode);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeNode");
        }
    }

    public void addChild(ODCNode oDCNode) throws ODCException {
        if (this.tree != null) {
            this.tree.obtainEdge(this, (ODCNodeImpl)oDCNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEdge(ODCNodeImpl oDCNodeImpl) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"addEdge", (Object)oDCNodeImpl);
        }
        Object object = this.sync;
        synchronized (object) {
            ODCNodeImpl oDCNodeImpl2;
            ODCNodeTypeImpl oDCNodeTypeImpl = oDCNodeImpl.type;
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeTypeImpl);
            if (oDCEdgeType == null) {
                throw new ODCException("a '" + this.type.name + "' can have no relationship to a '" + oDCNodeTypeImpl.name + "'");
            }
            if (!oDCEdgeType.isChild()) {
                throw new ODCException("a '" + this.type.name + "' can not have a '" + oDCNodeTypeImpl.name + "' as a child");
            }
            if (this.allChildren.contains(oDCNodeImpl)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"addEdge", (Object)"already a child");
                }
                return;
            }
            NodeList nodeList = this.typedChildren[oDCNodeTypeImpl.index];
            NodeList nodeList2 = oDCNodeImpl.typedParents[this.type.index];
            if (nodeList.size() > 0 && !oDCEdgeType.toMany()) {
                oDCNodeImpl2 = nodeList.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("to-one ODC schema violation: parent=" + this + ", curChild=" + oDCNodeImpl2 + ", newChild=" + oDCNodeImpl));
                }
                this.removeChild(oDCNodeImpl2);
            }
            if (nodeList2.size() > 0 && !oDCEdgeType.fromMany()) {
                oDCNodeImpl2 = nodeList2.get(0);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("from-one schema violation: child=" + oDCNodeImpl + ", curParent=" + oDCNodeImpl2 + ", newParent=" + this));
                }
                oDCNodeImpl2.removeChild(this);
            }
            this.allChildren.add(oDCNodeImpl);
            nodeList.add(oDCNodeImpl);
            oDCNodeImpl.allParents.add(this);
            nodeList2.add(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addEdge");
        }
    }

    public void removeChild(ODCNode oDCNode) throws ODCException {
        if (oDCNode.getParent() == this) {
            oDCNode.remove();
        } else if (this.tree != null) {
            this.tree.releaseEdge(this, (ODCNodeImpl)oDCNode, false);
        }
    }

    public void remove() throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)this);
        }
        this.remove(false);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(boolean bl) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{this, new Boolean(bl)});
        }
        Object object = this.sync;
        synchronized (object) {
            ODCTreeImpl oDCTreeImpl = this.tree;
            ODCNode[] oDCNodeArray = this.getParents();
            for (int i = 0; i < oDCNodeArray.length; ++i) {
                ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNodeArray[i];
                if (oDCTreeImpl == null) continue;
                oDCTreeImpl.releaseEdge(oDCNodeImpl, this, bl);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("removing children of " + this));
            }
            ODCNode[] oDCNodeArray2 = this.getChildren();
            for (int i = 0; i < oDCNodeArray2.length; ++i) {
                ODCNodeImpl oDCNodeImpl = (ODCNodeImpl)oDCNodeArray2[i];
                ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeImpl.type.getEdgeType(this.type);
                if (oDCTreeImpl != null) {
                    oDCTreeImpl.releaseEdge(this, oDCNodeImpl, bl);
                }
                if (oDCEdgeTypeImpl.linked) continue;
                oDCNodeImpl.remove(bl);
            }
            if (oDCTreeImpl != null) {
                oDCTreeImpl.releaseNode(this, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEdge(ODCNodeImpl oDCNodeImpl) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeEdge", (Object)new Object[]{this, oDCNodeImpl});
        }
        Object object = this.sync;
        synchronized (object) {
            boolean bl;
            ODCNodeTypeImpl oDCNodeTypeImpl = oDCNodeImpl.type;
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCNodeImpl.type);
            if (oDCEdgeType == null) {
                throw new ODCException("a '" + this.type.name + "' has no relationship to a '" + oDCNodeTypeImpl.name + "'");
            }
            if (!oDCEdgeType.isChild()) {
                throw new ODCException("a '" + this.type.name + "' can not have a '" + oDCNodeTypeImpl.name + "' as a child");
            }
            if (!this.allChildren.remove(oDCNodeImpl)) {
                return;
            }
            this.typedChildren[oDCNodeTypeImpl.index].remove(oDCNodeImpl);
            oDCNodeImpl.allParents.remove(this);
            oDCNodeImpl.typedParents[this.type.index].remove(this);
            boolean bl2 = bl = oDCNodeImpl.getParent() == this;
            if (bl) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("force removal of " + oDCNodeImpl));
                }
                oDCNodeImpl.remove(true);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEdge");
        }
    }

    public ODCPropertyDescriptor[] getPropertyDescriptors() throws ODCException {
        return this.props.getDescriptors();
    }

    public Object getProperty(ODCPropertyDescriptor oDCPropertyDescriptor) throws ODCException {
        ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCPropertyDescriptor;
        this.propDescriptorCheck(oDCPropertyDescriptorImpl);
        return this.props.getProperty(oDCPropertyDescriptorImpl);
    }

    public void setProperty(ODCPropertyDescriptor oDCPropertyDescriptor, Object object) throws ODCException {
        this.setProperty(oDCPropertyDescriptor, object, true);
    }

    public void setProperties(Map map, boolean bl) throws ODCException {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.setProperty((String)entry.getKey(), entry.getValue(), bl);
        }
    }

    public void setProperty(String string, Object object, boolean bl) throws ODCException {
        ODCPropertyDescriptor oDCPropertyDescriptor = this.type.getPropertyDescriptor(string);
        if (oDCPropertyDescriptor == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setProperty: ignoring '" + string + "'"));
            }
        } else {
            this.setProperty(oDCPropertyDescriptor, object, bl);
        }
    }

    public void setProperty(ODCPropertyDescriptor oDCPropertyDescriptor, Object object, boolean bl) throws ODCException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setProperty: local=" + bl + ", desc=" + oDCPropertyDescriptor + ", value=" + object));
        }
        this.setProperty(new ODCEventSetPropertyImpl(oDCPropertyDescriptor, this, object, bl));
        if (bl && this.tree != null) {
            this.tree.setProperty(this, (ODCPropertyDescriptorImpl)oDCPropertyDescriptor, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(ODCEventSetProperty oDCEventSetProperty) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setProperty", (Object)oDCEventSetProperty);
        }
        Object object = this.sync;
        synchronized (object) {
            ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl = (ODCPropertyDescriptorImpl)oDCEventSetProperty.getEventType();
            this.propDescriptorCheck(oDCPropertyDescriptorImpl);
            Object object2 = this.props.getProperty(oDCPropertyDescriptorImpl);
            Object object3 = oDCEventSetProperty.getNewValue();
            if (!(object2 == object3 || object2 != null && object3 != null && object2.equals(object3))) {
                this.props.setProperty(oDCPropertyDescriptorImpl, object3);
                if (this.tree != null) {
                    ((ODCEventSetPropertyImpl)oDCEventSetProperty).setOldValue(object2);
                    this.tree.notifyListeners(oDCEventSetProperty);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperty");
        }
    }

    public boolean getBooleanProperty(ODCPropertyDescriptor oDCPropertyDescriptor) throws ODCException {
        Object object = this.getProperty(oDCPropertyDescriptor);
        if (object == null) {
            throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' has no value for " + this.longName);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' of " + this.longName + " must be a Boolean; found a " + object.getClass().getName());
    }

    public void setBooleanProperty(ODCPropertyDescriptor oDCPropertyDescriptor, boolean bl) throws ODCException {
        this.setProperty(oDCPropertyDescriptor, new Boolean(bl));
    }

    public int getIntProperty(ODCPropertyDescriptor oDCPropertyDescriptor) throws ODCException {
        Object object = this.getProperty(oDCPropertyDescriptor);
        if (object == null) {
            throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' has no value for " + this.longName);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new ODCException("property '" + oDCPropertyDescriptor.getName() + "' of " + this.longName + " must be a Integer; found a " + object.getClass().getName());
    }

    public void setIntProperty(ODCPropertyDescriptor oDCPropertyDescriptor, int n) throws ODCException {
        this.setProperty(oDCPropertyDescriptor, new Integer(n));
    }

    public Map getProperties() {
        return this.props.getProperties();
    }

    public Map getProperties(boolean bl) {
        return this.props.getProperties(bl);
    }

    public void addProperties(Map map) {
        this.props.addProperties(map);
    }

    public ODCNode getChild() throws ODCException {
        return this.getOne(this.allChildren, "children");
    }

    public ODCNode[] getChildren() {
        return this.allChildren.toArray();
    }

    public int childCount() {
        return this.allChildren.size();
    }

    public ODCNode getChild(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.oneCheck(this.type, oDCNodeType);
        return this.getOne(this.typedChildren[oDCNodeTypeImpl.index], "children");
    }

    public ODCNode getChild(ODCNodeType oDCNodeType, String string) throws ODCException {
        ODCNode[] oDCNodeArray = this.getChildren(oDCNodeType);
        for (int i = 0; i < oDCNodeArray.length; ++i) {
            if (!string.equals(oDCNodeArray[i].getName())) continue;
            return oDCNodeArray[i];
        }
        return null;
    }

    public ODCNode[] getChildren(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.manyCheck(this.type, oDCNodeType);
        return this.typedChildren[oDCNodeTypeImpl.index].toArray();
    }

    public int childCount(ODCNodeType oDCNodeType) throws ODCException {
        return this.typedChildren[((ODCNodeTypeImpl)oDCNodeType).index].size();
    }

    public ODCNode getParent() throws ODCException {
        return this.parent;
    }

    public ODCNode[] getParents() {
        return this.allParents.toArray();
    }

    public int parentCount() {
        return this.allParents.size();
    }

    public ODCNode getParent(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.oneCheck(this.type, oDCNodeType);
        return this.getOne(this.typedParents[oDCNodeTypeImpl.index], "parents");
    }

    public ODCNode[] getParents(ODCNodeType oDCNodeType) throws ODCException {
        ODCNodeTypeImpl oDCNodeTypeImpl = (ODCNodeTypeImpl)oDCNodeType;
        ODCNodeImpl.manyCheck(this.type, oDCNodeType);
        return this.typedParents[oDCNodeTypeImpl.index].toArray();
    }

    public int parentCount(ODCNodeType oDCNodeType) throws ODCException {
        return this.typedParents[((ODCNodeTypeImpl)oDCNodeType).index].size();
    }

    void getEvents(boolean bl, List list) {
        ODCEdgeImpl oDCEdgeImpl;
        String string;
        ODCEdgeTypeImpl oDCEdgeTypeImpl;
        int n;
        Object object;
        list.add(new ODCEventNodeChangeImpl(true, this, bl));
        for (int i = 0; i < this.props.size(); ++i) {
            Object object2 = this.props.getValue(i);
            if (object2 == null) continue;
            object = this.props.getDescriptor(i);
            list.add(new ODCEventSetPropertyImpl((ODCPropertyDescriptor)object, this, object2, bl));
        }
        ODCNode[] oDCNodeArray = this.getChildren();
        for (n = 0; n < oDCNodeArray.length; ++n) {
            object = (ODCNodeImpl)oDCNodeArray[n];
            oDCEdgeTypeImpl = (ODCEdgeTypeImpl)this.type.getEdgeType(((ODCNodeImpl)object).getType());
            if (oDCEdgeTypeImpl.linked) continue;
            ((ODCNodeImpl)object).getEvents(bl, list);
            string = Util.makeEdgeLongName(this, (ODCNode)object);
            oDCEdgeImpl = new ODCEdgeImpl(string, this, (ODCNode)object, oDCEdgeTypeImpl);
            list.add(new ODCEventEdgeChangeImpl(true, oDCEdgeImpl, bl));
        }
        for (n = 0; n < oDCNodeArray.length; ++n) {
            object = (ODCNodeImpl)oDCNodeArray[n];
            oDCEdgeTypeImpl = (ODCEdgeTypeImpl)this.type.getEdgeType(((ODCNodeImpl)object).getType());
            if (!oDCEdgeTypeImpl.linked) continue;
            string = Util.makeEdgeLongName(this, (ODCNode)object);
            oDCEdgeImpl = new ODCEdgeImpl(string, this, (ODCNode)object, oDCEdgeTypeImpl);
            list.add(new ODCEventEdgeChangeImpl(true, oDCEdgeImpl, bl));
        }
    }

    private ODCNode getOne(NodeList nodeList, String string) throws ODCException {
        int n = nodeList.size();
        if (n == 1) {
            return nodeList.get(0);
        }
        if (n == 0) {
            return null;
        }
        throw new ODCException("node " + this.longName + " has multiple " + string);
    }

    boolean isRegistered() {
        return this.registered;
    }

    void setRegistered(boolean bl) {
        this.registered = bl;
    }

    public void print(PrintStream printStream) throws IOException {
        this.print(printStream, null, null, 0);
    }

    public void print(PrintStream printStream, File file) throws IOException {
        printStream.println("<!-- This document was automatically generated. -->");
        this.print(printStream, file, null, 0);
    }

    private void print(PrintStream printStream, File file, ODCNodeImpl oDCNodeImpl, int n) throws IOException {
        Object object;
        ODCNodeImpl[] oDCNodeImplArray;
        ODCEventType oDCEventType;
        int n2;
        this.indent(printStream, n);
        printStream.print("<" + this.type.name + " name=\"" + this.name + "\"");
        if (!this.props.hasValues() && this.childCount() == 0) {
            printStream.println("/>");
            return;
        }
        printStream.println(">");
        this.indent(printStream, n + 1);
        printStream.println("<transient properties=\"" + this.getTransientProperties() + "\"/>");
        for (n2 = 0; n2 < this.props.size(); ++n2) {
            Object object2 = this.props.getValue(n2);
            if (object2 == null) continue;
            oDCEventType = this.props.getDescriptor(n2);
            this.indent(printStream, n + 1);
            if (oDCEventType.valueInFile) {
                char c = File.pathSeparatorChar;
                oDCNodeImplArray = this.longName.replace('/', c);
                File file2 = new File(file, (String)oDCNodeImplArray);
                if (!file2.mkdirs()) {
                    throw new IOException("unable to create directory: " + file2.getPath());
                }
                object = new File(file2, "property" + c + oDCEventType.name);
                FileOutputStream fileOutputStream = new FileOutputStream((File)object);
                fileOutputStream.write(object2.toString().getBytes());
                fileOutputStream.close();
                object2 = this.longName + "/property/" + oDCEventType.name;
            }
            printStream.println("<property name=\"" + oDCEventType.name + "\" value=\"" + object2 + "\"/>");
        }
        n2 = this.type.schema.nodeTypeCount();
        for (int i = 0; i < n2; ++i) {
            ODCEdgeTypeImpl oDCEdgeTypeImpl;
            if (oDCNodeImpl != null && oDCNodeImpl.type.index == i || (oDCEdgeTypeImpl = (ODCEdgeTypeImpl)this.type.getEdgeType((ODCNodeType)(oDCEventType = this.type.schema.getNodeType(i)))) == null || !oDCEdgeTypeImpl.isChild()) continue;
            oDCNodeImplArray = this.typedChildren[i].toArray();
            if (oDCNodeImplArray.length > 0) {
                this.indent(printStream, n + 1);
                printStream.println("<!-- " + ((ODCNodeTypeImpl)oDCEventType).name + " section -->");
            }
            for (int j = 0; j < oDCNodeImplArray.length; ++j) {
                object = oDCNodeImplArray[j];
                if (oDCEdgeTypeImpl.linked) {
                    this.indent(printStream, n + 1);
                    printStream.println("<link name=\"" + ((ODCNodeImpl)object).longName + "\"/>");
                    continue;
                }
                ((ODCNodeImpl)object).print(printStream, file, this, n + 1);
            }
        }
        this.indent(printStream, n);
        printStream.println("</" + this.type.name + ">");
    }

    private void indent(PrintStream printStream, int n) {
        for (int i = 0; i < n; ++i) {
            printStream.print("    ");
        }
    }

    private void initTypedParents(ODCSchemaImpl oDCSchemaImpl) {
        int n = oDCSchemaImpl.nodeTypeCount();
        this.typedParents = new NodeList[n];
        for (int i = 0; i < n; ++i) {
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCSchemaImpl.getNodeType(i));
            this.typedParents[i] = oDCEdgeType != null && oDCEdgeType.isParent() ? new NodeList() : null;
        }
    }

    private void initTypedChildren(ODCSchemaImpl oDCSchemaImpl) {
        int n = oDCSchemaImpl.nodeTypeCount();
        this.typedChildren = new NodeList[n];
        for (int i = 0; i < n; ++i) {
            ODCEdgeType oDCEdgeType = this.type.getEdgeType(oDCSchemaImpl.getNodeType(i));
            this.typedChildren[i] = oDCEdgeType != null && oDCEdgeType.isChild() ? new NodeList() : null;
        }
    }

    private void propDescriptorCheck(ODCPropertyDescriptorImpl oDCPropertyDescriptorImpl) throws ODCException {
        if (oDCPropertyDescriptorImpl.nodeType != this.type) {
            throw new ODCException("property descriptor is from node type " + oDCPropertyDescriptorImpl.nodeType + " but this node is of type " + this.type);
        }
    }

    private NodeList getTypedList(ODCNodeType oDCNodeType) throws ODCException {
        int n = ((ODCNodeTypeImpl)oDCNodeType).index;
        NodeList nodeList = this.childCheck(oDCNodeType) ? this.typedChildren[n] : this.typedParents[n];
        if (nodeList == null) {
            throw new IllegalStateException("bad state");
        }
        return nodeList;
    }

    private boolean childCheck(ODCNodeType oDCNodeType) throws ODCException {
        ODCEdgeType oDCEdgeType = this.type.findEdgeType(oDCNodeType);
        if (oDCEdgeType.isParent() && oDCEdgeType.isChild()) {
            throw new ODCException(this.type.getName() + " can be both a child and a parent of " + oDCNodeType.getName() + "; use getParent or getChild");
        }
        return oDCEdgeType.isChild();
    }

    private static void oneCheck(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) throws ODCException {
        ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeType.getEdgeType(oDCNodeType2);
        if (oDCEdgeTypeImpl == null) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has no relationship with a '" + oDCNodeType2.getName() + "'");
        }
        if (oDCEdgeTypeImpl.toMany()) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has a to-many relationship with a '" + oDCNodeType2.getName() + "'");
        }
    }

    private static void manyCheck(ODCNodeType oDCNodeType, ODCNodeType oDCNodeType2) throws ODCException {
        ODCEdgeTypeImpl oDCEdgeTypeImpl = (ODCEdgeTypeImpl)oDCNodeType.getEdgeType(oDCNodeType2);
        if (oDCEdgeTypeImpl == null) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has no relationship with a '" + oDCNodeType2.getName() + "'");
        }
        if (oDCEdgeTypeImpl.toOne()) {
            throw new ODCException("a '" + oDCNodeType.getName() + "' has a to-one relationship with a '" + oDCNodeType2.getName() + "'");
        }
    }

    private class NodeList {
        private final List list = new LinkedList();
        private ODCNodeImpl[] array = null;

        public synchronized void add(Object object) {
            this.list.add(object);
            this.array = null;
        }

        public synchronized boolean remove(Object object) {
            if (this.list.remove(object)) {
                this.array = null;
                return true;
            }
            return false;
        }

        public ODCNodeImpl get(int n) {
            return (ODCNodeImpl)this.list.get(n);
        }

        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        public int size() {
            return this.list.size();
        }

        public ODCNodeImpl[] toArray() {
            if (this.array == null) {
                this.array = this.list.toArray(nullNodeArray);
            }
            return this.array;
        }
    }
}

