/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEventEdgeChangeImpl;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.wsspi.odc.ODCEventSetProperty;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import com.ibm.wsspi.odc.ODCPropertyDescriptor;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class ODCEventSetPropertyImpl
extends ODCEventImpl
implements ODCEventSetProperty,
Externalizable {
    private static final TraceComponent tc = TrUtil.register(ODCEventEdgeChangeImpl.class);
    private ODCNodeImpl node;
    private Object newVal;
    private Object oldVal;
    public String serNodeName = null;
    public String serNodePath = null;
    public String serTypeName = null;
    public String serParentPath = null;
    public String serPropertyName = null;
    public String serPropertyTypeName = null;

    public ODCEventSetPropertyImpl() {
        super(true);
    }

    public ODCEventSetPropertyImpl(ODCPropertyDescriptor oDCPropertyDescriptor, ODCNode oDCNode, Object object, boolean bl) {
        super(oDCPropertyDescriptor, bl);
        this.node = (ODCNodeImpl)oDCNode;
        this.newVal = object;
        this.oldVal = null;
    }

    public void setNode(ODCNode oDCNode) {
        this.node = (ODCNodeImpl)oDCNode;
    }

    public ODCNode getNode() {
        return this.node;
    }

    public ODCPropertyDescriptor getPropertyDescriptor() {
        return (ODCPropertyDescriptor)this.getEventType();
    }

    public Object getOldValue() {
        return this.oldVal;
    }

    public void setOldValue(Object object) {
        this.oldVal = object;
    }

    public Object getNewValue() {
        return this.newVal;
    }

    public void performEvent(ODCTreeImpl oDCTreeImpl) throws ODCException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performEvent", (Object)this);
        }
        this.node.setProperty(this);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performEvent", (Object)this);
        }
    }

    public void reverseEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reverseEvent", (Object)this);
        }
        Object object = this.oldVal;
        this.oldVal = this.newVal;
        this.newVal = object;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reverseEvent", (Object)this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("setProperty: ");
        if (this.node == null) {
            stringBuffer.append("Serialized");
            stringBuffer.append(", nodeName=" + this.serNodeName);
            stringBuffer.append(", nodePath=" + this.serNodePath);
            stringBuffer.append(", typeName=" + this.serTypeName);
            stringBuffer.append(", parentPath=" + this.serParentPath);
            stringBuffer.append(", propertyTypeName=" + this.serPropertyTypeName);
            stringBuffer.append(", propertyName=" + this.serPropertyName);
            stringBuffer.append(", local=" + (this.isLocal() ? "true " : "false "));
        } else {
            stringBuffer.append(this.getEventType() + ":" + this.node.getLongName());
        }
        stringBuffer.append(": oldVal=" + this.oldVal);
        stringBuffer.append(": newVal=" + this.newVal);
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Serial serial = new Serial();
        try {
            serial.nodeName = this.node.getName();
            serial.nodePath = this.node.getPath();
            serial.typeName = this.node.getType().getName();
            serial.parentPath = this.node.getParent() == null ? null : this.node.getParent().getPath();
            serial.oldVal = this.oldVal;
            serial.newVal = this.newVal;
            serial.local = this.isLocal();
            ODCPropertyDescriptor oDCPropertyDescriptor = (ODCPropertyDescriptor)this.getEventType();
            serial.propertyTypeName = oDCPropertyDescriptor.getNodeType().getName();
            serial.propertyName = oDCPropertyDescriptor.getName();
            objectOutput.writeObject(serial);
        }
        catch (ODCException oDCException) {
            throw new IOException(oDCException.getMessage());
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Serial serial = (Serial)objectInput.readObject();
        this.serNodeName = serial.nodeName;
        this.serNodePath = serial.nodePath;
        this.serTypeName = serial.typeName;
        this.serParentPath = serial.parentPath;
        this.serPropertyTypeName = serial.propertyTypeName;
        this.serPropertyName = serial.propertyName;
        this.oldVal = serial.oldVal;
        this.newVal = serial.newVal;
        this.setLocal(serial.local);
    }

    class Serial
    implements Serializable {
        public String nodeName;
        public String nodePath;
        public String typeName;
        public String parentPath;
        public String propertyTypeName;
        public String propertyName;
        public Object oldVal;
        public Object newVal;
        public boolean local;

        Serial() {
        }
    }
}

