/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.odc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.odc.ODCEventImpl;
import com.ibm.ws.odc.ODCNodeImpl;
import com.ibm.ws.odc.ODCTreeImpl;
import com.ibm.ws.odc.util.TrUtil;
import com.ibm.ws.odc.util.Util;
import com.ibm.wsspi.odc.ODCEdge;
import com.ibm.wsspi.odc.ODCEventEdgeChange;
import com.ibm.wsspi.odc.ODCException;
import com.ibm.wsspi.odc.ODCNode;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class ODCEventEdgeChangeImpl
extends ODCEventImpl
implements ODCEventEdgeChange,
Externalizable {
    private static final TraceComponent tc = TrUtil.register(ODCEventEdgeChangeImpl.class);
    private boolean add;
    private ODCEdge edge;
    private boolean srcNodeNew;
    private boolean dstNodeNew;
    public String serParentPath;
    public String serChildPath;
    public String serEdgePath;

    public ODCEventEdgeChangeImpl() {
        super(true);
    }

    public ODCEventEdgeChangeImpl(boolean bl, ODCEdge oDCEdge, boolean bl2) {
        super(bl2);
        this.add = bl;
        this.edge = oDCEdge;
        this.setEventType(oDCEdge.getType());
    }

    public boolean isAdd() {
        return this.add;
    }

    public ODCEdge getEdge() {
        return this.edge;
    }

    public ODCNode getSrcNode() {
        return this.edge.getSrcNode();
    }

    public ODCNode getDstNode() {
        return this.edge.getDstNode();
    }

    public void performEvent(ODCTreeImpl oDCTreeImpl) throws ODCException {
        ODCNodeImpl oDCNodeImpl = null;
        ODCNodeImpl oDCNodeImpl2 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"performEvent", (Object)this);
        }
        oDCNodeImpl = (ODCNodeImpl)this.getSrcNode();
        oDCNodeImpl2 = (ODCNodeImpl)this.getDstNode();
        if (this.add) {
            oDCNodeImpl.addEdge(oDCNodeImpl2);
        } else {
            oDCNodeImpl.removeEdge(oDCNodeImpl2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"performEvent", (Object)this);
        }
    }

    public void reverseEvent() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reverseEvent", (Object)this);
        }
        boolean bl = this.add = !this.add;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reverseEvent", (Object)this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.isLocal() ? "local" : "remote");
        stringBuffer.append(this.add ? " addChild " : " removeChild ");
        if (this.edge == null) {
            stringBuffer.append(" serialized ");
            stringBuffer.append(", parentPath=" + this.serParentPath);
            stringBuffer.append(", childPath=" + this.serChildPath);
            stringBuffer.append(", edgePath=" + this.serEdgePath);
        } else {
            stringBuffer.append(this.getEventType());
            stringBuffer.append(", src=").append(this.getSrcNode()).append(", dst=").append(this.getDstNode());
            stringBuffer.append(", srcNew=").append(this.srcNodeNew).append(",dstNew=").append(this.dstNodeNew);
        }
        return stringBuffer.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Serial serial = new Serial();
        serial.parentPath = this.edge.getSrcNode().getPath();
        serial.childPath = this.edge.getDstNode().getPath();
        serial.edgePath = Util.makeEdgeLongName(this.edge.getSrcNode(), this.edge.getDstNode());
        serial.local = this.isLocal();
        serial.add = this.add;
        objectOutput.writeObject(serial);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Serial serial = (Serial)objectInput.readObject();
        this.serParentPath = serial.parentPath;
        this.serChildPath = serial.childPath;
        this.serEdgePath = serial.edgePath;
        this.setLocal(serial.local);
        this.add = serial.add;
    }

    class Serial
    implements Serializable {
        String parentPath;
        String childPath;
        String edgePath;
        boolean add;
        boolean local;

        Serial() {
        }
    }
}

