/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.rsadapter.GenericDataStoreHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfigurationHelper;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.xa.OracleXAException;

public class OracleDataStoreHelper
extends GenericDataStoreHelper {
    private static final TraceComponent tc = Tr.register((Class)OracleDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private HashMap userNewMap = null;
    private HashMap oraErrorMap = null;
    private static final int HASHSIZE = 67;
    private boolean isXADataSource = false;
    private static final String oracleXADataSourceClassName = "OracleXADataSource";

    public OracleDataStoreHelper(Properties properties) {
        super(properties);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init> OracleHelper:", (Object)properties);
        }
        this.oraErrorMap = new HashMap(67);
        this.addInitialMaps();
        this.dshMd.setHelperType(13);
        this.dshMd.setReadOnlySupport(false);
        this.dshMd.setDatabaseDefaultIsolationLevel(2, this.customDefinedWasDefaultIsoLevel);
        String string = (String)properties.remove("dataSourceClass");
        if (string != null && string.endsWith(oracleXADataSourceClassName)) {
            this.isXADataSource = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"the metadata for the oracle helper is", (Object)this.dshMd);
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object)("The Oracle DataSource class name is " + string));
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object)("isXADataSource = " + this.isXADataSource));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init> OracleHelper:", (Object)this);
        }
    }

    private void addInitialMaps() {
        this.oraErrorMap.put(new Integer(28), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1012), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1014), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1033), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1034), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1035), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1089), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1090), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1092), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(3113), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(3114), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(12541), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(12560), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(12571), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(17002), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(17008), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(17009), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(17410), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(17401), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(17430), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(25408), StaleConnectionException.class);
        this.oraErrorMap.put(new Integer(1), DuplicateKeyException.class);
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        if (preparedStatement.getFetchDirection() != 1000) {
            preparedStatement.setFetchDirection(1000);
        }
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public final Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        Object var4_4 = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMappingClass for :", (Object)sQLException);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.oraErrorMap.get(new Integer(sQLException.getErrorCode()))) != null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"findMappingClass return ", var2_2);
                }
                return var2_2;
            }
            string = sQLException.getSQLState();
            if (string != null) {
                var2_2 = this.oraErrorMap.get(string);
            }
            if (var2_2 == null) {
                SQLException sQLException2 = sQLException.getNextException();
                if (sQLException2 != null) {
                    return this.findMappingClass(sQLException2);
                }
                return super.findMappingClass(sQLException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
        }
        return var2_2;
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getIsolationLevel, intent: ", (Object)accessIntent);
        }
        int n = -1;
        int n2 = this.dshMd.getDatabaseDefaultIsolationLevel();
        if (accessIntent != null) {
            n = accessIntent.getPessimisticUpdateLockHint();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The hint_value is: ", (Object)new Integer(n));
            }
            if (n == 4) {
                n2 = 8;
                Tr.warning((TraceComponent)tc, (String)"ORACLE_MAYBE_BAD_ISOLATION");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getIsolationLevel, return:", (Object)AdapterUtil.getIsolationLevelString((int)n2));
        }
        return n2;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        int n = 1007;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getResultSetConcurrency, intent: ", (Object)accessIntent);
        }
        if (accessIntent == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"getResultSetConcurrency,intent is null, return: ResultSet.CONCUR_READ_ONLY");
            }
            return n;
        }
        if (accessIntent.getAccessType() == 1) {
            n = 1008;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getResultSetConcurrency, return:", (Object)AdapterUtil.getConcurrencyModeString((int)n));
        }
        return n;
    }

    public String hasLostUpdateOrDeadLockOccurred(int n, boolean bl) {
        if (!bl && n == 2) {
            return "MSG_CONM_7009W";
        }
        return null;
    }

    public final String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: ", (Object)properties);
        }
        if (properties == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"showLockInfo: connection property is not specified ");
            }
            return null;
        }
        ConnectionPoolDataSource connectionPoolDataSource = null;
        String string = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
        Object object = null;
        try {
            object = DSConfigurationHelper.createDataSource((Object)string);
            DSConfigurationHelper.setDataSourceProperties((Object)object, (Properties)properties);
            connectionPoolDataSource = (ConnectionPoolDataSource)object;
        }
        catch (ResourceException resourceException) {
            FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.websphere.rsadapter.OracleDataStoreHelper.showLockInfo", (String)"254", (Object)this);
            Exception exception = resourceException.getLinkedException();
            if (exception == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"failed during establishing a connection -- linked exception is null, base exception is: ", (Object)((Object)resourceException));
                }
                throw resourceException;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failed during establishing a connection -- datasource creation exception is:", (Object)exception);
            }
            throw exception;
        }
        PooledConnection pooledConnection = connectionPoolDataSource.getPooledConnection();
        Connection connection = pooledConnection.getConnection();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo: connection established ", (Object)connection);
        }
        PreparedStatement preparedStatement = connection.prepareStatement("select distinct LO.Os_user_name, LO.Oracle_userName , LO.Process,  LO.session_ID, S.serial#, L.LMode, L.request, L.Block, L.type, O.sql_text, k.name from v$lock L, v$locked_object LO, v$open_cursor O, v$session S, sys.obj$ k where L.sid=LO.session_ID and L.sid=O.sid and S.sid=L.sid and LO.object_id=k.obj#");
        ResultSet resultSet = preparedStatement.executeQuery();
        boolean bl = false;
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(256);
        while (resultSet.next()) {
            stringBuffer.append("                   ===========" + ++n + "===========" + EOLN);
            stringBuffer.append("The OSID issued the lock       : " + resultSet.getString(1) + EOLN);
            stringBuffer.append("The OracleID issued the lock   : " + resultSet.getString(2) + EOLN);
            stringBuffer.append("The java process               : " + resultSet.getString(3) + EOLN);
            stringBuffer.append("The session ID                 : " + resultSet.getString(4) + EOLN);
            stringBuffer.append("The session serial#            : " + resultSet.getString(5) + EOLN);
            if (resultSet.getInt(6) != 0) {
                stringBuffer.append("The LOCK mode held             : " + resultSet.getString(6) + EOLN);
            }
            if (resultSet.getInt(7) != 0) {
                stringBuffer.append("The REQUEST mode               : " + resultSet.getString(7) + EOLN);
                bl = true;
            } else {
                bl = false;
            }
            if (resultSet.getInt(8) == 1) {
                stringBuffer.append("Status                         : Blocking" + EOLN);
            } else if (bl) {
                stringBuffer.append("Status                         : Waiting" + EOLN);
            }
            stringBuffer.append("The lock type                  : " + resultSet.getString(9) + EOLN);
            stringBuffer.append("The sqlText                    : " + resultSet.getString(10) + EOLN);
            stringBuffer.append("The locked table               : " + resultSet.getString(11) + EOLN);
        }
        stringBuffer.append(EOLN + "===>" + n + "Oracle locks found" + EOLN + EOLN + EOLN);
        stringBuffer.append("*****************************" + EOLN);
        stringBuffer.append("Symbols table: " + EOLN);
        stringBuffer.append("Lmode:  Lock mode in which the session holds the lock:" + EOLN + " 0, None " + EOLN + " 1, Null (NULL) " + EOLN + " 2, Row-S (SS) " + EOLN + " 3, Row-X (SX) " + EOLN + " 4, Share (S) " + EOLN + " 5, S/Row-X (SSX) " + EOLN + " 6, Exclusive (X)" + EOLN);
        stringBuffer.append("*****************************" + EOLN);
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            pooledConnection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public int getLockType(AccessIntent accessIntent) {
        int n;
        int n2 = 1;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLockType", (Object)new Object[]{this, accessIntent});
        }
        if (accessIntent == null) {
            return 2;
        }
        if (accessIntent.getAccessType() == 1 && accessIntent.getConcurrencyControl() == 1 && (n = accessIntent.getPessimisticUpdateLockHint()) != 1) {
            n2 = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLockType", (Object)AdapterUtil.getLockTypeAsString((int)n2));
        }
        return n2;
    }

    public String getXAExceptionContents(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer(350);
        if (xAException instanceof OracleXAException) {
            OracleXAException oracleXAException = (OracleXAException)xAException;
            int n = oracleXAException.getXAError();
            int n2 = oracleXAException.getOracleError();
            stringBuffer.append(EOLN).append("The XA Error is            : ").append(n).append(EOLN);
            stringBuffer.append("The XA Error message is    : ").append(OracleXAException.getXAErrorMessage((int)n)).append(EOLN);
            stringBuffer.append("The Oracle Error code is   : ").append(n2).append(EOLN);
            stringBuffer.append("The Oracle Error message is: ").append(OracleXAException.getXAErrorMessage((int)n2)).append(EOLN);
        }
        stringBuffer.append("The cause is               : ").append(xAException.getCause());
        return new String(stringBuffer);
    }

    public int modifyXAFlag(int n) {
        int n2 = n | 0x10000;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"returning (xaflag | OracleXAResource.ORATRANSLOOSE): ", (Object)new Integer(n2));
        }
        return n2;
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        if (accessIntent != null && accessIntent.getConcurrencyControl() == 2) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"isBatchUpdateSupportedWithAccessIntent(): returning false because occ is used.  AccessIntent is: ", (Object)accessIntent);
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isBatchUpdateSupportedWithAccessIntent(): returning true.  Accessintent is:", (Object)accessIntent);
        }
        return true;
    }
}

