/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.rsadapter;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.appprofile.accessintent.AccessIntent;
import com.ibm.websphere.ce.cm.DuplicateKeyException;
import com.ibm.websphere.ce.cm.PortableSQLException;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.ce.cm.StaleStatementException;
import com.ibm.websphere.rsadapter.DataStoreHelper;
import com.ibm.websphere.rsadapter.DataStoreHelperMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.rsadapter.AdapterUtil;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;

public class GenericDataStoreHelper
implements DataStoreHelper {
    protected static final String resBundle = "IBMDataStoreAdapterNLS";
    private static final TraceComponent tc = Tr.register((Class)GenericDataStoreHelper.class, (String)"RRA", (String)"IBMDataStoreAdapterNLS");
    private boolean reauthEnabled = false;
    protected int customDefinedWasDefaultIsoLevel = -1;
    protected static final String EOLN = System.getProperty("line.separator");
    final DataStoreHelperMetaData dshMd = new DataStoreHelperMetaData();
    protected HashMap genErrorMap = new HashMap(17);
    private static final int HASHSIZE = 17;
    private HashMap userNewMap = null;

    public GenericDataStoreHelper(Properties properties) {
        this.addInitialMaps();
        if (properties != null) {
            String string = properties.getProperty("webSphereDefaultIsolationLevel");
            if (string != null && !string.equals("")) {
                this.customDefinedWasDefaultIsoLevel = Integer.parseInt(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"the was default isolation level is customized to: ", (Object)AdapterUtil.getIsolationLevelString((int)this.customDefinedWasDefaultIsoLevel));
                }
                this.dshMd.setDatabaseDefaultIsolationLevel(2, this.customDefinedWasDefaultIsoLevel);
            }
            boolean bl = this.reauthEnabled = (string = properties.getProperty("reauthentication")) != null && new Boolean(string) != false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"init ", (Object)this);
        }
    }

    public DataStoreHelperMetaData getMetaData() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"returning: ", (Object)this.dshMd);
        }
        return this.dshMd;
    }

    private void addInitialMaps() {
        this.genErrorMap.put("55032", StaleConnectionException.class);
        this.genErrorMap.put("08001", StaleConnectionException.class);
        this.genErrorMap.put("08003", StaleConnectionException.class);
        this.genErrorMap.put("40003", StaleConnectionException.class);
        this.genErrorMap.put("S1000", StaleConnectionException.class);
        this.genErrorMap.put("08006", StaleConnectionException.class);
        this.genErrorMap.put("08S01", StaleConnectionException.class);
        this.genErrorMap.put(new Integer(23505), DuplicateKeyException.class);
    }

    public int getIsolationLevel(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getIsolationLevel, intent is:", (Object)accessIntent);
        }
        return this.dshMd.getDatabaseDefaultIsolationLevel();
    }

    public int getResultSetType(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getResultSetType, return: ResultSet.TYPE_FORWARD_ONLY");
        }
        return 1003;
    }

    public int getResultSetConcurrency(AccessIntent accessIntent) throws ResourceException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getResultSetConcurrency, default (CONCUR_READ_ONLY) is returned. intent is:", (Object)accessIntent);
        }
        return 1007;
    }

    public boolean isConnectionError(SQLException sQLException) {
        Class clazz;
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isConnectionError: ", (Object)sQLException);
        }
        if (sQLException != null && (clazz = this.findMappingClass(sQLException)) != null) {
            boolean bl2 = clazz.equals(StaleConnectionException.class) || clazz.equals(StaleStatementException.class) ? true : (bl = false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isConnectionError: ", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String hasLostUpdateOrDeadLockOccurred(int n, boolean bl) {
        switch (n) {
            case 1: 
            case 2: {
                return "MSG_CONM_7008W";
            }
        }
        if (!bl) {
            return "MSG_CONM_7010W";
        }
        return null;
    }

    public Class findMappingClass(SQLException sQLException) {
        Object var2_2 = null;
        String string = null;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findMappingClass for exception", (Object)sQLException);
        }
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"the DataStoreHelper is: ", (Object)this);
        }
        if (sQLException != null) {
            if (this.userNewMap != null) {
                var2_2 = this.userNewMap.get(new Integer(sQLException.getErrorCode()));
                if (var2_2 != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
                string = sQLException.getSQLState();
                if (string != null && (var2_2 = this.userNewMap.get(string)) != null) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"findMappingClass return: ", var2_2);
                    }
                    return var2_2;
                }
            }
            if ((var2_2 = this.genErrorMap.get(new Integer(sQLException.getErrorCode()))) == null && (string = sQLException.getSQLState()) != null) {
                var2_2 = this.genErrorMap.get(string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findMappingClass, returning", var2_2);
        }
        return var2_2;
    }

    private SQLException mapExceptionHelper(SQLException sQLException) {
        Class clazz;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"mapExceptionHelper");
        }
        if ((clazz = this.findMappingClass(sQLException)) != null && !clazz.equals(Void.class)) {
            try {
                Class[] classArray = new Class[]{SQLException.class};
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                PortableSQLException portableSQLException = (PortableSQLException)constructor.newInstance(sQLException);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"mapExceptionHelper: Mapping was done returning:", (Object)sQLException);
                }
                return portableSQLException;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.websphere.rsadapter.GenericDataStoreHelper.mapExceptionHelper", (String)"313", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"NO_EXCPT_MAP", (Object)exception);
                return sQLException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"mapExceptionHelper: No Mapping was done returning:");
        }
        return sQLException;
    }

    public SQLException mapException(SQLException sQLException) {
        if (sQLException instanceof PortableSQLException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception does not need to be mapped, returning the same exception", (Object)sQLException);
            }
            return sQLException;
        }
        return this.mapExceptionHelper(sQLException);
    }

    public void doConnectionSetup(Connection connection) throws SQLException {
    }

    public boolean doConnectionCleanup(Connection connection) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doConnectionCleanup(): no cleanup is done return false");
        }
        return false;
    }

    public void doStatementCleanup(PreparedStatement preparedStatement) throws SQLException {
        preparedStatement.setCursorName(null);
        preparedStatement.setFetchDirection(1000);
        preparedStatement.setMaxFieldSize(0);
        preparedStatement.setMaxRows(0);
        preparedStatement.setQueryTimeout(0);
    }

    public String showLockInfo(Properties properties) throws Exception {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"showLockInfo() is not supported for GenericDataStoreHelper");
        }
        return AdapterUtil.getNLSMessage((String)"GENERIC_HELPER_NO_LOCK_INFO");
    }

    public void setUserDefinedMap(Map map) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setUserDefinedMap: ", (Object)map);
        }
        this.userNewMap = new HashMap(map);
    }

    public int getLockType(AccessIntent accessIntent) {
        int n;
        int n2 = 1;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getLockType", (Object)new Object[]{this, accessIntent});
        }
        if (accessIntent != null && accessIntent.getAccessType() == 1 && accessIntent.getConcurrencyControl() == 1 && ((n = accessIntent.getPessimisticUpdateLockHint()) == 3 || n == 4)) {
            n2 = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getLockType", (Object)AdapterUtil.getLockTypeAsString((int)n2));
        }
        return n2;
    }

    public short calcPartitionNumber(String string, Properties properties) throws ResourceException {
        return -1;
    }

    public PrintWriter getPrintWriter() {
        return null;
    }

    public String getXAExceptionContents(XAException xAException) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("The cause is               : ").append(xAException.getCause());
        return stringBuffer.toString();
    }

    public int modifyXAFlag(int n) {
        return n;
    }

    public boolean isBatchUpdateSupportedWithAccessIntent(AccessIntent accessIntent) {
        return true;
    }

    public void doConnectionSetupPerTransaction(Subject subject, String string, Connection connection, boolean bl, Object object) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"doConnectionSetupPerTxn: is not implemented");
        }
        if (this.reauthEnabled) {
            throw new SQLException("Connection Reauthentication can not be enabled without overwriting the doConnectionSetupPerTransaction() helper method to provide actual authentication of connection ");
        }
    }
}

