/*
 * Decompiled with CFR 0.152.
 */
package com.tivoli.pd.jras.pdjlog.jlog;

import com.tivoli.pd.jras.pdjlog.jlog.FileHandler;
import com.tivoli.pd.jras.pdjlog.jlog.IFormatter;
import com.tivoli.pd.jras.pdjlog.jlog.ILogRecord;
import com.tivoli.pd.jras.pdjlog.jlog.LogObject;
import com.tivoli.pd.jras.pdjlog.jlog.LogUtil;
import com.tivoli.pd.jras.pdjlog.jlog.NestedException;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MultiFileHandler
extends FileHandler {
    private static final String N = "(C) Copyright IBM Corp. 1999.";
    static final long serialVersionUID = -4264888327332730757L;
    public static final int DEFAULT_FILES = 3;
    public static final int DEFAULT_FILE_SIZE = 512;
    protected transient long O;
    private int P;
    private long Q;
    protected String R;
    protected String S;
    protected String T;

    public MultiFileHandler() {
    }

    public MultiFileHandler(String string) {
        super(string);
    }

    public MultiFileHandler(String string, String string2) {
        super(string, string2);
    }

    public MultiFileHandler(String string, String string2, String string3) {
        super(string, string2, string3);
    }

    public MultiFileHandler(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public void init() {
        super.init();
        this.O = 0L;
        this.setMaxFiles(3);
        this.setMaxFileSize(512);
        this.R = null;
        this.S = null;
        this.T = null;
    }

    public Properties getConfig() {
        Properties properties = super.getConfig();
        properties.put("maxFiles", new Integer(this.getMaxFiles()).toString());
        properties.put("maxFileSize", new Integer(this.getMaxFileSize()).toString());
        return properties;
    }

    public void setConfig(Properties properties) {
        super.setConfig(properties);
        String string = properties.getProperty("maxFiles");
        if (string != null) {
            this.setMaxFiles(new Integer(string));
        }
        if ((string = properties.getProperty("maxFileSize")) != null) {
            this.setMaxFileSize(new Integer(string));
        }
    }

    public void setFileName(String string) throws AccessControlException {
        block2: {
            block3: {
                if (string == null) break block2;
                super.setFileName(string);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) break block3;
                this.d();
                if (!LogObject.i) break block2;
            }
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    MultiFileHandler.this.d();
                    return null;
                }
            });
        }
    }

    private void d() {
        block7: {
            int n2;
            String string;
            block6: {
                String string2 = this.getFileName();
                string = new File(string2).getAbsolutePath();
                File file = new File(string);
                this.S = file.getParent();
                if (this.S != null && !this.S.endsWith(File.separator)) {
                    this.S = this.S + File.separator;
                }
                if ((n2 = (string = file.getName()).lastIndexOf(46)) != -1) break block6;
                this.R = string;
                if (!LogObject.i) break block7;
            }
            this.R = string.substring(0, n2);
            this.T = string.substring(n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.S != null) {
            stringBuffer.append(this.S);
        }
        stringBuffer.append(this.R + "1");
        if (this.T != null) {
            stringBuffer.append(this.T);
        }
        this.L = stringBuffer.toString();
    }

    public String getNumberedFileName(int n2) {
        String string;
        block5: {
            block4: {
                if (this.getFileName() != null && n2 >= 1 && n2 <= this.getMaxFiles()) break block4;
                string = null;
                if (!LogObject.i) break block5;
            }
            string = this.S + this.R + n2;
            if (this.T != null) {
                string = string + this.T;
            }
        }
        return string;
    }

    public int getMaxFiles() {
        return this.P;
    }

    public void setMaxFiles(int n2) {
        if (n2 >= 0) {
            this.P = n2;
        }
    }

    public int getMaxFileSize() {
        return (int)(this.Q / 1024L);
    }

    public void setMaxFileSize(int n2) {
        if (n2 > 0) {
            this.Q = n2 * 1024;
        }
    }

    protected void b() throws NestedException {
        if (!this.r || this.O >= this.Q) {
            this.closeDevice();
            if (this.O >= this.Q) {
                Vector vector = this.a(this.S);
                vector = this.b(vector, this.S);
                this.a(vector, this.S);
            }
            super.b();
            this.O = new File(this.getFileName()).length();
        }
    }

    protected Vector a(String string) {
        File file = new File(string);
        if (!file.exists()) {
            file.mkdirs();
        }
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                boolean bl2;
                block5: {
                    bl2 = false;
                    int n2 = MultiFileHandler.this.getMaxFiles();
                    try {
                        int n3;
                        int n4 = MultiFileHandler.this.R.length();
                        if (MultiFileHandler.this.T == null) {
                            if (!string.startsWith(MultiFileHandler.this.R) || (n3 = Integer.parseInt(string.substring(n4))) < 1 || n2 != 0 && n3 > n2) break block5;
                            bl2 = true;
                            if (!LogObject.i) break block5;
                        }
                        if (string.startsWith(MultiFileHandler.this.R) && string.endsWith(MultiFileHandler.this.T) && (n3 = Integer.parseInt(string.substring(n4, string.indexOf(MultiFileHandler.this.T)))) >= 1 && (n2 == 0 || n3 <= n2)) {
                            bl2 = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return bl2;
            }
        };
        Vector<String> vector = new Vector<String>();
        String[] stringArray = file.list(filenameFilter);
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                vector.addElement(stringArray[i2]);
                if (!LogObject.i) continue;
            }
        }
        return this.a(vector);
    }

    protected void a(Vector vector, String string) {
        boolean bl2 = LogObject.i;
        int n2 = vector.size() + 1;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3;
            block4: {
                block3: {
                    string3 = (String)enumeration.nextElement();
                    if (this.T != null) break block3;
                    string2 = this.R + n2;
                    if (!bl2) break block4;
                }
                string2 = this.R + n2 + this.T;
            }
            File file = new File(string + string3);
            File file2 = new File(string + string2);
            file.renameTo(file2);
            --n2;
            if (!bl2) continue;
        }
    }

    protected Vector a(Vector vector) {
        boolean bl2 = LogObject.i;
        int n2 = this.R.length();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            String string = (String)vector.elementAt(i2);
            for (int i3 = i2 + 1; i3 < vector.size(); ++i3) {
                int n3;
                int n4;
                String string2;
                block5: {
                    block4: {
                        string2 = (String)vector.elementAt(i3);
                        if (this.T != null) break block4;
                        n4 = Integer.parseInt(string.substring(n2));
                        n3 = Integer.parseInt(string2.substring(n2));
                        if (!bl2) break block5;
                    }
                    n4 = Integer.parseInt(string.substring(n2, string.indexOf(this.T)));
                    n3 = Integer.parseInt(string2.substring(n2, string2.indexOf(this.T)));
                }
                if (n4 >= n3) continue;
                vector.setElementAt(string2, i2);
                vector.setElementAt(string, i3);
                string = string2;
                if (!bl2) continue;
            }
            if (!bl2) continue;
        }
        return vector;
    }

    protected Vector b(Vector vector, String string) {
        int n2 = this.getMaxFiles();
        if (n2 > 0) {
            while (vector.size() >= n2) {
                File file = new File(string + (String)vector.firstElement());
                file.delete();
                vector.removeElement(vector.firstElement());
                if (!LogObject.i) continue;
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void b(ILogRecord iLogRecord) throws NestedException {
        this.openDevice();
        Object object = this.A;
        synchronized (object) {
            IFormatter iFormatter;
            if (this.r && (iFormatter = this.e(iLogRecord)) != null) {
                String string = iFormatter.format(iLogRecord);
                this.O += (long)string.length();
                this.E.println(string);
                if (this.E.checkError()) {
                    this.closeDevice();
                    throw new NestedException(LogUtil.getLogMessage("ERR_WRITE_MSG", this.getName()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLog() throws AccessControlException {
        block6: {
            Object object = this.A;
            synchronized (object) {
                block5: {
                    this.closeDevice();
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) break block5;
                    this.e();
                    if (!LogObject.i) break block6;
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        MultiFileHandler.this.e();
                        return null;
                    }
                });
            }
        }
    }

    private void e() {
        if (this.getFileName() != null) {
            Enumeration enumeration = this.a(this.S).elements();
            while (enumeration.hasMoreElements()) {
                File file = new File(this.S + (String)enumeration.nextElement());
                if (file.exists() && !file.delete()) {
                    LogUtil.errorMsg(LogUtil.getLogMessage("ERR_DELETE_FILE", file.getName()));
                }
                if (!LogObject.i) continue;
            }
        }
    }

    public String toString() {
        String string = super.toString();
        return string + ", files=" + this.getMaxFiles() + ", fileSize=" + this.getMaxFileSize();
    }
}

