/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.Hashtable;
import sun.java2d.DefaultDisposerRecord;
import sun.java2d.DisposerRecord;
import sun.java2d.DisposerTarget;
import sun.security.action.GetPropertyAction;

public class Disposer
implements Runnable {
    private static final ReferenceQueue queue = new ReferenceQueue();
    private static final Hashtable records = new Hashtable();
    private static Disposer disposerInstance;
    public static final int WEAK = 0;
    public static final int PHANTOM = 1;
    public static int refType;

    public static void addRecord(DisposerTarget disposerTarget, long l, long l2) {
        disposerInstance.add(disposerTarget, new DefaultDisposerRecord(l, l2));
    }

    public static void addRecord(DisposerTarget disposerTarget, DisposerRecord disposerRecord) {
        disposerInstance.add(disposerTarget, disposerRecord);
    }

    synchronized void add(DisposerTarget disposerTarget, DisposerRecord disposerRecord) {
        Reference reference = refType == 1 ? new PhantomReference<Object>(disposerTarget.getDisposerReferent(), queue) : new WeakReference<Object>(disposerTarget.getDisposerReferent(), queue);
        records.put(reference, disposerRecord);
        disposerTarget.setDisposerRecord(disposerRecord);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    Reference reference = queue.remove();
                    DisposerRecord disposerRecord = (DisposerRecord)records.remove(reference);
                    disposerRecord.dispose();
                }
            }
            catch (Exception exception) {
                System.out.println("Exception while removing reference: " + exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static native void initIDs();

    static {
        refType = 1;
        Disposer.initIDs();
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.reftype"));
        if (string != null) {
            if (string.equals("weak")) {
                refType = 0;
                System.err.println("Using WEAK refs");
            } else {
                refType = 1;
                System.err.println("Using PHANTOM refs");
            }
        }
        disposerInstance = new Disposer();
        Thread thread = new Thread((Runnable)disposerInstance, "Java2D Disposer");
        thread.setDaemon(true);
        thread.setPriority(10);
        thread.start();
    }
}

