/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.security.AccessController;
import sun.awt.image.AcceleratedOffScreenImage;
import sun.awt.windows.Win32OffScreenImage;
import sun.awt.windows.Win32OffScreenSurfaceData;
import sun.java2d.loops.CompositeType;
import sun.security.action.GetPropertyAction;

public class Win32PeerlessImage
extends Win32OffScreenImage {
    private static final int MAX_SIZE = 65536;
    private static final int ICM_HISTOGRAM_SIZE = 256;
    private static final int ICM_HISTOGRAM_MASK = 255;
    private static final int DCM_HISTOGRAM_SIZE = 1024;
    private static final int DCM_HISTOGRAM_MASK = 1023;
    private ColorModel cmHw;
    private int transparency;
    private Color transColor;
    protected static boolean isTranslucentImagesAccEnabled = false;
    int timesTried = 0;

    public Win32PeerlessImage(ColorModel colorModel, ColorModel colorModel2, WritableRaster writableRaster, boolean bl, int n) {
        super(null, colorModel, writableRaster, bl);
        this.cmHw = colorModel2;
        this.transparency = n;
        if (AcceleratedOffScreenImage.getAccelerationThreshold() == 0) {
            GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.initAcceleratedBackground(graphicsConfiguration, this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initAcceleratedBackground(GraphicsConfiguration graphicsConfiguration, int n, int n2) {
        Win32PeerlessImage win32PeerlessImage = this;
        synchronized (win32PeerlessImage) {
            super.initAcceleratedBackground(graphicsConfiguration, n, n2);
            if (this.surfaceDataHw == null) {
                if (this.timesTried++ > 3) {
                    this.localAccelerationEnabled = false;
                }
            } else {
                this.timesTried = 0;
            }
            if (this.surfaceDataHw != null && this.transparency == 2 && this.getBackgroundColor() == null) {
                this.flush();
                this.surfaceDataHw = null;
            }
        }
    }

    public static boolean isValidOpaqueConfig(ColorModel colorModel, ColorModel colorModel2, int n) {
        return colorModel.getTransparency() == 1;
    }

    public static boolean isValidBitmaskConfig(ColorModel colorModel, ColorModel colorModel2, int n) {
        if (colorModel.getTransparency() == 2 && colorModel2.getPixelSize() != 8) {
            if (colorModel instanceof IndexColorModel) {
                return true;
            }
            if (colorModel instanceof DirectColorModel && colorModel.getPixelSize() == 25 && colorModel.getTransferType() == 3 && n <= 65536) {
                return true;
            }
        }
        return false;
    }

    public static boolean isValidTranslucentConfig(ColorModel colorModel, ColorModel colorModel2, int n) {
        return isTranslucentImagesAccEnabled && colorModel.getTransparency() == 3;
    }

    protected boolean operationSupported(CompositeType compositeType, Color color, boolean bl) {
        if (this.transparency == 1) {
            if (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcNoEa.equals(compositeType)) {
                return !bl || Win32OffScreenSurfaceData.isDDScaleEnabled();
            }
        } else if (this.transparency == 3 ? (CompositeType.SrcOverNoEa.equals(compositeType) || CompositeType.SrcOver.equals(compositeType)) && color == null : CompositeType.SrcOverNoEa.equals(compositeType) && color == null) {
            return !bl;
        }
        return false;
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return graphicsEnvironment.createGraphics(this);
    }

    protected ColorModel getDeviceColorModel() {
        return this.cmHw;
    }

    protected int getTransparency() {
        return this.transparency;
    }

    protected Color getBackgroundColor() {
        if (!accelerationEnabled || !this.localAccelerationEnabled || this.transparency != 2) {
            return null;
        }
        this.transColor = this.setupTransparentPixel();
        if (this.transColor == null) {
            this.localAccelerationEnabled = false;
        }
        return this.transColor;
    }

    protected Color setupTransparentPixel() {
        Color color = null;
        Integer n = null;
        ColorModel colorModel = this.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            n = this.findUnusedPixelICM();
        } else if (colorModel instanceof DirectColorModel) {
            n = this.findUnusedPixelDCM();
        }
        if (n != null) {
            int n2 = n;
            ((Win32OffScreenSurfaceData)this.surfaceDataHw).setTransparentPixel(n2);
            int n3 = this.surfaceDataHw.rgbFor(n2);
            color = new Color(n3);
        }
        return color;
    }

    private Integer findUnusedPixelICM() {
        int n;
        int n2;
        IndexColorModel indexColorModel = (IndexColorModel)this.getColorModel();
        int n3 = indexColorModel.getMapSize();
        int[] nArray = new int[256];
        int[] nArray2 = new int[n3];
        indexColorModel.getRGBs(nArray2);
        for (n2 = 0; n2 < n3; ++n2) {
            n = this.surfaceDataHw.pixelFor(nArray2[n2]);
            int n4 = n & 0xFF;
            nArray[n4] = nArray[n4] + 1;
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = nArray[n2];
            if (n != 0) continue;
            return new Integer(n2);
        }
        return null;
    }

    private Integer findUnusedPixelDCM() {
        int n;
        int n2;
        DataBufferInt dataBufferInt = (DataBufferInt)this.getRaster().getDataBuffer();
        this.localAccelerationEnabled = true;
        int[] nArray = dataBufferInt.getData();
        int[] nArray2 = new int[1024];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            n = this.surfaceDataHw.pixelFor(nArray[n2]);
            int n3 = n & 0x3FF;
            nArray2[n3] = nArray2[n3] + 1;
        }
        for (n2 = 0; n2 < nArray2.length; ++n2) {
            n = nArray2[n2];
            if (n != 0) continue;
            return new Integer(n2);
        }
        return null;
    }

    public void displayChanged() {
        super.displayChanged();
    }

    public String toString() {
        return new String("Win32PeerlessImage@" + Integer.toHexString(this.hashCode()) + " transparency: " + (this.transparency == 1 ? "OPAQUE" : (this.transparency == 2 ? "BITMASK" : "TRANSLUCENT")));
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.translaccel"));
        if (string != null && string.equals("true")) {
            isTranslucentImagesAccEnabled = true;
            System.out.println("Acceleration for translucent images is enabled.");
        }
    }
}

