/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.windows.HTMLDecodingInputStream;
import sun.awt.windows.HTMLSupport;
import sun.awt.windows.WImage;
import sun.awt.windows.WToolkitThreadBlockedHandler;

public class WDataTransferer
extends DataTransferer {
    private static final String[] predefinedClipboardNames = new String[]{"", "TEXT", "BITMAP", "METAFILEPICT", "SYLK", "DIF", "TIFF", "OEM TEXT", "DIB", "PALETTE", "PENDATA", "RIFF", "WAVE", "UNICODE TEXT", "ENHMETAFILE", "HDROP", "LOCALE"};
    private static final Map predefinedClipboardNameMap;
    public static final int CF_TEXT = 1;
    public static final int CF_METAFILEPICT = 3;
    public static final int CF_DIB = 8;
    public static final int CF_ENHMETAFILE = 14;
    public static final int CF_HDROP = 15;
    public static final int CF_LOCALE = 16;
    public static final long CF_HTML;
    public static final long CFSTR_INETURL;
    public static final long CF_PNG;
    public static final long CF_JFIF;
    private static final Long L_CF_LOCALE;
    private static final DirectColorModel directColorModel;
    private static final int[] bandmasks;
    private static WDataTransferer transferer;
    private final ToolkitThreadBlockedHandler handler = new WToolkitThreadBlockedHandler();

    private WDataTransferer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WDataTransferer getInstanceImpl() {
        if (transferer == null) {
            Class clazz = WDataTransferer.class;
            synchronized (clazz) {
                if (transferer == null) {
                    transferer = new WDataTransferer();
                }
            }
        }
        return transferer;
    }

    public Map getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        Map map = super.getFormatsForFlavors(dataFlavorArray, flavorTable);
        map.remove(L_CF_LOCALE);
        return map;
    }

    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l) throws IOException {
        byte[] byArray = super.translateTransferable(transferable, dataFlavor, l);
        if (l == CF_HTML) {
            byArray = HTMLSupport.convertToHTMLFormat(byArray);
        }
        return byArray;
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l, Transferable transferable) throws IOException {
        if (l == CF_HTML && dataFlavor.isFlavorTextType()) {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(byArray);
                byArray = null;
            }
            inputStream = new HTMLDecodingInputStream(inputStream);
        }
        if (l == CFSTR_INETURL && URL.class.equals(dataFlavor.getRepresentationClass())) {
            if (byArray == null) {
                byArray = WDataTransferer.inputStreamToByteArray(inputStream);
                inputStream = null;
            }
            String string = WDataTransferer.getDefaultTextCharset();
            if (transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(byArray, string));
        }
        return super.translateBytesOrStream(inputStream, byArray, dataFlavor, l, transferable);
    }

    public boolean isLocaleDependentTextFormat(long l) {
        return l == 1L || l == CFSTR_INETURL;
    }

    public boolean isFileFormat(long l) {
        return l == 15L;
    }

    protected Long getFormatForNativeAsLong(String string) {
        Long l = (Long)predefinedClipboardNameMap.get(string);
        if (l == null) {
            l = new Long(WDataTransferer.registerClipboardFormat(string));
        }
        return l;
    }

    protected String getNativeForFormat(long l) {
        return l < (long)predefinedClipboardNames.length ? predefinedClipboardNames[(int)l] : WDataTransferer.getClipboardFormatName(l);
    }

    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    private static native long registerClipboardFormat(String var0);

    private static native String getClipboardFormatName(long var0);

    public boolean isImageFormat(long l) {
        return l == 8L || l == 14L || l == 3L || l == CF_PNG || l == CF_JFIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToPlatformBytes(Image image, long l) throws IOException {
        Object object;
        String string = null;
        if (l == CF_PNG) {
            string = "image/png";
        } else if (l == CF_JFIF) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.imageToStandardBytes(image, string);
        }
        int n = 0;
        int n2 = 0;
        if (image instanceof WImage) {
            object = ((WImage)image).getImageRep();
            ((ImageRepresentation)object).reconstruct(32);
            n = ((ImageRepresentation)object).getWidth();
            n2 = ((ImageRepresentation)object).getHeight();
        } else {
            n = image.getWidth(null);
            n2 = image.getHeight(null);
        }
        object = new BufferedImage(n, n2, 1);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n2);
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        try {
            graphics2D.drawImage(image, affineTransform, null);
        }
        finally {
            graphics2D.dispose();
        }
        WritableRaster writableRaster = ((BufferedImage)object).getRaster();
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        return this.imageDataToPlatformImageBytes(nArray, n, n2, l);
    }

    private native byte[] imageDataToPlatformImageBytes(int[] var1, int var2, int var3, long var4);

    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l) throws IOException {
        int[] nArray;
        String string = null;
        if (l == CF_PNG) {
            string = "image/png";
        } else if (l == CF_JFIF) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.standardImageBytesOrStreamToImage(inputStream, byArray, string);
        }
        if (byArray == null) {
            byArray = WDataTransferer.inputStreamToByteArray(inputStream);
        }
        if ((nArray = this.platformImageBytesToImageData(byArray, l)) == null) {
            throw new IOException("data translation failed");
        }
        int n = nArray.length - 2;
        int n2 = nArray[n];
        int n3 = nArray[n + 1];
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n2, n3, n2, bandmasks, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    private native int[] platformImageBytesToImageData(byte[] var1, long var2) throws IOException;

    static {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(16, 1.0f);
        for (int i = 1; i < predefinedClipboardNames.length; ++i) {
            hashMap.put(predefinedClipboardNames[i], new Long(i));
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        CF_HTML = WDataTransferer.registerClipboardFormat("HTML Format");
        CFSTR_INETURL = WDataTransferer.registerClipboardFormat("UniformResourceLocator");
        CF_PNG = WDataTransferer.registerClipboardFormat("PNG");
        CF_JFIF = WDataTransferer.registerClipboardFormat("JFIF");
        L_CF_LOCALE = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[16]);
        directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        bandmasks = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
    }
}

