/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.Win32ShellFolderManager;

final class Win32ShellFolder
extends ShellFolder {
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int ATTRIB_CANCOPY = 1;
    public static final int ATTRIB_CANMOVE = 2;
    public static final int ATTRIB_CANLINK = 4;
    public static final int ATTRIB_CANRENAME = 16;
    public static final int ATTRIB_CANDELETE = 32;
    public static final int ATTRIB_HASPROPSHEET = 64;
    public static final int ATTRIB_DROPTARGET = 256;
    public static final int ATTRIB_LINK = 65536;
    public static final int ATTRIB_SHARE = 131072;
    public static final int ATTRIB_READONLY = 262144;
    public static final int ATTRIB_GHOSTED = 524288;
    public static final int ATTRIB_HIDDEN = 524288;
    public static final int ATTRIB_FILESYSANCESTOR = 0x10000000;
    public static final int ATTRIB_FOLDER = 0x20000000;
    public static final int ATTRIB_FILESYSTEM = 0x40000000;
    public static final int ATTRIB_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int ATTRIB_VALIDATE = 0x1000000;
    public static final int ATTRIB_REMOVABLE = 0x2000000;
    public static final int ATTRIB_COMPRESSED = 0x4000000;
    public static final int ATTRIB_BROWSABLE = 0x8000000;
    public static final int ATTRIB_NONENUMERATED = 0x100000;
    public static final int ATTRIB_NEWCONTENT = 0x200000;
    private long pIShellFolder = 0L;
    private long relativePIDL = 0L;
    private long pIDL = 0L;
    private long attributes = -1L;
    private String folderType = null;
    private String displayName = null;
    private Image smallIcon = null;
    private Image largeIcon = null;
    static int[] fileChooserBitmapBits;
    static Image[] fileChooserIcons;
    private List topFolderList = null;

    private static native void initIDs();

    Win32ShellFolder(ShellFolder shellFolder, int n) throws IOException {
        super(shellFolder, Win32ShellFolder.getFileSystemPath(n) == null ? "ShellFolder: 0x" + Integer.toHexString(n) : Win32ShellFolder.getFileSystemPath(n));
        if (n == 0) {
            this.initDesktop();
        } else {
            this.initSpecial(this.getDesktop().getIShellFolder(), n);
        }
    }

    public Win32ShellFolder(ShellFolder shellFolder, String string) throws FileNotFoundException {
        super(shellFolder, string);
        try {
            boolean bl = true;
            if (string.length() == 3 && string.endsWith(":\\")) {
                bl = false;
            }
            this.pIDL = this.initFile(this.getDesktopIShellFolder(), string, bl);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " (" + iOException.getMessage() + ")");
        }
    }

    public Win32ShellFolder(ShellFolder shellFolder, File file) throws FileNotFoundException {
        this(shellFolder, file.getAbsolutePath());
    }

    Win32ShellFolder(Win32ShellFolder win32ShellFolder, long l, long l2, String string) {
        super(win32ShellFolder, string != null ? string : "ShellFolder: ");
        this.pIShellFolder = l;
        this.relativePIDL = l2;
    }

    private native void initDesktop();

    private native void initSpecial(long var1, int var3);

    private native long initFile(long var1, String var3, boolean var4) throws IOException;

    protected Object writeReplace() throws ObjectStreamException {
        File[] fileArray;
        if (this.isFileSystem()) {
            return new File(this.getPath());
        }
        Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDrives();
        if (win32ShellFolder != null && (fileArray = win32ShellFolder.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                Win32ShellFolder win32ShellFolder2;
                if (!(fileArray[i] instanceof Win32ShellFolder) || !(win32ShellFolder2 = (Win32ShellFolder)fileArray[i]).isFileSystem() || win32ShellFolder2.hasAttribute(0x2000000)) continue;
                return new File(win32ShellFolder2.getPath());
            }
        }
        return new File("C:\\");
    }

    protected void finalize() throws Throwable {
        if (this.pIDL != 0L && this.pIShellFolder == 0L) {
            this.releasePIDL(this.pIDL);
            this.pIDL = 0L;
            if (this.relativePIDL != 0L) {
                this.releasePIDL(this.relativePIDL);
                this.relativePIDL = 0L;
            }
        } else {
            this.pIShellFolder = 0L;
        }
    }

    private native void releasePIDL(long var1);

    public long getIShellFolder() {
        return this.pIShellFolder;
    }

    public long getParentIShellFolder() {
        Win32ShellFolder win32ShellFolder = (Win32ShellFolder)this.getParentFile();
        if (win32ShellFolder == null) {
            if (this.equals(this.getDesktop())) {
                return this.getIShellFolder();
            }
            return 0L;
        }
        return win32ShellFolder.getIShellFolder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRelativePIDL(long l, long l2) {
        if (l == 0L || l2 == 0L) {
            return 0L;
        }
        long l3 = this.getEnumObjects(l, true);
        if (l3 == 0L) {
            return 0L;
        }
        try {
            long l4 = 0L;
            do {
                if ((l4 = this.getNextChild(l3)) == 0L) continue;
                long l5 = this.bindToObject(l, l4);
                if (l5 == l2) {
                    long l6 = l4;
                    return l6;
                }
                this.releasePIDL(l4);
            } while (l4 != 0L);
        }
        finally {
            this.releaseEnumObjects(l3);
        }
        return 0L;
    }

    public long getRelativePIDL() {
        if (this.relativePIDL == 0L) {
            this.relativePIDL = this.getRelativePIDL(this.getParentIShellFolder(), this.getIShellFolder());
        }
        return this.relativePIDL;
    }

    public long getPIDL() {
        return this.pIDL;
    }

    public Win32ShellFolder getDesktop() {
        return Win32ShellFolderManager.getDesktop();
    }

    public long getDesktopIShellFolder() {
        return this.getDesktop().getIShellFolder();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Win32ShellFolder)) {
            if (this.getPIDL() != 0L) {
                return super.equals(object);
            }
            return false;
        }
        Win32ShellFolder win32ShellFolder = (Win32ShellFolder)object;
        ShellFolder shellFolder = (ShellFolder)this.getParentFile();
        if (shellFolder != null && !shellFolder.equals(win32ShellFolder.getParentFile())) {
            return false;
        }
        if (this.isFileSystem()) {
            return this.getAbsolutePath().equals(win32ShellFolder.getAbsolutePath());
        }
        return this.getIShellFolder() == win32ShellFolder.getIShellFolder();
    }

    public boolean isFileSystem() {
        return this.getPIDL() != 0L || !this.getPath().startsWith("ShellFolder: ");
    }

    private native void initAttributes(long var1);

    private native boolean hasAttribute(long var1, long var3, int var5);

    public boolean hasAttribute(int n) {
        boolean bl = false;
        if (this.getPIDL() != 0L) {
            if (this.attributes == -1L) {
                this.initAttributes(this.getPIDL());
            }
            boolean bl2 = bl = (this.attributes & (long)n) != 0L;
        }
        if (this.pIShellFolder != 0L) {
            bl = bl || this.hasAttribute(this.getParentIShellFolder(), this.getRelativePIDL(), n);
        }
        return bl;
    }

    private boolean behavesLikeFileSystem(long l, long l2) {
        return this.hasAttribute(l, l2, 0x40000000);
    }

    static native String getFileSystemPath(long var0, long var2);

    static native String getFileSystemPath(int var0) throws IOException;

    private static boolean isNetworkRoot(String string) {
        return string.equals("\\\\") || string.equals("\\") || string.equals("//") || string.equals("/");
    }

    public File getParentFile() {
        if (this.parent == null && this.getPIDL() != 0L) {
            String string = this.getParent();
            if (string == null) {
                String string2 = this.getAbsolutePath();
                this.parent = string2.startsWith("\\") ? Win32ShellFolderManager.getNetwork() : Win32ShellFolderManager.getDrives();
            } else if (Win32ShellFolder.isNetworkRoot(string)) {
                this.parent = Win32ShellFolderManager.getNetwork();
            } else {
                try {
                    this.parent = new Win32ShellFolder(null, super.getParentFile());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return this.parent;
    }

    public boolean isDirectory() {
        return this.hasAttribute(Integer.MIN_VALUE) || this.isFileSystem() && super.isDirectory();
    }

    private long getEnumObjects(long l, boolean bl) {
        boolean bl2 = l == this.getDesktopIShellFolder();
        return this.getEnumObjects(l, bl2, bl);
    }

    private native long getEnumObjects(long var1, boolean var3, boolean var4);

    private native long getNextChild(long var1);

    private native void releaseEnumObjects(long var1);

    private native long bindToObject(long var1, long var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File[] listFiles(boolean bl) {
        long l;
        ArrayList<Win32ShellFolder> arrayList;
        block12: {
            long l2;
            Win32ShellFolder win32ShellFolder;
            Win32ShellFolder win32ShellFolder2;
            block13: {
                int n;
                File[] fileArray;
                File[] fileArray2;
                block11: {
                    block10: {
                        win32ShellFolder2 = Win32ShellFolderManager.getDesktop();
                        win32ShellFolder = Win32ShellFolderManager.getPersonal();
                        fileArray2 = null;
                        if (this.getPIDL() == 0L) break block10;
                        fileArray = super.listFiles(bl);
                        if (fileArray == null) return fileArray2;
                        fileArray2 = new File[fileArray.length];
                        n = 0;
                        break block11;
                    }
                    arrayList = new ArrayList<Win32ShellFolder>();
                    l2 = this.getIShellFolder();
                    if (l2 == 0L) return fileArray2;
                    l = this.getEnumObjects(l2, bl);
                    if (l == 0L) break block12;
                    break block13;
                }
                for (int i = 0; i < fileArray.length && !Thread.currentThread().isInterrupted(); ++i) {
                    try {
                        Win32ShellFolder win32ShellFolder3 = new Win32ShellFolder((ShellFolder)this, fileArray[i]);
                        fileArray2[n++] = win32ShellFolder3;
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (n >= fileArray.length) return fileArray2;
                fileArray = new File[n];
                System.arraycopy(fileArray2, 0, fileArray, 0, n);
                return fileArray;
            }
            long l3 = 0L;
            do {
                Win32ShellFolder win32ShellFolder4;
                block9: {
                    block14: {
                        if ((l3 = this.getNextChild(l)) == 0L) continue;
                        win32ShellFolder4 = null;
                        if (!this.hasAttribute(l2, l3, 0x40000000)) break block14;
                        String string = Win32ShellFolder.getFileSystemPath(l2, l3);
                        if (string == null || !new File(string).isAbsolute()) continue;
                        if (this == win32ShellFolder2 && win32ShellFolder != null && string.equalsIgnoreCase(win32ShellFolder.getAbsolutePath())) {
                            win32ShellFolder4 = win32ShellFolder;
                            break block9;
                        } else {
                            try {
                                win32ShellFolder4 = new Win32ShellFolder((ShellFolder)this, string);
                                break block9;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                continue;
                            }
                        }
                    }
                    if (this.hasAttribute(l2, l3, 0x10000000)) {
                        long l4 = this.bindToObject(l2, l3);
                        win32ShellFolder4 = new Win32ShellFolder(this, l4, l3, null);
                    }
                }
                if (win32ShellFolder4 == null) continue;
                arrayList.add(win32ShellFolder4);
            } while (l3 != 0L);
        }
        this.releaseEnumObjects(l);
        return arrayList.toArray(new ShellFolder[arrayList.size()]);
    }

    Win32ShellFolder getChildByPath(String string) {
        long l = this.getIShellFolder();
        long l2 = this.getEnumObjects(l, true);
        Win32ShellFolder win32ShellFolder = null;
        long l3 = 0L;
        while ((l3 = this.getNextChild(l2)) != 0L) {
            String string2;
            if (!this.hasAttribute(l, l3, 0x40000000) || (string2 = Win32ShellFolder.getFileSystemPath(l, l3)) == null || !string2.equalsIgnoreCase(string)) continue;
            long l4 = this.bindToObject(l, l3);
            win32ShellFolder = new Win32ShellFolder(this, l4, l3, string2);
            break;
        }
        this.releaseEnumObjects(l2);
        return win32ShellFolder;
    }

    public boolean isLink() {
        return this.hasAttribute(65536);
    }

    public boolean isHidden() {
        return this.hasAttribute(524288);
    }

    private native String getLinkLocation(long var1, long var3);

    public ShellFolder getLinkLocation() throws FileNotFoundException {
        if (!this.isLink()) {
            return null;
        }
        String string = null;
        string = this.getPIDL() != 0L ? this.getLinkLocation(this.getDesktopIShellFolder(), this.getPIDL()) : this.getLinkLocation(this.getParentIShellFolder(), this.getRelativePIDL());
        if (string == null) {
            return null;
        }
        return new Win32ShellFolder(null, string);
    }

    private native String getDisplayName(long var1, long var3);

    public String getDisplayName() {
        if (this.displayName == null && this.getPIDL() == 0L) {
            this.displayName = this.getDisplayName(this.getParentIShellFolder(), this.getRelativePIDL());
        }
        return this.displayName;
    }

    private native String getFolderType(long var1);

    public String getFolderType() {
        if (this.folderType == null && this.getPIDL() == 0L) {
            this.folderType = this.getFolderType(this.getRelativePIDL());
        }
        return this.folderType;
    }

    private native String getExecutableType(byte[] var1);

    public String getExecutableType() {
        if (!this.isFileSystem()) {
            return null;
        }
        return this.getExecutableType(this.getAbsolutePath().getBytes());
    }

    private native long getIcon(long var1, boolean var3);

    private native long getIcon(long var1, long var3, boolean var5);

    private native int[] getIconBits(long var1, int var3);

    private native void disposeIcon(long var1);

    public static native int[] getFileChooserBitmapBits();

    private int[] getIconBits(boolean bl) {
        long l = 0L;
        l = this.getPIDL() != 0L ? this.getIcon(this.getPIDL(), bl) : this.getIcon(this.getParentIShellFolder(), this.getRelativePIDL(), bl);
        if (l == 0L) {
            return null;
        }
        int[] nArray = this.getIconBits(l, bl ? 32 : 16);
        this.disposeIcon(l);
        return nArray;
    }

    static Image getFileChooserIcon(int n) {
        if (fileChooserIcons[n] != null) {
            return fileChooserIcons[n];
        }
        if (fileChooserBitmapBits == null) {
            fileChooserBitmapBits = Win32ShellFolder.getFileChooserBitmapBits();
        }
        if (fileChooserBitmapBits != null) {
            int n2 = fileChooserBitmapBits.length / 256;
            int[] nArray = new int[256];
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    nArray[i * 16 + j] = fileChooserBitmapBits[i * (n2 * 16) + n * 16 + j];
                }
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            bufferedImage.setRGB(0, 0, 16, 16, nArray, 0, 16);
            Win32ShellFolder.fileChooserIcons[n] = bufferedImage;
        }
        return fileChooserIcons[n];
    }

    public Image getIcon(boolean bl) {
        Image image;
        Image image2 = image = bl ? this.largeIcon : this.smallIcon;
        if (image == null) {
            int n = bl ? 32 : 16;
            int[] nArray = this.getIconBits(bl);
            if (nArray == null) {
                return super.getIcon(bl);
            }
            BufferedImage bufferedImage = new BufferedImage(n, n, 2);
            bufferedImage.setRGB(0, 0, n, n, nArray, 0, n);
            image = bl ? (this.largeIcon = bufferedImage) : (this.smallIcon = bufferedImage);
        }
        return image;
    }

    public File getCanonicalFile() throws IOException {
        if (this.getPIDL() != 0L) {
            return new Win32ShellFolder(this.parent, super.getCanonicalPath());
        }
        return this;
    }

    public int compareTo(File file) {
        if (file == null || !(file instanceof Win32ShellFolder) || file instanceof Win32ShellFolder && ((Win32ShellFolder)file).getPIDL() != 0L) {
            if (this.getPIDL() != 0L) {
                return super.compareTo(file);
            }
            return -1;
        }
        if (this.getPIDL() != 0L) {
            return 1;
        }
        if (this.topFolderList == null) {
            this.topFolderList = new ArrayList();
            this.topFolderList.add(Win32ShellFolderManager.getPersonal());
            this.topFolderList.add(Win32ShellFolderManager.getDesktop());
            this.topFolderList.add(Win32ShellFolderManager.getDrives());
            this.topFolderList.add(Win32ShellFolderManager.getNetwork());
        }
        int n = this.topFolderList.indexOf(this);
        int n2 = this.topFolderList.indexOf(file);
        if (n >= 0 && n2 >= 0) {
            return n - n2;
        }
        if (n >= 0) {
            return -1;
        }
        if (n2 >= 0) {
            return 1;
        }
        return this.getName().compareTo(file.getName());
    }

    static {
        Win32ShellFolder.initIDs();
        fileChooserBitmapBits = null;
        fileChooserIcons = new Image[47];
    }
}

