/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.TransferableProxy;

public abstract class SunClipboard
extends Clipboard
implements PropertyChangeListener {
    public static final FlavorTable flavorMap = (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
    private AppContext contentsContext = null;

    public SunClipboard(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setContents(Transferable transferable, ClipboardOwner clipboardOwner) {
        if (transferable == null) {
            throw new NullPointerException("contents");
        }
        this.initContext();
        ClipboardOwner clipboardOwner2 = this.owner;
        Transferable transferable2 = this.contents;
        try {
            this.owner = clipboardOwner;
            this.contents = new TransferableProxy(transferable, true);
            this.setContentsNative(transferable);
            Object var6_5 = null;
            if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
                clipboardOwner2.lostOwnership(this, transferable2);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (clipboardOwner2 != null && clipboardOwner2 != clipboardOwner) {
                clipboardOwner2.lostOwnership(this, transferable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initContext() {
        AppContext appContext = AppContext.getAppContext();
        if (this.contentsContext != appContext) {
            AppContext appContext2 = appContext;
            synchronized (appContext2) {
                if (appContext.isDisposed()) {
                    throw new IllegalStateException("Can't set contents from disposed AppContext");
                }
                appContext.addPropertyChangeListener("disposed", this);
            }
            if (this.contentsContext != null) {
                this.contentsContext.removePropertyChangeListener("disposed", this);
            }
            this.contentsContext = appContext;
        }
    }

    public synchronized Transferable getContents(Object object) {
        if (this.contents != null) {
            return this.contents;
        }
        ClipboardTransferable clipboardTransferable = new ClipboardTransferable(this);
        if (clipboardTransferable.getTransferDataFlavors().length == 0) {
            clipboardTransferable = null;
        }
        return clipboardTransferable;
    }

    public void openClipboard(SunClipboard sunClipboard) {
    }

    public void closeClipboard() {
    }

    public abstract long getID();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("disposed".equals(propertyChangeEvent.getPropertyName()) && Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            AppContext appContext = (AppContext)propertyChangeEvent.getSource();
            this.lostOwnershipLater(appContext);
        }
    }

    protected void lostOwnershipImpl() {
        this.lostOwnershipLater(null);
    }

    protected void lostOwnershipLater(final AppContext appContext) {
        AppContext appContext2 = this.contentsContext;
        if (appContext2 == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                SunClipboard sunClipboard = SunClipboard.this;
                ClipboardOwner clipboardOwner = null;
                Transferable transferable = null;
                SunClipboard sunClipboard2 = sunClipboard;
                synchronized (sunClipboard2) {
                    AppContext appContext2 = sunClipboard.contentsContext;
                    if (appContext2 == null) {
                        return;
                    }
                    if (appContext != null && appContext2 != appContext) {
                        return;
                    }
                    clipboardOwner = sunClipboard.owner;
                    transferable = sunClipboard.contents;
                    sunClipboard.contentsContext = null;
                    sunClipboard.owner = null;
                    sunClipboard.contents = null;
                    sunClipboard.clearNativeContext();
                    appContext2.removePropertyChangeListener("disposed", sunClipboard);
                }
                if (clipboardOwner != null) {
                    clipboardOwner.lostOwnership(sunClipboard, transferable);
                }
            }
        };
        SunToolkit.postEvent(appContext2, new PeerEvent(this, runnable, 1L));
    }

    protected abstract void clearNativeContext();

    protected abstract void setContentsNative(Transferable var1);
}

