/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.undo;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.StateEditable;

public class StateEdit
extends AbstractUndoableEdit {
    protected static final String RCSID = "$Id: StateEdit.java,v 1.6 1997/10/01 20:05:51 sandipc Exp $";
    protected StateEditable object;
    protected Hashtable preState;
    protected Hashtable postState;
    protected String undoRedoName;

    public StateEdit(StateEditable stateEditable) {
        this.init(stateEditable, null);
    }

    public StateEdit(StateEditable stateEditable, String string) {
        this.init(stateEditable, string);
    }

    protected void init(StateEditable stateEditable, String string) {
        this.object = stateEditable;
        this.preState = new Hashtable(11);
        this.object.storeState(this.preState);
        this.postState = null;
        this.undoRedoName = string;
    }

    public void end() {
        this.postState = new Hashtable(11);
        this.object.storeState(this.postState);
        this.removeRedundantState();
    }

    public void undo() {
        super.undo();
        this.object.restoreState(this.preState);
    }

    public void redo() {
        super.redo();
        this.object.restoreState(this.postState);
    }

    public String getPresentationName() {
        return this.undoRedoName;
    }

    protected void removeRedundantState() {
        Vector vector = new Vector();
        Enumeration enumeration = this.preState.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!this.postState.containsKey(k) || !this.postState.get(k).equals(this.preState.get(k))) continue;
            vector.addElement(k);
        }
        for (int i = vector.size() - 1; i >= 0; --i) {
            Object e = vector.elementAt(i);
            this.preState.remove(e);
            this.postState.remove(e);
        }
    }
}

